/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4chex.archive.mbean;

import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketException;
import java.net.UnknownHostException;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanException;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import javax.net.ServerSocketFactory;
import javax.net.SocketFactory;
import javax.net.ssl.HandshakeCompletedListener;
import org.dcm4che.util.HandshakeFailedListener;
import org.dcm4chex.archive.ejb.interfaces.AEDTO;
import org.dcm4chex.archive.exceptions.ConfigurationException;
import org.jboss.system.ServiceMBeanSupport;

public final class TLSConfigDelegate {
    private final ServiceMBeanSupport service;
    private int soSndBuf;
    private int soRcvBuf;
    private boolean tcpNoDelay = true;
    private ObjectName tlsConfigName;

    public TLSConfigDelegate(ServiceMBeanSupport service) {
        this.service = service;
    }

    public final ObjectName getTLSConfigName() {
        return this.tlsConfigName;
    }

    public final void setTLSConfigName(ObjectName tlsConfigName) {
        this.tlsConfigName = tlsConfigName;
    }

    public final int getReceiveBufferSize() {
        return this.soRcvBuf;
    }

    public final void setReceiveBufferSize(int size) {
        if (size < 0) {
            throw new IllegalArgumentException("size: " + size);
        }
        this.soRcvBuf = size;
    }

    public final int getSendBufferSize() {
        return this.soSndBuf;
    }

    public final void setSendBufferSize(int size) {
        if (size < 0) {
            throw new IllegalArgumentException("size: " + size);
        }
        this.soSndBuf = size;
    }

    public final boolean isTcpNoDelay() {
        return this.tcpNoDelay;
    }

    public final void setTcpNoDelay(boolean on) {
        this.tcpNoDelay = on;
    }

    public HandshakeFailedListener handshakeFailedListener() {
        try {
            return (HandshakeFailedListener)this.service.getServer().invoke(this.tlsConfigName, "handshakeFailedListener", null, null);
        }
        catch (Exception e) {
            throw new ConfigurationException(e);
        }
    }

    public HandshakeCompletedListener handshakeCompletedListener() {
        try {
            return (HandshakeCompletedListener)this.service.getServer().invoke(this.tlsConfigName, "handshakeCompletedListener", null, null);
        }
        catch (Exception e) {
            throw new ConfigurationException(e);
        }
    }

    public ServerSocketFactory serverSocketFactory(String[] cipherSuites) {
        try {
            return (ServerSocketFactory)this.service.getServer().invoke(this.tlsConfigName, "serverSocketFactory", new Object[]{cipherSuites}, new String[]{String[].class.getName()});
        }
        catch (InstanceNotFoundException e) {
            throw new ConfigurationException(e);
        }
        catch (MBeanException e) {
            throw new ConfigurationException(e);
        }
        catch (ReflectionException e) {
            throw new ConfigurationException(e);
        }
    }

    public SocketFactory socketFactory(String[] cipherSuites) {
        try {
            return (SocketFactory)this.service.getServer().invoke(this.tlsConfigName, "socketFactory", new Object[]{cipherSuites}, new String[]{String[].class.getName()});
        }
        catch (InstanceNotFoundException e) {
            throw new ConfigurationException(e);
        }
        catch (MBeanException e) {
            throw new ConfigurationException(e);
        }
        catch (ReflectionException e) {
            throw new ConfigurationException(e);
        }
    }

    public void startHandshake(Socket s) throws IOException {
        try {
            this.service.getServer().invoke(this.tlsConfigName, "startHandshake", new Object[]{s}, new String[]{Socket.class.getName()});
        }
        catch (Exception e) {
            Throwable cause = e.getCause();
            if (cause instanceof IOException) {
                throw (IOException)cause;
            }
            throw new ConfigurationException(e);
        }
    }

    public Socket createSocket(AEDTO localAE, AEDTO remoteAE) throws IOException {
        String[] cipherSuites = remoteAE.getCipherSuites();
        Socket s = this.socketFactory(cipherSuites).createSocket();
        s.bind(this.toBindPoint(localAE));
        s.connect(this.toEndPoint(remoteAE));
        this.startHandshake(s);
        this.initSendBufferSize(s);
        this.initReceiveBufferSize(s);
        if (s.getTcpNoDelay() != this.tcpNoDelay) {
            s.setTcpNoDelay(this.tcpNoDelay);
        }
        return s;
    }

    private InetSocketAddress toEndPoint(AEDTO remoteAE) throws UnknownHostException {
        InetAddress addr = InetAddress.getByName(remoteAE.getHostName());
        return new InetSocketAddress(addr, remoteAE.getPort());
    }

    private InetSocketAddress toBindPoint(AEDTO localAE) {
        try {
            InetAddress addr = InetAddress.getByName(localAE.getHostName());
            if (!addr.isLoopbackAddress()) {
                return new InetSocketAddress(addr, 0);
            }
        }
        catch (UnknownHostException e) {
            this.service.getLog().warn((Object)("Unkown Host " + localAE.getHostName() + " - bind socket to a valid local address picked up by the OS"));
        }
        return null;
    }

    private void initSendBufferSize(Socket s) throws SocketException {
        int tmp = s.getSendBufferSize();
        if (this.soSndBuf == 0) {
            this.soSndBuf = tmp;
        }
        if (this.soSndBuf != tmp) {
            s.setSendBufferSize(this.soSndBuf);
            this.soSndBuf = s.getSendBufferSize();
        }
    }

    private void initReceiveBufferSize(Socket s) throws SocketException {
        int tmp = s.getReceiveBufferSize();
        if (this.soRcvBuf == 0) {
            this.soRcvBuf = tmp;
        }
        if (this.soRcvBuf != tmp) {
            s.setReceiveBufferSize(this.soRcvBuf);
            this.soRcvBuf = s.getReceiveBufferSize();
        }
    }
}

