/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4chex.archive.mbean;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.StringTokenizer;
import javax.management.Notification;
import javax.management.NotificationListener;
import javax.management.ObjectName;
import org.dcm4che.data.Dataset;
import org.dcm4chex.archive.dcm.gpwlscp.GPWLScpService;
import org.dcm4chex.archive.ejb.interfaces.StudyMgt;
import org.dcm4chex.archive.ejb.interfaces.StudyMgtHome;
import org.dcm4chex.archive.util.EJBHomeFactory;
import org.jboss.system.ServiceMBeanSupport;

public class StudyStatusService
extends ServiceMBeanSupport
implements NotificationListener {
    private static final String DELIMS = ":=;,\n\r\t";
    private static final String NONE = "NONE";
    private ObjectName gpwlScpServiceName;
    private LinkedHashMap code2status = new LinkedHashMap();

    public final String getStatusUpdateRules() {
        if (this.code2status.isEmpty()) {
            return NONE;
        }
        StringBuffer sb = new StringBuffer();
        for (Map.Entry e : this.code2status.entrySet()) {
            sb.append(e.getKey()).append(':').append(e.getValue()).append(System.getProperty("line.separator", "\n"));
        }
        return sb.toString();
    }

    public final void setStatusUpdateRules(String str) {
        this.code2status.clear();
        if (str.equalsIgnoreCase(NONE)) {
            return;
        }
        StringTokenizer strtk = new StringTokenizer(str, DELIMS);
        String key = null;
        while (strtk.hasMoreTokens()) {
            String tk = strtk.nextToken();
            if (key != null) {
                this.code2status.put(key, tk);
                key = null;
                continue;
            }
            key = tk;
        }
    }

    public final ObjectName getGpwlScpServiceName() {
        return this.gpwlScpServiceName;
    }

    public final void setGpwlScpServiceName(ObjectName serviceName) {
        this.gpwlScpServiceName = serviceName;
    }

    protected void startService() throws Exception {
        this.server.addNotificationListener(this.gpwlScpServiceName, this, GPWLScpService.ON_PPS_NOTIF_FILTER, null);
    }

    protected void stopService() throws Exception {
        this.server.removeNotificationListener(this.gpwlScpServiceName, this, GPWLScpService.ON_PPS_NOTIF_FILTER, null);
    }

    public void handleNotification(Notification notif, Object handback) {
        Dataset pps = (Dataset)notif.getUserData();
        Dataset codeItem = pps.getItem(4210713);
        if (codeItem == null) {
            return;
        }
        String key = "" + codeItem.getString(524544) + '^' + codeItem.getString(524546);
        String status = (String)this.code2status.get(key);
        if (status == null) {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("No Status Update Rule for Performed Work Item Code: " + key));
            }
            return;
        }
        Dataset rqItem = pps.getItem(4236144);
        if (rqItem == null) {
            this.log.debug((Object)"Missing Ref.Request Item - No Status Update");
            return;
        }
        String suid = rqItem.getString(0x20000D);
        if (suid == null) {
            this.log.debug((Object)"Missing Study Instance UID in Ref.Request Item - No Status Update");
            return;
        }
        try {
            StudyMgtHome home = (StudyMgtHome)EJBHomeFactory.getFactory().lookup(StudyMgtHome.class, "ejb/StudyMgt");
            StudyMgt mgt = home.create();
            mgt.updateStudyStatusId(suid, status);
            this.log.info((Object)("Updated Status ID of Study[iuid=" + suid + "] to " + status));
        }
        catch (Exception e) {
            this.log.error((Object)("Failed to update Status ID of Study[iuid=" + suid + "]:"), (Throwable)e);
        }
    }
}

