/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4chex.archive.mbean;

import java.io.IOException;
import java.rmi.RemoteException;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.ejb.FinderException;
import javax.management.Notification;
import javax.management.NotificationListener;
import javax.management.ObjectName;
import org.apache.log4j.Logger;
import org.dcm4che.data.Command;
import org.dcm4che.data.Dataset;
import org.dcm4che.data.DcmObjectFactory;
import org.dcm4che.dict.Tags;
import org.dcm4che.net.ActiveAssociation;
import org.dcm4che.net.AssociationFactory;
import org.dcm4che.net.DcmServiceException;
import org.dcm4che.net.Dimse;
import org.dcm4che.net.FutureRSP;
import org.dcm4chex.archive.config.RetryIntervalls;
import org.dcm4chex.archive.dcm.AbstractScuService;
import org.dcm4chex.archive.ejb.interfaces.StudyReconciliation;
import org.dcm4chex.archive.ejb.interfaces.StudyReconciliationHome;
import org.dcm4chex.archive.ejb.jdbc.QueryCmd;
import org.dcm4chex.archive.mbean.SchedulerDelegate;
import org.dcm4chex.archive.util.EJBHomeFactory;

public class StudyReconciliationService
extends AbstractScuService {
    private final SchedulerDelegate scheduler = new SchedulerDelegate(this);
    private long taskInterval = 0L;
    private boolean isRunning;
    private int disabledStartHour;
    private int disabledEndHour;
    private int limitNumberOfStudiesPerTask;
    private long minStudyAge;
    private int scheduledStatus = 1;
    private int successStatus = 0;
    private int failureStatus = -1;
    private String calledAET = "TIANI_ARCHIVE";
    private boolean keepPriorPatientAfterMerge = true;
    private Integer listenerID;
    private static final AssociationFactory af = AssociationFactory.getInstance();
    private static final DcmObjectFactory dof = DcmObjectFactory.getInstance();
    private static final int PCID_FIND = 1;
    private int priority = 0;
    private int fetchSize;
    private String timerIDCheckStudyReconciliation = "CheckStudyReconciliation";
    private static final int[] UPDATE_ATTRIBUTES = new int[]{0x101000, 0x101001, 528432, 0x200010, 524368, 524320, 524336, 524432, 528446, 0x200011, 524384, 1572885, 524321, 524337, 0x200060, 528464};
    private static final Logger log = Logger.getLogger(StudyReconciliationService.class);
    private final NotificationListener updateCheckListener = new NotificationListener(){

        public void handleNotification(Notification notif, Object handback) {
            Calendar cal = Calendar.getInstance();
            int hour = cal.get(11);
            if (StudyReconciliationService.this.isDisabled(hour)) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Study Reconciliation ignored in time between " + StudyReconciliationService.this.disabledStartHour + " and " + StudyReconciliationService.this.disabledEndHour + " !"));
                }
            } else {
                new Thread(new Runnable(){

                    public void run() {
                        try {
                            log.info((Object)StudyReconciliationService.this.check());
                        }
                        catch (Exception e) {
                            log.error((Object)"Study Reconciliation failed!", (Throwable)e);
                        }
                    }
                }).start();
            }
        }
    };

    public ObjectName getSchedulerServiceName() {
        return this.scheduler.getSchedulerServiceName();
    }

    public void setSchedulerServiceName(ObjectName schedulerServiceName) {
        this.scheduler.setSchedulerServiceName(schedulerServiceName);
    }

    public String getCalledAET() {
        return this.calledAET;
    }

    public void setCalledAET(String calledAET) {
        this.calledAET = calledAET;
    }

    public final String getTaskInterval() {
        String s = RetryIntervalls.formatIntervalZeroAsNever(this.taskInterval);
        return this.disabledEndHour == -1 ? s : s + "!" + this.disabledStartHour + "-" + this.disabledEndHour;
    }

    public void setTaskInterval(String interval) throws Exception {
        long oldInterval = this.taskInterval;
        int pos = interval.indexOf(33);
        if (pos == -1) {
            this.taskInterval = RetryIntervalls.parseIntervalOrNever(interval);
            this.disabledEndHour = -1;
        } else {
            this.taskInterval = RetryIntervalls.parseIntervalOrNever(interval.substring(0, pos));
            int pos1 = interval.indexOf(45, pos);
            this.disabledStartHour = Integer.parseInt(interval.substring(pos + 1, pos1));
            this.disabledEndHour = Integer.parseInt(interval.substring(pos1 + 1));
        }
        if (this.getState() == 3 && oldInterval != this.taskInterval) {
            this.scheduler.stopScheduler(this.timerIDCheckStudyReconciliation, this.listenerID, this.updateCheckListener);
            this.listenerID = this.scheduler.startScheduler(this.timerIDCheckStudyReconciliation, this.taskInterval, this.updateCheckListener);
        }
    }

    public boolean isRunning() {
        return this.isRunning;
    }

    public String getMinStudyAge() {
        return RetryIntervalls.formatInterval(this.minStudyAge);
    }

    public void setMinStudyAge(String age) {
        this.minStudyAge = RetryIntervalls.parseInterval(age);
    }

    public int getLimitNumberOfStudiesPerTask() {
        return this.limitNumberOfStudiesPerTask;
    }

    public void setLimitNumberOfStudiesPerTask(int limit) {
        this.limitNumberOfStudiesPerTask = limit;
    }

    public int getScheduledStatus() {
        return this.scheduledStatus;
    }

    public void setScheduledStatus(int status) {
        this.scheduledStatus = status;
    }

    public int getSuccessStatus() {
        return this.successStatus;
    }

    public void setSuccessStatus(int status) {
        this.successStatus = status;
    }

    public int getFailureStatus() {
        return this.failureStatus;
    }

    public void setFailureStatus(int failureStatus) {
        this.failureStatus = failureStatus;
    }

    public boolean isKeepPriorPatientAfterMerge() {
        return this.keepPriorPatientAfterMerge;
    }

    public void setKeepPriorPatientAfterMerge(boolean keepPriorPatientAfterMerge) {
        this.keepPriorPatientAfterMerge = keepPriorPatientAfterMerge;
    }

    public int getFetchSize() {
        return this.fetchSize;
    }

    public void setFetchSize(int fetchSize) {
        this.fetchSize = fetchSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String check() throws Exception {
        Collection col;
        StudyReconciliation studyReconciliation;
        long start;
        block17: {
            StudyReconciliationService studyReconciliationService = this;
            synchronized (studyReconciliationService) {
                if (this.isRunning) {
                    String msg = "SyncFileStatus is already running!";
                    log.info((Object)msg);
                    return msg;
                }
                this.isRunning = true;
            }
            start = System.currentTimeMillis();
            studyReconciliation = this.newStudyReconciliation();
            Timestamp createdBefore = new Timestamp(System.currentTimeMillis() - this.minStudyAge);
            col = studyReconciliation.getStudyIuidsWithStatus(this.scheduledStatus, createdBefore, this.limitNumberOfStudiesPerTask);
            log.info((Object)("Check " + col.size() + " Studies for Reconcilitiation (status:" + this.scheduledStatus + ")"));
            if (!col.isEmpty()) break block17;
            log.debug((Object)("No Studies with status " + this.scheduledStatus + " found for Reconcilitiation!"));
            String string = "Nothing to do!";
            Object var21_10 = null;
            this.isRunning = false;
            return string;
        }
        try {
            Dataset qrSeriesDS = this.getSeriesQueryDS();
            Dataset qrInstanceDS = this.getInstanceQueryDS();
            ActiveAssociation aa = this.openAssociation(this.calledAET, "1.2.840.10008.5.1.4.1.2.2.1");
            int numPatUpdt = 0;
            int numPatMerge = 0;
            int numFailures = 0;
            try {
                for (String studyIuid : col) {
                    qrSeriesDS.putUI(0x20000D, studyIuid);
                    Map archiveStudy = this.query(aa, qrSeriesDS, 0x20000E);
                    Dataset patDS = this.checkStudy(qrSeriesDS, qrInstanceDS, archiveStudy, aa);
                    if (patDS != null) {
                        log.debug((Object)("check Patient info of study " + studyIuid));
                        Dataset origPatDS = (Dataset)archiveStudy.values().iterator().next();
                        if (this.compare(patDS, origPatDS, 0x100020) && this.compare(patDS, origPatDS, 0x100021)) {
                            if (!(this.compare(patDS, origPatDS, 0x100010) && this.compare(patDS, origPatDS, 0x100030) && this.compare(patDS, origPatDS, 0x100040))) {
                                log.info((Object)("UPDATE patient: " + origPatDS.getString(0x100020)));
                                studyReconciliation.updatePatient(origPatDS);
                                ++numPatUpdt;
                            }
                        } else {
                            log.info((Object)("MERGE patient: " + patDS.getString(0x100020) + " with " + origPatDS.getString(0x100020)));
                            studyReconciliation.mergePatient(origPatDS, patDS, this.keepPriorPatientAfterMerge);
                            ++numPatMerge;
                        }
                        studyReconciliation.updateStudyAndSeries(studyIuid, this.successStatus, archiveStudy);
                        continue;
                    }
                    ++numFailures;
                    studyReconciliation.updateStatus(studyIuid, this.failureStatus);
                }
                Object var18_23 = null;
            }
            catch (Throwable throwable) {
                Object var18_24 = null;
                try {
                    aa.release(true);
                }
                catch (Exception e) {
                    log.warn((Object)("Failed to release association " + aa.getAssociation()), (Throwable)e);
                }
                throw throwable;
            }
            try {
                aa.release(true);
            }
            catch (Exception e) {
                log.warn((Object)("Failed to release association " + aa.getAssociation()), (Throwable)e);
            }
            StringBuffer sb = new StringBuffer();
            sb.append(col.size()).append(" studies checked for Reconciliation!(updt:").append(numPatUpdt);
            sb.append(";merged:").append(numPatMerge).append(";failed:").append(numFailures);
            sb.append(") in ").append(System.currentTimeMillis() - start).append(" ms");
            String string = sb.toString();
            Object var21_11 = null;
            this.isRunning = false;
            return string;
        }
        catch (Throwable throwable) {
            Object var21_12 = null;
            this.isRunning = false;
            throw throwable;
        }
    }

    private boolean compare(Dataset ds1, Dataset ds2, int tag) {
        String s1 = ds1.getString(tag);
        String s2 = ds2.getString(tag);
        if (log.isDebugEnabled()) {
            log.debug((Object)("compare '" + s1 + "'=?'" + s2 + "'"));
        }
        return s1 == null ? s2 == null : s1.equals(s2);
    }

    private Dataset getSeriesQueryDS() {
        Dataset qrDS = dof.newDataset();
        qrDS.putCS(524370, "SERIES");
        qrDS.putUI(0x20000E);
        qrDS.putLO(0x100020);
        qrDS.putPN(0x100021);
        qrDS.putPN(0x100010);
        qrDS.putPN(0x100030);
        qrDS.putPN(0x100040);
        for (int i = 0; i < UPDATE_ATTRIBUTES.length; ++i) {
            if (qrDS.contains(UPDATE_ATTRIBUTES[i])) continue;
            qrDS.putXX(UPDATE_ATTRIBUTES[i]);
        }
        return qrDS;
    }

    private Dataset getInstanceQueryDS() {
        Dataset qrDS = dof.newDataset();
        qrDS.putCS(524370, "IMAGE");
        qrDS.putUI(524312);
        return qrDS;
    }

    private Map query(ActiveAssociation aassoc, Dataset keys, int tag) throws InterruptedException, IOException {
        if (aassoc == null) {
            throw new IllegalStateException("No Association established");
        }
        Command rqCmd = dof.newCommand();
        rqCmd.initCFindRQ(aassoc.getAssociation().nextMsgID(), "1.2.840.10008.5.1.4.1.2.2.1", this.priority);
        Dimse findRq = af.newDimse(1, rqCmd, keys);
        FutureRSP future = aassoc.invoke(findRq);
        Dimse findRsp = future.get();
        List findRspList = future.listPending();
        HashMap<String, Dataset> map = new HashMap<String, Dataset>(findRspList.size());
        int len = findRspList.size();
        for (int i = 0; i < len; ++i) {
            Dataset ds = ((Dimse)findRspList.get(i)).getDataset();
            String iuid = ds.getString(tag);
            this.removeEmptyUpdateAttributes(ds);
            if (map.put(iuid, ds) == null) continue;
            throw new IllegalArgumentException("C-FIND contains two items with same uid (" + Tags.toString(tag) + ") ! :" + iuid);
        }
        return map;
    }

    private void removeEmptyUpdateAttributes(Dataset ds) {
        for (int i = 0; i < UPDATE_ATTRIBUTES.length; ++i) {
            String value = ds.getString(UPDATE_ATTRIBUTES[i]);
            if (value != null && value.length() >= 1) continue;
            log.info((Object)("remove empty update attribute:" + UPDATE_ATTRIBUTES[i]));
            ds.remove(UPDATE_ATTRIBUTES[i]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Dataset checkStudy(Dataset qrSeriesDS, Dataset qrInstanceDS, Map archiveStudy, ActiveAssociation aa) throws Exception {
        Dataset dataset;
        QueryCmd queryCmd = QueryCmd.create((Dataset)qrSeriesDS, null, (boolean)false, (boolean)false, (boolean)false, (boolean)false, null);
        HashMap<String, Dataset> map = new HashMap<String, Dataset>();
        try {
            queryCmd.setFetchSize(this.fetchSize).execute();
            Dataset ds = null;
            String seriesIUID = null;
            while (queryCmd.next()) {
                block8: {
                    Dataset dataset2;
                    try {
                        ds = queryCmd.getDataset();
                        seriesIUID = ds.getString(0x20000E);
                        if (archiveStudy.get(seriesIUID) != null) break block8;
                        log.warn((Object)("Study Reconciliation failed! Series " + seriesIUID + " not available at reference FIND SCP! study:" + qrSeriesDS.getString(0x20000D)));
                        dataset2 = null;
                    }
                    catch (Exception x) {
                        log.error((Object)("Study Reconciliation failed! (study:" + qrSeriesDS.getString(0x20000D) + ")! Internal error:" + x.getMessage()), (Throwable)x);
                        Dataset dataset3 = null;
                        Object var12_16 = null;
                        queryCmd.close();
                        return dataset3;
                    }
                    Object var12_14 = null;
                    queryCmd.close();
                    return dataset2;
                }
                if (map.put(seriesIUID, ds) == null) continue;
                log.error((Object)("Local result contains two series with same iuid! :" + seriesIUID));
                Dataset dataset4 = null;
                Object var12_15 = null;
                queryCmd.close();
                return dataset4;
            }
            if (archiveStudy.size() != map.size()) {
                log.warn((Object)("Study Reconciliation failed! Number of Series mismatch! study:" + qrSeriesDS.getString(0x20000D)));
                Dataset x = null;
                Object var12_17 = null;
                queryCmd.close();
                return x;
            }
            boolean checked = true;
            qrInstanceDS.putUI(0x20000D, qrSeriesDS.getString(0x20000D));
            Iterator iter = archiveStudy.keySet().iterator();
            while (iter.hasNext() && checked) {
                qrInstanceDS.putUI(0x20000E, (String)iter.next());
                checked = this.checkSeries(qrInstanceDS, aa);
            }
            dataset = checked ? ds : null;
            Object var12_18 = null;
        }
        catch (Throwable throwable) {
            Object var12_19 = null;
            queryCmd.close();
            throw throwable;
        }
        queryCmd.close();
        return dataset;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean checkSeries(Dataset qrInstanceDS, ActiveAssociation aa) throws Exception {
        Map archiveSeries = this.query(aa, qrInstanceDS, 524312);
        QueryCmd queryCmd = QueryCmd.create((Dataset)qrInstanceDS, null, (boolean)false, (boolean)false, (boolean)false, (boolean)false, null);
        try {
            queryCmd.execute();
            String iuid = null;
            HashMap<String, Dataset> map = new HashMap<String, Dataset>();
            while (queryCmd.next()) {
                Dataset ds;
                block7: {
                    boolean bl;
                    try {
                        ds = queryCmd.getDataset();
                        iuid = ds.getString(524312);
                        if (archiveSeries.get(iuid) != null) break block7;
                        log.warn((Object)("Study Reconciliation failed! Instance " + iuid + " not available at reference FIND SCP! study:" + qrInstanceDS.getString(0x20000D) + " series:" + qrInstanceDS.getString(0x20000E)));
                        bl = false;
                    }
                    catch (Exception x) {
                        log.error((Object)("Study Reconciliation failed! (Series IUID:" + qrInstanceDS.getString(0x20000E) + ")! Internal error:" + x.getMessage()), (Throwable)x);
                        boolean bl2 = false;
                        Object var11_14 = null;
                        queryCmd.close();
                        return bl2;
                    }
                    Object var11_12 = null;
                    queryCmd.close();
                    return bl;
                }
                if (map.put(iuid, ds) == null) continue;
                log.error((Object)("Local result contains two instances with same iuid! :" + iuid));
                boolean bl = false;
                Object var11_13 = null;
                queryCmd.close();
                return bl;
            }
            if (archiveSeries.size() != map.size()) {
                log.warn((Object)("Study Reconciliation failed! Number of Instances mismatch! study:" + qrInstanceDS.getString(0x20000D) + " series:" + qrInstanceDS.getString(0x20000E)));
                boolean bl = false;
                Object var11_15 = null;
                queryCmd.close();
                return bl;
            }
            Object var11_16 = null;
            queryCmd.close();
            return true;
        }
        catch (Throwable throwable) {
            Object var11_17 = null;
            queryCmd.close();
            throw throwable;
        }
    }

    public String reschedule() throws RemoteException, FinderException, DcmServiceException {
        Collection col;
        StudyReconciliation studyReconciliation = this.newStudyReconciliation();
        Timestamp createdBefore = new Timestamp(System.currentTimeMillis());
        int total = 0;
        while (!(col = studyReconciliation.getStudyIuidsWithStatus(this.failureStatus, createdBefore, this.limitNumberOfStudiesPerTask)).isEmpty()) {
            studyReconciliation.updateStatus(col, this.scheduledStatus);
            total += col.size();
        }
        return total + " studies rescheduled for Reconciliation!";
    }

    private boolean isDisabled(int hour) {
        boolean inside;
        if (this.disabledEndHour == -1) {
            return false;
        }
        boolean sameday = this.disabledStartHour <= this.disabledEndHour;
        boolean bl = inside = hour >= this.disabledStartHour && hour < this.disabledEndHour;
        return sameday ? inside : !inside;
    }

    protected void startService() throws Exception {
        this.listenerID = this.scheduler.startScheduler(this.timerIDCheckStudyReconciliation, this.taskInterval, this.updateCheckListener);
    }

    protected void stopService() throws Exception {
        this.scheduler.stopScheduler(this.timerIDCheckStudyReconciliation, this.listenerID, this.updateCheckListener);
        super.stopService();
    }

    private StudyReconciliation newStudyReconciliation() {
        try {
            StudyReconciliationHome home = (StudyReconciliationHome)EJBHomeFactory.getFactory().lookup(StudyReconciliationHome.class, "ejb/StudyReconciliation");
            return home.create();
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to access Study Reconciliation SessionBean:", e);
        }
    }

    public String getTimerIDCheckStudyReconciliation() {
        return this.timerIDCheckStudyReconciliation;
    }

    public void setTimerIDCheckStudyReconciliation(String timerIDCheckStudyReconciliation) {
        this.timerIDCheckStudyReconciliation = timerIDCheckStudyReconciliation;
    }
}

