/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4chex.archive.mbean;

import java.io.File;
import java.io.Serializable;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.activation.FileDataSource;
import javax.jms.MessageListener;
import javax.jms.ObjectMessage;
import javax.mail.Address;
import javax.mail.BodyPart;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import javax.management.Notification;
import javax.management.NotificationFilter;
import javax.management.ObjectName;
import org.dcm4chex.archive.config.RetryIntervalls;
import org.dcm4chex.archive.mbean.JMSDelegate;
import org.dcm4chex.archive.mbean.SendMailMessageStatus;
import org.jboss.system.ServiceMBeanSupport;

public class SendMailService
extends ServiceMBeanSupport {
    public static final String MAIL_BODY = "body";
    public static final String MAIL_FILES = "files";
    public static final String MAIL_CC_ADDR = "ccAddr";
    public static final String MAIL_TO_ADDR = "toAddr";
    public static final String MAIL_REPLY_TO = "replyTo";
    public static final String MAIL_FROM_ADDR = "fromAddr";
    public static final String MAIL_SUBJECT = "subject";
    public static final String MAIL_RETRIES = "retries";
    public static final String MAIL_FAILURE_COUNT = "failureCount";
    private String queueName;
    private String smtpHost = "mail";
    private int smtpPort = 25;
    private boolean smtpAuth;
    private String smtpUser = "";
    private String smtpPassword = "";
    private RetryIntervalls retryIntervalls;
    private int concurrency = 1;
    private JMSDelegate jmsDelegate = new JMSDelegate(this);
    public static final NotificationFilter NOTIF_FILTER = new NotificationFilter(){
        private static final long serialVersionUID = -993747994840770270L;

        public boolean isNotificationEnabled(Notification notif) {
            return SendMailMessageStatus.class.getName().equals(notif.getType());
        }
    };
    private final MessageListener listener = new MessageListener(){

        public void onMessage(javax.jms.Message msg) {
            ObjectMessage objmsg = (ObjectMessage)msg;
            try {
                SendMailService.this.process((Map)((Object)objmsg.getObject()));
            }
            catch (Throwable e) {
                SendMailService.this.log.error((Object)e.getMessage(), e);
            }
        }
    };

    public final ObjectName getJmsServiceName() {
        return this.jmsDelegate.getJmsServiceName();
    }

    public final void setJmsServiceName(ObjectName jmsServiceName) {
        this.jmsDelegate.setJmsServiceName(jmsServiceName);
    }

    public final String getQueueName() {
        return this.queueName;
    }

    public final void setQueueName(String queueName) {
        this.queueName = queueName;
    }

    public final int getConcurrency() {
        return this.concurrency;
    }

    public final void setConcurrency(int concurrency) throws Exception {
        if (concurrency <= 0) {
            throw new IllegalArgumentException("Concurrency: " + concurrency);
        }
        if (this.concurrency != concurrency) {
            boolean restart;
            boolean bl = restart = this.getState() == 3;
            if (restart) {
                this.stop();
            }
            this.concurrency = concurrency;
            if (restart) {
                this.start();
            }
        }
    }

    public final String getSmtpHost() {
        return this.smtpHost;
    }

    public final void setSmtpHost(String smtpHost) {
        this.smtpHost = smtpHost;
    }

    public boolean isSmtpAuth() {
        return this.smtpAuth;
    }

    public void setSmtpAuth(boolean smtpAuth) {
        this.smtpAuth = smtpAuth;
    }

    public int getSmtpPort() {
        return this.smtpPort;
    }

    public void setSmtpPort(int smtpPort) {
        this.smtpPort = smtpPort;
    }

    public final String getSmtpUser() {
        return this.smtpUser;
    }

    public final void setSmtpUser(String smtpUser) {
        this.smtpUser = smtpUser;
    }

    public final void setSmtpPassword(String smtpPassword) {
        this.smtpPassword = smtpPassword;
    }

    public final String getRetryIntervalls() {
        return this.retryIntervalls.toString();
    }

    public final void setRetryIntervalls(String s) {
        this.retryIntervalls = new RetryIntervalls(s);
    }

    protected void startService() throws Exception {
        super.startService();
        this.jmsDelegate.startListening(this.queueName, this.listener, this.concurrency);
    }

    protected void stopService() throws Exception {
        this.jmsDelegate.stopListening(this.queueName);
        super.stopService();
    }

    private void process(Map mailProps) throws Exception {
        this.log.info((Object)("process " + mailProps));
        Session session = Session.getInstance((Properties)this.createSessionProperties());
        this.log.info((Object)("Mail session props:" + session.getProperties()));
        MimeMessage message = new MimeMessage(session);
        this.initSimpleMail(mailProps, message);
        File[] files = (File[])mailProps.get(MAIL_FILES);
        if (files != null && files.length > 0) {
            MimeMultipart multipart = new MimeMultipart("mixed");
            MimeBodyPart textbodypart = new MimeBodyPart();
            textbodypart.setText((String)mailProps.get(MAIL_BODY));
            multipart.addBodyPart((BodyPart)textbodypart);
            for (int i = 0; i < files.length; ++i) {
                if (!files[i].isFile()) continue;
                MimeBodyPart filebodypart = new MimeBodyPart();
                FileDataSource source = new FileDataSource(files[i]);
                filebodypart.setDataHandler(new DataHandler((DataSource)source));
                filebodypart.setFileName(files[i].getName());
                multipart.addBodyPart((BodyPart)filebodypart);
            }
            message.setContent((Multipart)multipart);
            this.log.info((Object)new StringBuffer().append("sending message: ").append(files.length).append(" files attached"));
        } else {
            message.setText((String)mailProps.get(MAIL_BODY));
        }
        try {
            message.saveChanges();
            Transport.send((Message)message);
            this.log.info((Object)("Message sent to " + mailProps.get(MAIL_TO_ADDR)));
            this.sendJMXNotification(new SendMailMessageStatus(mailProps));
        }
        catch (Exception e) {
            this.log.warn((Object)("Failed to send " + mailProps), (Throwable)e);
            int failureCount = 0;
            Integer failures = (Integer)mailProps.get(MAIL_FAILURE_COUNT);
            if (failures != null) {
                failureCount = failures;
            }
            mailProps.put(MAIL_FAILURE_COUNT, new Integer(++failureCount));
            long delay = this.retryIntervalls.getIntervall(failureCount);
            if (delay == -1L) {
                this.log.error((Object)("Give up to send " + mailProps));
                this.sendJMXNotification(new SendMailMessageStatus(false, mailProps));
            }
            this.log.warn((Object)("Failed to send " + mailProps + ". Scheduling retry."));
            this.jmsDelegate.queue(this.queueName, (Serializable)((Object)mailProps), 0, System.currentTimeMillis() + delay);
        }
    }

    public String send(String subject, String fromAddress, String toAddress, String body) {
        HashMap<String, String> mail = new HashMap<String, String>();
        mail.put(MAIL_BODY, body);
        mail.put(MAIL_FROM_ADDR, fromAddress);
        mail.put(MAIL_SUBJECT, subject);
        mail.put(MAIL_TO_ADDR, toAddress);
        try {
            this.jmsDelegate.queue(this.queueName, mail, 4, 0L);
            return "Mail '" + subject + "' succesfully sent to " + toAddress;
        }
        catch (Exception e) {
            this.log.error((Object)e.getMessage(), (Throwable)e);
            return "Failed to send mail '" + subject + "' to " + toAddress + " ! Reason:" + e.getMessage();
        }
    }

    private Properties createSessionProperties() {
        Properties properties = new Properties();
        if (this.getSmtpHost().equals(null)) {
            properties.put("mail.smtp.host", "127.0.0.1");
        } else {
            properties.put("mail.smtp.host", this.smtpHost);
        }
        properties.put("mail.smtp.port", String.valueOf(this.smtpPort));
        if (this.smtpUser != null && this.smtpUser.length() > 0 && this.smtpPassword != null && this.smtpPassword.length() > 0) {
            properties.put("mail.smtp.auth", String.valueOf(this.smtpAuth));
            properties.put("mail.smtp.user", this.smtpUser);
            properties.put("mail.smtp.password", this.smtpPassword);
        } else {
            properties.put("mail.smtp.auth", "false");
        }
        return properties;
    }

    private void initSimpleMail(Map map, MimeMessage message) throws AddressException, MessagingException {
        if (map.get(MAIL_SUBJECT) != null) {
            message.setSubject((String)map.get(MAIL_SUBJECT));
        }
        message.setSentDate(new Date());
        String fromAddr = (String)map.get(MAIL_FROM_ADDR);
        if (fromAddr != null) {
            try {
                message.setFrom((Address)new InternetAddress(fromAddr));
                String replyTo = (String)map.get(MAIL_REPLY_TO);
                if (replyTo == null) {
                    replyTo = fromAddr;
                }
                try {
                    message.setReplyTo(new Address[]{new InternetAddress(fromAddr)});
                }
                catch (Exception x) {}
            }
            catch (AddressException e) {
                throw new AddressException("invalid from address: " + fromAddr + ": " + e.getMessage());
            }
        }
        String toAddr = (String)map.get(MAIL_TO_ADDR);
        if (toAddr == null) {
            throw new AddressException("no to address");
        }
        try {
            message.setRecipients(Message.RecipientType.TO, (Address[])InternetAddress.parse((String)toAddr));
        }
        catch (AddressException e) {
            throw new AddressException("invalid to address: " + toAddr + ": " + e.getMessage());
        }
        String ccAddr = (String)map.get(MAIL_CC_ADDR);
        if (ccAddr != null) {
            try {
                message.setRecipients(Message.RecipientType.CC, (Address[])InternetAddress.parse((String)ccAddr));
            }
            catch (AddressException e) {
                throw new AddressException("invalid cc address: " + ccAddr + ": " + e.getMessage());
            }
        }
    }

    private void sendJMXNotification(SendMailMessageStatus msg) {
        long eventID = super.getNextNotificationSequenceNumber();
        Notification notif = new Notification(msg.getClass().getName(), (Object)this, eventID);
        notif.setUserData(msg);
        super.sendNotification(notif);
    }
}

