/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4chex.archive.mbean;

import java.util.Date;
import javax.management.Notification;
import javax.management.NotificationListener;
import javax.management.ObjectName;
import javax.management.timer.TimerNotification;
import org.jboss.system.ServiceMBeanSupport;

public class SchedulerService
extends ServiceMBeanSupport {
    public static String DEFAULT_TIMER_NAME = "jboss:service=Timer";
    private ObjectName mTimer;

    protected void startService() throws Exception {
        this.mTimer = new ObjectName(DEFAULT_TIMER_NAME);
        if (!this.server.isRegistered(this.mTimer)) {
            this.server.createMBean("javax.management.timer.Timer", this.mTimer);
        }
        if (!((Boolean)this.server.getAttribute(this.mTimer, "Active")).booleanValue()) {
            this.server.invoke(this.mTimer, "start", new Object[0], new String[0]);
        }
    }

    public Integer startScheduler(String name, long period, NotificationListener listener) {
        if (period <= 0L) {
            return null;
        }
        try {
            this.log.info((Object)("Start Scheduler " + name + " with period of " + period + "ms in 1 s."));
            Date now = new Date(System.currentTimeMillis() + 1000L);
            Integer id = (Integer)this.server.invoke(this.mTimer, "addNotification", new Object[]{"Schedule", "Scheduler Notification", null, now, new Long(period)}, new String[]{String.class.getName(), String.class.getName(), Object.class.getName(), Date.class.getName(), Long.TYPE.getName()});
            this.server.addNotificationListener(this.mTimer, listener, (javax.management.NotificationFilter)new NotificationFilter(id), null);
            return id;
        }
        catch (Exception e) {
            this.log.error((Object)"operation failed", (Throwable)e);
            return null;
        }
    }

    public void stopScheduler(String name, Integer id, NotificationListener listener) {
        if (id == null) {
            return;
        }
        try {
            this.log.info((Object)("Stop Scheduler " + name));
            this.server.removeNotificationListener(this.mTimer, listener);
            this.server.invoke(this.mTimer, "removeNotification", new Object[]{id}, new String[]{Integer.class.getName()});
        }
        catch (Exception e) {
            this.log.error((Object)"operation failed", (Throwable)e);
        }
    }

    private static class NotificationFilter
    implements javax.management.NotificationFilter {
        private static final long serialVersionUID = -2450167711140857405L;
        private Integer mId;

        public NotificationFilter(Integer pId) {
            this.mId = pId;
        }

        public boolean isNotificationEnabled(Notification notification) {
            if (notification instanceof TimerNotification) {
                TimerNotification lTimerNotification = (TimerNotification)notification;
                return lTimerNotification.getNotificationID().equals(this.mId);
            }
            return false;
        }
    }
}

