/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4chex.archive.mbean;

import java.io.Serializable;
import java.rmi.RemoteException;
import javax.ejb.CreateException;
import javax.jms.Message;
import javax.jms.MessageListener;
import javax.jms.ObjectMessage;
import javax.management.Notification;
import javax.management.NotificationListener;
import javax.management.ObjectName;
import org.dcm4che.data.Dataset;
import org.dcm4chex.archive.dcm.mppsscp.MPPSScpService;
import org.dcm4chex.archive.ejb.interfaces.PrivateManager;
import org.dcm4chex.archive.ejb.interfaces.PrivateManagerHome;
import org.dcm4chex.archive.mbean.JMSDelegate;
import org.dcm4chex.archive.util.EJBHomeFactory;
import org.dcm4chex.archive.util.HomeFactoryException;
import org.jboss.system.ServiceMBeanSupport;

public class PPSExceptionMgtService
extends ServiceMBeanSupport
implements NotificationListener,
MessageListener {
    private String queueName;
    private ObjectName mppsScpServiceName;
    private PrivateManager privateManager;
    private long delay = 0L;
    private JMSDelegate jmsDelegate = new JMSDelegate(this);

    public final ObjectName getJmsServiceName() {
        return this.jmsDelegate.getJmsServiceName();
    }

    public final void setJmsServiceName(ObjectName jmsServiceName) {
        this.jmsDelegate.setJmsServiceName(jmsServiceName);
    }

    public final String getQueueName() {
        return this.queueName;
    }

    public final void setQueueName(String queueName) {
        this.queueName = queueName;
    }

    public long getDelay() {
        return this.delay;
    }

    public void setDelay(long delay) {
        this.delay = delay;
    }

    public final ObjectName getMppsScpServiceName() {
        return this.mppsScpServiceName;
    }

    public final void setMppsScpServiceName(ObjectName mppsScpServiceName) {
        this.mppsScpServiceName = mppsScpServiceName;
    }

    protected void startService() throws Exception {
        this.jmsDelegate.startListening(this.queueName, this, 1);
        this.server.addNotificationListener(this.mppsScpServiceName, this, MPPSScpService.NOTIF_FILTER, null);
    }

    protected void stopService() throws Exception {
        this.server.removeNotificationListener(this.mppsScpServiceName, this, MPPSScpService.NOTIF_FILTER, null);
        this.jmsDelegate.stopListening(this.queueName);
    }

    public void handleNotification(Notification notif, Object handback) {
        Dataset mppsDS = null;
        try {
            if (notif.getType().equals("org.dcm4chex.archive.dcm.mppsscp#received")) {
                Dataset item;
                mppsDS = (Dataset)notif.getUserData();
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)"MPPS received. mpps:");
                    this.log.debug((Object)mppsDS);
                }
                if ((item = mppsDS.getItem(4194945)) != null && "110514".equals(item.getString(524544)) && "DCM".equals(item.getString(524546))) {
                    String mppsIUID = mppsDS.getString(524312);
                    this.log.debug((Object)("Scheduled: Move discontinued Series (IncorrectWorklistEntry) to trash folder! mppsIuid:" + mppsIUID));
                    this.jmsDelegate.queue(this.queueName, (Serializable)((Object)mppsIUID), 4, System.currentTimeMillis() + this.getDelay());
                }
            }
        }
        catch (Exception e) {
            this.log.error((Object)"Can not schedule: Move discontinued Series (IncorrectWorklistEntry) to trash folder!", (Throwable)e);
        }
    }

    private PrivateManager lookupPrivateManager() throws HomeFactoryException, RemoteException, CreateException {
        if (this.privateManager != null) {
            return this.privateManager;
        }
        this.privateManager = ((PrivateManagerHome)EJBHomeFactory.getFactory().lookup(PrivateManagerHome.class, "ejb/PrivateManager")).create();
        return this.privateManager;
    }

    public void onMessage(Message message) {
        try {
            String mppsIUID = (String)((Object)((ObjectMessage)message).getObject());
            this.log.info((Object)("Move discontinued Series (IncorrectWorklistEntry) to trash folder! mppsIuid:" + mppsIUID));
            this.lookupPrivateManager().moveSeriesOfPPSToTrash(mppsIUID, true);
        }
        catch (Exception e) {
            this.getLog().error((Object)"Can not move Series with MPPS 'IncorrectWorklistEntry' to trash folder!", (Throwable)e);
        }
    }
}

