/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4chex.archive.mbean;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.management.ObjectName;
import org.dcm4cheri.util.StringUtils;
import org.dcm4chex.archive.ejb.interfaces.PIXQuery;
import org.dcm4chex.archive.ejb.interfaces.PIXQueryHome;
import org.dcm4chex.archive.util.EJBHomeFactory;
import org.jboss.system.ServiceMBeanSupport;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PIXQueryService
extends ServiceMBeanSupport {
    private ObjectName hl7SendServiceName;
    private String pixQueryName;
    private String pixManager;
    private List<String[]> mockResponse;
    private List<String> issuersOfOnlyOtherPatientIDs;
    private List<String> issuersOfOnlyPrimaryPatientIDs;

    public final String getIssuersOfOnlyPrimaryPatientIDs() {
        return this.toString(this.issuersOfOnlyPrimaryPatientIDs);
    }

    public final void setIssuersOfOnlyPrimaryPatientIDs(String s) {
        this.issuersOfOnlyPrimaryPatientIDs = this.toList(s);
    }

    public final String getIssuersOfOnlyOtherPatientIDs() {
        return this.toString(this.issuersOfOnlyOtherPatientIDs);
    }

    public final void setIssuersOfOnlyOtherPatientIDs(String s) {
        this.issuersOfOnlyOtherPatientIDs = this.toList(s);
    }

    private String toString(List<String> list) {
        if (list == null || list.isEmpty()) {
            return "-";
        }
        Iterator<String> iter = list.iterator();
        StringBuffer sb = new StringBuffer(iter.next());
        while (iter.hasNext()) {
            sb.append(',').append(iter.next());
        }
        return sb.toString();
    }

    private List<String> toList(String s) {
        if (s.trim().equals("-")) {
            return null;
        }
        String[] a = StringUtils.split(s, ',');
        ArrayList<String> list = new ArrayList<String>(a.length);
        for (int i = 0; i < a.length; ++i) {
            list.add(a[i].trim());
        }
        return list;
    }

    public final ObjectName getHL7SendServiceName() {
        return this.hl7SendServiceName;
    }

    public final void setHL7SendServiceName(ObjectName name) {
        this.hl7SendServiceName = name;
    }

    public final String getPIXManager() {
        return this.pixManager;
    }

    public final void setPIXManager(String pixManager) {
        this.pixManager = pixManager;
    }

    public final boolean isPIXManagerLocal() {
        return "LOCAL".equalsIgnoreCase(this.pixManager);
    }

    public final String getPIXQueryName() {
        return this.pixQueryName;
    }

    public final void setPIXQueryName(String pixQueryName) {
        this.pixQueryName = pixQueryName;
    }

    public final String getMockResponse() {
        return this.mockResponse == null ? "-" : this.pids2cx(this.mockResponse);
    }

    protected List<String[]> getMockResponseInternal() {
        return this.mockResponse;
    }

    private String pids2cx(List<String[]> pids) {
        StringBuffer sb = new StringBuffer();
        Iterator<String[]> iter = pids.iterator();
        while (iter.hasNext()) {
            if (sb.length() > 0) {
                sb.append('~');
            }
            String[] pid = iter.next();
            sb.append(pid[0]).append("^^^").append(pid[1]);
            for (int i = 2; i < pid.length; ++i) {
                sb.append('&').append(pid[i]);
            }
        }
        return sb.toString();
    }

    public final void setMockResponse(String mockResponse) {
        String trim = mockResponse.trim();
        this.mockResponse = "-".equals(trim) ? null : this.cx2pids(trim);
    }

    private List<String[]> cx2pids(String s) {
        String[] cx = StringUtils.split(s, '~');
        ArrayList<String[]> l = new ArrayList<String[]>(cx.length);
        for (int i = 0; i < cx.length; ++i) {
            String[] comps = StringUtils.split(s, '^');
            String[] subcomps = StringUtils.split(comps[3], '&');
            String[] pid = new String[1 + subcomps.length];
            pid[0] = comps[0];
            System.arraycopy(subcomps, 0, pid, 1, subcomps.length);
            l.add(pid);
        }
        return l;
    }

    public String showCorrespondingPIDs(String patientID, String issuer) {
        try {
            return this.pids2cx(this.queryCorrespondingPIDs(patientID, issuer, null));
        }
        catch (Exception e) {
            return e.getMessage();
        }
    }

    public List<String[]> queryCorrespondingPIDs(String patientID, String issuer, String[] domains) throws Exception {
        if (this.mockResponse != null) {
            return this.mockResponse;
        }
        if (this.isPIXManagerLocal()) {
            return this.performLocalPIXQuery(patientID, issuer, domains);
        }
        return this.performRemotePIXQuery(patientID, issuer, domains);
    }

    protected List<String[]> performLocalPIXQuery(String patientID, String issuer, String[] domains) throws Exception {
        if (this.issuersOfOnlyPrimaryPatientIDs.contains(issuer)) {
            return this.pixQuery().queryCorrespondingPIDsByPrimaryPatientID(patientID, issuer, domains);
        }
        if (this.issuersOfOnlyOtherPatientIDs.contains(issuer)) {
            return this.pixQuery().queryCorrespondingPIDsByOtherPatientID(patientID, issuer, domains);
        }
        return this.pixQuery().queryCorrespondingPIDs(patientID, issuer, domains);
    }

    protected List<String[]> performRemotePIXQuery(String patientID, String issuer, String[] domains) throws Exception {
        if (this.isPIXManagerLocal()) {
            throw new Exception("No remote PIX manager has been configured");
        }
        ArrayList<Object> res = (ArrayList<Object>)this.server.invoke(this.hl7SendServiceName, "sendQBP_Q23", new Object[]{this.pixManager, this.pixQueryName, patientID, issuer, domains}, new String[]{String.class.getName(), String.class.getName(), String.class.getName(), String.class.getName(), String[].class.getName()});
        if (res == null) {
            return res;
        }
        boolean addOriginal = true;
        for (String[] stringArray : res) {
            if (!stringArray[0].equals(patientID) || !stringArray[1].equals(issuer)) continue;
            addOriginal = false;
            break;
        }
        if (addOriginal && domains != null) {
            addOriginal = false;
            for (String domain : domains) {
                if (!domain.equals(issuer)) continue;
                addOriginal = true;
                break;
            }
        }
        if (addOriginal) {
            ArrayList<Object> prv = res;
            res = new ArrayList<Object>();
            res.add(new String[]{patientID, issuer});
            res.addAll(prv);
        }
        return res;
    }

    protected PIXQuery pixQuery() throws Exception {
        return ((PIXQueryHome)EJBHomeFactory.getFactory().lookup(PIXQueryHome.class, "ejb/PIXQuery")).create();
    }
}

