/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4chex.archive.mbean;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.OutputStream;
import java.text.MessageFormat;
import javax.management.Notification;
import javax.management.NotificationListener;
import javax.management.ObjectName;
import org.dcm4che.util.Executer;
import org.dcm4chex.archive.notif.StorageFileSystemSwitched;
import org.jboss.system.ServiceMBeanSupport;

public class OnSwitchStorageFileSystemService
extends ServiceMBeanSupport
implements NotificationListener {
    private static final String NONE = "NONE";
    private ObjectName fileSystemMgtName;
    private String onSwitchStorageFSCmd;

    public ObjectName getFileSystemMgtName() {
        return this.fileSystemMgtName;
    }

    public void setFileSystemMgtName(ObjectName fileSystemMgtName) {
        this.fileSystemMgtName = fileSystemMgtName;
    }

    public String getOnSwitchStorageFileSystemInvoke() {
        return this.onSwitchStorageFSCmd != null ? this.onSwitchStorageFSCmd : NONE;
    }

    public void setOnSwitchStorageFileSystemInvoke(String command) {
        String s = command.trim();
        if (NONE.equalsIgnoreCase(s)) {
            this.onSwitchStorageFSCmd = null;
        } else if (new MessageFormat(s).getFormats().length == 2) {
            this.onSwitchStorageFSCmd = s;
        } else {
            throw new IllegalArgumentException(command);
        }
    }

    protected void startService() throws Exception {
        this.server.addNotificationListener(this.fileSystemMgtName, this, StorageFileSystemSwitched.NOTIF_FILTER, null);
    }

    protected void stopService() throws Exception {
        this.server.removeNotificationListener(this.fileSystemMgtName, this, StorageFileSystemSwitched.NOTIF_FILTER, null);
    }

    public void handleNotification(Notification notif, Object handback) {
        if (this.onSwitchStorageFSCmd == null) {
            return;
        }
        StorageFileSystemSwitched sfss = (StorageFileSystemSwitched)notif.getUserData();
        final String cmd = MessageFormat.format(this.onSwitchStorageFSCmd, sfss.getPreviousStorageFileSystem().getDirectoryPath().replace('/', File.separatorChar), sfss.getNewStorageFileSystem().getDirectoryPath().replace('/', File.separatorChar));
        new Thread(new Runnable(){

            public void run() {
                OnSwitchStorageFileSystemService.this.execute(cmd);
            }
        }).start();
    }

    private void execute(String cmd) {
        try {
            ByteArrayOutputStream stdout = new ByteArrayOutputStream();
            Executer ex = new Executer(cmd, (OutputStream)stdout, null);
            int exit = ex.waitFor();
            if (exit != 0) {
                this.log.info((Object)("Non-zero exit code(" + exit + ") of " + cmd));
            }
        }
        catch (Exception e) {
            this.log.error((Object)("Failed to execute " + cmd), (Throwable)e);
        }
    }
}

