/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4chex.archive.mbean;

import javax.management.Attribute;
import org.apache.log4j.Logger;
import org.dcm4chex.archive.ejb.jdbc.QueryOldARRCmd;
import org.jboss.system.ServiceMBeanSupport;

public class MigrateOldAuditRecordRepositoryService
extends ServiceMBeanSupport {
    private int emissionInterval;
    private int recordsByPass;
    private long lastEmittedPk;

    public final int getEmissionInterval() {
        return this.emissionInterval;
    }

    public final void setEmissionInterval(int emissionInterval) {
        if (emissionInterval < 0) {
            throw new IllegalArgumentException("emissionInterval: " + emissionInterval);
        }
        this.emissionInterval = emissionInterval;
    }

    public final int getRecordsByPass() {
        return this.recordsByPass;
    }

    public final void setRecordsByPass(int recordByPass) {
        if (recordByPass < 0) {
            throw new IllegalArgumentException("recordByPass: " + recordByPass);
        }
        this.recordsByPass = recordByPass;
    }

    public final long getLastEmittedPk() {
        return this.lastEmittedPk;
    }

    public final void setLastEmittedPk(long lastEmittedPk) {
        this.lastEmittedPk = lastEmittedPk;
    }

    public String emitAuditRecords(int num) throws Exception {
        int count;
        int emitted;
        long ms0 = System.currentTimeMillis();
        for (count = 0; count < num && (emitted = this.emitBlockOfAuditRecords(Math.min(num - count, this.recordsByPass))) != 0; count += emitted) {
        }
        long ms = System.currentTimeMillis() - ms0;
        return "Sent " + count + " Audit messages in " + (float)ms / 1000.0f + " s.";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int emitBlockOfAuditRecords(int limit) throws Exception {
        int n;
        block3: {
            int sent;
            this.log.info((Object)("Prepare sending " + limit + " Audit messages"));
            QueryOldARRCmd.Record[] result = new QueryOldARRCmd.Record[limit];
            QueryOldARRCmd cmd = new QueryOldARRCmd(this.lastEmittedPk, limit);
            int fetched = cmd.fetch(result);
            long lastEmittedPk = 0L;
            try {
                for (sent = 0; sent < fetched; ++sent) {
                    QueryOldARRCmd.Record rec = result[sent];
                    Logger.getLogger((String)"auditlog").info((Object)rec.xml_data);
                    lastEmittedPk = rec.pk;
                    Thread.sleep(this.emissionInterval);
                }
                n = sent;
                Object var10_9 = null;
                if (sent <= 0) break block3;
            }
            catch (Throwable throwable) {
                block4: {
                    Object var10_10 = null;
                    if (sent <= 0) break block4;
                    this.log.info((Object)("Sent " + sent + " Audit messages"));
                    this.server.setAttribute(this.serviceName, new Attribute("LastEmittedPk", new Long(lastEmittedPk)));
                }
                throw throwable;
            }
            this.log.info((Object)("Sent " + sent + " Audit messages"));
            this.server.setAttribute(this.serviceName, new Attribute("LastEmittedPk", new Long(lastEmittedPk)));
        }
        return n;
    }
}

