/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4chex.archive.mbean;

import java.io.File;
import java.io.IOException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.sql.Timestamp;
import java.util.Arrays;
import java.util.Calendar;
import javax.ejb.FinderException;
import javax.management.Notification;
import javax.management.NotificationListener;
import javax.management.ObjectName;
import org.dcm4che.util.MD5Utils;
import org.dcm4chex.archive.config.RetryIntervalls;
import org.dcm4chex.archive.ejb.interfaces.FileDTO;
import org.dcm4chex.archive.ejb.interfaces.FileSystemDTO;
import org.dcm4chex.archive.ejb.interfaces.FileSystemMgt2;
import org.dcm4chex.archive.ejb.interfaces.FileSystemMgt2Home;
import org.dcm4chex.archive.mbean.SchedulerDelegate;
import org.dcm4chex.archive.util.EJBHomeFactory;
import org.dcm4chex.archive.util.FileUtils;
import org.jboss.system.ServiceMBeanSupport;

public class MD5CheckService
extends ServiceMBeanSupport {
    private final SchedulerDelegate scheduler = new SchedulerDelegate(this);
    private long taskInterval = 0L;
    private boolean isRunning;
    private long maxCheckedBefore;
    private int disabledStartHour;
    private int disabledEndHour;
    private int limitNumberOfFilesPerTask;
    private int bufferSize = 8192;
    private Integer listenerID;
    private String timerIDCheckMD5;
    private final NotificationListener timerListener = new NotificationListener(){

        public void handleNotification(Notification notif, Object handback) {
            Calendar cal = Calendar.getInstance();
            int hour = cal.get(11);
            if (MD5CheckService.this.isDisabled(hour)) {
                if (MD5CheckService.this.log.isDebugEnabled()) {
                    MD5CheckService.this.log.debug((Object)("MD5Check ignored in time between " + MD5CheckService.this.disabledStartHour + " and " + MD5CheckService.this.disabledEndHour + " !"));
                }
            } else {
                new Thread(new Runnable(){

                    public void run() {
                        try {
                            MD5CheckService.this.check();
                        }
                        catch (Exception e) {
                            MD5CheckService.this.log.error((Object)"MD5 check failed!", (Throwable)e);
                        }
                    }
                }).start();
            }
        }
    };

    public ObjectName getSchedulerServiceName() {
        return this.scheduler.getSchedulerServiceName();
    }

    public void setSchedulerServiceName(ObjectName schedulerServiceName) {
        this.scheduler.setSchedulerServiceName(schedulerServiceName);
    }

    public final int getBufferSize() {
        return this.bufferSize;
    }

    public final void setBufferSize(int bufferSize) {
        this.bufferSize = bufferSize;
    }

    public final String getTaskInterval() {
        String s = RetryIntervalls.formatIntervalZeroAsNever(this.taskInterval);
        return this.disabledEndHour == -1 ? s : s + "!" + this.disabledStartHour + "-" + this.disabledEndHour;
    }

    public void setTaskInterval(String interval) throws Exception {
        long oldInterval = this.taskInterval;
        int pos = interval.indexOf(33);
        if (pos == -1) {
            this.taskInterval = RetryIntervalls.parseIntervalOrNever(interval);
            this.disabledEndHour = -1;
        } else {
            this.taskInterval = RetryIntervalls.parseIntervalOrNever(interval.substring(0, pos));
            int pos1 = interval.indexOf(45, pos);
            this.disabledStartHour = Integer.parseInt(interval.substring(pos + 1, pos1));
            this.disabledEndHour = Integer.parseInt(interval.substring(pos1 + 1));
        }
        if (this.getState() == 3 && oldInterval != this.taskInterval) {
            this.scheduler.stopScheduler(this.timerIDCheckMD5, this.listenerID, this.timerListener);
            this.listenerID = this.scheduler.startScheduler(this.timerIDCheckMD5, this.taskInterval, this.timerListener);
        }
    }

    public boolean isRunning() {
        return this.isRunning;
    }

    public int getLimitNumberOfFilesPerTask() {
        return this.limitNumberOfFilesPerTask;
    }

    public void setLimitNumberOfFilesPerTask(int limit) {
        this.limitNumberOfFilesPerTask = limit;
    }

    public String getMaxCheckedBefore() {
        return RetryIntervalls.formatInterval(this.maxCheckedBefore);
    }

    public void setMaxCheckedBefore(String maxCheckedBefore) {
        this.maxCheckedBefore = RetryIntervalls.parseInterval(maxCheckedBefore);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String check() throws Exception {
        MD5CheckService mD5CheckService = this;
        synchronized (mD5CheckService) {
            if (this.isRunning) {
                String msg = "MD5check is already running!";
                this.log.info((Object)msg);
                return msg;
            }
            this.isRunning = true;
        }
        try {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)"MD5 check started!");
            }
            int corrupted = 0;
            int total = 0;
            Timestamp before = new Timestamp(System.currentTimeMillis() - this.maxCheckedBefore);
            int limit = this.limitNumberOfFilesPerTask;
            FileSystemMgt2 fsMgt = this.newFileSystemMgt();
            FileSystemDTO[] fsdirs = fsMgt.getAllFileSystems();
            byte[] buffer = null;
            for (int j = 0; j < fsdirs.length; ++j) {
                FileDTO[] files = fsMgt.findFilesForMD5Check(fsdirs[j].getDirectoryPath(), before, limit);
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)("Check MD5 for " + files.length + " files on filesystem " + fsdirs[j]));
                }
                if (files.length <= 0) continue;
                if (buffer == null) {
                    buffer = new byte[this.bufferSize];
                }
                total += files.length;
                for (int k = 0; k < files.length; ++k) {
                    if (this.doCheck(fsMgt, files[k], buffer)) continue;
                    ++corrupted;
                }
                limit -= files.length;
            }
            if (corrupted > 0) {
                this.log.warn((Object)(corrupted + " files are corrupted!"));
            }
            String string = corrupted + " of " + total + " files corrupted!";
            Object var12_15 = null;
            this.isRunning = false;
            return string;
        }
        catch (Throwable throwable) {
            Object var12_16 = null;
            this.isRunning = false;
            throw throwable;
        }
    }

    private boolean doCheck(FileSystemMgt2 fsMgt, FileDTO fileDTO, byte[] buffer) throws IOException, NoSuchAlgorithmException, FinderException {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("check md5 for file " + fileDTO));
        }
        char[] storedMD5 = MD5Utils.toHexChars(fileDTO.getFileMd5());
        char[] fileMD5 = new char[32];
        File file = FileUtils.toFile(fileDTO.getDirectoryPath(), fileDTO.getFilePath());
        MessageDigest digest = MessageDigest.getInstance("MD5");
        MD5Utils.md5sum(file, fileMD5, digest, buffer);
        fsMgt.updateTimeOfLastMd5Check(fileDTO.getPk());
        if (!Arrays.equals(fileMD5, storedMD5)) {
            fsMgt.setFileStatus(fileDTO.getPk(), -3);
            this.log.warn((Object)("File (pk=" + fileDTO.getPk() + ") " + file + " corrupted! MD5 of file:" + new String(fileMD5) + " should be " + new String(storedMD5)));
            return false;
        }
        return true;
    }

    private boolean isDisabled(int hour) {
        boolean inside;
        if (this.disabledEndHour == -1) {
            return false;
        }
        boolean sameday = this.disabledStartHour <= this.disabledEndHour;
        boolean bl = inside = hour >= this.disabledStartHour && hour < this.disabledEndHour;
        return sameday ? inside : !inside;
    }

    protected void startService() throws Exception {
        this.listenerID = this.scheduler.startScheduler(this.timerIDCheckMD5, this.taskInterval, this.timerListener);
    }

    protected void stopService() throws Exception {
        this.scheduler.stopScheduler(this.timerIDCheckMD5, this.listenerID, this.timerListener);
        super.stopService();
    }

    protected FileSystemMgt2 newFileSystemMgt() throws Exception {
        return ((FileSystemMgt2Home)EJBHomeFactory.getFactory().lookup(FileSystemMgt2Home.class, "ejb/FileSystemMgt2")).create();
    }

    public String getTimerIDCheckMD5() {
        return this.timerIDCheckMD5;
    }

    public void setTimerIDCheckMD5(String timerIDCheckMD5) {
        this.timerIDCheckMD5 = timerIDCheckMD5;
    }
}

