/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4chex.archive.mbean;

import java.io.File;
import java.io.IOException;
import java.sql.Timestamp;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import java.util.StringTokenizer;
import javax.ejb.FinderException;
import javax.management.Notification;
import javax.management.NotificationListener;
import javax.management.ObjectName;
import org.dcm4che.data.Dataset;
import org.dcm4che.data.DcmObjectFactory;
import org.dcm4che.dict.UIDs;
import org.dcm4che.util.UIDGenerator;
import org.dcm4cheri.util.StringUtils;
import org.dcm4chex.archive.codec.CompressCmd;
import org.dcm4chex.archive.codec.CompressionFailedException;
import org.dcm4chex.archive.codec.DecompressCmd;
import org.dcm4chex.archive.config.RetryIntervalls;
import org.dcm4chex.archive.ejb.interfaces.FileDTO;
import org.dcm4chex.archive.ejb.interfaces.FileSystemDTO;
import org.dcm4chex.archive.ejb.interfaces.FileSystemMgt2;
import org.dcm4chex.archive.ejb.interfaces.FileSystemMgt2Home;
import org.dcm4chex.archive.ejb.jdbc.FileInfo;
import org.dcm4chex.archive.ejb.jdbc.RetrieveCmd;
import org.dcm4chex.archive.mbean.FileSystemMgt2Delegate;
import org.dcm4chex.archive.mbean.SchedulerDelegate;
import org.dcm4chex.archive.util.EJBHomeFactory;
import org.dcm4chex.archive.util.FileUtils;
import org.jboss.system.ServiceMBeanSupport;

public class LossyCompressionService
extends ServiceMBeanSupport {
    private static final String COMPRESS_FILE_FORMAT = "File Compression Ratio: {0,number,#.##} : 1\n Pixel Compression Ratio: {1,number,#.##} : 1";
    private static final String COMPRESS_SERIES_FORMAT = "{0,number,#} images compressed\nFile Compression Ratio: {1,number,#.##}/{2,number,#.##}/{3,number,#.##} : 1\nPixel Compression Ratio: {4,number,#.##}/{5,number,#.##}/{6,number,#.##} : 1";
    private static final String MAX_DERIVATION_FORMAT = "\nMaximal Absolute Pixel Sample Value Derivation: {0,number,#}/{1,number,#.##}/{2}";
    private static final UIDGenerator uidGenerator = UIDGenerator.getInstance();
    private ObjectName storeScpServiceName;
    private FileSystemMgt2Delegate fsmgt = new FileSystemMgt2Delegate(this);
    private final SchedulerDelegate scheduler = new SchedulerDelegate(this);
    private long taskInterval = 0L;
    private String timerIDCheckFilesToCompress;
    private Integer listenerID;
    private int disabledStartHour;
    private int disabledEndHour;
    private int limitNumberOfFilesPerTask;
    private int bufferSize = 8192;
    private File tmpDir;
    private String srcFSGroupID;
    private String destFSGroupID;
    private String sourceAET;
    private String seriesDescription;
    private List<CompressionRule> compressionRuleList = new ArrayList<CompressionRule>();
    private String externalRetrieveAET;
    private String copyOnFSGroupID;
    private boolean isRunning;
    private int fetchSize;
    private final NotificationListener delayedCompressionListener = new NotificationListener(){

        public void handleNotification(Notification notif, Object handback) {
            Calendar cal = Calendar.getInstance();
            int hour = cal.get(11);
            if (LossyCompressionService.this.isDisabled(hour)) {
                if (LossyCompressionService.this.log.isDebugEnabled()) {
                    LossyCompressionService.this.log.debug((Object)("trigger ignored in time between " + LossyCompressionService.this.disabledStartHour + " and " + LossyCompressionService.this.disabledEndHour + " !"));
                }
            } else {
                new Thread(new Runnable(){

                    public void run() {
                        try {
                            LossyCompressionService.this.checkForFilesToCompress();
                        }
                        catch (Exception e) {
                            LossyCompressionService.this.log.error((Object)"Delayed compression failed!", (Throwable)e);
                        }
                    }
                }).start();
            }
        }
    };

    public final void setStoreScpServiceName(ObjectName storeScpServiceName) {
        this.storeScpServiceName = storeScpServiceName;
    }

    public final ObjectName getStoreScpServiceName() {
        return this.storeScpServiceName;
    }

    public ObjectName getSchedulerServiceName() {
        return this.scheduler.getSchedulerServiceName();
    }

    public void setSchedulerServiceName(ObjectName schedulerServiceName) {
        this.scheduler.setSchedulerServiceName(schedulerServiceName);
    }

    public String getFileSystemMgtServiceNamePrefix() {
        return this.fsmgt.getFileSystemMgtServiceNamePrefix();
    }

    public void setFileSystemMgtServiceNamePrefix(String prefix) {
        this.fsmgt.setFileSystemMgtServiceNamePrefix(prefix);
    }

    public final String getSourceFileSystemGroupID() {
        return this.srcFSGroupID;
    }

    public final void setSourceFileSystemGroupID(String fsGroupID) {
        this.srcFSGroupID = fsGroupID.trim();
    }

    public final String getDestinationFileSystemGroupID() {
        return this.destFSGroupID;
    }

    public final void setDestinationFileSystemGroupID(String fsGroupID) {
        this.destFSGroupID = fsGroupID.trim();
    }

    public String getTimerIDCheckFilesToCompress() {
        return this.timerIDCheckFilesToCompress;
    }

    public void setTimerIDCheckFilesToCompress(String timerIDCheckFilesToCompress) {
        this.timerIDCheckFilesToCompress = timerIDCheckFilesToCompress;
    }

    public final String getTaskInterval() {
        String s = RetryIntervalls.formatIntervalZeroAsNever(this.taskInterval);
        return this.disabledEndHour == -1 ? s : s + "!" + this.disabledStartHour + "-" + this.disabledEndHour;
    }

    public void setTaskInterval(String interval) throws Exception {
        long oldInterval = this.taskInterval;
        int pos = interval.indexOf(33);
        if (pos == -1) {
            this.taskInterval = RetryIntervalls.parseIntervalOrNever(interval);
            this.disabledEndHour = -1;
        } else {
            this.taskInterval = RetryIntervalls.parseIntervalOrNever(interval.substring(0, pos));
            int pos1 = interval.indexOf(45, pos);
            this.disabledStartHour = Integer.parseInt(interval.substring(pos + 1, pos1));
            this.disabledEndHour = Integer.parseInt(interval.substring(pos1 + 1));
        }
        if (this.getState() == 3 && oldInterval != this.taskInterval) {
            this.scheduler.stopScheduler(this.timerIDCheckFilesToCompress, this.listenerID, this.delayedCompressionListener);
            this.listenerID = this.scheduler.startScheduler(this.timerIDCheckFilesToCompress, this.taskInterval, this.delayedCompressionListener);
        }
    }

    public boolean isRunning() {
        return this.isRunning;
    }

    public final void setCompressionRules(String rules) {
        this.compressionRuleList.clear();
        if (rules == null || rules.trim().length() == 0) {
            return;
        }
        StringTokenizer st = new StringTokenizer(rules, ",;\n\r\t");
        while (st.hasMoreTokens()) {
            String tk = st.nextToken().trim();
            if (tk.length() == 0) continue;
            this.compressionRuleList.add(new CompressionRule(tk));
        }
    }

    public final String getCompressionRules() {
        StringBuilder sb = new StringBuilder();
        for (CompressionRule compressionRule : this.compressionRuleList) {
            sb.append(compressionRule).append("\r\n");
        }
        return sb.toString();
    }

    public final String getExternalRetrieveAET() {
        return LossyCompressionService.maskNull(this.externalRetrieveAET, "-");
    }

    public final void setExternalRetrieveAET(String externalRetrieveAET) {
        this.externalRetrieveAET = LossyCompressionService.unmaskNull(externalRetrieveAET.trim(), "-");
    }

    public final String getCopyOnFSGroupID() {
        return LossyCompressionService.maskNull(this.copyOnFSGroupID, "-");
    }

    public final void setCopyOnFSGroupID(String copyOnFSGroupID) {
        this.copyOnFSGroupID = LossyCompressionService.unmaskNull(copyOnFSGroupID.trim(), "-");
    }

    private static String maskNull(String val, String mask) {
        return val == null ? mask : val;
    }

    private static String unmaskNull(String val, String mask) {
        return val.length() == 0 || val.equals("-") ? null : val;
    }

    public int getLimitNumberOfFilesPerTask() {
        return this.limitNumberOfFilesPerTask;
    }

    public void setLimitNumberOfFilesPerTask(int limit) {
        this.limitNumberOfFilesPerTask = limit;
    }

    public final String getSourceAET() {
        return this.sourceAET;
    }

    public final void setSourceAET(String sourceAET) {
        this.sourceAET = sourceAET.trim();
    }

    public final String getSeriesDescription() {
        return this.seriesDescription;
    }

    public final void setSeriesDescription(String seriesDescription) {
        this.seriesDescription = seriesDescription.trim();
    }

    public final int getBufferSize() {
        return this.bufferSize;
    }

    public final void setBufferSize(int bufferSize) {
        this.bufferSize = bufferSize;
    }

    public final void setTempDir(String dirPath) {
        this.tmpDir = new File(dirPath);
    }

    public final String getTempDir() {
        return this.tmpDir.toString();
    }

    public int getFetchSize() {
        return this.fetchSize;
    }

    public void setFetchSize(int fetchSize) {
        this.fetchSize = fetchSize;
    }

    public String compressFileJPEGLossy(String inFilePath, String outFilePath, float compressionQuality, String derivationDescription, float estimatedCompressionRatio, boolean newSOPInstanceUID, boolean newSeriesInstanceUID) throws Exception {
        File inFile = new File(inFilePath.trim());
        File outFile = new File(outFilePath.trim());
        float[] actualCompressionRatio = new float[1];
        CompressCmd.compressFileJPEGLossy(inFile, outFile, null, null, compressionQuality, derivationDescription, estimatedCompressionRatio, actualCompressionRatio, newSOPInstanceUID ? uidGenerator.createUID() : null, newSeriesInstanceUID ? uidGenerator.createUID() : null, new byte[this.bufferSize], null, null);
        return MessageFormat.format(COMPRESS_FILE_FORMAT, Float.valueOf((float)inFile.length() / (float)outFile.length()), Float.valueOf(actualCompressionRatio[0]));
    }

    private boolean isUncompressed(String tsuid) {
        return tsuid.equals("1.2.840.10008.1.2.1") || tsuid.equals("1.2.840.10008.1.2.2") || tsuid.equals("1.2.840.10008.1.2");
    }

    private boolean isLossyCompressed(String tsuid) {
        return tsuid.equals("1.2.840.10008.1.2.4.50") || tsuid.equals("1.2.840.10008.1.2.4.51") || tsuid.equals("1.2.840.10008.1.2.4.81") || tsuid.equals("1.2.840.10008.1.2.4.91");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String compressSeriesJPEGLossy(String seriesIUID, float compressionQuality, String derivationDescription, float estimatedCompressionRatio, boolean decompress, boolean archive) throws Exception {
        byte[] buffer = new byte[this.bufferSize];
        int[] planarConfiguration = new int[1];
        int[] pxdataVR = new int[1];
        float[] pixelCompressionRatio = new float[1];
        float minFileCompressionRatio = Float.MAX_VALUE;
        float maxFileCompressionRatio = Float.MIN_VALUE;
        float sumFileCompressionRatio = 0.0f;
        float minPixelCompressionRatio = Float.MAX_VALUE;
        float maxPixelCompressionRatio = Float.MIN_VALUE;
        float sumPixelCompressionRatio = 0.0f;
        int minMaxDiffPixelData = Integer.MAX_VALUE;
        int maxMaxDiffPixelData = Integer.MIN_VALUE;
        float sumMaxDiffPixelData = 0.0f;
        int count = 0;
        String suid = uidGenerator.createUID();
        Dataset keys = DcmObjectFactory.getInstance().newDataset();
        keys.putUI(0x20000E, seriesIUID.trim());
        RetrieveCmd cmd = RetrieveCmd.createSeriesRetrieve((Dataset)keys);
        cmd.setFetchSize(this.fetchSize);
        FileInfo[][] fileInfoss = cmd.getFileInfos();
        block2: for (int i = 0; i < fileInfoss.length; ++i) {
            FileInfo[] fileInfos = fileInfoss[i];
            for (int j = 0; j < fileInfos.length; ++j) {
                File uncFile2;
                File destFile;
                block21: {
                    Object var45_45;
                    FileInfo fileInfo = fileInfos[j];
                    if (!fileInfo.fsGroupID.equals(this.srcFSGroupID) || this.isLossyCompressed(fileInfo.tsUID)) continue;
                    File srcFile = FileUtils.toFile(fileInfo.basedir, fileInfo.fileID);
                    FileSystemDTO destfs = this.fsmgt.selectStorageFileSystem(this.destFSGroupID);
                    String destDirPath = destfs.getDirectoryPath();
                    destFile = FileUtils.createNewFile(FileUtils.toFile(destDirPath, fileInfo.fileID).getParentFile(), (int)Long.parseLong(srcFile.getName(), 16));
                    File uncFile = null;
                    uncFile2 = null;
                    try {
                        if (!this.isUncompressed(fileInfo.tsUID)) {
                            File absTmpDir = FileUtils.resolve(this.tmpDir);
                            if (absTmpDir.mkdirs()) {
                                this.log.info((Object)"Create directory for decompressed files");
                            }
                            uncFile = new File(absTmpDir, fileInfo.fileID.replace('/', '-') + ".dcm");
                            DecompressCmd.decompressFile(srcFile, uncFile, "1.2.840.10008.1.2.1", -1, 20311, buffer);
                            srcFile = uncFile;
                        }
                        String iuid = uidGenerator.createUID();
                        Dataset ds = DcmObjectFactory.getInstance().newDataset();
                        byte[] md5 = CompressCmd.compressFileJPEGLossy(srcFile, destFile, planarConfiguration, pxdataVR, compressionQuality, derivationDescription, estimatedCompressionRatio, pixelCompressionRatio, iuid, suid, buffer, ds, fileInfo);
                        float fileCompressionRatio = (float)srcFile.length() / (float)destFile.length();
                        if (minFileCompressionRatio > fileCompressionRatio) {
                            minFileCompressionRatio = fileCompressionRatio;
                        }
                        if (maxFileCompressionRatio < fileCompressionRatio) {
                            maxFileCompressionRatio = fileCompressionRatio;
                        }
                        sumFileCompressionRatio += fileCompressionRatio;
                        if (minPixelCompressionRatio > pixelCompressionRatio[0]) {
                            minPixelCompressionRatio = pixelCompressionRatio[0];
                        }
                        if (maxPixelCompressionRatio < pixelCompressionRatio[0]) {
                            maxPixelCompressionRatio = pixelCompressionRatio[0];
                        }
                        sumPixelCompressionRatio += pixelCompressionRatio[0];
                        ++count;
                        if (decompress) {
                            File absTmpDir = FileUtils.resolve(this.tmpDir);
                            if (absTmpDir.mkdirs()) {
                                this.log.info((Object)"Create directory for decompressed files");
                            }
                            uncFile2 = new File(absTmpDir, fileInfo.fileID.replace('/', '+') + ".dcm");
                            DecompressCmd.decompressFile(destFile, uncFile2, "1.2.840.10008.1.2.1", planarConfiguration[0], pxdataVR[0], buffer);
                            int maxDiffPixelData = FileUtils.maxDiffPixelData(srcFile, uncFile2);
                            if (minMaxDiffPixelData > maxDiffPixelData) {
                                minMaxDiffPixelData = maxDiffPixelData;
                            }
                            if (maxMaxDiffPixelData < maxDiffPixelData) {
                                maxMaxDiffPixelData = maxDiffPixelData;
                            }
                            sumMaxDiffPixelData += (float)maxDiffPixelData;
                        }
                        if (archive) {
                            File baseDir = FileUtils.toFile(destDirPath);
                            int baseDirPathLength = baseDir.getPath().length();
                            String destFilePath = destFile.getPath().substring(baseDirPathLength + 1).replace(File.separatorChar, '/');
                            FileDTO fileDTO = new FileDTO();
                            fileDTO.setRetrieveAET(destfs.getRetrieveAET());
                            fileDTO.setFileSystemPk(destfs.getPk());
                            fileDTO.setFileSystemGroupID(destfs.getGroupID());
                            fileDTO.setDirectoryPath(destfs.getDirectoryPath());
                            fileDTO.setAvailability(destfs.getAvailability());
                            fileDTO.setUserInfo(destfs.getUserInfo());
                            fileDTO.setFilePath(destFilePath);
                            fileDTO.setFileTsuid(ds.getFileMetaInfo().getTransferSyntaxUID());
                            fileDTO.setFileSize((int)destFile.length());
                            fileDTO.setFileMd5(md5);
                            this.updateSeriesDescription(ds);
                            ds.setPrivateCreatorID("dcm4che/archive");
                            ds.putAE(4390932, this.sourceAET);
                            ds.setPrivateCreatorID(null);
                            this.importFile(fileDTO, ds, suid, i + 1 >= fileInfoss.length);
                            destFile = null;
                        }
                        var45_45 = null;
                        if (uncFile == null) break block21;
                    }
                    catch (Throwable throwable) {
                        var45_45 = null;
                        if (uncFile != null) {
                            FileUtils.delete(uncFile, false);
                        }
                        if (uncFile2 != null) {
                            FileUtils.delete(uncFile2, false);
                        }
                        if (destFile != null) {
                            FileUtils.delete(destFile, false);
                        }
                        throw throwable;
                    }
                    FileUtils.delete(uncFile, false);
                }
                if (uncFile2 != null) {
                    FileUtils.delete(uncFile2, false);
                }
                if (destFile == null) continue block2;
                FileUtils.delete(destFile, false);
                {
                    continue block2;
                }
            }
        }
        if (count == 0) {
            return "No images compressed";
        }
        String msg = MessageFormat.format(COMPRESS_SERIES_FORMAT, count, Float.valueOf(minFileCompressionRatio), Float.valueOf(sumFileCompressionRatio / (float)count), Float.valueOf(maxFileCompressionRatio), Float.valueOf(minPixelCompressionRatio), Float.valueOf(sumPixelCompressionRatio / (float)count), Float.valueOf(maxPixelCompressionRatio));
        if (decompress) {
            msg = msg + MessageFormat.format(MAX_DERIVATION_FORMAT, minMaxDiffPixelData, Float.valueOf(sumMaxDiffPixelData / (float)count), maxMaxDiffPixelData);
        }
        return msg;
    }

    private void updateSeriesDescription(Dataset ds) {
        if ("{}".equals(this.seriesDescription)) {
            return;
        }
        String s = this.seriesDescription.replace("{}", ds.getString(528446, ""));
        if (s.length() > 64) {
            s = s.substring(0, 64);
        }
        ds.putLO(528446, s);
    }

    private void importFile(FileDTO fileDTO, Dataset ds, String prevseriuid, boolean last) throws Exception {
        this.server.invoke(this.getStoreScpServiceName(), "importFile", new Object[]{fileDTO, ds, prevseriuid, new Boolean(last)}, new String[]{FileDTO.class.getName(), Dataset.class.getName(), String.class.getName(), Boolean.TYPE.getName()});
    }

    private boolean isDisabled(int hour) {
        boolean inside;
        if (this.disabledEndHour == -1) {
            return false;
        }
        boolean sameday = this.disabledStartHour <= this.disabledEndHour;
        boolean bl = inside = hour >= this.disabledStartHour && hour < this.disabledEndHour;
        return sameday ? inside : !inside;
    }

    protected void startService() throws Exception {
        this.listenerID = this.scheduler.startScheduler(this.timerIDCheckFilesToCompress, this.taskInterval, this.delayedCompressionListener);
    }

    protected void stopService() throws Exception {
        this.scheduler.stopScheduler(this.timerIDCheckFilesToCompress, this.listenerID, this.delayedCompressionListener);
        super.stopService();
    }

    private FileSystemMgt2 newFileSystemMgt() {
        try {
            FileSystemMgt2Home home = (FileSystemMgt2Home)EJBHomeFactory.getFactory().lookup(FileSystemMgt2Home.class, "ejb/FileSystemMgt2");
            return home.create();
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to access File System Mgt EJB:", e);
        }
    }

    private static String uidOf(String nameOrUID) {
        return Character.isDigit(nameOrUID.charAt(0)) ? nameOrUID : UIDs.forName(nameOrUID);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void checkForFilesToCompress() throws FinderException, IOException {
        LossyCompressionService lossyCompressionService = this;
        synchronized (lossyCompressionService) {
            if (this.isRunning) {
                this.log.info((Object)"checkForFilesToCompress is already running!");
                return;
            }
            this.isRunning = true;
        }
        try {
            this.log.info((Object)"Check For Files To Lossy Compress");
            int limit = this.limitNumberOfFilesPerTask;
            byte[] buffer = null;
            FileSystemMgt2 fsMgtEJB = this.newFileSystemMgt();
            for (CompressionRule rule : this.compressionRuleList) {
                FileDTO[] files;
                Timestamp before = new Timestamp(System.currentTimeMillis() - rule.delay);
                for (FileDTO fileDTO : files = this.externalRetrieveAET != null ? fsMgtEJB.findFilesToLossyCompressWithExternalRetrieveAET(this.srcFSGroupID, this.externalRetrieveAET, LossyCompressionService.uidOf(rule.cuid), rule.bodyPart, rule.srcAET, before, limit) : (this.copyOnFSGroupID != null ? fsMgtEJB.findFilesToLossyCompressWithCopyOnOtherFileSystemGroup(this.srcFSGroupID, this.copyOnFSGroupID, LossyCompressionService.uidOf(rule.cuid), rule.bodyPart, rule.srcAET, before, limit) : fsMgtEJB.findFilesToLossyCompress(this.srcFSGroupID, LossyCompressionService.uidOf(rule.cuid), rule.bodyPart, rule.srcAET, before, limit))) {
                    if (buffer == null) {
                        buffer = new byte[this.bufferSize];
                    }
                    this.doCompress(fsMgtEJB, fileDTO, rule, buffer);
                    if (--limit <= 0) break;
                }
                if (limit > 0) continue;
                break;
            }
            Object var13_14 = null;
            this.isRunning = false;
        }
        catch (Throwable throwable) {
            Object var13_15 = null;
            this.isRunning = false;
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void doCompress(FileSystemMgt2 fsMgt, FileDTO fileDTO, CompressionRule rule, byte[] buffer) {
        File uncFile2;
        File destFile;
        block18: {
            String tsuid = fileDTO.getFileTsuid();
            File srcFile = FileUtils.toFile(fileDTO.getDirectoryPath(), fileDTO.getFilePath());
            destFile = null;
            File uncFile = null;
            uncFile2 = null;
            int failureStatus = -1;
            try {
                try {
                    FileSystemDTO destfs = this.fsmgt.selectStorageFileSystem(this.destFSGroupID);
                    String destDirPath = destfs.getDirectoryPath();
                    destFile = FileUtils.createNewFile(FileUtils.toFile(destDirPath, fileDTO.getFilePath()).getParentFile(), (int)Long.parseLong(srcFile.getName(), 16));
                    if (!this.isUncompressed(tsuid)) {
                        File absTmpDir = FileUtils.resolve(this.tmpDir);
                        if (absTmpDir.mkdirs()) {
                            this.log.info((Object)"Create directory for decompressed files");
                        }
                        uncFile = new File(absTmpDir, fileDTO.getFilePath().replace('/', '-') + ".dcm");
                        DecompressCmd.decompressFile(srcFile, uncFile, "1.2.840.10008.1.2.1", 20311, -1, buffer);
                        srcFile = uncFile;
                    }
                    Dataset ds = DcmObjectFactory.getInstance().newDataset();
                    int[] planarConfiguration = new int[1];
                    int[] pxdataVR = new int[1];
                    byte[] md5 = CompressCmd.compressFileJPEGLossy(srcFile, destFile, planarConfiguration, pxdataVR, rule.quality, rule.derivationDescription, rule.ratio, null, null, null, buffer, ds, null);
                    if (rule.near >= 0) {
                        File absTmpDir = FileUtils.resolve(this.tmpDir);
                        if (absTmpDir.mkdirs()) {
                            this.log.info((Object)"Create directory for decompressed files");
                        }
                        uncFile2 = new File(absTmpDir, fileDTO.getFilePath().replace('/', '+') + ".dcm");
                        DecompressCmd.decompressFile(destFile, uncFile2, "1.2.840.10008.1.2.1", planarConfiguration[0], pxdataVR[0], buffer);
                        int maxDiffPixelData = FileUtils.maxDiffPixelData(srcFile, uncFile2);
                        if (maxDiffPixelData > rule.near) {
                            failureStatus = -2;
                            throw new CompressionFailedException("Maximal absolute derivation of pixel sample values: " + maxDiffPixelData + " exeeds configured limit in compression rule: " + rule);
                        }
                    }
                    File baseDir = FileUtils.toFile(destDirPath);
                    int baseDirPathLength = baseDir.getPath().length();
                    String destFilePath = destFile.getPath().substring(baseDirPathLength + 1).replace(File.separatorChar, '/');
                    if (this.log.isDebugEnabled()) {
                        this.log.debug((Object)("replace File " + srcFile + " with " + destFile));
                    }
                    fsMgt.replaceFileAndCoerceAttributes(destfs.getPk(), fileDTO.getPk(), destFilePath, ds.getFileMetaInfo().getTransferSyntaxUID(), destFile.length(), md5, 0, ds);
                    destFile = null;
                }
                catch (Exception e) {
                    this.log.error((Object)("Lossy Compression of " + fileDTO + " failed:"), (Throwable)e);
                    try {
                        fsMgt.setFileStatus(fileDTO.getPk(), failureStatus);
                    }
                    catch (Exception x1) {
                        this.log.error((Object)("Failed to set status of " + fileDTO + " to " + failureStatus));
                    }
                    Object var21_23 = null;
                    if (uncFile != null) {
                        FileUtils.delete(uncFile, false);
                    }
                    if (uncFile2 != null) {
                        FileUtils.delete(uncFile2, false);
                    }
                    if (destFile == null) return;
                    FileUtils.delete(destFile, false);
                    return;
                }
                Object var21_22 = null;
                if (uncFile == null) break block18;
            }
            catch (Throwable throwable) {
                Object var21_24 = null;
                if (uncFile != null) {
                    FileUtils.delete(uncFile, false);
                }
                if (uncFile2 != null) {
                    FileUtils.delete(uncFile2, false);
                }
                if (destFile == null) throw throwable;
                FileUtils.delete(destFile, false);
                throw throwable;
            }
            FileUtils.delete(uncFile, false);
        }
        if (uncFile2 != null) {
            FileUtils.delete(uncFile2, false);
        }
        if (destFile == null) return;
        FileUtils.delete(destFile, false);
    }

    private static final class CompressionRule {
        final String cuid;
        final String bodyPart;
        final String srcAET;
        final long delay;
        final float quality;
        final String derivationDescription;
        final float ratio;
        final int near;

        public CompressionRule(String s) {
            String[] a = StringUtils.split(s, ':');
            if (a.length != 8) {
                throw new IllegalArgumentException(s);
            }
            LossyCompressionService.uidOf(a[0]);
            this.cuid = a[0];
            this.bodyPart = "*".equals(a[1]) || "".equals(a[1]) ? null : a[1];
            this.srcAET = a[2];
            this.delay = RetryIntervalls.parseInterval(a[3]);
            this.quality = Float.parseFloat(a[4]);
            this.derivationDescription = a[5];
            this.ratio = Float.parseFloat(a[6]);
            this.near = Integer.parseInt(a[7]);
        }

        public String toString() {
            return this.cuid + ':' + (this.bodyPart == null ? "*" : this.bodyPart) + ':' + this.srcAET + ':' + RetryIntervalls.formatInterval(this.delay) + ':' + this.quality + ':' + this.derivationDescription + ':' + this.ratio + ':' + this.near;
        }
    }
}

