/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4chex.archive.mbean;

import java.io.File;
import java.io.FileOutputStream;
import java.rmi.RemoteException;
import java.security.DigestOutputStream;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.TreeMap;
import javax.ejb.CreateException;
import javax.ejb.FinderException;
import javax.management.ObjectName;
import org.apache.log4j.Logger;
import org.dcm4che.data.Dataset;
import org.dcm4che.data.DcmElement;
import org.dcm4che.data.DcmEncodeParam;
import org.dcm4che.data.DcmObjectFactory;
import org.dcm4che.dict.UIDs;
import org.dcm4che.util.BufferedOutputStream;
import org.dcm4che.util.UIDGenerator;
import org.dcm4chex.archive.ejb.interfaces.ContentManager;
import org.dcm4chex.archive.ejb.interfaces.ContentManagerHome;
import org.dcm4chex.archive.ejb.interfaces.FileDTO;
import org.dcm4chex.archive.util.EJBHomeFactory;
import org.dcm4chex.archive.util.FileUtils;
import org.dcm4chex.archive.util.HomeFactoryException;
import org.jboss.system.ServiceMBeanSupport;

public class KeyObjectService
extends ServiceMBeanSupport {
    private DcmObjectFactory dof = DcmObjectFactory.getInstance();
    private Map waveformSopClassUIDs = new TreeMap();
    private Map compositSopClassUIDs = new TreeMap();
    private static Logger log = Logger.getLogger((String)KeyObjectService.class.getName());
    private ContentManager contentMgr;
    private ObjectName storeScpServiceName;
    private int bufferSize = 8192;
    private String fileSystemGroupID;

    public final String getFileSystemGroupID() {
        return this.fileSystemGroupID;
    }

    public final void setFileSystemGroupID(String fileSystemGroupID) {
        this.fileSystemGroupID = fileSystemGroupID;
    }

    public final ObjectName getStoreScpServiceName() {
        return this.storeScpServiceName;
    }

    public final void setStoreScpServiceName(ObjectName storeScpServiceName) {
        this.storeScpServiceName = storeScpServiceName;
    }

    protected void startService() throws Exception {
    }

    protected void stopService() throws Exception {
    }

    public Map getCompositSopClassUIDs() {
        return this.compositSopClassUIDs;
    }

    public void setCompositSopClassUIDs(Map compositSopClassUIDs) {
        this.compositSopClassUIDs = compositSopClassUIDs;
    }

    public String getWaveformSopClassUIDs() {
        return this.getCUIDs(this.waveformSopClassUIDs);
    }

    public void setWaveformSopClassUIDs(String sopCuids) {
        if (sopCuids == null || sopCuids.trim().length() == 0) {
            this.setDefaultWaveformSopCuids();
        } else {
            this.waveformSopClassUIDs = this.setCUIDs(sopCuids);
        }
    }

    public String getCompositeSopClassUIDs() {
        return this.getCUIDs(this.compositSopClassUIDs);
    }

    public void setCompositeSopClassUIDs(String sopCuids) {
        if (sopCuids == null || sopCuids.trim().length() == 0) {
            this.setDefaultCompositeSopCuids();
        } else {
            this.compositSopClassUIDs = this.setCUIDs(sopCuids);
        }
    }

    private String getCUIDs(Map map) {
        if (map == null || map.isEmpty()) {
            return "";
        }
        StringBuffer sb = new StringBuffer(map.size() << 5);
        Iterator iter = map.keySet().iterator();
        while (iter.hasNext()) {
            sb.append(iter.next()).append(System.getProperty("line.separator", "\n"));
        }
        return sb.toString();
    }

    private Map setCUIDs(String sopCuids) {
        StringTokenizer st = new StringTokenizer(sopCuids, "\r\n;");
        TreeMap<String, String> map = new TreeMap<String, String>();
        boolean i = false;
        while (st.hasMoreTokens()) {
            String uid;
            String name = uid = st.nextToken().trim();
            char ch = uid.charAt(0);
            if (ch >= '0' && ch <= '9') {
                if (!UIDs.isValid(uid)) {
                    throw new IllegalArgumentException("UID " + uid + " isn't a valid UID!");
                }
            } else {
                uid = UIDs.forName(name);
            }
            map.put(name, uid);
        }
        return map;
    }

    private void setDefaultWaveformSopCuids() {
        this.waveformSopClassUIDs.clear();
        this.waveformSopClassUIDs.put("AmbulatoryECGWaveformStorage", "1.2.840.10008.5.1.4.1.1.9.1.3");
        this.waveformSopClassUIDs.put("BasicVoiceAudioWaveformStorage", "1.2.840.10008.5.1.4.1.1.9.4.1");
        this.waveformSopClassUIDs.put("CardiacElectrophysiologyWaveformStorage", "1.2.840.10008.5.1.4.1.1.9.3.1");
        this.waveformSopClassUIDs.put("GeneralECGWaveformStorage", "1.2.840.10008.5.1.4.1.1.9.1.2");
        this.waveformSopClassUIDs.put("HemodynamicWaveformStorage", "1.2.840.10008.5.1.4.1.1.9.2.1");
        this.waveformSopClassUIDs.put("TwelveLeadECGWaveformStorage", "1.2.840.10008.5.1.4.1.1.9.1.1");
    }

    private void setDefaultCompositeSopCuids() {
        this.compositSopClassUIDs.clear();
        this.compositSopClassUIDs.put("BasicTextSR", "1.2.840.10008.5.1.4.1.1.88.11");
        this.compositSopClassUIDs.put("BlendingSoftcopyPresentationStateStorage", "1.2.840.10008.5.1.4.1.1.11.4");
        this.compositSopClassUIDs.put("ChestCADSR", "1.2.840.10008.5.1.4.1.1.88.65");
        this.compositSopClassUIDs.put("ColorSoftcopyPresentationStateStorage", "1.2.840.10008.5.1.4.1.1.11.2");
        this.compositSopClassUIDs.put("ComprehensiveSR", "1.2.840.10008.5.1.4.1.1.88.33");
        this.compositSopClassUIDs.put("Dcm4cheEncapsulatedDocumentStorage", "1.2.40.0.13.1.5.1.4.1.1.104.1");
        this.compositSopClassUIDs.put("DeformableSpatialRegistrationStorage", "1.2.840.10008.5.1.4.1.1.66.3");
        this.compositSopClassUIDs.put("EncapsulatedPDFStorage", "1.2.840.10008.5.1.4.1.1.104.1");
        this.compositSopClassUIDs.put("EnhancedSR", "1.2.840.10008.5.1.4.1.1.88.22");
        this.compositSopClassUIDs.put("GrayscaleSoftcopyPresentationStateStorage", "1.2.840.10008.5.1.4.1.1.11.1");
        this.compositSopClassUIDs.put("KeyObjectSelectionDocument", "1.2.840.10008.5.1.4.1.1.88.59");
        this.compositSopClassUIDs.put("MRSpectroscopyStorage", "1.2.840.10008.5.1.4.1.1.4.2");
        this.compositSopClassUIDs.put("MammographyCADSR", "1.2.840.10008.5.1.4.1.1.88.50");
        this.compositSopClassUIDs.put("ProcedureLogStorage", "1.2.840.10008.5.1.4.1.1.88.40");
        this.compositSopClassUIDs.put("PseudoColorSoftcopyPresentationStateStorage", "1.2.840.10008.5.1.4.1.1.11.3");
        this.compositSopClassUIDs.put("RTBeamsTreatmentRecordStorage", "1.2.840.10008.5.1.4.1.1.481.4");
        this.compositSopClassUIDs.put("RTBrachyTreatmentRecordStorage", "1.2.840.10008.5.1.4.1.1.481.6");
        this.compositSopClassUIDs.put("RTDoseStorage", "1.2.840.10008.5.1.4.1.1.481.2");
        this.compositSopClassUIDs.put("RTIonBeamsTreatmentRecordStorage", "1.2.840.10008.5.1.4.1.1.481.9");
        this.compositSopClassUIDs.put("RTIonPlanStorage", "1.2.840.10008.5.1.4.1.1.481.8");
        this.compositSopClassUIDs.put("RTPlanStorage", "1.2.840.10008.5.1.4.1.1.481.5");
        this.compositSopClassUIDs.put("RTStructureSetStorage", "1.2.840.10008.5.1.4.1.1.481.3");
        this.compositSopClassUIDs.put("RTTreatmentSummaryRecordStorage", "1.2.840.10008.5.1.4.1.1.481.7");
        this.compositSopClassUIDs.put("RawDataStorage", "1.2.840.10008.5.1.4.1.1.66");
        this.compositSopClassUIDs.put("RealWorldValueMappingStorage", "1.2.840.10008.5.1.4.1.1.67");
        this.compositSopClassUIDs.put("SegmentationStorage", "1.2.840.10008.5.1.4.1.1.66.4");
        this.compositSopClassUIDs.put("SiemensCSANonImageStorage", "1.3.12.2.1107.5.9.1");
        this.compositSopClassUIDs.put("SpatialFiducialsStorage", "1.2.840.10008.5.1.4.1.1.66.2");
        this.compositSopClassUIDs.put("SpatialRegistrationStorage", "1.2.840.10008.5.1.4.1.1.66.1");
        this.compositSopClassUIDs.put("StandaloneCurveStorage", "1.2.840.10008.5.1.4.1.1.9");
        this.compositSopClassUIDs.put("StandaloneModalityLUTStorage", "1.2.840.10008.5.1.4.1.1.10");
        this.compositSopClassUIDs.put("StandaloneOverlayStorage", "1.2.840.10008.5.1.4.1.1.8");
        this.compositSopClassUIDs.put("StandalonePETCurveStorage", "1.2.840.10008.5.1.4.1.1.129");
        this.compositSopClassUIDs.put("StandaloneVOILUTStorage", "1.2.840.10008.5.1.4.1.1.11");
        this.compositSopClassUIDs.put("StereometricRelationshipStorage", "1.2.840.10008.5.1.4.1.1.77.1.5.3");
        this.compositSopClassUIDs.put("XRayRadiationDoseSR", "1.2.840.10008.5.1.4.1.1.88.67");
    }

    public Dataset getKeyObject(String iuids) throws RemoteException, FinderException, HomeFactoryException, CreateException {
        StringTokenizer st = new StringTokenizer(iuids, ",|");
        ArrayList<String> l = new ArrayList<String>();
        while (st.hasMoreTokens()) {
            l.add(st.nextToken());
        }
        return this.getKeyObject(l, null, null);
    }

    public Dataset getKeyObject(Collection iuids, Dataset rootInfo, Collection contentItems) throws RemoteException, FinderException, HomeFactoryException, CreateException {
        Dataset ds;
        Collection col = this.lookupContentManager().getSOPInstanceRefMacros(iuids);
        if (!col.isEmpty()) {
            String studyIUID = ((Dataset)col.iterator().next()).getString(0x20000D);
            ds = this.newKeyObject(studyIUID, rootInfo);
            this.addPatInfo(ds, studyIUID);
            this.addContentSequence(ds, contentItems, col);
            this.addReqProcEvidenceSequence(ds, col);
        } else {
            ds = this.dof.newDataset();
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"Key Object Dataset:");
            log.debug((Object)ds);
        }
        return ds;
    }

    private Dataset newKeyObject(String studyIUID, Dataset rootInfo) {
        UIDGenerator uidGenerator = UIDGenerator.getInstance();
        Dataset ds = this.dof.newDataset();
        if (rootInfo != null) {
            ds.putAll(rootInfo);
        }
        ds.putUI(0x20000D, studyIUID != null ? studyIUID : uidGenerator.createUID());
        String seriesIUID = uidGenerator.createUID();
        ds.putUI(0x20000E, seriesIUID);
        ds.putUI(524310, "1.2.840.10008.5.1.4.1.1.88.59");
        ds.putUI(524312, uidGenerator.createUID());
        ds.putCS(524384, "KO");
        ds.putIS(2097171, 1);
        ds.putDA(524323, new Date());
        ds.putTM(524339, new Date());
        ds.putCS(0x40A040, "CONTAINER");
        Dataset tmplDS = ds.putSQ(4236548).addNewItem();
        tmplDS.putCS(4250368, "2010");
        tmplDS.putCS(524549, "DCMR");
        ds.putSQ(528657);
        return ds;
    }

    private void addContentSequence(Dataset ds, Collection conceptNames, Collection refSopInstances) {
        DcmElement sq = ds.putSQ(4237104);
        if (conceptNames != null) {
            Iterator iter = conceptNames.iterator();
            while (iter.hasNext()) {
                sq.addItem((Dataset)iter.next());
            }
        }
        for (Dataset sopInstRef : refSopInstances) {
            DcmElement refSerSq = sopInstRef.get(528661);
            int len = refSerSq.countItems();
            for (int i = 0; i < len; ++i) {
                Dataset refSerItem = refSerSq.getItem(i);
                DcmElement refSopSq = refSerItem.get(528793);
                int n = refSopSq.countItems();
                for (int j = 0; j < n; ++j) {
                    Dataset refSopItem = refSopSq.getItem(j);
                    Dataset item = sq.addNewItem();
                    item.putCS(4235280, "CONTAINS");
                    item.putCS(0x40A040, this.getValueType(refSopItem.getString(528720)));
                    Dataset sopDS = item.putSQ(528793).addNewItem();
                    sopDS.putUI(528720, refSopItem.getString(528720));
                    sopDS.putUI(528725, refSopItem.getString(528725));
                }
            }
        }
    }

    private String getValueType(String cuid) {
        if (this.compositSopClassUIDs.containsValue(cuid)) {
            return "COMPOSITE";
        }
        if (this.waveformSopClassUIDs.containsValue(cuid)) {
            return "WAVEFORM";
        }
        return "IMAGE";
    }

    private void addReqProcEvidenceSequence(Dataset ds, Collection col) throws RemoteException, FinderException, HomeFactoryException, CreateException {
        DcmElement sq = ds.putSQ(4236149);
        if (col.isEmpty()) {
            return;
        }
        Iterator iter = col.iterator();
        sq.addItem((Dataset)iter.next());
        if (iter.hasNext()) {
            DcmElement identicalSq = ds.putSQ(4236581);
            String patID = ds.getString(0x100020);
            while (iter.hasNext()) {
                Dataset studyDS = (Dataset)iter.next();
                String patID1 = this.lookupContentManager().getPatientForStudy(studyDS.getString(0x20000D)).getString(0x100020);
                if (!patID.equals(patID1)) {
                    throw new IllegalArgumentException("Instances of different patients are not allowed!");
                }
                sq.addItem(studyDS);
                this.addSOPInstanceRef(identicalSq, studyDS);
            }
        }
    }

    private void addSOPInstanceRef(DcmElement sq, Dataset studyDS) {
        Dataset ds = sq.addNewItem();
        ds.putUI(0x20000D, studyDS.getString(0x20000D));
        DcmElement serSq = ds.putSQ(528661);
        Dataset serDS = serSq.addNewItem();
        serDS.putUI(0x20000E, UIDGenerator.getInstance().createUID());
        DcmElement refSopSq = serDS.putSQ(528793);
        Dataset instDS = refSopSq.addNewItem();
        instDS.putUI(528725, UIDGenerator.getInstance().createUID());
        instDS.putUI(528720, "1.2.840.10008.5.1.4.1.1.88.59");
    }

    private void addPatInfo(Dataset ds, String studyIUID) throws RemoteException, FinderException, HomeFactoryException, CreateException {
        Dataset patDS = this.lookupContentManager().getPatientForStudy(studyIUID);
        ds.putAll(patDS);
    }

    private ContentManager lookupContentManager() throws HomeFactoryException, RemoteException, CreateException {
        if (this.contentMgr != null) {
            return this.contentMgr;
        }
        ContentManagerHome home = (ContentManagerHome)EJBHomeFactory.getFactory().lookup(ContentManagerHome.class, "ejb/ContentManager");
        this.contentMgr = home.create();
        return this.contentMgr;
    }

    public void storeAndRegister(Dataset dataset) throws Exception {
        FileDTO fileDTO = (FileDTO)this.server.invoke(this.storeScpServiceName, "makeFile", new Object[]{this.fileSystemGroupID, dataset}, new String[]{String.class.getName(), Dataset.class.getName()});
        this.writeFile(fileDTO, dataset);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void writeFile(FileDTO fileDTO, Dataset dataset) throws Exception {
        block7: {
            File file = FileUtils.toFile(fileDTO.getDirectoryPath(), fileDTO.getFilePath());
            String tsUID = "1.2.840.10008.1.2.1";
            boolean deleteFile = true;
            try {
                log.info((Object)("M-WRITE file: " + file));
                MessageDigest md = MessageDigest.getInstance("MD5");
                DigestOutputStream dos = new DigestOutputStream(new FileOutputStream(file), md);
                BufferedOutputStream out = new BufferedOutputStream(dos, new byte[this.bufferSize]);
                try {
                    DcmEncodeParam encParam = DcmEncodeParam.valueOf(tsUID);
                    dataset.writeFile(out, encParam);
                    Object var11_10 = null;
                }
                catch (Throwable throwable) {
                    Object var11_11 = null;
                    out.close();
                    throw throwable;
                }
                out.close();
                fileDTO.setFileMd5(md.digest());
                fileDTO.setFileSize(file.length());
                fileDTO.setFileTsuid(tsUID);
                this.importFile(fileDTO, dataset);
                deleteFile = false;
                Object var13_13 = null;
                if (!deleteFile) break block7;
            }
            catch (Throwable throwable) {
                Object var13_14 = null;
                if (deleteFile) {
                    log.info((Object)("M-DELETE file:" + file));
                    if (!file.delete()) {
                        log.error((Object)("Failed to delete " + file));
                    }
                }
                throw throwable;
            }
            log.info((Object)("M-DELETE file:" + file));
            if (!file.delete()) {
                log.error((Object)("Failed to delete " + file));
            }
        }
    }

    protected void importFile(FileDTO fileDTO, Dataset dataset) throws Exception {
        this.server.invoke(this.storeScpServiceName, "importFile", new Object[]{fileDTO, dataset, null, Boolean.TRUE}, new String[]{FileDTO.class.getName(), Dataset.class.getName(), String.class.getName(), Boolean.TYPE.getName()});
    }
}

