/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4chex.archive.mbean;

import java.io.Serializable;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageListener;
import javax.jms.ObjectMessage;
import javax.jms.Queue;
import javax.jms.QueueConnection;
import javax.jms.QueueConnectionFactory;
import javax.jms.QueueReceiver;
import javax.jms.QueueSender;
import javax.jms.QueueSession;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.dcm4chex.archive.exceptions.ConfigurationException;

class JMSQueueDelegate {
    public static final String CONNECTION_FACTORY = "java:ConnectionFactory";
    public static final String PROPERTY_SCHEDULED_DELIVERY = "JMS_JBOSS_SCHEDULED_DELIVERY";
    private final QueueConnection conn;
    private final Queue queue;
    private int deliveryMode;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public JMSQueueDelegate(String name, MessageListener listener, int receiverCount) throws JMSException {
        block12: {
            this.deliveryMode = 2;
            InitialContext iniCtx = null;
            QueueConnectionFactory qcf = null;
            try {
                try {
                    iniCtx = new InitialContext();
                    qcf = (QueueConnectionFactory)iniCtx.lookup(CONNECTION_FACTORY);
                    this.queue = (Queue)iniCtx.lookup("queue/" + name);
                    this.conn = qcf.createQueueConnection();
                }
                catch (NamingException e) {
                    throw new ConfigurationException(e);
                }
                catch (JMSException e) {
                    throw new ConfigurationException(e);
                }
                Object var8_6 = null;
                if (iniCtx == null) break block12;
            }
            catch (Throwable throwable) {
                Object var8_7 = null;
                if (iniCtx == null) throw throwable;
                try {
                    iniCtx.close();
                    throw throwable;
                }
                catch (Exception ignore) {
                    // empty catch block
                }
                throw throwable;
            }
            try {}
            catch (Exception ignore) {}
            iniCtx.close();
        }
        try {
            int i = 0;
            while (true) {
                if (i >= receiverCount) {
                    this.conn.start();
                    return;
                }
                QueueSession session = this.conn.createQueueSession(false, 1);
                QueueReceiver receiver = session.createReceiver(this.queue);
                receiver.setMessageListener(listener);
                ++i;
            }
        }
        catch (JMSException e) {
            this.close();
            throw e;
        }
    }

    public void close() {
        try {
            this.conn.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void queueMessage(Serializable obj, int priority, long scheduledTime) throws JMSException {
        QueueSession session = this.conn.createQueueSession(false, 1);
        try {
            ObjectMessage msg = session.createObjectMessage(obj);
            if (scheduledTime > 0L) {
                msg.setLongProperty(PROPERTY_SCHEDULED_DELIVERY, scheduledTime);
            }
            QueueSender sender = session.createSender(this.queue);
            sender.send((Message)msg, this.deliveryMode, priority, 0L);
            Object var9_7 = null;
        }
        catch (Throwable throwable) {
            Object var9_8 = null;
            session.close();
            throw throwable;
        }
        session.close();
    }
}

