/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4chex.archive.mbean;

import java.net.InetAddress;
import java.net.UnknownHostException;
import javax.security.jacc.PolicyContext;
import javax.security.jacc.PolicyContextException;
import javax.servlet.http.HttpServletRequest;

public class HttpUserInfo {
    private static final String WEB_REQUEST_KEY = "javax.servlet.http.HttpServletRequest";
    private String userId;
    private String ip;
    private String hostName;

    public HttpUserInfo(boolean enableDNSLookups) {
        try {
            HttpServletRequest rq = (HttpServletRequest)PolicyContext.getContext((String)WEB_REQUEST_KEY);
            this.init(rq, enableDNSLookups);
        }
        catch (PolicyContextException e) {
            this.userId = "UNKNOWN_USER";
        }
        catch (NullPointerException e) {
            this.userId = "SYSTEM";
        }
    }

    public HttpUserInfo(HttpServletRequest rq, boolean enableDNSLookups) {
        this.init(rq, enableDNSLookups);
    }

    private void init(HttpServletRequest rq, boolean enableDNSLookups) {
        int pos;
        this.userId = rq.getRemoteUser();
        String xForward = rq.getHeader("x-forwarded-for");
        this.ip = xForward != null ? ((pos = xForward.indexOf(44)) > 0 ? xForward.substring(0, pos) : xForward).trim() : rq.getRemoteAddr();
        if (enableDNSLookups) {
            try {
                this.hostName = InetAddress.getByName(this.ip).getHostName();
            }
            catch (UnknownHostException ignore) {
                this.hostName = this.ip;
            }
        } else {
            this.hostName = this.ip;
        }
    }

    public String getUserId() {
        return this.userId;
    }

    public String getIP() {
        return this.ip;
    }

    public String getHostName() {
        return this.hostName;
    }
}

