/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4chex.archive.mbean;

import java.rmi.RemoteException;
import javax.ejb.CreateException;
import javax.ejb.FinderException;
import org.apache.log4j.Logger;
import org.dcm4chex.archive.ejb.interfaces.FixPatientAttributes;
import org.dcm4chex.archive.ejb.interfaces.FixPatientAttributesHome;
import org.dcm4chex.archive.util.EJBHomeFactory;
import org.jboss.system.ServiceMBeanSupport;

public class FixPatientAttributesService
extends ServiceMBeanSupport {
    private int limitNumberOfPatientsPerTask;
    private static final Logger log = Logger.getLogger(FixPatientAttributesService.class);

    public int getLimitNumberOfPatientsPerTask() {
        return this.limitNumberOfPatientsPerTask;
    }

    public void setLimitNumberOfPatientsPerTask(int limit) {
        this.limitNumberOfPatientsPerTask = limit;
    }

    public int check() throws RemoteException, FinderException, CreateException {
        return this.checkPatientAttributes(false);
    }

    public int repair() throws RemoteException, FinderException, CreateException {
        return this.checkPatientAttributes(true);
    }

    private int checkPatientAttributes(boolean doUpdate) throws RemoteException, FinderException {
        int[] fixed;
        FixPatientAttributes checker = this.newFixPatientAttributes();
        int offset = 0;
        int total = 0;
        do {
            fixed = checker.checkPatientAttributes(offset, this.limitNumberOfPatientsPerTask, doUpdate);
            total += fixed[0];
            offset += this.limitNumberOfPatientsPerTask;
        } while (fixed[1] == this.limitNumberOfPatientsPerTask);
        return total;
    }

    private FixPatientAttributes newFixPatientAttributes() {
        try {
            FixPatientAttributesHome home = (FixPatientAttributesHome)EJBHomeFactory.getFactory().lookup(FixPatientAttributesHome.class, "ejb/FixPatientAttributes");
            return home.create();
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to access FixPatientAttributes EJB:", e);
        }
    }
}

