/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4chex.archive.mbean;

import java.io.File;
import java.io.IOException;
import java.rmi.RemoteException;
import java.util.Calendar;
import javax.ejb.FinderException;
import javax.ejb.ObjectNotFoundException;
import javax.management.Attribute;
import javax.management.Notification;
import javax.management.NotificationListener;
import javax.management.ObjectName;
import org.dcm4chex.archive.common.Availability;
import org.dcm4chex.archive.common.DeleteStudyOrder;
import org.dcm4chex.archive.common.FileSystemStatus;
import org.dcm4chex.archive.common.SeriesStored;
import org.dcm4chex.archive.config.RetryIntervalls;
import org.dcm4chex.archive.ejb.interfaces.FileDTO;
import org.dcm4chex.archive.ejb.interfaces.FileSystemDTO;
import org.dcm4chex.archive.ejb.interfaces.FileSystemMgt2;
import org.dcm4chex.archive.mbean.AbstractDeleterService;
import org.dcm4chex.archive.mbean.DeleteStudyDelegate;
import org.dcm4chex.archive.notif.StorageFileSystemSwitched;
import org.dcm4chex.archive.util.FileSystemUtils;
import org.dcm4chex.archive.util.FileUtils;

public class FileSystemMgt2Service
extends AbstractDeleterService {
    protected static final String GROUP = "group";
    private long minFreeDiskSpace = 20000000L;
    private float minFreeDiskSpaceRatio = -1.0f;
    private final DeleteStudyDelegate deleteStudy = new DeleteStudyDelegate(this);
    private String timerIDDeleteOrphanedPrivateFiles;
    private long deleteOrphanedPrivateFilesInterval;
    private boolean isRunningDeleteOrphanedPrivateFiles;
    private String defRetrieveAET;
    private int defAvailability;
    private String defUserInfo;
    private String defStorageDir;
    private boolean checkStorageFileSystemStatus = true;
    private boolean makeStorageDirectory = true;
    private String mountFailedCheckFile = "NO_MOUNT";
    private long expectedDataVolumePerDay = 100000L;
    private long adjustExpectedDataVolumePerDay = 0L;
    private long checkFreeDiskSpaceMinInterval;
    private long checkFreeDiskSpaceMaxInterval;
    private long checkFreeDiskSpaceRetryInterval;
    private long checkFreeDiskSpaceTime;
    private boolean noFreeDiskSpace;
    private boolean scheduleStudiesForDeletionOnSeriesStored;
    private int deleteOrphanedPrivateFilesBatchSize;
    private int updateStudiesBatchSize;
    private FileSystemDTO storageFileSystem;
    private Integer deleteOrphanedPrivateFilesListenerID;
    private ObjectName storeScpServiceName;
    private final NotificationListener scheduleStudiesForDeletionOnSeriesStoredListener = new NotificationListener(){

        public void handleNotification(Notification notif, Object handback) {
            if (FileSystemMgt2Service.this.scheduleStudiesForDeletionOnSeriesStored) {
                FileSystemMgt2Service.this.startScheduleStudiesForDeletion();
            }
        }
    };
    private NotificationListener deleteOrphanedPrivateFilesListener = new NotificationListener(){
        private Thread thread;

        public void handleNotification(Notification notif, Object handback) {
            if (this.thread == null) {
                this.thread = new Thread(new Runnable(){

                    public void run() {
                        try {
                            FileSystemMgt2Service.this.deleteOrphanedPrivateFiles();
                        }
                        catch (Exception e) {
                            FileSystemMgt2Service.this.log.error((Object)"deleteOrphanedPrivateFiles() failed:", (Throwable)e);
                        }
                        thread = null;
                    }
                });
                this.thread.start();
            } else {
                FileSystemMgt2Service.this.log.info((Object)"deleteOrphanedPrivateFiles() still in progress! Ignore this timer notification!");
            }
        }
    };

    public String getMinFreeDiskSpace() {
        return this.minFreeDiskSpaceRatio > 0.0f ? this.minFreeDiskSpaceRatio + "%" : (this.minFreeDiskSpace == 0L ? "NONE" : FileUtils.formatSize(this.minFreeDiskSpace));
    }

    public long getMinFreeDiskSpaceBytes() {
        return this.minFreeDiskSpace;
    }

    public void setMinFreeDiskSpace(String str) {
        if (str.endsWith("%")) {
            this.minFreeDiskSpaceRatio = Float.parseFloat(str.substring(0, str.length() - 1));
            this.minFreeDiskSpace = this.calcFreeDiskSpace(this.storageFileSystem);
        } else {
            this.minFreeDiskSpaceRatio = -1.0f;
            this.minFreeDiskSpace = str.equalsIgnoreCase("NONE") ? 0L : FileUtils.parseSize(str, 20000000L);
        }
    }

    private long calcFreeDiskSpace(FileSystemDTO fs) {
        if (fs == null) {
            return -1L;
        }
        File dir = this.checkFS(fs, " - can not calculate minimum free disc space!");
        if (dir == null) {
            return -1L;
        }
        long total = FileSystemUtils.totalSpace(dir.getAbsolutePath());
        this.log.info((Object)("Total space of " + fs.getDirectoryPath() + " :" + FileUtils.formatSize(total)));
        return (long)((float)total * this.minFreeDiskSpaceRatio / 100.0f);
    }

    public final String getExpectedDataVolumePerDay() {
        return FileUtils.formatSize(this.expectedDataVolumePerDay);
    }

    public long getExpectedDataVolumePerDayBytes() throws Exception {
        Calendar now = Calendar.getInstance();
        if (this.adjustExpectedDataVolumePerDay != 0L && now.getTimeInMillis() > this.adjustExpectedDataVolumePerDay) {
            this.adjustExpectedDataVolumePerDay();
            this.adjustExpectedDataVolumePerDay = this.nextMidnight();
        }
        return this.expectedDataVolumePerDay;
    }

    public final void setExpectedDataVolumePerDay(String s) {
        this.expectedDataVolumePerDay = FileUtils.parseSize(s, 1000000L);
    }

    public final boolean isAdjustExpectedDataVolumePerDay() {
        return this.adjustExpectedDataVolumePerDay != 0L;
    }

    public final void setAdjustExpectedDataVolumePerDay(boolean b) {
        this.adjustExpectedDataVolumePerDay = b ? this.nextMidnight() : 0L;
    }

    public String adjustExpectedDataVolumePerDay() throws Exception {
        FileSystemMgt2 fsMgt = FileSystemMgt2Service.fileSystemMgt();
        return this.adjustExpectedDataVolumePerDay(fsMgt, fsMgt.getFileSystemsOfGroup(this.getFileSystemGroupIDForDeleter()));
    }

    private String adjustExpectedDataVolumePerDay(FileSystemMgt2 fsMgt, FileSystemDTO[] fss) throws Exception {
        Calendar cal = Calendar.getInstance();
        cal.roll(5, false);
        long after = cal.getTimeInMillis();
        long sum = 0L;
        for (FileSystemDTO fs : fss) {
            sum = fsMgt.sizeOfFilesCreatedAfter(fs.getPk(), after);
        }
        String size = FileUtils.formatSize(sum);
        if (sum > this.expectedDataVolumePerDay) {
            this.server.setAttribute(this.serviceName, new Attribute("ExpectedDataVolumePerDay", size));
        }
        return size;
    }

    public ObjectName getStoreScpServiceName() {
        return this.storeScpServiceName;
    }

    public final void setStoreScpServiceName(ObjectName storeScpServiceName) {
        this.storeScpServiceName = storeScpServiceName;
    }

    public ObjectName getDeleteStudyServiceName() {
        return this.deleteStudy.getDeleteStudyServiceName();
    }

    public void setDeleteStudyServiceName(ObjectName deleteStudyServiceName) {
        this.deleteStudy.setDeleteStudyServiceName(deleteStudyServiceName);
    }

    public String getTimerIDDeleteOrphanedPrivateFiles() {
        return this.timerIDDeleteOrphanedPrivateFiles;
    }

    public void setTimerIDDeleteOrphanedPrivateFiles(String timerIDDeleteOrphanedPrivateFiles) {
        this.timerIDDeleteOrphanedPrivateFiles = timerIDDeleteOrphanedPrivateFiles;
    }

    public String getDeleteOrphanedPrivateFilesInterval() {
        return RetryIntervalls.formatIntervalZeroAsNever(this.deleteOrphanedPrivateFilesInterval);
    }

    public void setDeleteOrphanedPrivateFilesInterval(String interval) throws Exception {
        this.deleteOrphanedPrivateFilesInterval = RetryIntervalls.parseIntervalOrNever(interval);
        if (this.getState() == 3) {
            this.scheduler.stopScheduler(this.timerIDDeleteOrphanedPrivateFiles, this.deleteOrphanedPrivateFilesListenerID, this.deleteOrphanedPrivateFilesListener);
            this.deleteOrphanedPrivateFilesListenerID = this.scheduler.startScheduler(this.timerIDDeleteOrphanedPrivateFiles, this.deleteOrphanedPrivateFilesInterval, this.deleteOrphanedPrivateFilesListener);
        }
    }

    public boolean isRunningDeleteOrphanedPrivateFiles() {
        return this.isRunningDeleteOrphanedPrivateFiles;
    }

    protected void startService() throws Exception {
        super.startService();
        this.deleteOrphanedPrivateFilesListenerID = this.scheduler.startScheduler(this.timerIDDeleteOrphanedPrivateFiles, this.deleteOrphanedPrivateFilesInterval, this.deleteOrphanedPrivateFilesListener);
        this.server.addNotificationListener(this.storeScpServiceName, this.scheduleStudiesForDeletionOnSeriesStoredListener, SeriesStored.NOTIF_FILTER, null);
    }

    protected void stopService() throws Exception {
        this.scheduler.stopScheduler(this.timerIDDeleteOrphanedPrivateFiles, this.deleteOrphanedPrivateFilesListenerID, this.deleteOrphanedPrivateFilesListener);
        this.server.removeNotificationListener(this.storeScpServiceName, this.scheduleStudiesForDeletionOnSeriesStoredListener, SeriesStored.NOTIF_FILTER, null);
    }

    public String getFileSystemGroupID() {
        return this.serviceName.getKeyProperty(GROUP);
    }

    public String getDefRetrieveAET() {
        return this.defRetrieveAET;
    }

    public void setDefRetrieveAET(String defRetrieveAET) {
        this.defRetrieveAET = defRetrieveAET;
    }

    public String getDefAvailability() {
        return Availability.toString(this.defAvailability);
    }

    public void setDefAvailability(String availability) {
        this.defAvailability = Availability.toInt(availability);
    }

    public String getDefUserInfo() {
        return this.defUserInfo;
    }

    public void setDefUserInfo(String defUserInfo) {
        this.defUserInfo = defUserInfo;
    }

    public String getDefStorageDir() {
        return this.defStorageDir != null ? this.defStorageDir : "NONE";
    }

    public void setDefStorageDir(String defStorageDir) {
        String trimmed = defStorageDir.trim();
        this.defStorageDir = trimmed.equalsIgnoreCase("NONE") ? null : trimmed;
    }

    public final boolean isCheckStorageFileSystemStatus() {
        return this.checkStorageFileSystemStatus;
    }

    public final void setCheckStorageFileSystemStatus(boolean checkStorageFileSystemStatus) {
        this.checkStorageFileSystemStatus = checkStorageFileSystemStatus;
    }

    public boolean isMakeStorageDirectory() {
        return this.makeStorageDirectory;
    }

    public void setMakeStorageDirectory(boolean makeStorageDirectory) {
        this.makeStorageDirectory = makeStorageDirectory;
    }

    public final String getMountFailedCheckFile() {
        return this.mountFailedCheckFile;
    }

    public final void setMountFailedCheckFile(String mountFailedCheckFile) {
        this.mountFailedCheckFile = mountFailedCheckFile;
    }

    public long getFreeDiskSpaceOnCurFS() throws IOException {
        if (this.storageFileSystem == null || this.getMinFreeDiskSpaceBytes() == 0L) {
            return -1L;
        }
        File dir = FileUtils.toFile(this.storageFileSystem.getDirectoryPath());
        return dir.isDirectory() ? FileSystemUtils.freeSpace(dir.getPath()) : -1L;
    }

    public String getFreeDiskSpaceOnCurFSString() throws IOException {
        return FileUtils.formatSize(this.getFreeDiskSpaceOnCurFS());
    }

    public long getUsableDiskSpaceOnCurFS() throws IOException {
        long free = this.getFreeDiskSpaceOnCurFS();
        return free == -1L ? -1L : Math.max(0L, free - this.getMinFreeDiskSpaceBytes());
    }

    public String getUsableDiskSpaceOnCurFSString() throws IOException {
        return FileUtils.formatSize(this.getUsableDiskSpaceOnCurFS());
    }

    public final String getCheckFreeDiskSpaceMinimalInterval() {
        return RetryIntervalls.formatInterval(this.checkFreeDiskSpaceMinInterval);
    }

    public final void setCheckFreeDiskSpaceMinimalInterval(String s) {
        this.checkFreeDiskSpaceMinInterval = RetryIntervalls.parseInterval(s);
    }

    public final String getCheckFreeDiskSpaceMaximalInterval() {
        return RetryIntervalls.formatInterval(this.checkFreeDiskSpaceMaxInterval);
    }

    public final void setCheckFreeDiskSpaceMaximalInterval(String s) {
        this.checkFreeDiskSpaceMaxInterval = RetryIntervalls.parseInterval(s);
    }

    public final String getCheckFreeDiskSpaceRetryInterval() {
        return RetryIntervalls.formatInterval(this.checkFreeDiskSpaceRetryInterval);
    }

    public final void setCheckFreeDiskSpaceRetryInterval(String s) {
        this.checkFreeDiskSpaceRetryInterval = RetryIntervalls.parseInterval(s);
    }

    public void setScheduleStudiesForDeletionOnSeriesStored(boolean scheduleStudiesForDeletionOnSeriesStored) {
        this.scheduleStudiesForDeletionOnSeriesStored = scheduleStudiesForDeletionOnSeriesStored;
    }

    public boolean isScheduleStudiesForDeletionOnSeriesStored() {
        return this.scheduleStudiesForDeletionOnSeriesStored;
    }

    public void setDeleteOrphanedPrivateFilesBatchSize(int batchSize) {
        if (batchSize <= 0) {
            throw new IllegalArgumentException("batchSize: " + batchSize);
        }
        this.deleteOrphanedPrivateFilesBatchSize = batchSize;
    }

    public int getDeleteOrphanedPrivateFilesBatchSize() {
        return this.deleteOrphanedPrivateFilesBatchSize;
    }

    public int getUpdateStudiesBatchSize() {
        return this.updateStudiesBatchSize;
    }

    public void setUpdateStudiesBatchSize(int batchSize) {
        if (batchSize <= 0) {
            throw new IllegalArgumentException("batchSize: " + batchSize);
        }
        this.updateStudiesBatchSize = batchSize;
    }

    public String listAllFileSystems() throws Exception {
        FileSystemDTO[] fss = FileSystemMgt2Service.fileSystemMgt().getAllFileSystems();
        FileSystemMgt2Service.sortFileSystems(fss);
        return FileSystemMgt2Service.toString(fss);
    }

    public String listFileSystems() throws Exception {
        FileSystemDTO[] fss = FileSystemMgt2Service.fileSystemMgt().getFileSystemsOfGroup(this.getFileSystemGroupID());
        FileSystemMgt2Service.sortFileSystems(fss);
        return FileSystemMgt2Service.toString(fss);
    }

    public File[] listFileSystemDirectories() throws Exception {
        FileSystemDTO[] fss = FileSystemMgt2Service.fileSystemMgt().getFileSystemsOfGroup(this.getFileSystemGroupID());
        FileSystemMgt2Service.sortFileSystems(fss);
        File[] dirs = new File[fss.length];
        for (int i = 0; i < fss.length; ++i) {
            dirs[i] = FileUtils.toFile(fss[i].getDirectoryPath());
        }
        return dirs;
    }

    public FileSystemDTO addRWFileSystem(String dirPath) throws Exception {
        return this.addRWFileSystem(this.mkFileSystemDTO(dirPath.trim(), 1));
    }

    protected FileSystemDTO addRWFileSystem(FileSystemDTO fsDTO) throws Exception {
        FileSystemDTO dto = FileSystemMgt2Service.fileSystemMgt().addAndLinkFileSystem(fsDTO);
        if (dto.getStatus() == 0) {
            this.storageFileSystem = dto;
        }
        return dto;
    }

    private FileSystemDTO mkFileSystemDTO(String dirPath, int status) {
        FileSystemDTO fs = new FileSystemDTO();
        fs.setDirectoryPath(dirPath);
        fs.setGroupID(this.getFileSystemGroupID());
        fs.setRetrieveAET(this.defRetrieveAET);
        fs.setAvailability(this.defAvailability);
        fs.setUserInfo(this.defUserInfo);
        fs.setStatus(status);
        return fs;
    }

    public FileSystemDTO removeFileSystem(String dirPath) throws Exception {
        FileSystemDTO fsDTO = FileSystemMgt2Service.fileSystemMgt().removeFileSystem(this.getFileSystemGroupID(), dirPath);
        if (this.storageFileSystem != null && this.storageFileSystem.getPk() == fsDTO.getPk()) {
            this.selectStorageFileSystem();
        }
        return fsDTO;
    }

    public FileSystemDTO linkFileSystems(String dirPath, String next) throws Exception {
        return FileSystemMgt2Service.fileSystemMgt().linkFileSystems(this.getFileSystemGroupID(), dirPath, next);
    }

    public FileSystemDTO updateFileSystemStatus(String dirPath, String status) throws Exception {
        FileSystemDTO fsDTO = FileSystemMgt2Service.fileSystemMgt().updateFileSystemStatus(this.getFileSystemGroupID(), dirPath, FileSystemStatus.toInt(status));
        this.selectStorageFileSystem();
        return fsDTO;
    }

    public FileSystemDTO updateFileSystemAvailability(String dirPath, String availability, String availabilityOfExternalRetrievable) throws Exception {
        String fsGroupID = this.getFileSystemGroupID();
        FileSystemMgt2 fsMgt = FileSystemMgt2Service.fileSystemMgt();
        return fsMgt.updateFileSystemAvailability(fsGroupID, dirPath, Availability.toInt(availability)) ? fsMgt.updateAvailabilityForStudyOnFileSystem(fsGroupID, dirPath, Availability.toInt(availabilityOfExternalRetrievable), this.updateStudiesBatchSize) : fsMgt.getFileSystemOfGroup(fsGroupID, dirPath);
    }

    public FileSystemDTO updateFileSystemRetrieveAETitle(String dirPath, String aet) throws Exception {
        return FileSystemMgt2Service.fileSystemMgt().updateFileSystemRetrieveAET(this.getFileSystemGroupID(), dirPath, aet, this.updateStudiesBatchSize);
    }

    public FileSystemDTO selectStorageFileSystem() throws Exception {
        FileSystemMgt2 fsMgt = FileSystemMgt2Service.fileSystemMgt();
        if (this.storageFileSystem == null) {
            this.initStorageFileSystem(fsMgt);
        } else if (this.checkStorageFileSystemStatus) {
            this.checkStorageFileSystemStatus(fsMgt);
        }
        if (this.storageFileSystem == null) {
            this.log.warn((Object)("No writeable storage file system configured in group " + this.getFileSystemGroupID() + " - storage will fail until " + "a writeable storage file system is configured."));
            return null;
        }
        if (this.checkFreeDiskSpaceTime < System.currentTimeMillis()) {
            this.noFreeDiskSpace = false;
            if (!this.checkFreeDiskSpace(this.storageFileSystem) && !this.switchFileSystem(fsMgt, this.storageFileSystem)) {
                this.log.error((Object)("High Water Mark reached on storage file system " + this.storageFileSystem + " - no alternative storage file " + "system configured for file system group " + this.getFileSystemGroupID()));
                this.checkFreeDiskSpaceTime = System.currentTimeMillis() + this.checkFreeDiskSpaceRetryInterval;
                this.noFreeDiskSpace = true;
                return null;
            }
        }
        return this.noFreeDiskSpace ? null : this.storageFileSystem;
    }

    public File selectStorageDirectory() throws Exception {
        FileSystemDTO dto = this.selectStorageFileSystem();
        return dto != null ? FileUtils.toFile(dto.getDirectoryPath()) : null;
    }

    private synchronized boolean switchFileSystem(FileSystemMgt2 fsMgt, FileSystemDTO fsDTO) throws Exception {
        String next;
        if (this.storageFileSystem.getPk() != fsDTO.getPk()) {
            this.log.info((Object)("Storage file system has already been switched from " + fsDTO + " to " + this.storageFileSystem + " by another thread."));
            return true;
        }
        FileSystemDTO tmp = this.storageFileSystem;
        while ((next = tmp.getNext()) != null && !next.equals(this.storageFileSystem.getDirectoryPath())) {
            tmp = fsMgt.getFileSystemOfGroup(this.getFileSystemGroupID(), next);
            if (this.minFreeDiskSpaceRatio > 0.0f) {
                this.minFreeDiskSpace = this.calcFreeDiskSpace(tmp);
            }
            if (tmp.getStatus() != 1 || tmp.getAvailability() != Availability.toInt(this.getDefAvailability()) || !this.checkFreeDiskSpace(tmp)) continue;
            this.storageFileSystem = fsMgt.updateFileSystemStatus(tmp.getPk(), 0);
            this.log.info((Object)("Switch storage file system from " + fsDTO + " to " + this.storageFileSystem));
            this.sendJMXNotification(new StorageFileSystemSwitched(fsDTO, this.storageFileSystem));
            return true;
        }
        return false;
    }

    void sendJMXNotification(Object o) {
        long eventID = super.getNextNotificationSequenceNumber();
        Notification notif = new Notification(o.getClass().getName(), (Object)this, eventID);
        notif.setUserData(o);
        super.sendNotification(notif);
    }

    private boolean checkFreeDiskSpace(FileSystemDTO fsDTO) throws IOException {
        File dir = this.checkFS(fsDTO, " - try to switch to next configured storage directory");
        if (dir == null) {
            return false;
        }
        if (this.getMinFreeDiskSpaceBytes() == 0L) {
            return true;
        }
        long freeSpace = FileSystemUtils.freeSpace(dir.getPath());
        this.log.info((Object)("Free disk space on " + dir + ": " + FileUtils.formatSize(freeSpace)));
        if (freeSpace < this.getMinFreeDiskSpaceBytes()) {
            this.log.info((Object)("High Water Mark reached on current storage directory " + dir + " - try to switch to next configured storage directory"));
            return false;
        }
        this.checkFreeDiskSpaceTime = System.currentTimeMillis() + Math.min(freeSpace * this.checkFreeDiskSpaceMinInterval / this.getMinFreeDiskSpaceBytes(), this.checkFreeDiskSpaceMaxInterval);
        return true;
    }

    private File checkFS(FileSystemDTO fsDTO, String msgPostfix) {
        File nomount;
        File dir = FileUtils.toFile(fsDTO.getDirectoryPath());
        if (!dir.exists()) {
            if (!this.makeStorageDirectory) {
                this.log.warn((Object)("No such directory " + dir + msgPostfix));
                return null;
            }
            this.log.info((Object)("M-WRITE " + dir));
            if (!dir.mkdirs()) {
                this.log.warn((Object)("Failed to create directory " + dir + msgPostfix));
                return null;
            }
        }
        if ((nomount = new File(dir, this.mountFailedCheckFile)).exists()) {
            this.log.warn((Object)("Mount on " + dir + " seems broken" + msgPostfix));
            return null;
        }
        return dir;
    }

    private void checkStorageFileSystemStatus(FileSystemMgt2 fsMgt) throws FinderException, RemoteException {
        try {
            this.storageFileSystem = fsMgt.getFileSystem(this.storageFileSystem.getPk());
            if (this.storageFileSystem.getStatus() == 0) {
                return;
            }
            this.log.info((Object)("Status of previous storage file system changed: " + this.storageFileSystem));
        }
        catch (ObjectNotFoundException onfe) {
            this.log.info((Object)("Previous storage file system: " + this.storageFileSystem + " was removed from configuration"));
        }
        this.storageFileSystem = fsMgt.getDefRWFileSystemsOfGroup(this.getFileSystemGroupID());
        if (this.storageFileSystem != null) {
            this.log.info((Object)("New storage file system: " + this.storageFileSystem));
        }
        if (this.minFreeDiskSpaceRatio > 0.0f) {
            this.minFreeDiskSpace = this.calcFreeDiskSpace(this.storageFileSystem);
        }
        this.checkFreeDiskSpaceTime = 0L;
    }

    private void initStorageFileSystem(FileSystemMgt2 fsMgt) throws Exception {
        this.storageFileSystem = fsMgt.getDefRWFileSystemsOfGroup(this.getFileSystemGroupID());
        if (this.storageFileSystem == null && this.defStorageDir != null) {
            this.storageFileSystem = fsMgt.addFileSystem(this.mkFileSystemDTO(this.defStorageDir, 0));
            this.log.info((Object)("No writeable storage file system configured in group " + this.getFileSystemGroupID() + " - auto configure " + this.storageFileSystem));
            return;
        }
        this.checkFreeDiskSpaceTime = 0L;
        if (this.minFreeDiskSpaceRatio > 0.0f) {
            this.minFreeDiskSpace = this.calcFreeDiskSpace(this.storageFileSystem);
        }
    }

    private static String toString(FileSystemDTO[] fss) {
        StringBuilder sb = new StringBuilder();
        for (FileSystemDTO fs : fss) {
            sb.append(fs).append("\r\n");
        }
        String s = sb.toString();
        return s;
    }

    private static void sortFileSystems(FileSystemDTO[] fss) {
        for (int i = 0; i < fss.length; ++i) {
            FileSystemMgt2Service.selectRoot(fss, i);
            while (FileSystemMgt2Service.selectNext(fss, i)) {
                ++i;
            }
        }
    }

    private static boolean selectRoot(FileSystemDTO[] fss, int index) {
        for (int i = index; i < fss.length; ++i) {
            if (FileSystemMgt2Service.hasPrevious(fss, i)) continue;
            FileSystemMgt2Service.swap(fss, index, i);
            return true;
        }
        return false;
    }

    private static boolean selectNext(FileSystemDTO[] fss, int index) {
        String next = fss[index].getNext();
        if (next == null) {
            return false;
        }
        for (int i = index + 1; i < fss.length; ++i) {
            if (!next.equals(fss[i].getDirectoryPath())) continue;
            FileSystemMgt2Service.swap(fss, index + 1, i);
            return true;
        }
        return false;
    }

    private static void swap(FileSystemDTO[] fss, int i, int j) {
        if (i == j) {
            return;
        }
        FileSystemDTO tmp = fss[i];
        fss[i] = fss[j];
        fss[j] = tmp;
    }

    private static boolean hasPrevious(FileSystemDTO[] fss, int index) {
        String next = fss[index].getDirectoryPath();
        for (int i = 0; i < fss.length; ++i) {
            if (i == index || !next.equals(fss[i].getNext())) continue;
            return true;
        }
        return false;
    }

    protected String showTriggerInfo() {
        StringBuilder sb = new StringBuilder();
        sb.append("Trigger intervall: ").append(this.getScheduleStudiesForDeletionInterval()).append("\nTrigger on SeriesStored:").append(this.scheduleStudiesForDeletionOnSeriesStored);
        if ("NEVER".equals(this.getScheduleStudiesForDeletionInterval()) && !this.scheduleStudiesForDeletionOnSeriesStored) {
            sb.append("\nWARN: No studies will be deleted automatically from file systems of file system group ").append(this.getFileSystemGroupID()).append("\n\n");
        }
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int deleteOrphanedPrivateFiles() throws Exception {
        FileSystemMgt2Service fileSystemMgt2Service = this;
        synchronized (fileSystemMgt2Service) {
            if (this.isRunningDeleteOrphanedPrivateFiles) {
                this.log.info((Object)"DeleteOrphanedPrivateFiles is already running!");
                return -1;
            }
            this.isRunningDeleteOrphanedPrivateFiles = true;
        }
        try {
            this.log.info((Object)("Check file system group " + this.getFileSystemGroupID() + " for deletion of orphaned private files"));
            FileSystemMgt2 fsMgt = FileSystemMgt2Service.fileSystemMgt();
            FileDTO[] fileDTOs = fsMgt.getOrphanedPrivateFilesOnFSGroup(this.getFileSystemGroupID(), this.deleteOrphanedPrivateFilesBatchSize);
            int deleted = 0;
            for (int i = 0; i < fileDTOs.length; ++i) {
                FileDTO fileDTO = fileDTOs[i];
                File file = FileUtils.toFile(fileDTO.getDirectoryPath(), fileDTO.getFilePath());
                try {
                    fsMgt.deletePrivateFile(fileDTO.getPk());
                }
                catch (Exception e) {
                    this.log.warn((Object)("Failed to remove File Record[pk=" + fileDTO.getPk() + "] from DB:"), (Throwable)e);
                    this.log.info((Object)("-> Keep dereferenced file: " + file));
                    continue;
                }
                FileUtils.delete(file, true, fileDTO.getDirectoryPath());
                ++deleted;
            }
            int n = deleted;
            Object var9_9 = null;
            this.isRunningDeleteOrphanedPrivateFiles = false;
            return n;
        }
        catch (Throwable throwable) {
            Object var9_10 = null;
            this.isRunningDeleteOrphanedPrivateFiles = false;
            throw throwable;
        }
    }

    protected void scheduleDeleteOrder(DeleteStudyOrder order) throws Exception {
        this.deleteStudy.scheduleDeleteOrder(order);
    }

    protected String getFileSystemGroupIDForDeleter() {
        return this.getFileSystemGroupID();
    }

    private long nextMidnight() {
        Calendar cal = Calendar.getInstance();
        cal.set(11, 23);
        cal.set(12, 59);
        cal.set(13, 59);
        cal.set(14, 999);
        return cal.getTimeInMillis();
    }
}

