/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4chex.archive.mbean;

import javax.management.JMException;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.dcm4chex.archive.ejb.interfaces.FileSystemDTO;
import org.jboss.system.ServiceMBeanSupport;

public class FileSystemMgt2Delegate {
    private final ServiceMBeanSupport service;
    private String fileSystemMgtServiceNamePrefix = "dcm4chee.archive:service=FileSystemMgt,group=";

    public FileSystemMgt2Delegate(ServiceMBeanSupport service) {
        this.service = service;
    }

    public boolean isFileSystemGroupLocalAccessable(String groupID) {
        return this.service.getServer().isRegistered(this.toObjectName(groupID));
    }

    private ObjectName toObjectName(String groupID) {
        try {
            return new ObjectName(this.fileSystemMgtServiceNamePrefix + groupID);
        }
        catch (MalformedObjectNameException e) {
            throw new IllegalArgumentException(groupID);
        }
    }

    public String getFileSystemMgtServiceNamePrefix() {
        return this.fileSystemMgtServiceNamePrefix;
    }

    public void setFileSystemMgtServiceNamePrefix(String prefix) {
        this.fileSystemMgtServiceNamePrefix = prefix;
    }

    public FileSystemDTO selectStorageFileSystem(String groupID) {
        try {
            return (FileSystemDTO)this.service.getServer().invoke(this.toObjectName(groupID), "selectStorageFileSystem", null, null);
        }
        catch (JMException e) {
            throw new RuntimeException("Failed to invoke 'selectStorageFileSystem'", e);
        }
    }
}

