/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4chex.archive.mbean;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.rmi.RemoteException;
import java.util.Collection;
import org.dcm4che.data.DcmObjectFactory;
import org.dcm4che.net.ActiveAssociation;
import org.dcm4che.net.AssociationFactory;
import org.dcm4chex.archive.dcm.AbstractScuService;
import org.dcm4chex.archive.ejb.interfaces.AEDTO;

public class EchoService
extends AbstractScuService {
    private static final int PCID_ECHO = 1;

    public String[] echoAll() throws RemoteException, Exception {
        Collection aes = this.aeMgt().findAll();
        String[] sa = new String[aes.size()];
        int i = 0;
        for (AEDTO ae : aes) {
            try {
                sa[i] = ae + " : " + this.echo(ae, new Integer(3));
            }
            catch (Exception x) {
                sa[i] = ae + " failed:" + x.getMessage();
            }
            ++i;
        }
        return sa;
    }

    public String echo(String aet) throws Exception {
        return this.echo(aet, (Integer)1);
    }

    public String echo(String aet, Integer nrOfTests) {
        try {
            return this.echo(this.aeMgt().findByAET(aet), nrOfTests);
        }
        catch (Throwable e) {
            return "Echo failed:" + e.getMessage();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String echo(AEDTO aeData, Integer nrOfTests) throws InterruptedException, IOException {
        StringWriter swr = new StringWriter(nrOfTests * 20 + 50);
        StringBuffer echoResult = swr.getBuffer();
        echoResult.append("DICOM Echo to ").append(aeData).append(":\n");
        try {
            long t0 = System.currentTimeMillis();
            ActiveAssociation aa = this.openAssociation(aeData, "1.2.840.10008.1.1");
            try {
                long t1 = System.currentTimeMillis();
                echoResult.append("Open Association in ").append(t1 - t0).append(" ms.\n");
                this.echo(aa, nrOfTests, nrOfTests > 1 ? echoResult : null);
                echoResult.append("Total time for successfully echo ").append(aeData.getTitle());
                if (nrOfTests > 1) {
                    echoResult.append(' ').append(nrOfTests).append(" times");
                }
                echoResult.append(": ").append(System.currentTimeMillis() - t0).append(" ms!");
                Object var11_9 = null;
            }
            catch (Throwable throwable) {
                Object var11_10 = null;
                try {
                    aa.release(true);
                }
                catch (Exception e) {
                    this.log.warn((Object)("Failed to release " + aa.getAssociation()));
                }
                throw throwable;
            }
            try {
                aa.release(true);
            }
            catch (Exception e) {
                this.log.warn((Object)("Failed to release " + aa.getAssociation()));
            }
        }
        catch (Throwable e) {
            this.log.error((Object)("Echo " + aeData + " failed"), e);
            echoResult.append("Echo failed! Reason: ").append(e.getMessage());
            e.printStackTrace(new PrintWriter(swr));
        }
        return echoResult.toString();
    }

    private void echo(ActiveAssociation aa, int nrOfTests, StringBuffer echoResult) throws InterruptedException, IOException {
        AssociationFactory aFact = AssociationFactory.getInstance();
        DcmObjectFactory oFact = DcmObjectFactory.getInstance();
        int nrOfLT1ms = 0;
        for (int i = 0; i < nrOfTests; ++i) {
            long t0 = System.currentTimeMillis();
            aa.invoke(aFact.newDimse(1, oFact.newCommand().initCEchoRQ(i)), null);
            if (echoResult == null) continue;
            long t1 = System.currentTimeMillis();
            long diff = t1 - t0;
            if (diff < 1L) {
                ++nrOfLT1ms;
                continue;
            }
            if (nrOfLT1ms > 0) {
                echoResult.append(nrOfLT1ms).append(" Echoes, each done in less than 1 ms!\n");
                nrOfLT1ms = 0;
            }
            echoResult.append("Echo done in ").append(System.currentTimeMillis() - t0).append(" ms!\n");
        }
        if (nrOfLT1ms > 0) {
            echoResult.append(nrOfLT1ms).append(" Echoes, each done in less than 1 ms!\n");
        }
    }

    public String echo(String title, String host, int port, String cipherSuites, int nrOfTests) throws InterruptedException, IOException {
        AEDTO ae = new AEDTO();
        ae.setTitle(title);
        ae.setHostName(host);
        ae.setPort(port);
        ae.setCipherSuitesAsString(cipherSuites);
        return this.echo(ae, (Integer)nrOfTests);
    }

    public boolean checkEcho(String title, String host, int port, String cipherSuites) {
        AEDTO ae = new AEDTO();
        ae.setTitle(title);
        ae.setHostName(host);
        ae.setPort(port);
        ae.setCipherSuitesAsString(cipherSuites);
        return this.checkEcho(ae);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive exception aggregation
     */
    public boolean checkEcho(AEDTO aeData) {
        try {
            boolean bl;
            ActiveAssociation aa = this.openAssociation(aeData, "1.2.840.10008.1.1");
            try {
                this.echo(aa, 1, null);
                bl = true;
                Object var5_5 = null;
            }
            catch (Throwable throwable) {
                Object var5_6 = null;
                try {
                    aa.release(true);
                }
                catch (Exception e) {
                    this.log.warn((Object)("Failed to release " + aa.getAssociation()));
                }
                throw throwable;
            }
            try {
                aa.release(true);
            }
            catch (Exception e) {
                this.log.warn((Object)("Failed to release " + aa.getAssociation()));
            }
            return bl;
        }
        catch (Exception e) {
            this.log.error((Object)("Echo " + aeData + " failed"), (Throwable)e);
            return false;
        }
    }
}

