/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4chex.archive.mbean;

import java.security.Principal;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.security.auth.Subject;
import org.dcm4che.net.AAssociateRJException;
import org.dcm4che.net.AAssociateRQ;
import org.dcm4che.net.Association;
import org.dcm4che.net.AssociationFactory;
import org.dcm4che.net.UserIdentityAC;
import org.dcm4che.net.UserIdentityNegotiator;
import org.dcm4che.net.UserIdentityRQ;
import org.dcm4chex.archive.ejb.interfaces.AEDTO;
import org.dcm4chex.archive.ejb.interfaces.AEManager;
import org.dcm4chex.archive.ejb.interfaces.AEManagerHome;
import org.dcm4chex.archive.exceptions.ConfigurationException;
import org.dcm4chex.archive.exceptions.UnknownAETException;
import org.dcm4chex.archive.util.EJBHomeFactory;
import org.jboss.security.SimplePrincipal;
import org.jboss.security.plugins.JaasSecurityManager;
import org.jboss.system.ServiceMBeanSupport;

public class DicomSecurityService
extends ServiceMBeanSupport
implements UserIdentityNegotiator {
    private JaasSecurityManager securityManager;
    private String securityDomain;
    private String defUserID;
    private String defPassword;
    private boolean rejectIfNoUserIdentity;

    public final String getSecurityDomain() {
        return this.securityDomain;
    }

    public final void setSecurityDomain(String securityDomain) {
        if (securityDomain.equals(this.securityDomain)) {
            return;
        }
        this.securityDomain = securityDomain;
        if (super.getState() == 3) {
            this.initSecurityManager();
        }
    }

    public final boolean isRejectIfNoUserIdentity() {
        return this.rejectIfNoUserIdentity;
    }

    public final void setRejectIfNoUserIdentity(boolean reject) {
        this.rejectIfNoUserIdentity = reject;
    }

    private static String maskNull(String val, String def) {
        return val != null ? val : def;
    }

    private static String nullify(String val, String nullval) {
        String trim = val.trim();
        return trim.equals(nullval) ? null : trim;
    }

    public final String getDefaultUserID() {
        return DicomSecurityService.maskNull(this.defUserID, "-");
    }

    public final void setDefaultUserID(String defUserID) {
        this.defUserID = DicomSecurityService.nullify(defUserID, "-");
    }

    public final String getDefaultPassword() {
        return DicomSecurityService.maskNull(this.defPassword, "-");
    }

    public final void setDefaultPassword(String defPassword) {
        this.defPassword = DicomSecurityService.nullify(defPassword, "-");
    }

    protected void startService() throws Exception {
        this.initSecurityManager();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void initSecurityManager() {
        InitialContext iniCtx = null;
        try {
            try {
                iniCtx = new InitialContext();
                this.securityManager = (JaasSecurityManager)iniCtx.lookup("java:/jaas/" + this.securityDomain);
            }
            catch (NamingException e) {
                throw new ConfigurationException(e);
            }
            Object var4_2 = null;
            if (iniCtx == null) return;
        }
        catch (Throwable throwable) {
            Object var4_3 = null;
            if (iniCtx == null) throw throwable;
            try {
                iniCtx.close();
                throw throwable;
            }
            catch (NamingException ignore) {
                // empty catch block
            }
            throw throwable;
        }
        try {}
        catch (NamingException ignore) {}
        iniCtx.close();
        return;
    }

    public UserIdentityNegotiator userIdentityNegotiator() {
        return this;
    }

    public UserIdentityAC negotiate(Association assoc) throws AAssociateRJException {
        String userId = null;
        String passwd = null;
        AAssociateRQ rq = assoc.getAAssociateRQ();
        UserIdentityRQ uidRQ = rq.getUserIdentity();
        if (uidRQ != null) {
            userId = uidRQ.getUsername();
            passwd = uidRQ.getPasscode();
        } else {
            try {
                AEDTO ae = this.aeMgr().findByAET(rq.getCallingAET());
                userId = ae.getUserID();
                passwd = ae.getPassword();
            }
            catch (UnknownAETException e) {
            }
            catch (Exception e) {
                throw new ConfigurationException(e);
            }
            if (userId == null || userId.length() == 0) {
                if (this.rejectIfNoUserIdentity) {
                    throw new AAssociateRJException(1, 2, 1);
                }
                if (this.defUserID == null) {
                    return null;
                }
                userId = this.defUserID;
                passwd = this.defPassword;
            }
        }
        Subject subject = new Subject();
        if (!this.isValid(userId, passwd, subject)) {
            throw new AAssociateRJException(1, 2, 1);
        }
        assoc.putProperty("user", subject);
        return uidRQ != null && uidRQ.isPositiveResponseRequested() ? AssociationFactory.getInstance().newUserIdentity() : null;
    }

    private AEManager aeMgr() throws Exception {
        AEManagerHome home = (AEManagerHome)EJBHomeFactory.getFactory().lookup(AEManagerHome.class, "ejb/AEManager");
        return home.create();
    }

    public boolean isValid(String userId, String passwd, Subject subject) {
        return this.securityManager.isValid((Principal)new SimplePrincipal(userId), (Object)passwd, subject);
    }
}

