/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4chex.archive.mbean;

import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.ejb.CreateException;
import javax.ejb.FinderException;
import javax.ejb.RemoveException;
import javax.xml.transform.Templates;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.sax.SAXResult;
import javax.xml.transform.stream.StreamSource;
import org.dcm4che.data.Dataset;
import org.dcm4che.data.DcmElement;
import org.dcm4che.data.DcmObjectFactory;
import org.dcm4cheri.util.StringUtils;
import org.dcm4chex.archive.ejb.interfaces.CodeToDeviceMapping;
import org.dcm4chex.archive.ejb.interfaces.CodeToDeviceMappingHome;
import org.dcm4chex.archive.util.EJBHomeFactory;
import org.dcm4chex.archive.util.HomeFactoryException;
import org.jboss.system.ServiceMBeanSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DeviceService
extends ServiceMBeanSupport {
    private static Logger log = LoggerFactory.getLogger(DeviceService.class);
    private static final String STANDARD_XSL_URL = "resource:dcm4chee-device-import.xsl";
    private CodeToDeviceMapping mapper;
    private Map templates = new HashMap();
    private static final TransformerFactory tf = TransformerFactory.newInstance();
    private static final DcmObjectFactory dof = DcmObjectFactory.getInstance();

    protected void startService() throws Exception {
    }

    protected void stopService() throws Exception {
    }

    public String importDeviceMapping(String importURL) {
        Dataset ds = dof.newDataset();
        try {
            Transformer t = this.getTemplates(STANDARD_XSL_URL).newTransformer();
            t.transform(new StreamSource(importURL), new SAXResult(ds.getSAXHandler2(null)));
            this.lookupMapper().createMapping(ds);
        }
        catch (Exception x) {
            log.error("Exception importing Device mapping for URL {}", (Object)importURL, (Object)x);
            return "Exception:" + x.getMessage();
        }
        return "Device mapping from url '" + importURL + "' imported!";
    }

    public String deleteMapping() throws RemoteException, FinderException, RemoveException, HomeFactoryException, CreateException {
        return "Status:" + this.lookupMapper().deleteMapping();
    }

    public String deleteDevice(String device) throws RemoteException, FinderException, RemoveException, HomeFactoryException, CreateException {
        return "Status:" + this.lookupMapper().deleteDevice(device);
    }

    public Collection getDeviceList(String protocol) throws RemoteException, HomeFactoryException, CreateException, FinderException {
        String[] sa = StringUtils.split(protocol, '^');
        if (sa.length < 3) {
            throw new IllegalArgumentException("Wrong protocol format! Use <code>^<meaning>^<designator> !");
        }
        Dataset ds = dof.newDataset();
        DcmElement sq = ds.putSQ(0x400100);
        Dataset ds1 = sq.addNewItem();
        DcmElement codeSq = ds1.putSQ(0x400008);
        Dataset ds2 = codeSq.addNewItem();
        ds2.putSH(524544, sa[0]);
        ds2.putSH(524548, sa[1]);
        ds2.putSH(524546, sa[2]);
        Dataset ds3 = this.addScheduledStationInfo(ds);
        sq = ds3.get(0x400100);
        ds1 = sq.getItem();
        String dev = ds1.getString(0x400010);
        ArrayList<String> l = new ArrayList<String>();
        l.add(dev);
        return l;
    }

    public Dataset addScheduledStationInfo(Dataset ds) throws RemoteException, FinderException, HomeFactoryException, CreateException {
        return this.lookupMapper().addScheduledStationInfo(ds);
    }

    public Templates getTemplates(String uri) throws TransformerConfigurationException {
        Templates tpl = (Templates)this.templates.get(uri);
        if (tpl == null) {
            tpl = tf.newTemplates(new StreamSource(uri));
            this.templates.put(uri, tpl);
        }
        return tpl;
    }

    private CodeToDeviceMapping lookupMapper() throws HomeFactoryException, RemoteException, CreateException {
        if (this.mapper == null) {
            CodeToDeviceMappingHome home = (CodeToDeviceMappingHome)EJBHomeFactory.getFactory().lookup(CodeToDeviceMappingHome.class, "ejb/CodeToDeviceMapping");
            this.mapper = home.create();
        }
        return this.mapper;
    }
}

