/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4chex.archive.mbean;

import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Date;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageListener;
import javax.jms.ObjectMessage;
import javax.management.Notification;
import javax.management.ObjectName;
import org.dcm4che.data.Dataset;
import org.dcm4che.data.DcmElement;
import org.dcm4chex.archive.common.ActionOrder;
import org.dcm4chex.archive.common.BaseJmsOrder;
import org.dcm4chex.archive.common.DeleteStudyOrder;
import org.dcm4chex.archive.config.RetryIntervalls;
import org.dcm4chex.archive.ejb.interfaces.FileSystemDTO;
import org.dcm4chex.archive.ejb.interfaces.FileSystemMgt2;
import org.dcm4chex.archive.ejb.interfaces.FileSystemMgt2Home;
import org.dcm4chex.archive.exceptions.ConcurrentStudyStorageException;
import org.dcm4chex.archive.exceptions.NoSuchSeriesException;
import org.dcm4chex.archive.exceptions.NoSuchStudyException;
import org.dcm4chex.archive.mbean.JMSDelegate;
import org.dcm4chex.archive.notif.StudyDeleted;
import org.dcm4chex.archive.util.EJBHomeFactory;
import org.dcm4chex.archive.util.FileUtils;
import org.jboss.system.ServiceMBeanSupport;

public class DeleteStudyService
extends ServiceMBeanSupport
implements MessageListener {
    private JMSDelegate jmsDelegate = new JMSDelegate(this);
    private String deleteStudyQueueName;
    private RetryIntervalls retryIntervalsForJmsOrder = new RetryIntervalls();
    private boolean deleteStudyFromDB;
    private boolean deletePatientWithoutObjects;
    private boolean createIANonStudyDelete = false;
    private boolean deleteSeriesBySeries;

    public boolean isDeleteSeriesBySeries() {
        return this.deleteSeriesBySeries;
    }

    public void setDeleteSeriesBySeries(boolean deleteSeriesBySeries) {
        this.deleteSeriesBySeries = deleteSeriesBySeries;
    }

    public boolean isDeleteStudyFromDB() {
        return this.deleteStudyFromDB;
    }

    public void setDeleteStudyFromDB(boolean deleteStudyFromDB) {
        this.deleteStudyFromDB = deleteStudyFromDB;
    }

    public boolean isDeletePatientWithoutObjects() {
        return this.deletePatientWithoutObjects;
    }

    public void setDeletePatientWithoutObjects(boolean deletePatientWithoutObjects) {
        this.deletePatientWithoutObjects = deletePatientWithoutObjects;
    }

    public boolean isCreateIANonStudyDelete() {
        return this.createIANonStudyDelete;
    }

    public void setCreateIANonStudyDelete(boolean createIANonStudyDelete) {
        this.createIANonStudyDelete = createIANonStudyDelete;
    }

    public final String getRetryIntervalsForJmsOrder() {
        return this.retryIntervalsForJmsOrder.toString();
    }

    public final void setRetryIntervalsForJmsOrder(String s) {
        this.retryIntervalsForJmsOrder = new RetryIntervalls(s);
    }

    public String getDeleteStudyQueueName() {
        return this.deleteStudyQueueName;
    }

    public void setDeleteStudyQueueName(String deleteStudyQueueName) {
        this.deleteStudyQueueName = deleteStudyQueueName;
    }

    public ObjectName getJmsServiceName() {
        return this.jmsDelegate.getJmsServiceName();
    }

    public void setJmsServiceName(ObjectName jmsServiceName) {
        this.jmsDelegate.setJmsServiceName(jmsServiceName);
    }

    protected void startService() throws Exception {
        this.jmsDelegate.startListening(this.deleteStudyQueueName, this, 1);
    }

    protected void stopService() throws Exception {
        this.jmsDelegate.stopListening(this.deleteStudyQueueName);
    }

    public void scheduleDeleteOrder(DeleteStudyOrder order) throws Exception {
        this.schedule(order, 0L);
    }

    protected void schedule(BaseJmsOrder order, long scheduledTime) throws Exception {
        if (this.log.isInfoEnabled()) {
            String scheduledTimeStr = scheduledTime > 0L ? new Date(scheduledTime).toString() : "now";
            this.log.info((Object)("Scheduling job [" + order + "] at " + scheduledTimeStr + ". Retry times: " + order.getFailureCount()));
        }
        this.jmsDelegate.queue(this.deleteStudyQueueName, order, 4, scheduledTime);
    }

    public void onMessage(Message msg) {
        ObjectMessage message = (ObjectMessage)msg;
        Serializable o = null;
        try {
            o = message.getObject();
        }
        catch (JMSException e1) {
            this.log.error((Object)("Processing JMS message failed! message:" + message), (Throwable)e1);
        }
        if (o instanceof BaseJmsOrder) {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Processing JMS message: " + o));
            }
            BaseJmsOrder order = (BaseJmsOrder)o;
            try {
                if (order instanceof ActionOrder) {
                    ActionOrder actionOrder = (ActionOrder)order;
                    Method m = ((Object)((Object)this)).getClass().getDeclaredMethod(actionOrder.getActionMethod(), Object.class);
                    m.invoke((Object)this, actionOrder.getData());
                } else if (order instanceof DeleteStudyOrder) {
                    try {
                        if (this.deleteSeriesBySeries) {
                            this.deleteSeries((DeleteStudyOrder)order);
                        } else {
                            this.deleteStudy((DeleteStudyOrder)order);
                        }
                    }
                    catch (ConcurrentStudyStorageException e) {
                        this.log.info((Object)e.getMessage());
                    }
                }
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)("Finished processing " + order));
                }
            }
            catch (Exception e) {
                int failureCount = order.getFailureCount() + 1;
                order.setFailureCount(failureCount);
                long delay = this.retryIntervalsForJmsOrder.getIntervall(failureCount);
                if (delay == -1L) {
                    order.setThrowable(e);
                    this.log.error((Object)("Give up to process " + order));
                    try {
                        this.jmsDelegate.fail(this.deleteStudyQueueName, order);
                    }
                    catch (Exception e2) {
                        this.log.error((Object)("Failed to notify JMSDelgate of failed job! Give up to process" + order), (Throwable)e2);
                    }
                }
                Throwable thisThrowable = e;
                if (e instanceof InvocationTargetException) {
                    thisThrowable = ((InvocationTargetException)e).getTargetException();
                }
                if (order.getFailureCount() == 1 || order.getThrowable() != null && !thisThrowable.getClass().equals(order.getThrowable().getClass())) {
                    this.log.error((Object)("Failed to process JMS job. Will schedule retry ... Dumping - " + order.toString()), (Throwable)e);
                    order.setThrowable(thisThrowable);
                } else {
                    this.log.warn((Object)("Failed to process " + order + ". Details should have been provided. Will schedule retry."));
                }
                try {
                    this.schedule(order, System.currentTimeMillis() + delay);
                }
                catch (Exception e2) {
                    this.log.error((Object)("Failed to schedule retry! Give up to process " + order), (Throwable)e2);
                }
            }
        }
    }

    private void deleteStudy(DeleteStudyOrder order) throws Exception {
        FileSystemMgt2 fsMgt = DeleteStudyService.fileSystemMgt();
        Collection ians = null;
        if (this.createIANonStudyDelete && this.deleteStudyFromDB) {
            ians = fsMgt.createIANforStudy(order.getStudyPk());
        }
        String[] filePaths = fsMgt.deleteStudy(order, this.deleteStudyFromDB, this.deletePatientWithoutObjects);
        FileSystemDTO fsDto = fsMgt.getFileSystem(order.getFsPk());
        for (int i = 0; i < filePaths.length; ++i) {
            FileUtils.delete(FileUtils.toFile(filePaths[i]), true, fsDto.getDirectoryPath());
        }
        try {
            fsMgt.removeStudyOnFSRecord(order);
        }
        catch (Exception x) {
            this.log.warn((Object)("Remove StudyOnFS record failed for " + order), (Throwable)x);
        }
        if (this.createIANonStudyDelete) {
            try {
                try {
                    ians = fsMgt.createIANforStudy(order.getStudyPk());
                    for (Dataset ian : ians) {
                        this.updateRetrieveAET(ian, fsMgt.getFileSystem(order.getFsPk()).getRetrieveAET());
                    }
                }
                catch (NoSuchStudyException e) {
                    if (ians == null) {
                        throw e;
                    }
                    for (Dataset ian : ians) {
                        DeleteStudyService.updateAvailability(ian, "UNAVAILABLE");
                    }
                }
                for (Dataset ian : ians) {
                    this.sendJMXNotification(new StudyDeleted(ian));
                }
            }
            catch (Exception e) {
                this.log.error((Object)"Failed to create IAN on Study Delete:", (Throwable)e);
            }
        }
    }

    private void updateRetrieveAET(Dataset ian, String retrieveAET) {
        DcmElement refSerSeq = ian.get(528661);
        int n = refSerSeq.countItems();
        for (int i = 0; i < n; ++i) {
            Dataset refSer = refSerSeq.getItem(i);
            DcmElement refSopSeq = refSer.get(528793);
            int m = refSopSeq.countItems();
            for (int j = 0; j < m; ++j) {
                Dataset refSOP = refSopSeq.getItem(j);
                if (refSOP.containsValue(524372)) continue;
                refSOP.putCS(524372, retrieveAET);
            }
        }
    }

    private static void updateAvailability(Dataset ian, String availability) {
        DcmElement refSerSeq = ian.get(528661);
        int n = refSerSeq.countItems();
        for (int i = 0; i < n; ++i) {
            Dataset refSer = refSerSeq.getItem(i);
            DcmElement refSopSeq = refSer.get(528793);
            int m = refSopSeq.countItems();
            for (int j = 0; j < m; ++j) {
                Dataset refSOP = refSopSeq.getItem(j);
                refSOP.putCS(524374, availability);
            }
        }
    }

    private void deleteSeries(DeleteStudyOrder order) throws Exception {
        FileSystemMgt2 fsMgt = DeleteStudyService.fileSystemMgt();
        Collection seriesPks = fsMgt.getSeriesPks(order);
        FileSystemDTO fsDto = fsMgt.getFileSystem(order.getFsPk());
        for (Long seriesPk : seriesPks) {
            String[] filePaths;
            Dataset ian = null;
            if (this.createIANonStudyDelete && this.deleteStudyFromDB) {
                try {
                    ian = fsMgt.createIANforSeries(seriesPk);
                }
                catch (NoSuchSeriesException e) {
                    continue;
                }
            }
            if ((filePaths = fsMgt.deleteSeries(order, seriesPk, this.deleteStudyFromDB, this.deletePatientWithoutObjects)).length == 0) continue;
            for (int i = 0; i < filePaths.length; ++i) {
                FileUtils.delete(FileUtils.toFile(filePaths[i]), true, fsDto.getDirectoryPath());
            }
            if (!this.createIANonStudyDelete) continue;
            try {
                try {
                    ian = fsMgt.createIANforSeries(seriesPk);
                    this.updateRetrieveAET(ian, fsMgt.getFileSystem(order.getFsPk()).getRetrieveAET());
                }
                catch (NoSuchSeriesException e) {
                    if (ian == null) {
                        throw e;
                    }
                    DeleteStudyService.updateAvailability(ian, "UNAVAILABLE");
                }
                this.sendJMXNotification(new StudyDeleted(ian));
            }
            catch (Exception e) {
                this.log.error((Object)"Failed to create IAN on Study Delete:", (Throwable)e);
            }
        }
        try {
            fsMgt.removeStudyOnFSRecord(order);
        }
        catch (Exception x) {
            this.log.warn((Object)("Remove StudyOnFS record failed for " + order), (Throwable)x);
        }
    }

    static FileSystemMgt2 fileSystemMgt() throws Exception {
        FileSystemMgt2Home home = (FileSystemMgt2Home)EJBHomeFactory.getFactory().lookup(FileSystemMgt2Home.class, "ejb/FileSystemMgt2");
        return home.create();
    }

    void sendJMXNotification(Object o) {
        long eventID = super.getNextNotificationSequenceNumber();
        Notification notif = new Notification(o.getClass().getName(), (Object)this, eventID);
        notif.setUserData(o);
        super.sendNotification(notif);
    }
}

