/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4chex.archive.mbean;

import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.ejb.CreateException;
import javax.ejb.EJBException;
import javax.ejb.FinderException;
import javax.ejb.RemoveException;
import javax.management.InstanceNotFoundException;
import javax.management.Notification;
import javax.management.ObjectName;
import org.apache.log4j.Logger;
import org.dcm4che.data.Dataset;
import org.dcm4che.data.DcmElement;
import org.dcm4che.data.PersonName;
import org.dcm4che2.audit.message.AuditEvent;
import org.dcm4che2.audit.message.AuditMessage;
import org.dcm4che2.audit.message.InstancesAccessedMessage;
import org.dcm4che2.audit.message.ParticipantObject;
import org.dcm4che2.audit.message.ParticipantObjectDescription;
import org.dcm4che2.audit.message.PatientRecordMessage;
import org.dcm4che2.audit.message.StudyDeletedMessage;
import org.dcm4che2.audit.util.InstanceSorter;
import org.dcm4chex.archive.common.PatientMatching;
import org.dcm4chex.archive.ejb.interfaces.ContentEdit;
import org.dcm4chex.archive.ejb.interfaces.ContentEditHome;
import org.dcm4chex.archive.ejb.interfaces.ContentManager;
import org.dcm4chex.archive.ejb.interfaces.ContentManagerHome;
import org.dcm4chex.archive.ejb.interfaces.FileDTO;
import org.dcm4chex.archive.ejb.interfaces.PrivateManager;
import org.dcm4chex.archive.ejb.interfaces.PrivateManagerHome;
import org.dcm4chex.archive.mbean.HttpUserInfo;
import org.dcm4chex.archive.notif.PatientUpdated;
import org.dcm4chex.archive.notif.SeriesUpdated;
import org.dcm4chex.archive.notif.StudyDeleted;
import org.dcm4chex.archive.util.EJBHomeFactory;
import org.dcm4chex.archive.util.HomeFactoryException;
import org.jboss.system.ServiceMBeanSupport;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ContentEditService
extends ServiceMBeanSupport {
    private static final int DELETED = 1;
    private boolean auditEnabled;
    private boolean createIANonMoveToTrash;
    private ContentEdit contentEdit;
    private ObjectName hl7SendServiceName;
    private String sendingApplication;
    private String sendingFacility;
    private String receivingApplication;
    private String receivingFacility;
    private boolean keepPriorPatientAfterMerge = true;
    private ObjectName studyMgtScuServiceName;
    private ObjectName storeScpServiceName;
    private ObjectName mppsScpServiceName;
    private String callingAET;
    private String calledAET;
    private ContentManager contentMgr;
    private PrivateManager privateMgr;
    private boolean logIUIDsForStudyUpdate;
    private boolean logIUIDsForSeriesUpdate;
    private boolean logDeletedOnMoveEntities;

    protected void startService() throws Exception {
    }

    protected void stopService() throws Exception {
    }

    public void setAuditEnabled(boolean auditEnabled) {
        this.auditEnabled = auditEnabled;
    }

    public boolean getAuditEnabled() {
        return this.auditEnabled;
    }

    public void setCreateIANonMoveToTrash(boolean createIAN) {
        this.createIANonMoveToTrash = createIAN;
    }

    public boolean isCreateIANonMoveToTrash() {
        return this.createIANonMoveToTrash;
    }

    public boolean isKeepPriorPatientAfterMerge() {
        return this.keepPriorPatientAfterMerge;
    }

    public void setKeepPriorPatientAfterMerge(boolean keepPriorPatientAfterMerge) {
        this.keepPriorPatientAfterMerge = keepPriorPatientAfterMerge;
    }

    public boolean isLogIUIDsForStudyUpdate() {
        return this.logIUIDsForStudyUpdate;
    }

    public void setLogIUIDsForStudyUpdate(boolean logIUIDsForStudyUpdate) {
        this.logIUIDsForStudyUpdate = logIUIDsForStudyUpdate;
    }

    public boolean isLogIUIDsForSeriesUpdate() {
        return this.logIUIDsForSeriesUpdate;
    }

    public void setLogIUIDsForSeriesUpdate(boolean logIUIDsForSeriesUpdate) {
        this.logIUIDsForSeriesUpdate = logIUIDsForSeriesUpdate;
    }

    public boolean isLogDeletedOnMoveEntities() {
        return this.logDeletedOnMoveEntities;
    }

    public void setLogDeletedOnMoveEntities(boolean logDeletedOnMoveEntities) {
        this.logDeletedOnMoveEntities = logDeletedOnMoveEntities;
    }

    public final ObjectName getHL7SendServiceName() {
        return this.hl7SendServiceName;
    }

    public final void setHL7SendServiceName(ObjectName name) {
        this.hl7SendServiceName = name;
    }

    public final ObjectName getStudyMgtScuServiceName() {
        return this.studyMgtScuServiceName;
    }

    public final void setStudyMgtScuServiceName(ObjectName name) {
        this.studyMgtScuServiceName = name;
    }

    public ObjectName getStoreScpServiceName() {
        return this.storeScpServiceName;
    }

    public void setStoreScpServiceName(ObjectName storeScpServiceName) {
        this.storeScpServiceName = storeScpServiceName;
    }

    public ObjectName getMppsScpServiceName() {
        return this.mppsScpServiceName;
    }

    public void setMppsScpServiceName(ObjectName mppsScpServiceName) {
        this.mppsScpServiceName = mppsScpServiceName;
    }

    public String getReceivingApplication() {
        return this.receivingApplication;
    }

    public void setReceivingApplication(String receivingApplication) {
        this.receivingApplication = receivingApplication;
    }

    public String getReceivingFacility() {
        return this.receivingFacility;
    }

    public void setReceivingFacility(String receivingFacility) {
        this.receivingFacility = receivingFacility;
    }

    public String getSendingApplication() {
        return this.sendingApplication;
    }

    public void setSendingApplication(String sendingApplication) {
        this.sendingApplication = sendingApplication;
    }

    public String getSendingFacility() {
        return this.sendingFacility;
    }

    public void setSendingFacility(String sendingFacility) {
        this.sendingFacility = sendingFacility;
    }

    public String getCalledAET() {
        return this.calledAET;
    }

    public void setCalledAET(String calledAET) {
        this.calledAET = calledAET;
    }

    public String getCallingAET() {
        return this.callingAET;
    }

    public void setCallingAET(String callingAET) {
        this.callingAET = callingAET;
    }

    public Dataset createPatient(Dataset ds) throws RemoteException, CreateException, HomeFactoryException, FinderException {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)"create Partient");
        }
        String pid = ds.getString(0x100020);
        String issuer = ds.getString(0x100021);
        Dataset ds1 = this.lookupContentManager().getPatientByID(pid, issuer);
        if (ds1 != null) {
            throw new CreateException("Patient with ID(pid:" + pid + " issuer:" + issuer + ") already exists!");
        }
        ds1 = this.lookupContentEdit().createPatient(ds);
        this.sendHL7PatientXXX(ds, "ADT^A04");
        this.logPatientRecord(ds, PatientRecordMessage.CREATE);
        return ds1;
    }

    public Map mergePatients(Long patPk, long[] mergedPks) throws RemoteException, HomeFactoryException, CreateException, RemoveException, EJBException {
        Map map;
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)"merge Partient");
        }
        if (!(map = this.lookupContentEdit().mergePatients(patPk, mergedPks, this.keepPriorPatientAfterMerge)).containsKey("ERROR")) {
            this.sendHL7PatientMerge((Dataset)map.get("DOMINANT"), (Dataset[])map.get("MERGED"));
            String patID = ((Dataset)map.get("DOMINANT")).getString(0x100020);
            this.sendJMXNotification(new PatientUpdated(patID, "Patient merge"));
        }
        return map;
    }

    public Dataset createStudy(Dataset ds, Long patPk) throws CreateException, RemoteException, HomeFactoryException {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)"create study:");
        }
        this.log.debug((Object)ds);
        Dataset stdyMgtDs = this.lookupContentEdit().createStudy(ds, patPk);
        this.logInstancesAccessed(stdyMgtDs, InstancesAccessedMessage.CREATE, false, null);
        this.sendStudyMgt(stdyMgtDs.getString(0x20000D), 320, 0, stdyMgtDs);
        this.sendNewStudyNotification(ds);
        return stdyMgtDs;
    }

    private void sendNewStudyNotification(Dataset ds) {
        long eventID = super.getNextNotificationSequenceNumber();
        Notification notif = new Notification("org.dcm4chex.archive.dcm.storescp#newStudy", (Object)this, eventID);
        notif.setUserData(ds);
        super.sendNotification(notif);
    }

    public Dataset createSeries(Dataset ds, Long studyPk) throws CreateException, RemoteException, HomeFactoryException, FinderException {
        Dataset stdyMgtDs = this.lookupContentEdit().createSeries(ds, studyPk);
        this.log.debug((Object)"create Series ds1:");
        this.log.debug((Object)stdyMgtDs);
        this.logInstancesAccessed(stdyMgtDs, InstancesAccessedMessage.CREATE, false, "Created Series:");
        this.sendStudyMgt(stdyMgtDs.getString(0x20000D), 288, 0, stdyMgtDs);
        String seriesIUID = stdyMgtDs.get(528661).getItem().getString(0x20000E);
        return this.lookupContentManager().getSeriesByIUID(seriesIUID);
    }

    public void updatePatient(Dataset ds) throws RemoteException, HomeFactoryException, CreateException {
        this.log.debug((Object)"update Patient");
        Collection col = this.lookupContentEdit().updatePatient(ds);
        this.sendHL7PatientXXX(ds, "ADT^A08");
        String patID = ds.getString(0x100020);
        this.sendJMXNotification(new PatientUpdated(patID, "Patient update"));
        this.logPatientRecord(ds, PatientRecordMessage.UPDATE);
    }

    public Map linkMppsToMwl(String[] spsIDs, String[] mppsIUIDs) {
        return this.doLinkMppsToMwl(spsIDs, mppsIUIDs);
    }

    public Map linkMppsToMwl(Dataset[] spsAttrs, String[] mppsIUIDs) {
        return this.doLinkMppsToMwl(spsAttrs, mppsIUIDs);
    }

    private Map doLinkMppsToMwl(Object o, String[] mppsIUIDs) {
        try {
            Map map = (Map)this.server.invoke(this.mppsScpServiceName, "linkMppsToMwl", new Object[]{o, mppsIUIDs}, new String[]{o.getClass().getName(), String[].class.getName()});
            List studyDsN = (List)map.get("StudyMgtDS");
            for (Dataset dsN : studyDsN) {
                this.sendStudyMgt(dsN.getString(0x20000D), 288, 0, dsN);
                this.sendSeriesUpdatedNotifications(dsN, "Series update");
            }
            return map;
        }
        catch (Exception x) {
            this.log.error((Object)("Exception occured in linkMppsToMwl: " + x.getMessage()), (Throwable)x);
            return null;
        }
    }

    private void sendStudyMgt(String iuid, int commandField, int actionTypeID, Dataset dataset) {
        String infoStr = "iuid: " + iuid + ", cmd:" + commandField + ", action: " + actionTypeID + ", ds:";
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("send StudyMgt command: " + infoStr));
            this.log.debug((Object)dataset);
        }
        try {
            this.server.invoke(this.studyMgtScuServiceName, "forward", new Object[]{this.callingAET, this.calledAET, iuid, new Integer(commandField), new Integer(actionTypeID), dataset}, new String[]{String.class.getName(), String.class.getName(), String.class.getName(), Integer.TYPE.getName(), Integer.TYPE.getName(), Dataset.class.getName()});
        }
        catch (InstanceNotFoundException infe) {
            this.log.warn((Object)("The MBean service [" + this.studyMgtScuServiceName + "] is not registered. Ignore sending StudyMgt command: " + infoStr));
        }
        catch (Exception e) {
            this.log.error((Object)("Failed to send StudyMgt command:" + infoStr), (Throwable)e);
        }
    }

    private void sendHL7PatientXXX(Dataset ds, String msgType) {
        try {
            this.server.invoke(this.hl7SendServiceName, "sendHL7PatientXXX", new Object[]{ds, msgType, this.getSendingApplication() + "^" + this.getSendingFacility(), this.getReceivingApplication() + "^" + this.getReceivingFacility(), Boolean.TRUE}, new String[]{Dataset.class.getName(), String.class.getName(), String.class.getName(), String.class.getName(), Boolean.TYPE.getName()});
        }
        catch (InstanceNotFoundException infe) {
            this.log.warn((Object)("The MBean service [" + this.hl7SendServiceName + "] is not registered. Ignore sending HL7 message: " + msgType));
        }
        catch (Exception e) {
            this.log.error((Object)("Failed to send HL7 message:" + msgType), (Throwable)e);
            this.log.error((Object)ds);
        }
    }

    private void sendHL7PatientMerge(Dataset dsDominant, Dataset[] priorPats) {
        try {
            this.server.invoke(this.hl7SendServiceName, "sendHL7PatientMerge", new Object[]{dsDominant, priorPats, this.getSendingApplication() + "^" + this.getSendingFacility(), this.getReceivingApplication() + "^" + this.getReceivingFacility(), Boolean.TRUE}, new String[]{Dataset.class.getName(), Dataset[].class.getName(), String.class.getName(), String.class.getName(), Boolean.TYPE.getName()});
        }
        catch (InstanceNotFoundException infe) {
            this.log.warn((Object)("The MBean service [" + this.hl7SendServiceName + "] is not registered. Ignore sending HL7 patient merge message."));
        }
        catch (Exception e) {
            this.log.error((Object)"Failed to send HL7 patient merge message:", (Throwable)e);
            this.log.error((Object)dsDominant);
        }
    }

    public void updateStudy(Dataset ds) throws RemoteException, HomeFactoryException, CreateException {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)"update Study");
        }
        Dataset dsN = this.lookupContentEdit().updateStudy(ds);
        this.logInstancesAccessed(dsN, InstancesAccessedMessage.UPDATE, this.logIUIDsForStudyUpdate, null);
        this.sendStudyMgt(dsN.getString(0x20000D), 288, 0, dsN);
        this.sendSeriesUpdatedNotifications(dsN, "Study update");
    }

    public void updateSeries(Dataset ds) throws RemoteException, HomeFactoryException, CreateException {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)"update Series");
        }
        Dataset dsN = this.lookupContentEdit().updateSeries(ds);
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)"update series: dsN:");
            this.log.debug((Object)dsN);
        }
        this.logInstancesAccessed(dsN, InstancesAccessedMessage.UPDATE, this.logIUIDsForSeriesUpdate, "Updated Series:");
        this.sendStudyMgt(dsN.getString(0x20000D), 288, 0, dsN);
        this.sendSeriesUpdatedNotifications(dsN, "Series update");
    }

    public void movePatientToTrash(long pk) throws Exception {
        this.logMovePatientToTrash(this.lookupPrivateManager().movePatientToTrash(pk), true);
    }

    public void movePatientToTrash(Dataset patAttrs, PatientMatching matching) throws Exception {
        this.logMovePatientToTrash(this.lookupPrivateManager().movePatientToTrash(patAttrs, matching), false);
    }

    private void logMovePatientToTrash(Collection<Dataset> ians, boolean sendHL7_ADT_A23) {
        Dataset ds2 = null;
        for (Dataset ds2 : ians) {
            if (!ds2.containsValue(0x20000D)) continue;
            if (this.createIANonMoveToTrash) {
                this.sendJMXNotification(new StudyDeleted(ds2));
            }
            this.logStudyDeleted(ds2);
        }
        if (sendHL7_ADT_A23) {
            this.sendHL7PatientXXX(ds2, "ADT^A23");
        }
        this.logPatientRecord(ds2, PatientRecordMessage.DELETE);
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)"Patient moved to trash. ds:");
            this.log.debug((Object)ds2);
        }
    }

    public void moveStudyToTrash(long pk) throws Exception {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Move Study (pk=" + pk + ") to trash."));
        }
        Dataset ian = this.lookupPrivateManager().moveStudyToTrash(pk);
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("sendStudyMgt N-DELETE Study (pk=" + pk + ")."));
        }
        this.sendStudyMgt(ian.getString(0x20000D), 336, 0, ian);
        this.logMoveStudyToTrash(ian);
    }

    public void moveStudyToTrash(String siuid) throws Exception {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Move Study (suid=" + siuid + ") to trash."));
        }
        this.logMoveStudyToTrash(this.lookupPrivateManager().moveStudyToTrash(siuid));
    }

    private void logMoveStudyToTrash(Dataset ian) {
        if (this.createIANonMoveToTrash) {
            this.sendJMXNotification(new StudyDeleted(ian));
        }
        this.logStudyDeleted(ian);
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)"Study moved to trash. ds:");
            this.log.debug((Object)ian);
        }
    }

    public void moveSeriesToTrash(long pk) throws Exception {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Move Series (pk=" + pk + ") to trash."));
        }
        Dataset ds = this.lookupPrivateManager().moveSeriesToTrash(pk);
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("sendStudyMgt N-ACTION Series (pk=" + pk + ")."));
        }
        this.sendStudyMgt(ds.getString(0x20000D), 304, 1, ds);
        if (this.createIANonMoveToTrash) {
            this.sendJMXNotification(new StudyDeleted(ds));
        }
        this.logInstancesAccessed(ds, InstancesAccessedMessage.DELETE, this.logIUIDsForSeriesUpdate, "Deleted Series:");
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)"Series moved to trash. ds:");
            this.log.debug((Object)ds);
        }
    }

    public void moveInstanceToTrash(long pk) throws RemoteException, HomeFactoryException, CreateException {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Move Instance (pk=" + pk + ") to trash."));
        }
        Dataset ds = this.lookupPrivateManager().moveInstanceToTrash(pk);
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("sendStudyMgt N-ACTION Instance (pk=" + pk + ")."));
        }
        this.sendStudyMgt(ds.getString(0x20000D), 304, 2, ds);
        if (this.createIANonMoveToTrash) {
            this.sendJMXNotification(new StudyDeleted(ds));
        }
        this.logInstancesAccessed(ds, InstancesAccessedMessage.DELETE, true, "Referenced Series of deleted Instances:");
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)"Instance moved to trash. ds:");
            this.log.debug((Object)ds);
        }
    }

    public Dataset moveSeriesToTrash(String[] iuids) throws Exception {
        Collection dss;
        if (this.log.isDebugEnabled()) {
            this.log.debug("Move " + iuids != null ? Integer.valueOf(iuids.length) : null + " Series to trash: " + iuids);
        }
        if ((dss = this.lookupPrivateManager().moveSeriesToTrash(iuids)).size() != 1) {
            throw new Exception("moveSeriesToTrash failed");
        }
        for (Dataset ds : dss) {
            if (this.createIANonMoveToTrash) {
                this.sendJMXNotification(new StudyDeleted(ds));
            }
            this.logInstancesAccessed(ds, InstancesAccessedMessage.DELETE, true, "Deleted Series:");
        }
        return (Dataset)dss.iterator().next();
    }

    public Dataset moveInstancesToTrash(String[] iuids) throws Exception {
        Collection dss;
        if (this.log.isDebugEnabled()) {
            this.log.debug("Move " + iuids != null ? Integer.valueOf(iuids.length) : null + " Instances to trash: " + iuids);
        }
        if ((dss = this.lookupPrivateManager().moveInstancesToTrash(iuids, true)).size() != 1) {
            throw new Exception("moveInstancesToTrash failed");
        }
        for (Dataset ds : dss) {
            if (this.createIANonMoveToTrash) {
                this.sendJMXNotification(new StudyDeleted(ds));
            }
            this.logInstancesAccessed(ds, InstancesAccessedMessage.DELETE, true, "Referenced Series of deleted Instances:");
        }
        return (Dataset)dss.iterator().next();
    }

    public List undeletePatient(long privPatPk) throws RemoteException, FinderException, HomeFactoryException, CreateException {
        List[] files;
        List failed;
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("undelete Patient from trash. pk:" + privPatPk));
        }
        if ((failed = this.recoverFiles(files = this.lookupContentManager().listPatientFilesToRecover(privPatPk))).isEmpty()) {
            this.lookupPrivateManager().deletePrivateFiles(files[0]);
            this.lookupPrivateManager().deletePrivatePatient(privPatPk);
        }
        return failed;
    }

    public List undeleteStudy(long privStudyPk) throws RemoteException, FinderException, HomeFactoryException, CreateException {
        List[] files;
        List failed;
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("undelete Study from trash. pk:" + privStudyPk));
        }
        if ((failed = this.recoverFiles(files = this.lookupContentManager().listStudyFilesToRecover(privStudyPk))).isEmpty()) {
            this.lookupPrivateManager().deletePrivateFiles(files[0]);
            this.lookupPrivateManager().deletePrivateStudy(privStudyPk);
        }
        return failed;
    }

    public List undeleteSeries(long privSeriesPk) throws RemoteException, FinderException, HomeFactoryException, CreateException {
        List[] files;
        List failed;
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("undelete Series from trash. pk:" + privSeriesPk));
        }
        if ((failed = this.recoverFiles(files = this.lookupContentManager().listSeriesFilesToRecover(privSeriesPk))).isEmpty()) {
            this.lookupPrivateManager().deletePrivateFiles(files[0]);
            this.lookupPrivateManager().deletePrivateSeries(privSeriesPk);
        }
        return failed;
    }

    public List undeleteInstance(long privInstancePk) throws RemoteException, FinderException, HomeFactoryException, CreateException {
        List[] files;
        List failed;
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("undelete Instance from trash. pk:" + privInstancePk));
        }
        if ((failed = this.recoverFiles(files = this.lookupContentManager().listInstanceFilesToRecover(privInstancePk))).isEmpty()) {
            this.lookupPrivateManager().deletePrivateFiles(files[0]);
            this.lookupPrivateManager().deletePrivateInstance(privInstancePk);
        }
        return failed;
    }

    private List recoverFiles(List[] files) {
        if (files == null || files.length != 2 || files[0] == null || files[1] == null || files[0].size() != files[1].size()) {
            throw new IllegalArgumentException("List array for files to recover is illegal:" + files);
        }
        ArrayList<FileDTO> failed = new ArrayList<FileDTO>();
        Iterator iterFileDTO = files[0].iterator();
        Iterator iterDS = files[1].iterator();
        String prevseriuid = null;
        while (iterFileDTO.hasNext()) {
            FileDTO fileDTO = (FileDTO)iterFileDTO.next();
            Dataset ds = (Dataset)iterDS.next();
            try {
                this.importFile(fileDTO, ds, prevseriuid, !iterFileDTO.hasNext());
                prevseriuid = ds.getString(0x20000E);
            }
            catch (Exception e) {
                failed.add(fileDTO);
                this.log.warn((Object)("Undelete failed for file " + fileDTO + " ds:"), (Throwable)e);
                this.log.warn((Object)ds);
            }
        }
        return failed;
    }

    public void deletePatient(long patPk) throws RemoteException, HomeFactoryException, CreateException, FinderException {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("delete Patient from trash. pk:" + patPk));
        }
        this.lookupPrivateManager().deletePrivatePatient(patPk);
    }

    public void deleteStudy(long studyPk) throws RemoteException, HomeFactoryException, CreateException, FinderException {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("delete Study from trash. pk:" + studyPk));
        }
        this.lookupPrivateManager().deletePrivateStudy(studyPk);
    }

    public void purgeStudy(String suid) throws RemoteException, HomeFactoryException, CreateException, FinderException {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("purge Study. Study IUID:" + suid));
        }
        Dataset ian = this.lookupPrivateManager().purgeStudy(suid);
        this.sendStudyMgt(ian.getString(0x20000D), 336, 0, ian);
        this.logStudyDeleted(ian);
    }

    public void deleteSeries(long seriesPk) throws RemoteException, HomeFactoryException, CreateException, FinderException {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("delete Series from trash. pk:" + seriesPk));
        }
        this.lookupPrivateManager().deletePrivateSeries(seriesPk);
    }

    public void deleteInstance(long pk) throws RemoteException, HomeFactoryException, CreateException, FinderException {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("delete Instance from trash. pk:" + pk));
        }
        this.lookupPrivateManager().deletePrivateInstance(pk);
    }

    public void emptyTrash() throws RemoteException, HomeFactoryException, CreateException, FinderException {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)"EMPTY TRASH! (delete all entries of 'private' tables of privateType:1)");
        }
        this.lookupPrivateManager().deleteAll(1);
    }

    public void moveStudies(long[] study_pks, Long patient_pk) throws FinderException, HomeFactoryException, CreateException, RemoteException {
        AuditEvent.ActionCode action;
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)"move Studies");
        }
        if (this.auditEnabled && this.logDeletedOnMoveEntities) {
            Dataset[] ds = this.lookupContentEdit().getStudyMgtDatasetForStudies(study_pks);
            for (int i = 0; i < ds.length; ++i) {
                this.logInstancesAccessed(ds[i], InstancesAccessedMessage.DELETE, true, "Affected Series (Move Studies):");
            }
            action = InstancesAccessedMessage.CREATE;
        } else {
            action = InstancesAccessedMessage.UPDATE;
        }
        Collection col = this.lookupContentEdit().moveStudies(study_pks, patient_pk);
        for (Dataset dsStdyMgt : col) {
            this.logInstancesAccessed(dsStdyMgt, action, true, "Affected Series (Move Studies):");
            this.sendStudyMgt(dsStdyMgt.getString(0x20000D), 288, 0, dsStdyMgt);
            this.sendSeriesUpdatedNotifications(dsStdyMgt, "Move studies");
        }
    }

    public void moveSeries(long[] series_pks, Long study_pk) throws RemoteException, HomeFactoryException, CreateException, FinderException {
        Dataset dsStdyMgt;
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)"move Series");
        }
        if (this.auditEnabled && this.logDeletedOnMoveEntities) {
            dsStdyMgt = this.lookupContentEdit().getStudyMgtDatasetForSeries(series_pks);
            this.logInstancesAccessed(dsStdyMgt, InstancesAccessedMessage.DELETE, true, "Affected Series (Move Series):");
        }
        dsStdyMgt = this.lookupContentEdit().moveSeries(series_pks, study_pk);
        this.logInstancesAccessed(dsStdyMgt, this.logDeletedOnMoveEntities ? InstancesAccessedMessage.CREATE : InstancesAccessedMessage.UPDATE, true, "Affected Series (Move Series):");
        this.sendStudyMgt(dsStdyMgt.getString(0x20000D), 288, 0, dsStdyMgt);
        this.sendSeriesUpdatedNotifications(dsStdyMgt, "Move series");
    }

    public void moveInstances(long[] instance_pks, Long series_pk) throws RemoteException, HomeFactoryException, CreateException, FinderException {
        Dataset dsStdyMgt;
        if (this.auditEnabled && this.logDeletedOnMoveEntities) {
            dsStdyMgt = this.lookupContentEdit().getStudyMgtDatasetForInstances(instance_pks);
            this.logInstancesAccessed(dsStdyMgt, InstancesAccessedMessage.DELETE, true, "Affected Series (Move Instances):");
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)"move Instances");
        }
        dsStdyMgt = this.lookupContentEdit().moveInstances(instance_pks, series_pk);
        this.logInstancesAccessed(dsStdyMgt, this.logDeletedOnMoveEntities ? InstancesAccessedMessage.CREATE : InstancesAccessedMessage.UPDATE, true, "Affected Series (Move Instances):");
        this.sendStudyMgt(dsStdyMgt.getString(0x20000D), 288, 0, dsStdyMgt);
        this.sendSeriesUpdatedNotifications(dsStdyMgt, "Move instances");
    }

    private ContentEdit lookupContentEdit() throws HomeFactoryException, RemoteException, CreateException {
        if (this.contentEdit != null) {
            return this.contentEdit;
        }
        ContentEditHome home = (ContentEditHome)EJBHomeFactory.getFactory().lookup(ContentEditHome.class, "ejb/ContentEdit");
        this.contentEdit = home.create();
        return this.contentEdit;
    }

    private ContentManager lookupContentManager() throws HomeFactoryException, RemoteException, CreateException {
        if (this.contentMgr != null) {
            return this.contentMgr;
        }
        ContentManagerHome home = (ContentManagerHome)EJBHomeFactory.getFactory().lookup(ContentManagerHome.class, "ejb/ContentManager");
        this.contentMgr = home.create();
        return this.contentMgr;
    }

    protected PrivateManager lookupPrivateManager() throws HomeFactoryException, RemoteException, CreateException {
        if (this.privateMgr != null) {
            return this.privateMgr;
        }
        PrivateManagerHome home = (PrivateManagerHome)EJBHomeFactory.getFactory().lookup(PrivateManagerHome.class, "ejb/PrivateManager");
        this.privateMgr = home.create();
        return this.privateMgr;
    }

    private void sendSeriesUpdatedNotifications(Dataset studyMgtDS, String description) {
        DcmElement sq = studyMgtDS.get(528661);
        int len = sq.countItems();
        for (int i = 0; i < len; ++i) {
            this.sendJMXNotification(new SeriesUpdated(sq.getItem(i).getString(0x20000E), description));
        }
    }

    protected void sendJMXNotification(Object o) {
        long eventID = super.getNextNotificationSequenceNumber();
        Notification notif = new Notification(o.getClass().getName(), (Object)this, eventID);
        notif.setUserData(o);
        super.sendNotification(notif);
    }

    private void importFile(FileDTO fileDTO, Dataset ds, String prevseriuid, boolean last) throws Exception {
        this.server.invoke(this.storeScpServiceName, "importFile", new Object[]{fileDTO, ds, prevseriuid, new Boolean(last)}, new String[]{FileDTO.class.getName(), Dataset.class.getName(), String.class.getName(), Boolean.TYPE.getName()});
    }

    protected void logPatientRecord(Dataset ds, AuditEvent.ActionCode actionCode) {
        if (!this.auditEnabled) {
            return;
        }
        HttpUserInfo userInfo = new HttpUserInfo(AuditMessage.isEnableDNSLookups());
        this.log.debug((Object)("log Patient Record! actionCode:" + actionCode));
        try {
            PatientRecordMessage msg = new PatientRecordMessage(actionCode);
            msg.addUserPerson(userInfo.getUserId(), null, null, userInfo.getHostName(), true);
            PersonName pn = ds.getPersonName(0x100010);
            String pname = pn != null ? pn.format() : null;
            msg.addPatient(ds.getString(0x100020), pname);
            msg.validate();
            Logger.getLogger((String)"auditlog").info((Object)msg);
        }
        catch (Exception x) {
            this.log.warn((Object)("Audit Log 'Patient Record' (actionCode:" + actionCode + ") failed:"), (Throwable)x);
        }
    }

    protected void logInstancesAccessed(Dataset ds, AuditEvent.ActionCode actionCode, boolean addIUID, String detailMessage) {
        ArrayList<Dataset> l = new ArrayList<Dataset>();
        l.add(ds);
        this.logInstancesAccessed(l, actionCode, addIUID, detailMessage);
    }

    protected void logInstancesAccessed(Collection<Dataset> studies, AuditEvent.ActionCode actionCode, boolean addIUID, String detailMessage) {
        if (!this.auditEnabled) {
            return;
        }
        HttpUserInfo userInfo = new HttpUserInfo(AuditMessage.isEnableDNSLookups());
        this.log.debug((Object)("log instances Accessed! actionCode:" + actionCode));
        try {
            InstancesAccessedMessage msg = new InstancesAccessedMessage(actionCode);
            msg.addUserPerson(userInfo.getUserId(), null, null, userInfo.getHostName(), true);
            Iterator<Dataset> iter = studies.iterator();
            Dataset studyMgtDs = iter.next();
            PersonName pn = studyMgtDs.getPersonName(0x100010);
            String pname = pn != null ? pn.format() : null;
            msg.addPatient(studyMgtDs.getString(0x100020), pname);
            while (studyMgtDs != null) {
                ParticipantObject study = msg.addStudy(studyMgtDs.getString(0x20000D), this.getStudyDescription(studyMgtDs, addIUID));
                if (detailMessage != null) {
                    study.addParticipantObjectDetail("Description", this.getStudySeriesDetail(detailMessage, studyMgtDs));
                }
                studyMgtDs = iter.hasNext() ? iter.next() : null;
            }
            msg.validate();
            Logger.getLogger((String)"auditlog").info((Object)msg);
        }
        catch (Exception x) {
            this.log.warn((Object)("Audit Log 'Instances Accessed' (actionCode:" + actionCode + ") failed:"), (Throwable)x);
        }
    }

    protected String getStudySeriesDetail(String detailMessage, Dataset studyMgtDs) {
        DcmElement refSeries = studyMgtDs.get(528661);
        StringBuffer sb = new StringBuffer();
        sb.append(detailMessage);
        int len = refSeries.countItems();
        if (len > 0) {
            sb.append(refSeries.getItem(0).getString(0x20000E));
            for (int i = 1; i < len; ++i) {
                sb.append(", ").append(refSeries.getItem(i).getString(0x20000E));
            }
        }
        return sb.toString();
    }

    protected void logStudyDeleted(Dataset studyMgtDs) {
        if (!this.auditEnabled) {
            return;
        }
        HttpUserInfo userInfo = new HttpUserInfo(AuditMessage.isEnableDNSLookups());
        try {
            StudyDeletedMessage msg = new StudyDeletedMessage();
            msg.addUserPerson(userInfo.getUserId(), null, null, userInfo.getHostName(), true);
            PersonName pn = studyMgtDs.getPersonName(0x100010);
            String pname = pn != null ? pn.format() : null;
            msg.addPatient(studyMgtDs.getString(0x100020), pname);
            msg.addStudy(studyMgtDs.getString(0x20000D), this.getStudyDescription(studyMgtDs, this.logIUIDsForStudyUpdate));
            msg.validate();
            Logger.getLogger((String)"auditlog").info((Object)msg);
        }
        catch (Exception x) {
            this.log.warn((Object)"Audit Log 'Study Deleted' failed:", (Throwable)x);
        }
    }

    protected ParticipantObjectDescription getStudyDescription(Dataset studyMgtDs, boolean addIUID) {
        ParticipantObjectDescription desc = new ParticipantObjectDescription();
        String accNr = studyMgtDs.getString(524368);
        if (accNr != null) {
            desc.addAccession(accNr);
        }
        this.addSOPClassInfo(desc, studyMgtDs, addIUID);
        return desc;
    }

    protected void addSOPClassInfo(ParticipantObjectDescription desc, Dataset studyMgtDs, boolean addIUID) {
        DcmElement refSeries = studyMgtDs.get(528661);
        if (refSeries == null) {
            return;
        }
        String suid = studyMgtDs.getString(0x20000D);
        InstanceSorter sorter = new InstanceSorter();
        int len = refSeries.countItems();
        for (int i = 0; i < len; ++i) {
            DcmElement refSopSeq = refSeries.getItem(i).get(528793);
            if (refSopSeq == null) continue;
            int jlen = refSopSeq.countItems();
            for (int j = 0; j < jlen; ++j) {
                Dataset ds = refSopSeq.getItem(j);
                sorter.addInstance(suid, ds.getString(528720), ds.getString(528725), null);
            }
        }
        for (String cuid : sorter.getCUIDs(suid)) {
            ParticipantObjectDescription.SOPClass sopClass = new ParticipantObjectDescription.SOPClass(cuid);
            sopClass.setNumberOfInstances(sorter.countInstances(suid, cuid));
            if (addIUID) {
                for (String iuid : sorter.getIUIDs(suid, cuid)) {
                    sopClass.addInstance(iuid);
                }
            }
            desc.addSOPClass(sopClass);
        }
    }
}

