/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4chex.archive.mbean;

import java.rmi.RemoteException;
import java.sql.Timestamp;
import java.util.Calendar;
import javax.ejb.FinderException;
import javax.management.Notification;
import javax.management.NotificationListener;
import javax.management.ObjectName;
import org.apache.log4j.Logger;
import org.dcm4chex.archive.common.Availability;
import org.dcm4chex.archive.config.RetryIntervalls;
import org.dcm4chex.archive.ejb.interfaces.ConsistencyCheck;
import org.dcm4chex.archive.ejb.interfaces.ConsistencyCheckHome;
import org.dcm4chex.archive.mbean.SchedulerDelegate;
import org.dcm4chex.archive.util.EJBHomeFactory;
import org.jboss.system.ServiceMBeanSupport;

public class ConsistenceCheckService
extends ServiceMBeanSupport {
    private final SchedulerDelegate scheduler = new SchedulerDelegate(this);
    private int availabilityOfExternalRetrieveable;
    private long taskInterval = 0L;
    private long minStudyAge;
    private long maxStudyAge;
    private long maxCheckedBefore;
    private int disabledStartHour;
    private int disabledEndHour;
    private int limitNumberOfStudiesPerTask;
    private Integer listenerID;
    private String timerIDCheckStudyConsistency;
    private static final Logger log = Logger.getLogger(ConsistenceCheckService.class);
    private final NotificationListener consistentCheckListener = new NotificationListener(){

        public void handleNotification(Notification notif, Object handback) {
            Calendar cal = Calendar.getInstance();
            int hour = cal.get(11);
            if (ConsistenceCheckService.this.isDisabled(hour)) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("ConsistentCheck ignored in time between " + ConsistenceCheckService.this.disabledStartHour + " and " + ConsistenceCheckService.this.disabledEndHour + " !"));
                }
            } else {
                try {
                    ConsistenceCheckService.this.check();
                }
                catch (Exception e) {
                    log.error((Object)"Consistant check failed!", (Throwable)e);
                }
            }
        }
    };

    public String getAvailabilityOfExternalRetrieveable() {
        return Availability.toString(this.availabilityOfExternalRetrieveable);
    }

    public void setAvailabilityOfExternalRetrieveable(String availability) {
        this.availabilityOfExternalRetrieveable = Availability.toInt(availability.trim());
    }

    public ObjectName getSchedulerServiceName() {
        return this.scheduler.getSchedulerServiceName();
    }

    public void setSchedulerServiceName(ObjectName schedulerServiceName) {
        this.scheduler.setSchedulerServiceName(schedulerServiceName);
    }

    public final String getTaskInterval() {
        String s = RetryIntervalls.formatIntervalZeroAsNever(this.taskInterval);
        return this.disabledEndHour == -1 ? s : s + "!" + this.disabledStartHour + "-" + this.disabledEndHour;
    }

    public void setTaskInterval(String interval) throws Exception {
        long oldInterval = this.taskInterval;
        int pos = interval.indexOf(33);
        if (pos == -1) {
            this.taskInterval = RetryIntervalls.parseIntervalOrNever(interval);
            this.disabledEndHour = -1;
        } else {
            this.taskInterval = RetryIntervalls.parseIntervalOrNever(interval.substring(0, pos));
            int pos1 = interval.indexOf(45, pos);
            this.disabledStartHour = Integer.parseInt(interval.substring(pos + 1, pos1));
            this.disabledEndHour = Integer.parseInt(interval.substring(pos1 + 1));
        }
        if (this.getState() == 3 && oldInterval != this.taskInterval) {
            this.scheduler.stopScheduler(this.timerIDCheckStudyConsistency, this.listenerID, this.consistentCheckListener);
            this.listenerID = this.scheduler.startScheduler(this.timerIDCheckStudyConsistency, this.taskInterval, this.consistentCheckListener);
        }
    }

    public int getLimitNumberOfStudiesPerTask() {
        return this.limitNumberOfStudiesPerTask;
    }

    public void setLimitNumberOfStudiesPerTask(int limit) {
        this.limitNumberOfStudiesPerTask = limit;
    }

    public String getMinStudyAge() {
        return RetryIntervalls.formatInterval(this.minStudyAge);
    }

    public void setMinStudyAge(String age) {
        this.minStudyAge = RetryIntervalls.parseInterval(age);
    }

    public String getMaxStudyAge() {
        return RetryIntervalls.formatInterval(this.maxStudyAge);
    }

    public void setMaxStudyAge(String age) {
        this.maxStudyAge = RetryIntervalls.parseInterval(age);
    }

    public String getMaxCheckedBefore() {
        return RetryIntervalls.formatInterval(this.maxCheckedBefore);
    }

    public void setMaxCheckedBefore(String maxCheckedBefore) {
        this.maxCheckedBefore = RetryIntervalls.parseInterval(maxCheckedBefore);
    }

    public String check() throws RemoteException, FinderException {
        int updated = 0;
        long l = System.currentTimeMillis();
        Timestamp createdBefore = new Timestamp(l - this.minStudyAge);
        Timestamp createdAfter = new Timestamp(l - this.maxStudyAge);
        Timestamp checkedBefore = new Timestamp(l - this.maxCheckedBefore);
        ConsistencyCheck checker = this.newConsistencyCheck();
        if (log.isDebugEnabled()) {
            log.debug((Object)("call findStudiesToCheck: createdAfter:" + createdAfter + " createdBefore:" + createdBefore + " checkedBefore:" + checkedBefore));
        }
        long[] studyPks = checker.findStudiesToCheck(createdAfter, createdBefore, checkedBefore, this.limitNumberOfStudiesPerTask);
        int len = studyPks.length;
        for (int i = 0; i < len; ++i) {
            if (!checker.updateStudy(studyPks[i], this.availabilityOfExternalRetrieveable)) continue;
            ++updated;
        }
        return updated + " of " + studyPks.length + " studies updated!";
    }

    private boolean isDisabled(int hour) {
        boolean inside;
        if (this.disabledEndHour == -1) {
            return false;
        }
        boolean sameday = this.disabledStartHour <= this.disabledEndHour;
        boolean bl = inside = hour >= this.disabledStartHour && hour < this.disabledEndHour;
        return sameday ? inside : !inside;
    }

    protected void startService() throws Exception {
        this.listenerID = this.scheduler.startScheduler(this.timerIDCheckStudyConsistency, this.taskInterval, this.consistentCheckListener);
    }

    protected void stopService() throws Exception {
        this.scheduler.stopScheduler(this.timerIDCheckStudyConsistency, this.listenerID, this.consistentCheckListener);
        super.stopService();
    }

    private ConsistencyCheck newConsistencyCheck() {
        try {
            ConsistencyCheckHome home = (ConsistencyCheckHome)EJBHomeFactory.getFactory().lookup(ConsistencyCheckHome.class, "ejb/ConsistencyCheck");
            return home.create();
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to access ConsistencyCheck EJB:", e);
        }
    }

    public String getTimerIDCheckStudyConsistency() {
        return this.timerIDCheckStudyConsistency;
    }

    public void setTimerIDCheckStudyConsistency(String timerIDCheckStudyConsistency) {
        this.timerIDCheckStudyConsistency = timerIDCheckStudyConsistency;
    }
}

