/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4chex.archive.mbean;

import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import javax.ejb.FinderException;
import javax.management.Notification;
import javax.management.NotificationListener;
import javax.management.ObjectName;
import org.dcm4che.dict.UIDs;
import org.dcm4cheri.util.StringUtils;
import org.dcm4chex.archive.codec.CodecCmd;
import org.dcm4chex.archive.codec.CompressCmd;
import org.dcm4chex.archive.codec.CompressionFailedException;
import org.dcm4chex.archive.codec.DecompressCmd;
import org.dcm4chex.archive.config.RetryIntervalls;
import org.dcm4chex.archive.ejb.interfaces.FileDTO;
import org.dcm4chex.archive.ejb.interfaces.FileSystemDTO;
import org.dcm4chex.archive.ejb.interfaces.FileSystemMgt2;
import org.dcm4chex.archive.ejb.interfaces.FileSystemMgt2Home;
import org.dcm4chex.archive.ejb.jdbc.ClaimCompressingFileCmd;
import org.dcm4chex.archive.mbean.SchedulerDelegate;
import org.dcm4chex.archive.util.EJBHomeFactory;
import org.dcm4chex.archive.util.FileUtils;
import org.jboss.system.ServiceMBeanSupport;

public class CompressionService
extends ServiceMBeanSupport {
    private static final String _DCM = ".dcm";
    private final SchedulerDelegate scheduler = new SchedulerDelegate(this);
    private long taskInterval = 0L;
    private int disabledStartHour;
    private int disabledEndHour;
    private String[] fileSystemGroupIDs;
    private int limitNumberOfFilesPerTask;
    private boolean verifyCompression;
    private Integer listenerID;
    private File tmpDir = new File("tmp");
    private long keepTempFileIfVerificationFails = 0L;
    private List compressionRuleList = new ArrayList();
    private int bufferSize = 8192;
    private String timerIDCheckFilesToCompress;
    private boolean isRunning;
    private static final String[] CODEC_NAMES = new String[]{"JPLL", "JLSL", "J2KR"};
    private static final String[] COMPRESS_TRANSFER_SYNTAX = new String[]{"1.2.840.10008.1.2.4.70", "1.2.840.10008.1.2.4.80", "1.2.840.10008.1.2.4.90"};
    private final NotificationListener delayedCompressionListener = new NotificationListener(){

        public void handleNotification(Notification notif, Object handback) {
            CompressionService.this.checkForTempFilesToDelete();
            Calendar cal = Calendar.getInstance();
            int hour = cal.get(11);
            if (CompressionService.this.isDisabled(hour)) {
                if (CompressionService.this.log.isDebugEnabled()) {
                    CompressionService.this.log.debug((Object)("trigger ignored in time between " + CompressionService.this.disabledStartHour + " and " + CompressionService.this.disabledEndHour + " !"));
                }
            } else {
                new Thread(new Runnable(){

                    public void run() {
                        try {
                            CompressionService.this.checkForFilesToCompress();
                        }
                        catch (Exception e) {
                            CompressionService.this.log.error((Object)"Delayed compression failed!", (Throwable)e);
                        }
                    }
                }).start();
            }
        }
    };

    public String getFileSystemGroupIDs() {
        return StringUtils.toString(this.fileSystemGroupIDs, ',');
    }

    public void setFileSystemGroupIDs(String fileSystemGroupIDs) {
        StringTokenizer st = new StringTokenizer(fileSystemGroupIDs, ",;\n\r\t ");
        this.fileSystemGroupIDs = new String[st.countTokens()];
        for (int i = 0; i < this.fileSystemGroupIDs.length; ++i) {
            this.fileSystemGroupIDs[i] = st.nextToken();
        }
    }

    public final int getBufferSize() {
        return this.bufferSize;
    }

    public final void setBufferSize(int bufferSize) {
        this.bufferSize = bufferSize;
    }

    public ObjectName getSchedulerServiceName() {
        return this.scheduler.getSchedulerServiceName();
    }

    public void setSchedulerServiceName(ObjectName schedulerServiceName) {
        this.scheduler.setSchedulerServiceName(schedulerServiceName);
    }

    public final String getKeepTempFileIfVerificationFails() {
        return RetryIntervalls.formatInterval(this.keepTempFileIfVerificationFails);
    }

    public final void setKeepTempFileIfVerificationFails(String interval) {
        this.keepTempFileIfVerificationFails = RetryIntervalls.parseInterval(interval);
    }

    public final String getTaskInterval() {
        String s = RetryIntervalls.formatIntervalZeroAsNever(this.taskInterval);
        return this.disabledEndHour == -1 ? s : s + "!" + this.disabledStartHour + "-" + this.disabledEndHour;
    }

    public void setTaskInterval(String interval) throws Exception {
        long oldInterval = this.taskInterval;
        int pos = interval.indexOf(33);
        if (pos == -1) {
            this.taskInterval = RetryIntervalls.parseIntervalOrNever(interval);
            this.disabledEndHour = -1;
        } else {
            this.taskInterval = RetryIntervalls.parseIntervalOrNever(interval.substring(0, pos));
            int pos1 = interval.indexOf(45, pos);
            this.disabledStartHour = Integer.parseInt(interval.substring(pos + 1, pos1));
            this.disabledEndHour = Integer.parseInt(interval.substring(pos1 + 1));
        }
        if (this.getState() == 3 && oldInterval != this.taskInterval) {
            this.scheduler.stopScheduler(this.timerIDCheckFilesToCompress, this.listenerID, this.delayedCompressionListener);
            this.listenerID = this.scheduler.startScheduler(this.timerIDCheckFilesToCompress, this.taskInterval, this.delayedCompressionListener);
        }
    }

    public boolean isRunning() {
        return this.isRunning;
    }

    public final void setCompressionRules(String rules) {
        this.compressionRuleList.clear();
        if (rules == null || rules.trim().length() < 1) {
            return;
        }
        StringTokenizer st = new StringTokenizer(rules, ",;\n\r\t ");
        while (st.hasMoreTokens()) {
            this.compressionRuleList.add(new CompressionRule(st.nextToken()));
        }
    }

    public final String getCompressionRules() {
        StringBuffer sb = new StringBuffer();
        Iterator iter = this.compressionRuleList.iterator();
        while (iter.hasNext()) {
            sb.append((CompressionRule)iter.next()).append("\r\n");
        }
        return sb.toString();
    }

    public int getLimitNumberOfFilesPerTask() {
        return this.limitNumberOfFilesPerTask;
    }

    public void setLimitNumberOfFilesPerTask(int limit) {
        this.limitNumberOfFilesPerTask = limit;
    }

    public boolean isVerifyCompression() {
        return this.verifyCompression;
    }

    public void setVerifyCompression(boolean checkCompression) {
        this.verifyCompression = checkCompression;
    }

    public final int getMaxConcurrentCodec() {
        return CodecCmd.getMaxConcurrentCodec();
    }

    public final void setMaxConcurrentCodec(int maxConcurrentCodec) {
        CodecCmd.setMaxConcurrentCodec(maxConcurrentCodec);
    }

    public final int getMaxConcurrentCompression() {
        return CompressCmd.getMaxConcurrentCompression();
    }

    public final void setMaxConcurrentCompression(int maxConcurrent) {
        CompressCmd.setMaxConcurrentCompression(maxConcurrent);
    }

    public final int getMaxConcurrentDecompression() {
        return DecompressCmd.getMaxConcurrentDecompression();
    }

    public final void setMaxConcurrentDecompression(int maxConcurrent) {
        DecompressCmd.setMaxConcurrentDecompression(maxConcurrent);
    }

    public final int getMaxBufferedImagePoolSize() {
        return CodecCmd.getMaxBufferedImagePoolSize();
    }

    public final void setMaxBufferedImagePoolSize(int maxSize) {
        CodecCmd.setMaxBufferedImagePoolSize(maxSize);
    }

    public final int getCurrentBufferedImagePoolSize() {
        return CodecCmd.getCurrentBufferedImagePoolSize();
    }

    public final String getMaxBufferedImagePoolMemory() {
        return FileUtils.formatSize(CodecCmd.getMaxBufferedImagePoolMemory());
    }

    public final void setMaxBufferedImagePoolMemory(String maxMemory) {
        CodecCmd.setMaxBufferedImagePoolMemory(FileUtils.parseSize(maxMemory, 0L));
    }

    public final String getCurrentBufferedImagePoolMemory() {
        return FileUtils.formatSize(CodecCmd.getCurrentBufferedImagePoolMemory());
    }

    public final float getBufferedImagePoolHitRate() {
        return CodecCmd.getBufferedImagePoolHitRate();
    }

    public final void resetBufferedImagePoolHitRate() {
        CodecCmd.resetBufferedImagePoolHitRate();
    }

    public final void setTempDir(String dirPath) {
        this.tmpDir = new File(dirPath);
    }

    public final String getTempDir() {
        return this.tmpDir.toString();
    }

    public void checkForTempFilesToDelete() {
        if (this.keepTempFileIfVerificationFails <= 0L) {
            return;
        }
        File absTmpDir = FileUtils.resolve(this.tmpDir);
        if (!absTmpDir.isDirectory()) {
            return;
        }
        final long before = System.currentTimeMillis() - this.keepTempFileIfVerificationFails;
        File[] files = absTmpDir.listFiles(new FileFilter(){

            public boolean accept(File f) {
                return f.getName().endsWith(CompressionService._DCM) && f.lastModified() < before;
            }
        });
        for (int i = 0; i < files.length; ++i) {
            FileUtils.delete(files[i], false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void checkForFilesToCompress() throws FinderException, IOException {
        CompressionService compressionService = this;
        synchronized (compressionService) {
            if (this.isRunning) {
                this.log.info((Object)"checkForFilesToCompress is already running!");
                return;
            }
            this.isRunning = true;
        }
        try {
            try {
                this.log.info((Object)"Check For Files To Compress on attached filesystems!");
                int limit = this.limitNumberOfFilesPerTask;
                byte[] buffer = null;
                FileSystemMgt2 fsMgt = this.newFileSystemMgt();
                for (int g = 0; g < this.fileSystemGroupIDs.length; ++g) {
                    FileSystemDTO[] fsDTOs = fsMgt.getRWFileSystemsOfGroup(this.fileSystemGroupIDs[g]);
                    int len = this.compressionRuleList.size();
                    for (int i = 0; i < len && limit > 0; ++i) {
                        CompressionRule info = (CompressionRule)this.compressionRuleList.get(i);
                        String cuid = info.getCUID();
                        Timestamp before = new Timestamp(System.currentTimeMillis() - info.getDelay());
                        for (int j = 0; j < fsDTOs.length; ++j) {
                            FileDTO[] files = fsMgt.findFilesToCompress(fsDTOs[j], cuid, before, limit);
                            if (files.length <= 0) continue;
                            if (buffer == null) {
                                buffer = new byte[this.bufferSize];
                            }
                            this.log.debug((Object)("Compress " + files.length + " files on filesystem " + fsDTOs[j] + " triggered by " + info));
                            for (int k = 0; k < files.length; ++k) {
                                try {
                                    this.doCompress(fsMgt, files[k], info, buffer);
                                    continue;
                                }
                                catch (CompressionFailedException e) {
                                    // empty catch block
                                }
                            }
                            limit -= files.length;
                        }
                    }
                }
                Object var16_17 = null;
                this.isRunning = false;
            }
            catch (ExceptionInInitializerError e) {
                this.log.error((Object)"Error initializing compression libraries!", (Throwable)e);
                throw e;
            }
        }
        catch (Throwable throwable) {
            Object var16_18 = null;
            this.isRunning = false;
            throw throwable;
        }
    }

    public boolean compress(FileDTO fileDTO) throws IOException, CompressionFailedException {
        if (!this.isUncompressed(fileDTO.getFileTsuid())) {
            this.log.debug((Object)("The image is already compressed, file = " + fileDTO.getFilePath()));
            return false;
        }
        CompressionRule rule = this.getCompressionRule(fileDTO.getSopClassUID());
        if (rule == null) {
            this.log.debug((Object)("There is no compression rule for this image SOP Class: " + fileDTO.getSopClassUID()));
            return false;
        }
        return this.doCompress(this.newFileSystemMgt(), fileDTO, rule, new byte[this.bufferSize]);
    }

    private CompressionRule getCompressionRule(String cuid) {
        for (CompressionRule rule : this.compressionRuleList) {
            if (!cuid.equals(rule.getCUID())) continue;
            return rule;
        }
        return null;
    }

    private boolean isUncompressed(String tsuid) {
        return tsuid.equals("1.2.840.10008.1.2.1") || tsuid.equals("1.2.840.10008.1.2.2") || tsuid.equals("1.2.840.10008.1.2");
    }

    private boolean doCompress(FileSystemMgt2 fsMgt, FileDTO fileDTO, CompressionRule info, byte[] buffer) throws CompressionFailedException {
        File baseDir = FileUtils.toFile(fileDTO.getDirectoryPath());
        File srcFile = FileUtils.toFile(fileDTO.getDirectoryPath(), fileDTO.getFilePath());
        File destFile = null;
        try {
            FileUtils.verifyMD5(srcFile, fileDTO.getMd5String());
            if (!ClaimCompressingFileCmd.claim((long)fileDTO.getPk())) {
                this.log.info((Object)("File " + srcFile + " already compressed by concurrent thread!"));
                return false;
            }
            destFile = FileUtils.createNewFile(srcFile.getParentFile(), (int)Long.parseLong(srcFile.getName(), 16) + 1);
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Compress file " + srcFile + " to " + destFile + " with CODEC:" + info.getCodec() + "(" + info.getTransferSyntax() + ")"));
            }
            int[] planarConfiguration = new int[1];
            int[] pxvalVR = new int[1];
            byte[] md5 = CompressCmd.compressFile(srcFile, destFile, info.getTransferSyntax(), planarConfiguration, pxvalVR, buffer);
            if (this.verifyCompression && fileDTO.getFileMd5() != null) {
                File decFile;
                byte[] dec_md5;
                File absTmpDir = FileUtils.resolve(this.tmpDir);
                if (absTmpDir.mkdirs()) {
                    this.log.info((Object)"Create directory for decompressed files");
                }
                if (!Arrays.equals(dec_md5 = DecompressCmd.decompressFile(destFile, decFile = new File(absTmpDir, fileDTO.getFilePath().replace('/', '-') + _DCM), fileDTO.getFileTsuid(), planarConfiguration[0], pxvalVR[0], buffer), fileDTO.getFileMd5())) {
                    this.log.info((Object)("MD5 sum after compression+decompression of " + srcFile + " differs - compare pixel matrix"));
                    if (!FileUtils.equalsPixelData(srcFile, decFile)) {
                        String errmsg = "Pixel matrix after decompression differs from original file " + srcFile + "! Keep original uncompressed file.";
                        this.log.warn((Object)errmsg);
                        FileUtils.delete(destFile, false);
                        fsMgt.setFileStatus(fileDTO.getPk(), -2);
                        if (this.keepTempFileIfVerificationFails <= 0L) {
                            FileUtils.delete(decFile, false);
                        }
                        throw new CompressionFailedException(errmsg);
                    }
                }
                FileUtils.delete(decFile, false);
            }
            int baseDirPathLength = baseDir.getPath().length();
            String destFilePath = destFile.getPath().substring(baseDirPathLength + 1).replace(File.separatorChar, '/');
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("replace File " + srcFile + " with " + destFile));
            }
            fsMgt.replaceFile(fileDTO.getPk(), destFilePath, info.getTransferSyntax(), destFile.length(), md5, 0);
            fileDTO.setPk(0L);
            fileDTO.setFilePath(destFilePath);
            fileDTO.setFileSize((int)destFile.length());
            fileDTO.setFileMd5(md5);
            fileDTO.setFileTsuid(info.getTransferSyntax());
            FileUtils.delete(srcFile, false);
            return true;
        }
        catch (CompressionFailedException e) {
            throw e;
        }
        catch (Exception e) {
            String errmsg = "Can't compress file:" + srcFile;
            this.log.error((Object)errmsg, (Throwable)e);
            if (destFile != null && destFile.exists()) {
                FileUtils.delete(destFile, false);
            }
            try {
                fsMgt.setFileStatus(fileDTO.getPk(), -1);
            }
            catch (Exception x1) {
                this.log.error((Object)("Failed to set FAILED_TO_COMPRESS for file " + srcFile));
            }
            throw new CompressionFailedException(errmsg, e);
        }
    }

    private boolean isDisabled(int hour) {
        boolean inside;
        if (this.disabledEndHour == -1) {
            return false;
        }
        boolean sameday = this.disabledStartHour <= this.disabledEndHour;
        boolean bl = inside = hour >= this.disabledStartHour && hour < this.disabledEndHour;
        return sameday ? inside : !inside;
    }

    protected void startService() throws Exception {
        this.listenerID = this.scheduler.startScheduler(this.timerIDCheckFilesToCompress, this.taskInterval, this.delayedCompressionListener);
    }

    protected void stopService() throws Exception {
        this.scheduler.stopScheduler(this.timerIDCheckFilesToCompress, this.listenerID, this.delayedCompressionListener);
        super.stopService();
    }

    private FileSystemMgt2 newFileSystemMgt() {
        try {
            FileSystemMgt2Home home = (FileSystemMgt2Home)EJBHomeFactory.getFactory().lookup(FileSystemMgt2Home.class, "ejb/FileSystemMgt2");
            return home.create();
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to access File System Mgt EJB:", e);
        }
    }

    public String getTimerIDCheckFilesToCompress() {
        return this.timerIDCheckFilesToCompress;
    }

    public void setTimerIDCheckFilesToCompress(String timerIDCheckFilesToCompress) {
        this.timerIDCheckFilesToCompress = timerIDCheckFilesToCompress;
    }

    public class CompressionRule {
        String cuid;
        int codec;
        long delay;

        public CompressionRule(String s) {
            String[] a = StringUtils.split(s, ':');
            if (a.length != 3) {
                throw new IllegalArgumentException("Wrong format - " + s);
            }
            this.cuid = a[0];
            this.getCUID();
            this.codec = Arrays.asList(CODEC_NAMES).indexOf(a[1]);
            if (this.codec == -1) {
                throw new IllegalArgumentException("Unrecognized codec - " + a[1]);
            }
            this.delay = RetryIntervalls.parseInterval(a[2]);
        }

        public String getCodec() {
            return CODEC_NAMES[this.codec];
        }

        public String getCUID() {
            return Character.isDigit(this.cuid.charAt(0)) ? this.cuid : UIDs.forName(this.cuid);
        }

        public long getDelay() {
            return this.delay;
        }

        public String getTransferSyntax() {
            return COMPRESS_TRANSFER_SYNTAX[this.codec];
        }

        public String toString() {
            return this.cuid + ":" + this.getCodec() + ':' + RetryIntervalls.formatInterval(this.delay);
        }
    }
}

