/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4chex.archive.mbean;

import java.io.File;
import java.io.IOException;
import java.util.Calendar;
import java.util.Collection;
import java.util.Iterator;
import javax.management.Notification;
import javax.management.NotificationListener;
import javax.management.ObjectName;
import org.dcm4che.data.Dataset;
import org.dcm4chex.archive.common.Availability;
import org.dcm4chex.archive.common.DeleteStudyOrder;
import org.dcm4chex.archive.common.DeleteStudyOrdersAndMaxAccessTime;
import org.dcm4chex.archive.config.DeleterThresholds;
import org.dcm4chex.archive.config.RetryIntervalls;
import org.dcm4chex.archive.dcm.findscu.FindScuDelegate;
import org.dcm4chex.archive.ejb.interfaces.FileSystemDTO;
import org.dcm4chex.archive.ejb.interfaces.FileSystemMgt2;
import org.dcm4chex.archive.ejb.interfaces.FileSystemMgt2Home;
import org.dcm4chex.archive.mbean.SchedulerDelegate;
import org.dcm4chex.archive.util.EJBHomeFactory;
import org.dcm4chex.archive.util.FileSystemUtils;
import org.dcm4chex.archive.util.FileUtils;
import org.jboss.system.ServiceMBeanSupport;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractDeleterService
extends ServiceMBeanSupport {
    public static final long MIN_FREE_DISK_SPACE = 20000000L;
    protected static final String NONE = "NONE";
    protected static final String AUTO = "AUTO";
    private final FindScuDelegate findScu = new FindScuDelegate(this);
    protected final SchedulerDelegate scheduler = new SchedulerDelegate(this);
    private String timerIDScheduleStudiesForDeletion;
    private long scheduleStudiesForDeletionInterval;
    private boolean isRunningScheduleStudiesForDeletion;
    private DeleterThresholds deleterThresholds;
    private long maxNotAccessedFor = 0L;
    private long minNotAccessedFor = 0L;
    private boolean externalRetrievable;
    private String instanceAvailabilityOfExternalRetrievable;
    private boolean storageNotCommited;
    private boolean copyOnMedia;
    private String copyOnFSGroup;
    private boolean copyArchived;
    private boolean copyOnReadOnlyFS;
    private int scheduleStudiesForDeletionBatchSize;
    private Integer scheduleStudiesForDeletionListenerID;
    private final NotificationListener scheduleStudiesForDeletionListener = new NotificationListener(){

        public void handleNotification(Notification notif, Object handback) {
            AbstractDeleterService.this.startScheduleStudiesForDeletion();
        }
    };

    public ObjectName getFindScuServiceName() {
        return this.findScu.getFindScuServiceName();
    }

    public void setFindScuServiceName(ObjectName findScuServiceName) {
        this.findScu.setFindScuServiceName(findScuServiceName);
    }

    public ObjectName getSchedulerServiceName() {
        return this.scheduler.getSchedulerServiceName();
    }

    public void setSchedulerServiceName(ObjectName schedulerServiceName) {
        this.scheduler.setSchedulerServiceName(schedulerServiceName);
    }

    public void setTimerIDScheduleStudiesForDeletion(String timerID) {
        this.timerIDScheduleStudiesForDeletion = timerID;
    }

    public String getTimerIDScheduleStudiesForDeletion() {
        return this.timerIDScheduleStudiesForDeletion;
    }

    public String getScheduleStudiesForDeletionInterval() {
        return RetryIntervalls.formatIntervalZeroAsNever(this.scheduleStudiesForDeletionInterval);
    }

    public void setScheduleStudiesForDeletionInterval(String interval) throws Exception {
        this.scheduleStudiesForDeletionInterval = RetryIntervalls.parseIntervalOrNever(interval);
        if (this.getState() == 3) {
            this.scheduler.stopScheduler(this.timerIDScheduleStudiesForDeletion, this.scheduleStudiesForDeletionListenerID, this.scheduleStudiesForDeletionListener);
            this.scheduleStudiesForDeletionListenerID = this.scheduler.startScheduler(this.timerIDScheduleStudiesForDeletion, this.scheduleStudiesForDeletionInterval, this.scheduleStudiesForDeletionListener);
        }
    }

    public boolean isRunningScheduleStudiesForDeletion() {
        return this.isRunningScheduleStudiesForDeletion;
    }

    protected void startService() throws Exception {
        this.scheduleStudiesForDeletionListenerID = this.scheduler.startScheduler(this.timerIDScheduleStudiesForDeletion, this.scheduleStudiesForDeletionInterval, this.scheduleStudiesForDeletionListener);
    }

    protected void stopService() throws Exception {
        this.scheduler.stopScheduler(this.timerIDScheduleStudiesForDeletion, this.scheduleStudiesForDeletionListenerID, this.scheduleStudiesForDeletionListener);
    }

    protected void startScheduleStudiesForDeletion() {
        new Thread(new Runnable(){

            public void run() {
                try {
                    AbstractDeleterService.this.scheduleStudiesForDeletion();
                }
                catch (Exception e) {
                    AbstractDeleterService.this.log.error((Object)"Schedule Studies for deletion failed:", (Throwable)e);
                }
            }
        }).start();
    }

    protected abstract String getFileSystemGroupIDForDeleter();

    public abstract long getMinFreeDiskSpaceBytes();

    public long getFreeDiskSpace() throws Exception {
        if (this.getMinFreeDiskSpaceBytes() == 0L) {
            return -1L;
        }
        FileSystemDTO[] fsDTOs = AbstractDeleterService.fileSystemMgt().getFileSystemsOfGroup(this.getFileSystemGroupIDForDeleter());
        long free = 0L;
        for (FileSystemDTO fsDTO : fsDTOs) {
            File dir;
            int status = fsDTO.getStatus();
            if (status != 1 && status != 0 || !(dir = FileUtils.toFile(fsDTO.getDirectoryPath())).isDirectory()) continue;
            free += FileSystemUtils.freeSpace(dir.getPath());
        }
        return free;
    }

    public String getFreeDiskSpaceString() throws Exception {
        return FileUtils.formatSize(this.getFreeDiskSpace());
    }

    public long getUsableDiskSpace() throws Exception {
        long minFree = this.getMinFreeDiskSpaceBytes();
        if (minFree == 0L) {
            return -1L;
        }
        return this.calcUsableDiskSpace(minFree);
    }

    public long calcUsableDiskSpace(long minFree) throws Exception {
        return this.calcUsableDiskSpace(AbstractDeleterService.fileSystemMgt().getFileSystemsOfGroup(this.getFileSystemGroupIDForDeleter()), minFree);
    }

    private long calcUsableDiskSpace(FileSystemDTO[] fsDTOs, long minFree) throws IOException {
        long free = 0L;
        for (FileSystemDTO fsDTO : fsDTOs) {
            File dir;
            int status = fsDTO.getStatus();
            if (status != 1 && status != 0 || !(dir = FileUtils.toFile(fsDTO.getDirectoryPath())).isDirectory()) continue;
            free += Math.max(0L, FileSystemUtils.freeSpace(dir.getPath()) - minFree);
        }
        return free;
    }

    public String getUsableDiskSpaceString() throws Exception {
        return FileUtils.formatSize(this.getUsableDiskSpace());
    }

    public final String getDeleterThresholds() {
        return this.deleterThresholds == null ? NONE : this.deleterThresholds.toString();
    }

    public final void setDeleterThresholds(String s) {
        this.deleterThresholds = s.equalsIgnoreCase(NONE) ? null : new DeleterThresholds(s, true);
    }

    public abstract long getExpectedDataVolumePerDayBytes() throws Exception;

    public long getCurrentDeleterThreshold() throws Exception {
        if (this.deleterThresholds == null) {
            return -1L;
        }
        FileSystemMgt2 fsMgt = AbstractDeleterService.fileSystemMgt();
        return this.getCurrentDeleterThreshold(fsMgt, fsMgt.getFileSystemsOfGroup(this.getFileSystemGroupIDForDeleter()));
    }

    private long getCurrentDeleterThreshold(FileSystemMgt2 fsMgt, FileSystemDTO[] fsDTOs) throws Exception {
        long exp = this.getExpectedDataVolumePerDayBytes();
        return exp == -1L ? -1L : this.deleterThresholds.getDeleterThreshold(Calendar.getInstance()).getFreeSize(exp);
    }

    public String getDeleteStudyIfNotAccessedFor() {
        return RetryIntervalls.formatIntervalZeroAsNever(this.maxNotAccessedFor);
    }

    public void setDeleteStudyIfNotAccessedFor(String interval) {
        this.maxNotAccessedFor = RetryIntervalls.parseIntervalOrNever(interval);
    }

    public String getDeleteStudyOnlyIfNotAccessedFor() {
        return RetryIntervalls.formatInterval(this.minNotAccessedFor);
    }

    public void setDeleteStudyOnlyIfNotAccessedFor(String interval) {
        this.minNotAccessedFor = RetryIntervalls.parseInterval(interval);
    }

    public boolean isDeleteStudyOnlyIfStorageNotCommited() {
        return this.storageNotCommited;
    }

    public void setDeleteStudyOnlyIfStorageNotCommited(boolean storageNotCommited) {
        this.storageNotCommited = storageNotCommited;
    }

    public boolean isDeleteStudyOnlyIfCopyOnMedia() {
        return this.copyOnMedia;
    }

    public boolean isDeleteStudyOnlyIfCopyExternalRetrievable() {
        return this.externalRetrievable;
    }

    public void setDeleteStudyOnlyIfCopyExternalRetrievable(boolean externalRetrievable) {
        this.externalRetrievable = externalRetrievable;
    }

    public final String getInstanceAvailabilityOfExternalRetrievable() {
        return this.instanceAvailabilityOfExternalRetrievable != null ? this.instanceAvailabilityOfExternalRetrievable : AUTO;
    }

    public final void setInstanceAvailabilityOfExternalRetrievable(String availability) {
        String trimmed = availability.trim();
        this.instanceAvailabilityOfExternalRetrievable = trimmed.equalsIgnoreCase(AUTO) ? null : Availability.toString(Availability.toInt(trimmed));
    }

    public void setDeleteStudyOnlyIfCopyOnMedia(boolean copyOnMedia) {
        this.copyOnMedia = copyOnMedia;
    }

    public String getDeleteStudyOnlyIfCopyOnFileSystemOfFileSystemGroup() {
        return this.copyOnFSGroup != null ? this.copyOnFSGroup : NONE;
    }

    public void setDeleteStudyOnlyIfCopyOnFileSystemOfFileSystemGroup(String copyOnFSGroup) {
        String trimmed = copyOnFSGroup.trim();
        if (this.serviceName != null && trimmed.equals(this.getFileSystemGroupIDForDeleter())) {
            throw new IllegalArgumentException("Must differ from file system group managed by this service");
        }
        this.copyOnFSGroup = trimmed.equalsIgnoreCase(NONE) ? null : trimmed;
    }

    public boolean isDeleteStudyOnlyIfCopyArchived() {
        return this.copyArchived;
    }

    public void setDeleteStudyOnlyIfCopyArchived(boolean copyArchived) {
        this.copyArchived = copyArchived;
    }

    public boolean isDeleteStudyOnlyIfCopyOnReadOnlyFileSystem() {
        return this.copyOnReadOnlyFS;
    }

    public void setDeleteStudyOnlyIfCopyOnReadOnlyFileSystem(boolean copyOnReadOnlyFS) {
        this.copyOnReadOnlyFS = copyOnReadOnlyFS;
    }

    public void setScheduleStudiesForDeletionBatchSize(int batchSize) {
        if (batchSize <= 0) {
            throw new IllegalArgumentException("batchSize: " + batchSize);
        }
        this.scheduleStudiesForDeletionBatchSize = batchSize;
    }

    public int getScheduleStudiesForDeletionBatchSize() {
        return this.scheduleStudiesForDeletionBatchSize;
    }

    protected static FileSystemMgt2 fileSystemMgt() throws Exception {
        FileSystemMgt2Home home = (FileSystemMgt2Home)EJBHomeFactory.getFactory().lookup(FileSystemMgt2Home.class, "ejb/FileSystemMgt2");
        return home.create();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int scheduleStudiesForDeletion() throws Exception {
        long usable;
        long threshold;
        long sizeToDel;
        FileSystemDTO[] fsDTOs;
        FileSystemMgt2 fsMgt;
        String fsGroup;
        block11: {
            if (this.maxNotAccessedFor == 0L && this.deleterThresholds == null) {
                return 0;
            }
            AbstractDeleterService abstractDeleterService = this;
            synchronized (abstractDeleterService) {
                if (this.isRunningScheduleStudiesForDeletion) {
                    this.log.info((Object)"ScheduleStudiesForDeletion is already running!");
                    return -1;
                }
                this.isRunningScheduleStudiesForDeletion = true;
            }
            fsGroup = this.getFileSystemGroupIDForDeleter();
            try {
                fsMgt = AbstractDeleterService.fileSystemMgt();
                fsDTOs = fsMgt.getFileSystemsOfGroup(fsGroup);
                if (fsDTOs.length != 0) break block11;
                this.log.info((Object)("No Filesystem configured in file system group " + fsGroup + "! Ignore check for deletion of studies!"));
                int n = 0;
                Object var12_7 = null;
                this.isRunningScheduleStudiesForDeletion = false;
                return n;
            }
            catch (Throwable throwable) {
                Object var12_9 = null;
                this.isRunningScheduleStudiesForDeletion = false;
                throw throwable;
            }
        }
        this.log.info((Object)("Check file system group " + fsGroup + " for deletion of studies"));
        int countStudies = 0;
        if (this.maxNotAccessedFor > 0L) {
            countStudies = this.scheduleStudiesForDeletion(fsMgt, System.currentTimeMillis() - this.maxNotAccessedFor, Long.MAX_VALUE);
        }
        if (this.deleterThresholds != null && (sizeToDel = (threshold = this.getCurrentDeleterThreshold(fsMgt, fsDTOs)) - (usable = this.calcUsableDiskSpace(fsDTOs, this.getMinFreeDiskSpaceBytes()))) > 0L) {
            this.log.info((Object)("Try to free " + sizeToDel + " of disk space on file system group " + fsGroup));
            countStudies += this.scheduleStudiesForDeletion(fsMgt, System.currentTimeMillis() - this.minNotAccessedFor, sizeToDel);
        }
        if (countStudies > 0) {
            this.log.info((Object)("Scheduled " + countStudies + " studies for deletion on file system group " + fsGroup));
        }
        int n = countStudies;
        Object var12_8 = null;
        this.isRunningScheduleStudiesForDeletion = false;
        return n;
    }

    private int scheduleStudiesForDeletion(FileSystemMgt2 fsMgt, long notAccessedAfter, long sizeToDel0) throws Exception {
        int countStudies = 0;
        long minAccessTime = 0L;
        long sizeToDel = sizeToDel0;
        do {
            DeleteStudyOrdersAndMaxAccessTime deleteOrdersAndAccessTime;
            if ((deleteOrdersAndAccessTime = fsMgt.createDeleteOrdersForStudiesOnFSGroup(this.getFileSystemGroupIDForDeleter(), minAccessTime, notAccessedAfter, this.scheduleStudiesForDeletionBatchSize, this.externalRetrievable, this.storageNotCommited, this.copyOnMedia, this.copyOnFSGroup, this.copyArchived, this.copyOnReadOnlyFS)) == null) {
                if (sizeToDel0 == Long.MAX_VALUE) break;
                this.log.warn((Object)("Could not find any further study for deletion on file system group " + this.getFileSystemGroupIDForDeleter()));
                break;
            }
            Iterator<DeleteStudyOrder> orderIter = deleteOrdersAndAccessTime.deleteStudyOrders.iterator();
            long[] result = this.markAndScheduleDeleteOrders(deleteOrdersAndAccessTime.deleteStudyOrders, sizeToDel);
            if (result[0] != 0L) {
                sizeToDel -= result[0];
                countStudies = (int)((long)countStudies + result[1]);
            }
            if (deleteOrdersAndAccessTime.deleteStudyOrders.size() == 0 && minAccessTime == deleteOrdersAndAccessTime.maxAccessTime) {
                this.log.warn((Object)("Possible infinite loop in deleter thread detected! Please check access_time in study_on_fs! Current minAccessTime:" + minAccessTime));
                ++minAccessTime;
                continue;
            }
            minAccessTime = deleteOrdersAndAccessTime.maxAccessTime;
        } while (sizeToDel > 0L && this.isRunningScheduleStudiesForDeletion);
        if (countStudies == 0 && sizeToDel > 0L) {
            this.log.warn((Object)("No study found for clean up filesystem group " + this.getFileSystemGroupIDForDeleter() + "! Please check your configuration!"));
            this.log.warn((Object)this.showDeleterCriteria());
        }
        return countStudies;
    }

    private long[] markAndScheduleDeleteOrders(Collection<DeleteStudyOrder> orders, long maxSize) throws Exception {
        FileSystemMgt2 fsMgt = AbstractDeleterService.fileSystemMgt();
        long[] result = new long[]{0L, 0L};
        if (orders.size() > 0) {
            boolean dontCheckMax;
            Iterator<DeleteStudyOrder> iter = orders.iterator();
            boolean bl = dontCheckMax = maxSize < 1L;
            while (iter.hasNext() && (dontCheckMax || result[0] < maxSize)) {
                DeleteStudyOrder order = iter.next();
                if (!this.checkExternalRetrievable(order) || !fsMgt.markStudyOnFSRecordForDeletion(order, true)) continue;
                try {
                    this.scheduleDeleteOrder(order);
                }
                catch (Exception e) {
                    fsMgt.markStudyOnFSRecordForDeletion(order, false);
                    throw e;
                }
                result[0] = result[0] + fsMgt.getStudySize(order);
                result[1] = result[1] + 1L;
            }
        }
        return result;
    }

    protected abstract void scheduleDeleteOrder(DeleteStudyOrder var1) throws Exception;

    protected String showTriggerInfo() {
        return "Trigger intervall: " + this.getScheduleStudiesForDeletionInterval();
    }

    public String showDeleterCriteria() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.showTriggerInfo());
        if (this.maxNotAccessedFor == 0L) {
            sb.append("\nOnly triggered by running out of disk space! Studies not accessed for ").append(this.getDeleteStudyOnlyIfNotAccessedFor());
        } else {
            sb.append("\nAll studies not accessed for ").append(this.getDeleteStudyIfNotAccessedFor());
            sb.append(".\n And studies not accessed for ").append(this.getDeleteStudyOnlyIfNotAccessedFor()).append(" when running out of disk space!");
        }
        sb.append("\nDeleter Criteria: ");
        int i = 0;
        if (this.externalRetrievable) {
            sb.append("\n  ").append(++i).append(") External Retrievable");
        }
        if (this.copyOnFSGroup != null) {
            sb.append("\n  ").append(++i).append(") Copy on Filesystem Group " + this.copyOnFSGroup);
        }
        if (this.copyArchived) {
            sb.append("\n  ").append(++i).append(") Copy must be archived");
        }
        if (this.copyOnReadOnlyFS) {
            sb.append("\n  ").append(++i).append(") Copy on a ReadOnly Filesystem");
        }
        if (this.copyOnMedia) {
            sb.append("\n  ").append(++i).append(") Copy on Media");
        }
        if (this.storageNotCommited) {
            sb.append("\n  ").append(++i).append(") Storage Not Commited");
        }
        if (i == 0) {
            sb.append("\n  WARNING! No Deletion criteria configured!");
        }
        return sb.toString();
    }

    public void stopCurrentDeleterThread() {
        this.isRunningScheduleStudiesForDeletion = false;
    }

    private boolean checkExternalRetrievable(DeleteStudyOrder order) {
        int availabilityAsInt;
        String aet = order.getExternalRetrieveAET();
        if (aet == null) {
            return true;
        }
        String availability = this.instanceAvailabilityOfExternalRetrievable;
        String studyIUID = order.getStudyIUID();
        if (availability == null) {
            try {
                Dataset findRsp = this.findScu.findStudy(aet, studyIUID);
                if (findRsp == null) {
                    this.log.warn((Object)("Study:" + studyIUID + " not found at Retrieve AE: " + aet));
                    return false;
                }
                availability = findRsp.getString(524374);
                if (availability == null) {
                    this.log.warn((Object)("Retrieve AE: " + aet + " does not return Instance Availability for study: " + studyIUID));
                    return false;
                }
            }
            catch (Exception e) {
                this.log.warn((Object)("Query external Retrieve AE: " + aet + " for study: " + studyIUID + "failed:"), (Throwable)e);
                return false;
            }
        }
        if ((availabilityAsInt = Availability.toInt(availability)) == 3) {
            this.log.warn((Object)("Retrieve AE: " + aet + " returns Instance Availability: UNAVAILABLE for study: " + studyIUID));
            return false;
        }
        order.setExternalRetrieveAvailability(availabilityAsInt);
        return true;
    }

    public long scheduleStudyForDeletion(String suid) throws Exception {
        FileSystemMgt2 fsMgt = AbstractDeleterService.fileSystemMgt();
        Collection orders = fsMgt.createDeleteOrdersForStudyOnFSGroup(suid, this.getFileSystemGroupIDForDeleter());
        return this.markAndScheduleDeleteOrders(orders, -1L)[0];
    }
}

