/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4chex.archive.mbean;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.rmi.RemoteException;
import java.util.Collection;
import java.util.StringTokenizer;
import javax.management.Attribute;
import javax.management.AttributeNotFoundException;
import javax.management.Notification;
import javax.management.ObjectName;
import org.apache.log4j.Logger;
import org.dcm4che2.audit.message.ActiveParticipant;
import org.dcm4che2.audit.message.AuditEvent;
import org.dcm4che2.audit.message.AuditMessage;
import org.dcm4che2.audit.message.SecurityAlertMessage;
import org.dcm4cheri.util.StringUtils;
import org.dcm4chex.archive.ejb.interfaces.AEDTO;
import org.dcm4chex.archive.ejb.interfaces.AEManager;
import org.dcm4chex.archive.ejb.interfaces.AEManagerHome;
import org.dcm4chex.archive.ejb.interfaces.FileSystemMgt2;
import org.dcm4chex.archive.ejb.interfaces.FileSystemMgt2Home;
import org.dcm4chex.archive.exceptions.UnknownAETException;
import org.dcm4chex.archive.mbean.HttpUserInfo;
import org.dcm4chex.archive.notif.AetChanged;
import org.dcm4chex.archive.util.EJBHomeFactory;
import org.jboss.system.ServiceMBeanSupport;

public class AEService
extends ServiceMBeanSupport {
    private static final int MAX_MAX_CACHE_SIZE = 1000;
    private ObjectName echoServiceName;
    private boolean dontSaveIP = true;
    private boolean autoUpdateIP;
    private int[] portNumbers;
    private int maxCacheSize;
    private int updateStudiesBatchSize;
    private ObjectName[] otherServiceNames = new ObjectName[0];
    private String[] otherServiceAETAttrs = new String[0];

    public ObjectName getEchoServiceName() {
        return this.echoServiceName;
    }

    public void setEchoServiceName(ObjectName echoServiceName) {
        this.echoServiceName = echoServiceName;
    }

    public boolean isDontSaveIP() {
        return this.dontSaveIP;
    }

    public void setDontSaveIP(boolean dontSaveIP) {
        this.dontSaveIP = dontSaveIP;
    }

    public boolean isAutoUpdateIP() {
        return this.autoUpdateIP;
    }

    public void setAutoUpdateIP(boolean autoUpdateIP) {
        this.autoUpdateIP = autoUpdateIP;
    }

    public String getPortNumbers() {
        if (this.portNumbers == null || this.portNumbers.length < 1) {
            return "NONE";
        }
        int len = this.portNumbers.length;
        String first = String.valueOf(this.portNumbers[0]);
        if (len == 1) {
            return first;
        }
        StringBuffer sb = new StringBuffer(first);
        for (int i = 1; i < len; ++i) {
            sb.append(",").append(this.portNumbers[i]);
        }
        return sb.toString();
    }

    public void setPortNumbers(String ports) {
        if (ports == null || "NONE".equalsIgnoreCase(ports)) {
            this.portNumbers = null;
        } else {
            StringTokenizer st = new StringTokenizer(ports, ",");
            this.portNumbers = new int[st.countTokens()];
            int i = 0;
            while (st.hasMoreTokens()) {
                this.portNumbers[i] = Integer.parseInt(st.nextToken());
                ++i;
            }
        }
    }

    public int getCacheSize() throws Exception {
        return this.aeMgr().getCacheSize();
    }

    public int getMaxCacheSize() throws Exception {
        return this.maxCacheSize;
    }

    public void setMaxCacheSize(int maxCacheSize) throws Exception {
        if (maxCacheSize < 0 || maxCacheSize > 1000) {
            throw new IllegalArgumentException("maxCacheSize: " + maxCacheSize);
        }
        this.maxCacheSize = maxCacheSize;
        if (this.getState() == 3) {
            this.aeMgr().setMaxCacheSize(maxCacheSize);
        }
    }

    public int getUpdateStudiesBatchSize() {
        return this.updateStudiesBatchSize;
    }

    public void setUpdateStudiesBatchSize(int batchSize) {
        if (batchSize <= 0) {
            throw new IllegalArgumentException("batchSize: " + batchSize);
        }
        this.updateStudiesBatchSize = batchSize;
    }

    public final String getOtherServiceAETAttrs() {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < this.otherServiceNames.length; ++i) {
            sb.append(this.otherServiceNames[i].toString()).append('#').append(this.otherServiceAETAttrs[i]).append("\r\n");
        }
        return sb.toString();
    }

    public final void setOtherServiceAETAttrs(String s) {
        StringTokenizer stk = new StringTokenizer(s, "\r\n\t; ");
        int count = stk.countTokens();
        ObjectName[] names = new ObjectName[count];
        String[] attrs = new String[count];
        String tk = null;
        try {
            for (int i = 0; i < names.length; ++i) {
                tk = stk.nextToken();
                int endName = tk.indexOf(35);
                names[i] = new ObjectName(tk.substring(0, endName));
                attrs[i] = tk.substring(endName + 1);
            }
        }
        catch (Exception e) {
            throw new IllegalArgumentException(tk);
        }
        this.otherServiceNames = names;
        this.otherServiceAETAttrs = attrs;
    }

    public void clearCache() throws Exception {
        this.aeMgr().clearCache();
    }

    public String getAEs() throws Exception {
        Collection c = this.aeMgr().findAll();
        StringBuffer sb = new StringBuffer();
        for (AEDTO ae : c) {
            sb.append(ae.toString()).append(" cipher:").append(ae.getCipherSuitesAsString()).append("\r\n");
        }
        return sb.toString();
    }

    public Collection listAEs() throws Exception {
        return this.aeMgr().findAll();
    }

    public AEDTO getAE(String title) throws Exception {
        return this.aeMgr().findByAET(title);
    }

    static FileSystemMgt2 fileSystemMgt() throws Exception {
        FileSystemMgt2Home home = (FileSystemMgt2Home)EJBHomeFactory.getFactory().lookup(FileSystemMgt2Home.class, "ejb/FileSystemMgt2");
        return home.create();
    }

    public void updateAETitle(String prevAET, String newAET) throws Exception {
        if ((prevAET = prevAET.trim()).equals(newAET = newAET.trim())) {
            return;
        }
        AEManager aeManager = this.aeMgr();
        AEDTO ae = aeManager.findByAET(prevAET);
        ae.setTitle(newAET);
        aeManager.updateAE(ae);
        AEService.fileSystemMgt().updateFileSystemRetrieveAET(prevAET, newAET, this.updateStudiesBatchSize);
        for (int i = 0; i < this.otherServiceNames.length; ++i) {
            if (this.server.isRegistered(this.otherServiceNames[i])) {
                this.updateAETitle(this.otherServiceNames[i], this.otherServiceAETAttrs[i], prevAET, newAET);
                continue;
            }
            if (!this.log.isDebugEnabled()) continue;
            this.log.debug((Object)("Service: " + this.otherServiceNames[i] + " not registered -> cannot update AETitle in attribute: " + this.otherServiceNames[i] + "#" + this.otherServiceAETAttrs[i]));
        }
        this.log.info((Object)("AE title changed from " + prevAET + " to " + newAET));
        this.notifyAETchange(prevAET, newAET, "");
    }

    private boolean updateAETitle(ObjectName name, String attr, String prevAET, String newAET) throws Exception {
        try {
            String val = (String)this.server.getAttribute(name, attr);
            String[] aets = StringUtils.split(val, '\\');
            boolean modified = false;
            for (int i = 0; i < aets.length; ++i) {
                if (!aets[i].equals(prevAET)) continue;
                aets[i] = newAET;
                modified = true;
            }
            if (modified) {
                this.server.setAttribute(name, new Attribute(attr, StringUtils.toString(aets, '\\')));
                this.log.info((Object)("Update AETitle in attribute: " + name + "#" + attr));
            }
            return modified;
        }
        catch (AttributeNotFoundException e) {
            this.log.info((Object)("No such attribute: " + name + "#" + attr));
            return false;
        }
    }

    public AEDTO getAE(String title, String host) throws RemoteException, Exception {
        return this.getAE(title, host == null ? null : InetAddress.getByName(host));
    }

    public AEDTO getAE(String aet, InetAddress addr) throws Exception {
        AEManager aetMgr = this.aeMgr();
        try {
            return this.updateIP(aetMgr.findByAET(aet), addr, aetMgr);
        }
        catch (UnknownAETException e) {
            return this.autoConfigAE(aet, addr, aetMgr);
        }
    }

    private AEDTO updateIP(AEDTO ae, InetAddress addr, AEManager aetMgr) throws Exception {
        String newIP;
        String oldIP;
        if (this.autoUpdateIP && addr != null && ActiveParticipant.isIP((String)(oldIP = ae.getHostName())) && !oldIP.equals(newIP = addr.getHostAddress())) {
            ae.setHostName(newIP);
            aetMgr.updateAE(ae);
            this.log.info((Object)("Update IP of " + ae));
        }
        return ae;
    }

    private AEDTO autoConfigAE(String aet, InetAddress addr, AEManager aetMgr) throws Exception {
        if (this.portNumbers == null || addr == null) {
            return null;
        }
        String aeHost = addr.getHostName();
        for (int i = 0; i < this.portNumbers.length; ++i) {
            AEDTO ae = new AEDTO();
            ae.setTitle(aet);
            ae.setHostName(aeHost);
            ae.setPort(this.portNumbers[i]);
            if (!this.echo(ae)) continue;
            if (this.dontSaveIP) {
                if (!aeHost.equals(addr.getHostAddress())) {
                    aetMgr.newAE(ae);
                }
            } else {
                aetMgr.newAE(ae);
            }
            this.logActorConfig("Add new auto-configured AE " + ae, SecurityAlertMessage.NETWORK_CONFIGURATION);
            this.notifyAETchange(null, aet, "");
            return ae;
        }
        return null;
    }

    public void updateAE(long pk, String title, String host, int port, String cipher, String issuerOfPatientID, String issuerOfAccessionNumber, String user, String passwd, String fsGroupID, String group, String desc, String wadoUrl, String stationName, String institution, String department, boolean installed, boolean checkHost) throws Exception {
        if (checkHost) {
            try {
                host = InetAddress.getByName(host).getCanonicalHostName();
            }
            catch (UnknownHostException x) {
                throw new IllegalArgumentException("Host " + host + " cant be resolved! Disable hostname check to add new AE anyway!");
            }
        }
        AEDTO newAE = new AEDTO();
        newAE.setPk(pk);
        newAE.setTitle(title);
        newAE.setHostName(host);
        newAE.setPort(port);
        newAE.setCipherSuitesAsString(cipher);
        newAE.setIssuerOfPatientID(issuerOfPatientID);
        newAE.setIssuerOfAccessionNumberAsString(issuerOfAccessionNumber);
        newAE.setUserID(user);
        newAE.setPassword(passwd);
        newAE.setFileSystemGroupID(fsGroupID);
        newAE.setGroup(group);
        newAE.setDescription(desc);
        newAE.setWadoURL(wadoUrl);
        newAE.setStationName(stationName);
        newAE.setInstitution(institution);
        newAE.setDepartment(department);
        newAE.setInstalled(installed);
        AEManager aeManager = this.aeMgr();
        if (pk == -1L) {
            aeManager.newAE(newAE);
            this.logActorConfig("Add AE " + newAE + " cipher:" + newAE.getCipherSuitesAsString(), SecurityAlertMessage.NETWORK_CONFIGURATION);
            this.notifyAETchange(null, title, "");
        } else {
            AEDTO oldAE = aeManager.findByPrimaryKey(pk);
            String oldAET = null;
            if (!oldAE.getTitle().equals(title)) {
                try {
                    AEDTO aeOldByTitle = aeManager.findByAET(title);
                    throw new IllegalArgumentException("AE Title " + title + " already exists!:" + aeOldByTitle);
                }
                catch (UnknownAETException e) {
                    oldAET = oldAE.getTitle();
                }
            }
            aeManager.updateAE(newAE);
            this.logActorConfig("Modify AE " + oldAE + " -> " + newAE, SecurityAlertMessage.NETWORK_CONFIGURATION);
            if (oldAET != null) {
                this.notifyAETchange(oldAET, title, "");
            }
        }
    }

    public void addAE(String title, String host, int port, String cipher, String issuerOfPatientID, String issuerOfAccessionNumber, String user, String passwd, String fsGroupID, String group, String desc, String wadoUrl, String stationName, String institution, String department, boolean installed, boolean checkHost) throws Exception {
        this.updateAE(-1L, title, host, port, cipher, issuerOfPatientID, issuerOfAccessionNumber, user, passwd, fsGroupID, group, desc, wadoUrl, stationName, institution, department, installed, checkHost);
    }

    public void removeAE(String titles) throws Exception {
        StringTokenizer st = new StringTokenizer(titles, " ,;\t\r\n");
        AEManager aeManager = this.aeMgr();
        while (st.hasMoreTokens()) {
            AEDTO ae = aeManager.findByAET(st.nextToken());
            aeManager.removeAE(ae.getPk());
            this.logActorConfig("Remove AE " + ae, SecurityAlertMessage.NETWORK_CONFIGURATION);
            this.notifyAETchange(ae.getTitle(), null, "");
        }
    }

    protected void logActorConfig(String desc, AuditEvent.TypeCode eventTypeCode) {
        this.log.info((Object)desc);
        try {
            HttpUserInfo userInfo = new HttpUserInfo(AuditMessage.isEnableDNSLookups());
            SecurityAlertMessage msg = new SecurityAlertMessage(eventTypeCode);
            msg.addReportingProcess(AuditMessage.getProcessID(), AuditMessage.getLocalAETitles(), AuditMessage.getProcessName(), AuditMessage.getLocalHostName());
            msg.addPerformingPerson(userInfo.getUserId(), null, null, userInfo.getHostName());
            msg.addAlertSubjectWithNodeID(AuditMessage.getLocalNodeID(), desc);
            msg.validate();
            Logger.getLogger((String)"auditlog").info((Object)msg);
        }
        catch (Exception e) {
            this.log.warn((Object)"Failed to log ActorConfig:", (Throwable)e);
        }
    }

    public void notifyAETchange(String oldTitle, String newTitle, String message) {
        long eventID = this.getNextNotificationSequenceNumber();
        Notification notif = new Notification(AetChanged.class.getName(), (Object)this, eventID, message);
        notif.setUserData(new AetChanged(oldTitle, newTitle));
        this.log.debug((Object)("send AE Title changed notif:" + notif));
        this.sendNotification(notif);
    }

    private boolean echo(AEDTO ae) {
        try {
            Boolean result = (Boolean)this.server.invoke(this.echoServiceName, "checkEcho", new Object[]{ae}, new String[]{AEDTO.class.getName()});
            return result;
        }
        catch (Exception e) {
            this.log.warn((Object)"Failed to use echo service:", (Throwable)e);
            return false;
        }
    }

    protected AEManager aeMgr() throws Exception {
        AEManagerHome home = (AEManagerHome)EJBHomeFactory.getFactory().lookup(AEManagerHome.class, "ejb/AEManager");
        return home.create();
    }

    protected void startService() throws Exception {
        this.aeMgr().setMaxCacheSize(this.maxCacheSize);
    }
}

