/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4chex.archive.mawf;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.jms.Message;
import javax.jms.MessageListener;
import javax.jms.ObjectMessage;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanException;
import javax.management.Notification;
import javax.management.NotificationListener;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import org.dcm4che.data.Dataset;
import org.dcm4che.data.DcmElement;
import org.dcm4che.srom.Code;
import org.dcm4che.srom.SRDocumentFactory;
import org.dcm4chex.archive.common.BaseJmsOrder;
import org.dcm4chex.archive.config.RetryIntervalls;
import org.dcm4chex.archive.dcm.storescp.StoreScpService;
import org.dcm4chex.archive.exceptions.ConfigurationException;
import org.dcm4chex.archive.mawf.RejectionNoteStoredOrder;
import org.dcm4chex.archive.mbean.JMSDelegate;
import org.jboss.system.ServiceMBeanSupport;

public class RejectionNoteStoredService
extends ServiceMBeanSupport
implements NotificationListener,
MessageListener {
    private static Pattern PATTERN = Pattern.compile("\\s*(\\([^\\(\\)]+\\))");
    private ObjectName storeScpServiceName;
    private ObjectName contentEditServiceName;
    private JMSDelegate jmsDelegate = new JMSDelegate(this);
    private String queueName;
    private List<Code> rejectionNoteCodes;
    private long deletionDelay;
    private boolean keepRejectionNote;
    private RetryIntervalls retryIntervals = new RetryIntervalls();

    public ObjectName getStoreScpServiceName() {
        return this.storeScpServiceName;
    }

    public final void setStoreScpServiceName(ObjectName storeScpServiceName) {
        this.storeScpServiceName = storeScpServiceName;
    }

    public void setContentEditServiceName(ObjectName serviceName) {
        this.contentEditServiceName = serviceName;
    }

    public ObjectName getContentEditServiceName() {
        return this.contentEditServiceName;
    }

    public ObjectName getJmsServiceName() {
        return this.jmsDelegate.getJmsServiceName();
    }

    public void setJmsServiceName(ObjectName jmsServiceName) {
        this.jmsDelegate.setJmsServiceName(jmsServiceName);
    }

    public void setQueueName(String queueName) {
        this.queueName = queueName;
    }

    public String getQueueName() {
        return this.queueName;
    }

    public String getRejectionNoteCodes() {
        StringBuilder sb = new StringBuilder();
        for (Code code : this.rejectionNoteCodes) {
            sb.append(code).append("\r\n");
        }
        return sb.toString();
    }

    public void setRejectionNoteCodes(String input) {
        Matcher m = PATTERN.matcher(input);
        ArrayList<Code> tmp = new ArrayList<Code>();
        while (m.find()) {
            tmp.add(SRDocumentFactory.getInstance().newCode(m.group(1)));
        }
        this.rejectionNoteCodes = tmp;
    }

    public String getDeletionDelay() {
        return RetryIntervalls.formatInterval(this.deletionDelay);
    }

    public void setDeletionDelay(String delay) {
        this.deletionDelay = RetryIntervalls.parseInterval(delay.trim());
    }

    public void setKeepRejectionNote(boolean keepRejectionNote) {
        this.keepRejectionNote = keepRejectionNote;
    }

    public boolean isKeepRejectionNote() {
        return this.keepRejectionNote;
    }

    public void setRetryIntervals(String retryIntervals) {
        this.retryIntervals = new RetryIntervalls(retryIntervals);
    }

    public String getRetryIntervals() {
        return this.retryIntervals.toString();
    }

    public boolean scheduleDeleteOnRejectionNoteStored(Dataset ds) throws Exception {
        if (!"1.2.840.10008.5.1.4.1.1.88.59".equals(ds.getString(524310))) {
            return false;
        }
        Dataset title = ds.getItem(4235331);
        if (!this.rejectionNoteCodes.contains(SRDocumentFactory.getInstance().newCode(title))) {
            return false;
        }
        this.schedule(new RejectionNoteStoredOrder(ds), this.deletionDelay != 0L ? System.currentTimeMillis() + this.deletionDelay : 0L);
        return true;
    }

    protected void schedule(BaseJmsOrder order, long scheduledTime) throws Exception {
        if (this.log.isInfoEnabled()) {
            String scheduledTimeStr = scheduledTime > 0L ? new Date(scheduledTime).toString() : "now";
            this.log.info((Object)("Scheduling job [" + order + "] at " + scheduledTimeStr + ". Retry times: " + order.getFailureCount()));
        }
        this.jmsDelegate.queue(this.queueName, order, 4, scheduledTime);
    }

    protected void startService() throws Exception {
        this.server.addNotificationListener(this.storeScpServiceName, this, StoreScpService.NOTIF_FILTER, null);
        this.jmsDelegate.startListening(this.queueName, this, 1);
    }

    protected void stopService() throws Exception {
        this.server.removeNotificationListener(this.storeScpServiceName, this, StoreScpService.NOTIF_FILTER, null);
        this.jmsDelegate.stopListening(this.queueName);
    }

    public void handleNotification(Notification notif, Object handback) {
        Dataset ds = (Dataset)notif.getUserData();
        if ("1.2.840.10008.5.1.4.1.1.88.59".equals(ds.getString(524310))) {
            Dataset title = ds.getItem(4235331);
            if (this.rejectionNoteCodes.contains(SRDocumentFactory.getInstance().newCode(title))) {
                RejectionNoteStoredOrder order = new RejectionNoteStoredOrder(ds);
                try {
                    this.schedule(order, this.deletionDelay == 0L ? 0L : System.currentTimeMillis() + this.deletionDelay);
                }
                catch (Exception e) {
                    this.log.error((Object)("Failed to schedule " + order), (Throwable)e);
                }
            }
        }
    }

    public void onMessage(Message msg) {
        RejectionNoteStoredOrder order;
        try {
            order = (RejectionNoteStoredOrder)((ObjectMessage)msg).getObject();
        }
        catch (Exception e) {
            this.log.error((Object)("Processing JMS message failed! message:" + msg), (Throwable)e);
            return;
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Processing " + order));
        }
        try {
            this.moveInstancesToTrash(this.iuidsOf(order.getDataset()));
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Finished processing " + order));
            }
        }
        catch (Exception e) {
            int failureCount = order.getFailureCount() + 1;
            long delay = this.retryIntervals.getIntervall(failureCount);
            order.setFailureCount(failureCount);
            if (delay == -1L) {
                order.setThrowable(e);
                this.log.error((Object)("Give up to process " + order));
                try {
                    this.jmsDelegate.fail(this.queueName, order);
                }
                catch (Exception e2) {
                    this.log.error((Object)("Failed to notify JMSDelgate of failed job! Give up to process" + order), (Throwable)e2);
                }
            }
            Throwable thisThrowable = e;
            if (e instanceof InvocationTargetException) {
                thisThrowable = ((InvocationTargetException)e).getTargetException();
            }
            if (failureCount == 1 || order.getThrowable() != null && !thisThrowable.getClass().equals(order.getThrowable().getClass())) {
                this.log.error((Object)("Failed to process JMS job. Will schedule retry... Dumping - " + order.toLongString()), (Throwable)e);
                order.setThrowable(thisThrowable);
            } else {
                this.log.warn((Object)("Failed to process " + order + ". Details should have been provided." + " Will schedule retry."));
            }
            try {
                this.schedule(order, System.currentTimeMillis() + delay);
            }
            catch (Exception e2) {
                this.log.error((Object)("Failed to schedule retry! Give up to process " + order), (Throwable)e2);
            }
        }
    }

    private String[] iuidsOf(Dataset ds) {
        ArrayList<String> iuids = new ArrayList<String>();
        DcmElement stysq = ds.get(4236149);
        int styCount = stysq.countItems();
        for (int i = 0; i < styCount; ++i) {
            DcmElement sersq = stysq.getItem(i).get(528661);
            int serCount = sersq.countItems();
            for (int j = 0; j < serCount; ++j) {
                DcmElement refsopsq = sersq.getItem(j).get(528793);
                int refsopsqCount = refsopsq.countItems();
                for (int k = 0; k < refsopsqCount; ++k) {
                    iuids.add(refsopsq.getItem(k).getString(528725));
                }
            }
        }
        if (!this.keepRejectionNote) {
            iuids.add(ds.getString(524312));
        }
        return iuids.toArray(new String[iuids.size()]);
    }

    private void moveInstancesToTrash(String[] iuids) throws Exception {
        try {
            this.server.invoke(this.contentEditServiceName, "moveInstancesToTrash", new Object[]{iuids}, new String[]{String[].class.getName()});
        }
        catch (MBeanException e) {
            throw e.getTargetException();
        }
        catch (InstanceNotFoundException e) {
            throw new ConfigurationException(e);
        }
        catch (ReflectionException e) {
            throw new ConfigurationException(e);
        }
    }
}

