/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4chex.archive.hsm.module.dicey;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.channels.FileChannel;
import org.apache.log4j.Logger;

public class TransferThread
extends Thread {
    public File source;
    public File destination;
    private long lengthInBytes;
    public long chunckSizeInBytes;
    public boolean verbose;
    volatile FileChannel outputChannel;
    volatile FileChannel inputChannel;
    volatile boolean stop = false;
    private static final Logger log = Logger.getLogger(TransferThread.class);
    private static final int KB = 1024;
    private static final int MB = 0x100000;

    public TransferThread(File inFile, File outFile, int i) {
        this.source = inFile;
        this.destination = outFile;
        this.chunckSizeInBytes = i;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() {
        log.debug((Object)"Opening streams");
        FileInputStream fileInputStream = null;
        FileOutputStream fileOutputStream = null;
        this.lengthInBytes = this.source.length();
        StringBuilder logoutput = new StringBuilder();
        try {
            try {
                try {
                    fileInputStream = new FileInputStream(this.source);
                }
                catch (FileNotFoundException e) {
                    log.error((Object)"Opening input Stream Failed");
                    throw e;
                }
                try {
                    fileOutputStream = new FileOutputStream(this.destination);
                }
                catch (FileNotFoundException e1) {
                    log.error((Object)"Opening output Stream Failed");
                    throw e1;
                }
                log.debug((Object)"Opening channels");
                this.inputChannel = fileInputStream.getChannel();
                this.outputChannel = fileOutputStream.getChannel();
                long overallBytesTransfered = 0L;
                try {
                    try {
                        long t1 = System.currentTimeMillis();
                        while (!this.stop) {
                            long bytesToTransfer = Math.min(this.chunckSizeInBytes, this.lengthInBytes - overallBytesTransfered);
                            long bytesTransfered = 0L;
                            log.debug((Object)("Transfer bytes: " + bytesToTransfer));
                            try {
                                bytesTransfered = this.inputChannel.transferTo(overallBytesTransfered, bytesToTransfer, this.outputChannel);
                            }
                            catch (IOException e) {
                                log.error((Object)"Opening output Stream Failed");
                                throw e;
                            }
                            if ((overallBytesTransfered += bytesTransfered) != this.lengthInBytes) continue;
                            this.stop = true;
                            long t2 = System.currentTimeMillis();
                            logoutput.append("Copied ").append(this.source).append(" -> ").append(this.destination).append(" ");
                            if (this.lengthInBytes > 0x100000L) {
                                logoutput.append(this.lengthInBytes / 0x100000L).append("MiB");
                            } else {
                                logoutput.append(this.lengthInBytes / 1024L).append("KiB");
                            }
                            logoutput.append(" in ").append((float)(t2 - t1) / 1000.0f).append(" seconds").append(" [").append((float)this.lengthInBytes / 1024.0f / 1024.0f / ((float)(t2 - t1) / 1000.0f)).append("MiB/s]");
                            log.info((Object)logoutput.toString());
                        }
                        Object var15_14 = null;
                    }
                    catch (IOException e) {
                        log.error((Object)"Copy failed");
                        throw e;
                    }
                }
                catch (Throwable throwable) {
                    Object var15_15 = null;
                    fileInputStream.close();
                    fileOutputStream.close();
                    this.inputChannel.close();
                    this.outputChannel.close();
                    throw throwable;
                }
                fileInputStream.close();
                fileOutputStream.close();
                this.inputChannel.close();
                this.outputChannel.close();
                Object var17_17 = null;
            }
            catch (IOException e) {
                log.error((Object)"Stacktrace:", (Throwable)e);
                Object var17_18 = null;
                this.interrupt();
                return;
            }
        }
        catch (Throwable throwable) {
            Object var17_19 = null;
            this.interrupt();
            throw throwable;
        }
        this.interrupt();
    }
}

