/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4chex.archive.hsm.module.dicey;

import java.io.File;
import java.io.IOException;
import org.apache.log4j.Logger;
import org.dcm4chex.archive.hsm.module.dicey.TransferThread;

public class FileIOTimeOut {
    private static final Logger log = Logger.getLogger(FileIOTimeOut.class);
    private static final int CHUNKSIZE = 0x400000;

    public static void copy(File source, File destination, int timeOut) throws IOException {
        try {
            TransferThread ioThread = new TransferThread(source, destination, 0x400000);
            ioThread.start();
            log.debug((Object)"Thread started");
            int MAX_SECONDS = timeOut;
            int counter = 0;
            long totalSize = 0L;
            totalSize = destination.length();
            while (!ioThread.stop || ioThread.getState() != Thread.State.TERMINATED) {
                log.debug((Object)("Timeout seconds: " + counter));
                if (counter >= MAX_SECONDS) {
                    log.debug((Object)"TimeOut reached");
                    ioThread.inputChannel.close();
                    ioThread.outputChannel.close();
                    ioThread.stop = true;
                    ioThread.interrupt();
                    throw new IOException("TimeOut reached");
                }
                try {
                    Thread.sleep(1000L);
                    if (destination.length() > totalSize) {
                        totalSize = destination.length();
                        counter = 0;
                        log.debug((Object)("Size:" + totalSize));
                    } else {
                        log.debug((Object)("Size not changed:" + totalSize));
                    }
                }
                catch (InterruptedException e) {
                    throw new IOException("Thread Aborted");
                }
                ++counter;
            }
        }
        catch (Exception e) {
            throw new IOException("FileCopy Not successfull", e);
        }
    }
}

