/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4chex.archive.hsm.module.dicey;

import java.io.File;
import java.io.IOException;
import org.apache.log4j.Logger;
import org.dcm4chex.archive.hsm.module.HSMException;
import org.dcm4chex.archive.hsm.module.HSMFileBasedModule;
import org.dcm4chex.archive.hsm.module.dicey.FileIOTimeOut;
import org.dcm4chex.archive.util.FileUtils;

public class DiceyFSModule
extends HSMFileBasedModule {
    private static final Logger log = Logger.getLogger(DiceyFSModule.class);
    private File incomingDir;
    private File absIncomingDir;
    private int readTimeout;

    public final String getIncomingDir() {
        return this.incomingDir.getPath();
    }

    public final void setIncomingDir(String dir) {
        this.incomingDir = new File(dir);
        this.absIncomingDir = FileUtils.resolve(this.incomingDir);
    }

    public final int getReadTimeout() {
        return this.readTimeout;
    }

    public final void setReadTimeout(int to) {
        this.readTimeout = to;
    }

    protected void checkMount(final String fsID) throws HSMException {
        final Boolean[] notMounted = new Boolean[]{null};
        Thread t = new Thread(){

            public void run() {
                notMounted[0] = FileUtils.toFile(DiceyFSModule.this.stripTarIdentifier(fsID), DiceyFSModule.this.getMountFailedCheckFile()).exists();
            }
        };
        t.start();
        try {
            t.join(this.readTimeout * 1000);
        }
        catch (InterruptedException e) {
            log.warn((Object)"checkMount thread interrupted!", (Throwable)e);
        }
        if (notMounted[0] == null) {
            t.interrupt();
            log.warn((Object)("Accessibility of " + fsID + " seems broken! Timeout during mount check!"));
            throw new HSMException("Filesystem accessibility broken! fsID:" + fsID);
        }
        if (notMounted[0].booleanValue()) {
            log.warn((Object)("Mount on " + fsID + " seems broken! mountFailedCheckFile file exists:" + this.getMountFailedCheckFile()));
            throw new HSMException("Filesystem not mounted! fsID:" + fsID);
        }
    }

    public File fetchHSMFile(String fsID, String filePath) throws HSMException {
        File tarFile;
        this.checkMount(fsID);
        if (this.absIncomingDir.mkdirs()) {
            log.info((Object)("M-WRITE " + this.absIncomingDir));
        }
        try {
            tarFile = File.createTempFile("hsm_", ".tar", this.absIncomingDir);
        }
        catch (IOException x) {
            throw new HSMException("Failed to create temp file in " + this.absIncomingDir, x);
        }
        File fileToFetch = FileUtils.toFile(this.stripTarIdentifier(fsID), filePath);
        try {
            FileIOTimeOut.copy(fileToFetch, tarFile, this.readTimeout);
        }
        catch (IOException x) {
            throw new HSMException("Failed to retrieve " + fileToFetch, x);
        }
        return tarFile;
    }

    public void fetchHSMFileFinished(String fsID, String filePath, File file) throws HSMException {
        log.info((Object)("M-DELETE " + file));
        if (!file.delete()) {
            log.warn((Object)("Deletion failed:" + file));
        }
    }
}

