/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4chex.archive.hsm.module;

import java.io.File;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import org.dcm4chex.archive.common.FileStatus;
import org.dcm4chex.archive.hsm.VerifyTar;
import org.dcm4chex.archive.hsm.module.AbstractHSMModule;
import org.dcm4chex.archive.hsm.module.HSMException;
import org.dcm4chex.archive.util.FileUtils;

public class HSMFileBasedModule
extends AbstractHSMModule {
    private static final String FILE_PARAM = "%f";
    private static final String DATE_PARAM = "%d";
    private static final String NEWLINE = System.getProperty("line.separator", "\n");
    private static final String CAL_FIELD_NAMES = "yMd";
    private static final int[] CAL_FIELDS = new int[]{1, 2, 5};
    private String mountFailedCheckFile = "NO_MOUNT";
    private byte[] buf = new byte[8192];
    private int[] retentionTime = new int[2];
    private String[] accessTimeCmd;
    private boolean setAccessTimeAfterSetReadonly;
    private SimpleDateFormat df;
    private HashMap<String, Integer> extensionStatusMap = new HashMap();
    private Integer noStatusFileStatus;
    private boolean checkMD5forStatusChange;

    public String getRetentionTime() {
        return (this.setAccessTimeAfterSetReadonly ? "+" : "") + String.valueOf(this.retentionTime[0]) + CAL_FIELD_NAMES.charAt(this.retentionTime[1]);
    }

    public void setRetentionTime(String s) {
        int len = s.length();
        this.setAccessTimeAfterSetReadonly = s.charAt(0) == '+';
        this.retentionTime[0] = Integer.parseInt(s.substring(this.setAccessTimeAfterSetReadonly ? 1 : 0, --len));
        int idx = CAL_FIELD_NAMES.indexOf(s.charAt(len));
        if (idx < 0 || idx > 2) {
            throw new IllegalArgumentException("Last character must be 'y', 'M' or 'd'!");
        }
        this.retentionTime[1] = idx;
    }

    public final String getAccessTimeCmd() {
        return this.cmd2str(this.accessTimeCmd);
    }

    public final void setAccessTimeCmd(String cmd) {
        this.accessTimeCmd = this.str2cmd(cmd);
    }

    public String getPattern() {
        return this.df.toPattern();
    }

    public void setPattern(String pattern) {
        this.df = new SimpleDateFormat(pattern);
    }

    public String getStatusExtensions() {
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<String, Integer> entry : this.extensionStatusMap.entrySet()) {
            sb.append(entry.getKey()).append("=").append(FileStatus.toString(entry.getValue())).append(NEWLINE);
        }
        sb.append(this.noStatusFileStatus == null ? "NONE" : FileStatus.toString(this.noStatusFileStatus));
        return sb.toString();
    }

    public void setStatusExtensions(String s) {
        this.extensionStatusMap.clear();
        this.noStatusFileStatus = null;
        StringTokenizer st = new StringTokenizer(s, " \t\r\n;");
        while (st.hasMoreTokens()) {
            String token = st.nextToken().trim();
            int pos = token.indexOf(61);
            if (pos == -1) {
                this.noStatusFileStatus = "NONE".equals(token) ? null : Integer.valueOf(FileStatus.toInt(token));
                continue;
            }
            this.extensionStatusMap.put(token.substring(0, pos), FileStatus.toInt(token.substring(++pos)));
        }
    }

    public boolean isCheckMD5forStatusChange() {
        return this.checkMD5forStatusChange;
    }

    public void setCheckMD5forStatusChange(boolean checkMD5forStatusChange) {
        this.checkMD5forStatusChange = checkMD5forStatusChange;
    }

    public final String getMountFailedCheckFile() {
        return this.mountFailedCheckFile;
    }

    public final void setMountFailedCheckFile(String mountFailedCheckFile) {
        this.mountFailedCheckFile = mountFailedCheckFile;
    }

    protected void checkMount(String fsID) throws HSMException {
        File nomount = FileUtils.toFile(this.stripTarIdentifier(fsID), this.mountFailedCheckFile);
        if (nomount.exists()) {
            this.log.warn((Object)("Mount on " + fsID + " seems broken! mountFailedCheckFile file exists:" + this.mountFailedCheckFile));
            throw new HSMException("Filesystem not mounted! fsID:" + fsID);
        }
    }

    public File prepareHSMFile(String fsID, String filePath) throws HSMException {
        this.checkMount(fsID);
        return FileUtils.toFile(this.stripTarIdentifier(fsID), filePath);
    }

    public String storeHSMFile(File file, String fsID, String filePath) throws HSMException {
        this.checkMount(fsID);
        if (this.setAccessTimeAfterSetReadonly) {
            file.setReadOnly();
        }
        if (this.accessTimeCmd != null) {
            String cmd = this.makeAccessTimeCommand(file.getAbsolutePath(), this.getRetentionDate());
            this.doCommand(cmd, null, "Set Access Time of file " + file);
        }
        if (!this.setAccessTimeAfterSetReadonly) {
            file.setReadOnly();
        }
        return filePath;
    }

    private String getRetentionDate() {
        Calendar c = Calendar.getInstance();
        c.add(CAL_FIELDS[this.retentionTime[1]], this.retentionTime[0]);
        return this.df.format(c.getTime());
    }

    public void failedHSMFile(File file, String fsID, String filePath) {
    }

    public File fetchHSMFile(String fsID, String filePath) throws HSMException {
        this.checkMount(fsID);
        return FileUtils.toFile(this.stripTarIdentifier(fsID), filePath);
    }

    public void fetchHSMFileFinished(String fsID, String filePath, File file) throws HSMException {
    }

    public Integer queryStatus(String fsID, String filePath, String userInfo) throws HSMException {
        this.checkMount(fsID);
        boolean isTar = fsID.startsWith("tar:");
        for (Map.Entry<String, Integer> entry : this.extensionStatusMap.entrySet()) {
            if (!FileUtils.toFile(isTar ? fsID.substring(4) : fsID, filePath + entry.getKey()).exists()) continue;
            if (this.checkMD5forStatusChange) {
                if (isTar) {
                    try {
                        VerifyTar.verify(FileUtils.toFile(fsID.substring(4), filePath), this.buf);
                    }
                    catch (Exception x) {
                        this.log.error((Object)("Verify tar file failed! dirPath:" + fsID + " filePath:" + filePath), (Throwable)x);
                        return -3;
                    }
                } else {
                    this.log.info((Object)"Check MD5 for Status change ignored. Not a tar filesystem!");
                }
            }
            return entry.getValue();
        }
        return this.noStatusFileStatus;
    }

    private String makeAccessTimeCommand(String file, String date) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < this.accessTimeCmd.length; ++i) {
            sb.append(this.accessTimeCmd[i] == DATE_PARAM ? date : (this.accessTimeCmd[i] == FILE_PARAM ? file : this.accessTimeCmd[i]));
        }
        return sb.toString();
    }
}

