/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4chex.archive.hsm.module;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.util.regex.Pattern;
import org.dcm4chex.archive.common.FileStatus;
import org.dcm4chex.archive.hsm.module.AbstractHSMModule;
import org.dcm4chex.archive.hsm.module.HSMException;
import org.dcm4chex.archive.util.FileUtils;

public class HSMCommandModule
extends AbstractHSMModule {
    private static final String SRC_DST_PARAM = "%p";
    private static final String FS_PARAM = "%d";
    private static final String FILE_PARAM = "%f";
    private static final String DIR_PARAM = "%d";
    private static final String INFO_PARAM = "%i";
    private String[] copyCmd;
    private String[] fetchCmd;
    private File outgoingDir;
    private File absOutgoingDir;
    private File incomingDir;
    private File absIncomingDir;
    private boolean fileIDFromStdOut;
    private int commandFailedFileStatus;
    private int nonZeroExitFileStatus;
    private int matchFileStatus;
    private int noMatchFileStatus;
    private String[] qryCmd;
    private Pattern pattern;

    public final String getCopyCommand() {
        String s = this.cmd2str(this.copyCmd);
        if (this.fileIDFromStdOut) {
            s = s + ":%f";
        }
        return s;
    }

    public final void setCopyCommand(String cmd) {
        this.fileIDFromStdOut = cmd.endsWith(":%f");
        if (this.fileIDFromStdOut) {
            cmd = cmd.substring(0, cmd.length() - 3);
        }
        this.copyCmd = this.str2cmd(cmd);
    }

    public final String getFetchCommand() {
        return this.cmd2str(this.fetchCmd);
    }

    public final void setFetchCommand(String cmd) {
        this.fetchCmd = this.str2cmd(cmd);
    }

    public final String getQueryCommand() {
        return this.cmd2str(this.qryCmd);
    }

    public final void setQueryCommand(String cmd) {
        this.qryCmd = this.str2cmd(cmd);
    }

    public final String getPattern() {
        return this.pattern.pattern();
    }

    public final void setPattern(String pattern) {
        this.pattern = Pattern.compile(pattern, 32);
    }

    public final String getNonZeroExitFileStatus() {
        return FileStatus.toString(this.nonZeroExitFileStatus);
    }

    public final void setNonZeroExitFileStatus(String status) {
        this.nonZeroExitFileStatus = FileStatus.toInt(status);
    }

    public final String getMatchFileStatus() {
        return FileStatus.toString(this.matchFileStatus);
    }

    public final void setMatchFileStatus(String status) {
        this.matchFileStatus = FileStatus.toInt(status);
    }

    public final String getNoMatchFileStatus() {
        return FileStatus.toString(this.noMatchFileStatus);
    }

    public final void setNoMatchFileStatus(String status) {
        this.noMatchFileStatus = FileStatus.toInt(status);
    }

    public final String getCommandFailedFileStatus() {
        return FileStatus.toString(this.commandFailedFileStatus);
    }

    public final void setCommandFailedFileStatus(String status) {
        this.commandFailedFileStatus = FileStatus.toInt(status);
    }

    public final String getOutgoingDir() {
        return this.outgoingDir.getPath();
    }

    public final void setOutgoingDir(String dir) {
        this.outgoingDir = new File(dir);
        this.absOutgoingDir = FileUtils.resolve(this.outgoingDir);
    }

    public final String getIncomingDir() {
        return this.incomingDir.getPath();
    }

    public final void setIncomingDir(String dir) {
        this.incomingDir = new File(dir);
        this.absIncomingDir = FileUtils.resolve(this.incomingDir);
    }

    public boolean isFileIDFromStdOut() {
        return this.fileIDFromStdOut;
    }

    public void setFileIDFromStdOut(boolean fileIDFromStdOut) {
        this.fileIDFromStdOut = fileIDFromStdOut;
    }

    public File prepareHSMFile(String fsID, String filePath) {
        String path = this.stripTarIdentifier(fsID);
        if (this.copyCmd == null) {
            return FileUtils.toFile(path + "/" + filePath);
        }
        return new File(this.absOutgoingDir, new File(filePath).getName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String storeHSMFile(File file, String fsID, String filePath) throws HSMException {
        String string;
        if (this.copyCmd == null) {
            this.log.warn((Object)"No copy command configured!");
            return filePath;
        }
        try {
            String cmd = this.makeCopyCommand(file.getPath(), fsID, filePath);
            this.log.info((Object)("Copy to HSM: " + cmd));
            ByteArrayOutputStream stdout = new ByteArrayOutputStream();
            this.doCommand(cmd, stdout, "storeHSMFile");
            string = this.fileIDFromStdOut ? stdout.toString().trim() : filePath;
            Object var8_7 = null;
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            this.log.info((Object)("M-DELETE " + file));
            file.delete();
            throw throwable;
        }
        this.log.info((Object)("M-DELETE " + file));
        file.delete();
        return string;
    }

    public void failedHSMFile(File file, String fsID, String filePath) {
    }

    public File fetchHSMFile(String fsID, String filePath) throws HSMException {
        File tarFile;
        if (this.fetchCmd == null) {
            int pos = fsID.indexOf(58);
            if (pos != -1) {
                fsID = fsID.substring(++pos);
            }
            return FileUtils.toFile(fsID, filePath);
        }
        if (this.absIncomingDir.mkdirs()) {
            this.log.info((Object)("M-WRITE " + this.absIncomingDir));
        }
        try {
            tarFile = File.createTempFile("hsm_", ".tar", this.absIncomingDir);
        }
        catch (IOException x) {
            throw new HSMException("Failed to create temp file in " + this.absIncomingDir, x);
        }
        String cmd = this.makeFetchCommand(fsID, filePath, tarFile.getPath());
        this.doCommand(cmd, null, "fetchHSMFile");
        return tarFile;
    }

    public void fetchHSMFileFinished(String fsID, String filePath, File file) throws HSMException {
        if (this.fetchCmd != null) {
            this.log.info((Object)("M-DELETE " + file));
            file.delete();
        }
    }

    public Integer queryStatus(String fsID, String filePath, String userInfo) {
        if (this.qryCmd == null) {
            this.log.warn((Object)"No QueryCommand configured! HSM File Status can not be updated!");
            return null;
        }
        String cmd = this.makeQueryCommand(fsID, filePath, userInfo);
        try {
            ByteArrayOutputStream stdout = new ByteArrayOutputStream();
            this.doCommand(cmd, stdout, "queryStatus");
            String result = stdout.toString();
            return this.pattern.matcher(result).matches() ? this.matchFileStatus : this.noMatchFileStatus;
        }
        catch (Exception e) {
            this.log.error((Object)("Failed to execute " + cmd), (Throwable)e);
            return this.commandFailedFileStatus;
        }
    }

    public boolean applyPattern(String s) {
        return this.pattern.matcher(s).matches();
    }

    private String makeCopyCommand(String srcParam, String fsID, String fileID) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < this.copyCmd.length; ++i) {
            sb.append(this.copyCmd[i] == SRC_DST_PARAM ? srcParam : (this.copyCmd[i] == "%d" ? fsID : (this.copyCmd[i] == FILE_PARAM ? fileID : this.copyCmd[i])));
        }
        return sb.toString();
    }

    private String makeFetchCommand(String fsParam, String fileParam, String dstParam) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < this.fetchCmd.length; ++i) {
            sb.append(this.fetchCmd[i] == "%d" ? fsParam : (this.fetchCmd[i] == FILE_PARAM ? fileParam : (this.fetchCmd[i] == SRC_DST_PARAM ? dstParam : this.fetchCmd[i])));
        }
        return sb.toString();
    }

    private String makeQueryCommand(String dirParam, String fileParam, String infoParam) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < this.qryCmd.length; ++i) {
            sb.append(this.qryCmd[i] == "%d" ? dirParam : (this.qryCmd[i] == FILE_PARAM ? fileParam : (this.qryCmd[i] == INFO_PARAM ? infoParam : this.qryCmd[i])));
        }
        return sb.toString();
    }
}

