/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4chex.archive.hsm.module;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.OutputStream;
import javax.management.ObjectName;
import org.dcm4che.util.Executer;
import org.dcm4cheri.util.StringUtils;
import org.dcm4chex.archive.hsm.module.HSMException;
import org.jboss.system.ServiceMBeanSupport;

public abstract class AbstractHSMModule
extends ServiceMBeanSupport {
    public static final String NONE = "NONE";
    protected ObjectName fileCopyServiceName;

    protected void startService() throws Exception {
        this.server.invoke(this.fileCopyServiceName, "registerHSMModule", new Object[]{this.getServiceName()}, new String[]{ObjectName.class.getName()});
    }

    protected void stopService() throws Exception {
        this.server.invoke(this.fileCopyServiceName, "unregisterHSMModule", new Object[]{this.getServiceName()}, new String[]{ObjectName.class.getName()});
    }

    public ObjectName getFileCopyServiceName() {
        return this.fileCopyServiceName;
    }

    public void setFileCopyServiceName(ObjectName fileCopyServiceName) {
        this.fileCopyServiceName = fileCopyServiceName;
    }

    public abstract File prepareHSMFile(String var1, String var2) throws HSMException;

    public abstract String storeHSMFile(File var1, String var2, String var3) throws HSMException;

    public abstract void failedHSMFile(File var1, String var2, String var3) throws HSMException;

    public abstract File fetchHSMFile(String var1, String var2) throws HSMException;

    public abstract void fetchHSMFileFinished(String var1, String var2, File var3) throws HSMException;

    public abstract Integer queryStatus(String var1, String var2, String var3) throws HSMException;

    protected String stripTarIdentifier(String s) {
        return s.startsWith("tar:") ? s.substring(4) : s;
    }

    protected String[] str2cmd(String cmd) {
        if (NONE.equalsIgnoreCase(cmd)) {
            return null;
        }
        String[] a = StringUtils.split(cmd, '%');
        try {
            String[] b = new String[a.length + a.length - 1];
            b[0] = a[0];
            for (int i = 1; i < a.length; ++i) {
                String s = a[i];
                b[2 * i - 1] = ("%" + s.charAt(0)).intern();
                b[2 * i] = s.substring(1);
            }
            return b;
        }
        catch (IndexOutOfBoundsException e) {
            throw new IllegalArgumentException(cmd);
        }
    }

    protected String cmd2str(String[] cmd) {
        if (cmd == null) {
            return NONE;
        }
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < cmd.length; ++i) {
            sb.append(cmd[i]);
        }
        return sb.toString();
    }

    protected void doCommand(String cmd, ByteArrayOutputStream stdout, String info) throws HSMException {
        int exit = -1;
        try {
            this.log.info((Object)(info + ": " + cmd));
            Executer ex = new Executer(cmd, (OutputStream)stdout, null);
            exit = ex.waitFor();
        }
        catch (Exception x) {
            throw new HSMException(info + " failed!", x);
        }
        if (exit != 0) {
            throw new HSMException(info + " failed! Non-zero exit code(" + exit + ") of " + cmd);
        }
    }
}

