/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4chex.archive.hsm;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.security.DigestInputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.compress.tar.TarEntry;
import org.apache.commons.compress.tar.TarInputStream;
import org.dcm4chex.archive.hsm.VerifyTarException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VerifyTar {
    private static Logger log = LoggerFactory.getLogger(VerifyTar.class);
    private static final int BUF_SIZE = 8192;
    private static final String USAGE = "Usage: java -jar verifytar.jar [-p<num>] <file or directory path>[..]\n\n -p<num>  Strip the smallest prefix containing <num> leading slashes from each\n          file name prompted to stdout.";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map<String, byte[]> verify(File file, byte[] buf) throws IOException, VerifyTarException {
        Map<String, byte[]> map;
        FileInputStream in = new FileInputStream(file);
        try {
            map = VerifyTar.verify(in, file.toString(), buf);
            Object var5_4 = null;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            in.close();
            throw throwable;
        }
        in.close();
        return map;
    }

    public static Map<String, byte[]> verify(InputStream in, String tarname, byte[] buf) throws IOException, VerifyTarException {
        return VerifyTar.verify(in, tarname, buf, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map<String, byte[]> verify(InputStream in, String tarname, byte[] buf, ArrayList<String> objectNames) throws IOException, VerifyTarException {
        HashMap<String, byte[]> hashMap;
        TarInputStream tar = new TarInputStream(in);
        try {
            MessageDigest digest;
            String line;
            log.debug("Verify tar file: {}", (Object)tarname);
            TarEntry entry = tar.getNextEntry();
            if (entry == null) {
                throw new VerifyTarException("No entries in " + tarname);
            }
            String entryName = entry.getName();
            if (!"MD5SUM".equals(entryName)) {
                throw new VerifyTarException("Missing MD5SUM entry in " + tarname);
            }
            BufferedReader dis = new BufferedReader(new InputStreamReader((InputStream)tar));
            HashMap<String, byte[]> md5sums = new HashMap<String, byte[]>();
            while ((line = dis.readLine()) != null) {
                char[] c = line.toCharArray();
                byte[] md5sum = new byte[16];
                int i = 0;
                int j = 0;
                while (i < md5sum.length) {
                    md5sum[i] = (byte)(VerifyTar.fromHexDigit(c[j]) << 4 | VerifyTar.fromHexDigit(c[j + 1]));
                    ++i;
                    ++j;
                    ++j;
                }
                md5sums.put(line.substring(34), md5sum);
            }
            HashMap<String, byte[]> entries = new HashMap<String, byte[]>(md5sums.size());
            entries.putAll(md5sums);
            try {
                digest = MessageDigest.getInstance("MD5");
            }
            catch (NoSuchAlgorithmException e) {
                throw new RuntimeException(e);
            }
            while ((entry = tar.getNextEntry()) != null) {
                entryName = entry.getName();
                log.debug("START: Check MD5 of entry: {}", (Object)entryName);
                if (objectNames != null && !objectNames.remove(entryName)) {
                    throw new VerifyTarException("TAR " + tarname + " contains entry: " + entryName + " not in file list");
                }
                byte[] md5sum = (byte[])md5sums.remove(entryName);
                if (md5sum == null) {
                    throw new VerifyTarException("Unexpected TAR entry: " + entryName + " in " + tarname);
                }
                digest.reset();
                in = new DigestInputStream((InputStream)tar, digest);
                while (in.read(buf) > 0) {
                }
                if (!Arrays.equals(digest.digest(), md5sum)) {
                    throw new VerifyTarException("Failed MD5 check of TAR entry: " + entryName + " in " + tarname);
                }
                log.debug("DONE: Check MD5 of entry: {}", (Object)entryName);
            }
            if (!md5sums.isEmpty()) {
                throw new VerifyTarException("Missing TAR entries: " + md5sums.keySet() + " in " + tarname);
            }
            if (objectNames != null && !objectNames.isEmpty()) {
                throw new VerifyTarException("Missing TAR entries from object list: " + objectNames.toString() + " in " + tarname);
            }
            hashMap = entries;
            Object var15_18 = null;
        }
        catch (Throwable throwable) {
            Object var15_19 = null;
            tar.close();
            throw throwable;
        }
        tar.close();
        return hashMap;
    }

    public static int fromHexDigit(char c) {
        return c - (c <= '9' ? 48 : (c <= 'F' ? 65 : 97) - 10);
    }

    public static void main(String[] args) {
        if (args.length == 0) {
            System.out.println(USAGE);
            System.exit(-1);
        }
        int off = 0;
        int strip = 0;
        if (args[0].startsWith("-p")) {
            try {
                strip = Integer.parseInt(args[0].substring(2));
                off = 1;
            }
            catch (NumberFormatException e) {
                System.out.println(USAGE);
                System.exit(-1);
            }
        }
        int errors = 0;
        byte[] buf = new byte[8192];
        for (int i = off; i < args.length; ++i) {
            try {
                errors += VerifyTar.verify(new File(args[i]), strip, buf);
                continue;
            }
            catch (FileNotFoundException e) {
                System.err.println(e.getMessage());
                System.exit(-2);
            }
        }
        System.exit(errors);
    }

    private static int verify(File file, int strip, byte[] buf) throws FileNotFoundException {
        int errors = 0;
        if (file.isDirectory()) {
            String[] ss = file.list();
            for (int i = 0; i < ss.length; ++i) {
                errors += VerifyTar.verify(new File(file, ss[i]), strip, buf);
            }
        } else {
            String tarname = file.getPath();
            try {
                int pos = 0;
                while (strip-- > 0 && (pos = tarname.indexOf(File.separatorChar, pos)) != -1) {
                    ++pos;
                }
                if (pos != -1) {
                    log.info(tarname.substring(pos) + ' ');
                }
                VerifyTar.verify(file, buf);
                log.info("ok");
            }
            catch (Exception e) {
                errors = 1;
                log.error("Failed to create substring", (Object)e.getMessage());
            }
        }
        return errors;
    }
}

