/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4chex.archive.hsm;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.security.DigestInputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.apache.commons.compress.tar.TarEntry;
import org.apache.commons.compress.tar.TarInputStream;
import org.dcm4che.util.MD5Utils;
import org.dcm4chex.archive.hsm.VerifyTarException;
import org.dcm4chex.archive.util.CacheJournal;
import org.dcm4chex.archive.util.FileSystemUtils;
import org.dcm4chex.archive.util.FileUtils;
import org.jboss.system.ServiceMBeanSupport;

public class TarRetrieverService
extends ServiceMBeanSupport {
    private static final String NONE = "NONE";
    private static final Set<String> extracting = Collections.synchronizedSet(new HashSet());
    private String dataRootDir;
    private String journalRootDir;
    private CacheJournal journal = new CacheJournal();
    private long minFreeDiskSpace;
    private long prefFreeDiskSpace;
    private ObjectName hsmModuleServicename = null;
    private int bufferSize = 8192;
    private boolean checkMD5 = true;

    public String getCacheRoot() {
        return this.dataRootDir;
    }

    public void setCacheRoot(String dataRootDir) {
        this.journal.setDataRootDir(FileUtils.resolve(new File(dataRootDir)));
        this.dataRootDir = dataRootDir;
    }

    public String getCacheJournalRootDir() {
        return this.journalRootDir;
    }

    public void setCacheJournalRootDir(String journalRootDir) {
        this.journal.setJournalRootDir(FileUtils.resolve(new File(journalRootDir)));
        this.journalRootDir = journalRootDir;
    }

    public String getCacheJournalFilePathFormat() {
        return this.journal.getJournalFilePathFormat();
    }

    public void setCacheJournalFilePathFormat(String journalFilePathFormat) {
        if (this.getState() == 3) {
            if (journalFilePathFormat.equals(this.getCacheJournalFilePathFormat())) {
                return;
            }
            if (!this.journal.isEmpty()) {
                throw new IllegalStateException("cache not empty!");
            }
        }
        this.journal.setJournalFilePathFormat(journalFilePathFormat);
    }

    public boolean isCheckMD5() {
        return this.checkMD5;
    }

    public void setCheckMD5(boolean checkMD5) {
        this.checkMD5 = checkMD5;
    }

    public final int getBufferSize() {
        return this.bufferSize;
    }

    public final void setBufferSize(int bufferSize) {
        this.bufferSize = bufferSize;
    }

    public final String getMinFreeDiskSpace() {
        return FileUtils.formatSize(this.minFreeDiskSpace);
    }

    public final void setMinFreeDiskSpace(String s) {
        this.minFreeDiskSpace = FileUtils.parseSize(s, 0L);
    }

    public final String getPreferredFreeDiskSpace() {
        return FileUtils.formatSize(this.prefFreeDiskSpace);
    }

    public final void setPreferredFreeDiskSpace(String s) {
        this.prefFreeDiskSpace = FileUtils.parseSize(s, 0L);
    }

    public String getFreeDiskSpace() throws IOException {
        File dir = this.journal.getDataRootDir();
        return dir == null || !dir.exists() ? "N/A" : FileUtils.formatSize(FileSystemUtils.freeSpace(dir.getPath()));
    }

    public final String getHSMModulServicename() {
        return this.hsmModuleServicename == null ? NONE : this.hsmModuleServicename.toString();
    }

    public final void setHSMModulServicename(String name) throws MalformedObjectNameException {
        this.hsmModuleServicename = NONE.equals(name) ? null : ObjectName.getInstance(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public File retrieveFileFromTAR(String fsID, String fileID) throws IOException, VerifyTarException {
        String fpath;
        if (!fsID.startsWith("tar:")) {
            throw new IllegalArgumentException("Not a tar file system: " + fsID);
        }
        int tarEnd = fileID.indexOf(33);
        if (tarEnd == -1) {
            throw new IllegalArgumentException("Missing ! in " + fileID);
        }
        String tarPath = fileID.substring(0, tarEnd);
        File cacheDir = new File(this.journal.getDataRootDir(), tarPath.replace('/', File.separatorChar));
        File f = new File(cacheDir, fpath = fileID.substring(tarEnd + 1).replace('/', File.separatorChar));
        if (f.exists()) {
            this.journal.record(cacheDir, true);
            return f;
        }
        boolean extracted = false;
        if (extracting.add(tarPath)) {
            Set<String> set;
            try {
                this.fetchAndExtractTar(fsID, tarPath, cacheDir);
                extracted = true;
                Object var10_9 = null;
                set = extracting;
            }
            catch (Throwable throwable) {
                Object var10_10 = null;
                Set<String> set2 = extracting;
                synchronized (set2) {
                    extracting.remove(tarPath);
                    extracting.notifyAll();
                }
                throw throwable;
            }
            synchronized (set) {
                extracting.remove(tarPath);
                extracting.notifyAll();
            }
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Wait for concurrent fetch and extract of tar: " + tarPath));
        }
        Set<String> set = extracting;
        synchronized (set) {
            while (extracting.contains(tarPath)) {
                try {
                    extracting.wait();
                }
                catch (InterruptedException e) {
                    this.log.warn((Object)("Wait for concurrent fetch and extract of tar: " + tarPath + " interrupted:"), (Throwable)e);
                }
            }
        }
        this.journal.record(cacheDir, !extracted);
        if (!f.exists()) {
            this.log.error((Object)("Tar file " + tarPath + " doesn't contain file " + fpath + "!"));
            throw new FileNotFoundException(f.getPath());
        }
        return f;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fetchAndExtractTar(String fsID, String tarPath, File cacheDir) throws IOException, VerifyTarException {
        File tarFile = this.fetchTarFile(fsID, tarPath);
        try {
            this.extractTar(tarFile, cacheDir);
            Object var6_5 = null;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            this.fetchHSMFileFinished(fsID, tarPath, tarFile);
            throw throwable;
        }
        this.fetchHSMFileFinished(fsID, tarPath, tarFile);
    }

    public File fetchTarFile(String fsID, String tarPath) throws IOException {
        return this.hsmModuleServicename == null ? FileUtils.toFile(fsID.substring(4), tarPath) : this.fetchHSMFile(fsID, tarPath);
    }

    private File fetchHSMFile(String fsID, String tarPath) throws IOException {
        try {
            return (File)this.server.invoke(this.hsmModuleServicename, "fetchHSMFile", new Object[]{fsID, tarPath}, new String[]{String.class.getName(), String.class.getName()});
        }
        catch (Exception x) {
            this.log.error((Object)("Fetch of HSMFile failed! fsID:" + fsID + " tarPath:" + tarPath), (Throwable)x);
            IOException iox = new IOException("Fetch of HSMFile failed!");
            iox.initCause(x);
            throw iox;
        }
    }

    private void fetchHSMFileFinished(String fsID, String tarPath, File tarFile) throws IOException {
        if (this.hsmModuleServicename != null) {
            try {
                this.server.invoke(this.hsmModuleServicename, "fetchHSMFileFinished", new Object[]{fsID, tarPath, tarFile}, new String[]{String.class.getName(), String.class.getName(), File.class.getName()});
            }
            catch (Exception x) {
                this.log.warn((Object)("fetchHSMFileFinished! fsID:" + fsID + " tarPath:" + tarPath + " tarFile:" + tarFile), (Throwable)x);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void extractTar(File tarFile, File cacheDir) throws IOException, VerifyTarException {
        int count = 0;
        long totalSize = 0L;
        long free = FileSystemUtils.freeSpace(this.journal.getDataRootDir().getPath());
        long fsize = tarFile.length();
        long toDelete = fsize + this.minFreeDiskSpace - free;
        if (toDelete > 0L) {
            free += this.free(toDelete);
        }
        byte[] buf = new byte[this.bufferSize];
        TarInputStream tar = new TarInputStream((InputStream)new FileInputStream(tarFile));
        Object in = tar;
        try {
            TarEntry entry = this.skipDirectoryEntries(tar);
            if (entry == null) {
                throw new IOException("No entries in " + tarFile);
            }
            String entryName = entry.getName();
            HashMap<String, byte[]> md5sums = null;
            MessageDigest digest = null;
            if ("MD5SUM".equals(entryName)) {
                if (this.checkMD5) {
                    String line;
                    try {
                        digest = MessageDigest.getInstance("MD5");
                    }
                    catch (NoSuchAlgorithmException e) {
                        throw new RuntimeException(e);
                    }
                    md5sums = new HashMap<String, byte[]>();
                    BufferedReader lineReader = new BufferedReader(new InputStreamReader((InputStream)tar));
                    while ((line = lineReader.readLine()) != null) {
                        md5sums.put(line.substring(34), MD5Utils.toBytes(line.substring(0, 32)));
                    }
                }
                entry = this.skipDirectoryEntries(tar);
            } else if (this.checkMD5) {
                this.getLog().warn((Object)("Missing MD5SUM entry in " + tarFile));
            }
            while (entry != null) {
                Exception ignore2;
                Object var27_23;
                File fOri;
                File f;
                File dir;
                entryName = entry.getName();
                byte[] md5sum = null;
                if (md5sums != null && digest != null) {
                    md5sum = (byte[])md5sums.remove(entryName);
                    if (md5sum == null) {
                        throw new VerifyTarException("Unexpected TAR entry: " + entryName + " in " + tarFile);
                    }
                    digest.reset();
                    in = new DigestInputStream((InputStream)tar, digest);
                }
                if ((dir = (f = new File((fOri = new File(cacheDir, entryName.replace('/', File.separatorChar))).getAbsolutePath() + ".tmp")).getParentFile()).mkdirs()) {
                    this.log.info((Object)("M-WRITE " + dir));
                }
                this.log.info((Object)("M-WRITE " + f));
                FileOutputStream out = new FileOutputStream(f);
                boolean cleanup = true;
                try {
                    int len;
                    while ((len = ((InputStream)in).read(buf)) > 0) {
                        out.write(buf, 0, len);
                    }
                    cleanup = false;
                    var27_23 = null;
                }
                catch (Throwable throwable) {
                    var27_23 = null;
                    try {
                        out.close();
                    }
                    catch (Exception ignore2) {
                        // empty catch block
                    }
                    if (cleanup) {
                        this.log.info((Object)("M-DELETE " + f));
                        f.delete();
                    }
                    throw throwable;
                }
                try {
                    out.close();
                }
                catch (Exception ignore2) {
                    // empty catch block
                }
                if (cleanup) {
                    this.log.info((Object)("M-DELETE " + f));
                    f.delete();
                }
                if (md5sums != null && digest != null) {
                    if (!Arrays.equals(digest.digest(), md5sum)) {
                        this.log.info((Object)("M-DELETE " + f));
                        f.delete();
                        throw new VerifyTarException("Failed MD5 check of TAR entry: " + entryName + " in " + tarFile);
                    }
                    this.log.info((Object)("MD5 check is successful for " + entryName + " in " + tarFile));
                }
                free -= f.length();
                ++count;
                totalSize += f.length();
                if (f.exists()) {
                    f.renameTo(fOri);
                }
                entry = this.skipDirectoryEntries(tar);
            }
            Object var30_26 = null;
        }
        catch (Throwable throwable) {
            Object var30_27 = null;
            tar.close();
            throw throwable;
        }
        tar.close();
        toDelete = this.prefFreeDiskSpace - free;
        if (toDelete > 0L) {
            this.freeNonBlocking(toDelete);
        }
    }

    private TarEntry skipDirectoryEntries(TarInputStream tar) throws IOException {
        TarEntry entry = tar.getNextEntry();
        while (entry != null) {
            if (!entry.isDirectory()) {
                return entry;
            }
            entry = tar.getNextEntry();
        }
        return null;
    }

    private void freeNonBlocking(final long toDelete) {
        new Thread(new Runnable(){

            public void run() {
                try {
                    TarRetrieverService.this.free(toDelete);
                }
                catch (IOException e) {
                    TarRetrieverService.this.log.error((Object)e.getMessage(), (Throwable)e);
                }
            }
        }).start();
    }

    public long free(long size) throws IOException {
        this.log.info((Object)("Start deleting LRU directories of at least " + size + " bytes from TAR cache"));
        long deleted = this.journal.free(size);
        this.log.info((Object)("Finished deleting LRU directories with " + deleted + " bytes from TAR cache"));
        return deleted;
    }
}

