/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4chex.archive.hsm;

import java.io.File;
import java.io.IOException;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanException;
import javax.management.MalformedObjectNameException;
import javax.management.Notification;
import javax.management.NotificationListener;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import org.dcm4chex.archive.common.FileStatus;
import org.dcm4chex.archive.config.RetryIntervalls;
import org.dcm4chex.archive.ejb.interfaces.FileDTO;
import org.dcm4chex.archive.ejb.interfaces.FileSystemMgt2;
import org.dcm4chex.archive.ejb.interfaces.FileSystemMgt2Home;
import org.dcm4chex.archive.ejb.interfaces.MD5;
import org.dcm4chex.archive.exceptions.ConfigurationException;
import org.dcm4chex.archive.hsm.VerifyTar;
import org.dcm4chex.archive.hsm.VerifyTarException;
import org.dcm4chex.archive.mbean.SchedulerDelegate;
import org.dcm4chex.archive.util.EJBHomeFactory;
import org.jboss.system.ServiceMBeanSupport;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SyncFileStatusService
extends ServiceMBeanSupport {
    private static final String NONE = "NONE";
    private static final String DELETE = "DELETE";
    private static final String NEWLINE = System.getProperty("line.separator", "\n");
    private final SchedulerDelegate scheduler = new SchedulerDelegate(this);
    private String timerIDCheckSyncFileStatus;
    private boolean isRunning;
    private long minFileAge = 0L;
    private long taskInterval = 0L;
    private int disabledStartHour;
    private int disabledEndHour;
    private int limitNumberOfFilesPerTask;
    private int checkFileStatus;
    private String fileSystem = null;
    private Integer listenerID;
    private ObjectName hsmModuleServicename = null;
    private ObjectName tarRetrieverName;
    private Timestamp oldestCreatedTimeOfCheckFileStatus;
    private long nextUpdate;
    private boolean verifyTar;
    private HashMap<Integer, Integer> skipVerifyTarHSMStati = new HashMap();
    private int notInTarStatus;
    private int invalidTarStatus;
    private byte[] buf = new byte[8192];
    private final NotificationListener timerListener = new NotificationListener(){

        public void handleNotification(Notification notif, Object handback) {
            Calendar cal;
            int hour;
            if (SyncFileStatusService.this.fileSystem == null) {
                SyncFileStatusService.this.log.debug((Object)"SyncFileStatus disabled (fileSystem=NONE)!");
            }
            if (SyncFileStatusService.this.isDisabled(hour = (cal = Calendar.getInstance()).get(11))) {
                if (SyncFileStatusService.this.log.isDebugEnabled()) {
                    SyncFileStatusService.this.log.debug((Object)("SyncFileStatus ignored in time between " + SyncFileStatusService.this.disabledStartHour + " and " + SyncFileStatusService.this.disabledEndHour + " !"));
                }
            } else {
                new Thread(new Runnable(){

                    public void run() {
                        try {
                            SyncFileStatusService.this.check();
                        }
                        catch (Exception e) {
                            SyncFileStatusService.this.log.error((Object)"check file status failed!", (Throwable)e);
                        }
                    }
                }).start();
            }
        }
    };

    public final ObjectName getTarRetrieverName() {
        return this.tarRetrieverName;
    }

    public final void setTarRetrieverName(ObjectName tarRetrieverName) {
        this.tarRetrieverName = tarRetrieverName;
    }

    public ObjectName getSchedulerServiceName() {
        return this.scheduler.getSchedulerServiceName();
    }

    public void setSchedulerServiceName(ObjectName schedulerServiceName) {
        this.scheduler.setSchedulerServiceName(schedulerServiceName);
    }

    public final String getFileSystem() {
        return this.fileSystem == null ? NONE : this.fileSystem;
    }

    public final void setFileSystem(String fileSystem) {
        this.fileSystem = NONE.equalsIgnoreCase(fileSystem) ? null : fileSystem;
    }

    public final String getCheckFileStatus() {
        return FileStatus.toString(this.checkFileStatus);
    }

    public final void setCheckFileStatus(String status) {
        this.checkFileStatus = FileStatus.toInt(status);
    }

    public boolean isVerifyTar() {
        return this.verifyTar;
    }

    public void setVerifyTar(boolean verifyTar) {
        this.verifyTar = verifyTar;
    }

    public String getSkipVerifyTarHSMStati() {
        if (this.skipVerifyTarHSMStati.isEmpty()) {
            return NONE;
        }
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<Integer, Integer> e : this.skipVerifyTarHSMStati.entrySet()) {
            sb.append(FileStatus.toString(e.getKey()));
            if (e.getValue() != null) {
                int newStatus = e.getValue();
                sb.append('=').append(newStatus == Integer.MIN_VALUE ? DELETE : FileStatus.toString(newStatus));
            }
            sb.append(NEWLINE);
        }
        return sb.toString();
    }

    public void setSkipVerifyTarHSMStati(String s) {
        if (NONE.equals(s)) {
            this.skipVerifyTarHSMStati.clear();
        } else {
            HashMap<Integer, Integer> stati = new HashMap<Integer, Integer>();
            StringTokenizer st = new StringTokenizer(s, "\n\t\r,;");
            while (st.hasMoreElements()) {
                String tk = st.nextToken();
                int pos = tk.indexOf(61);
                if (pos == -1) {
                    stati.put(FileStatus.toInt(tk), null);
                } else {
                    String ns = tk.substring(pos + 1);
                    int newStatus = DELETE.equals(ns) ? Integer.MIN_VALUE : FileStatus.toInt(ns);
                    stati.put(FileStatus.toInt(tk.substring(0, pos)), newStatus);
                }
                this.skipVerifyTarHSMStati = stati;
            }
        }
    }

    public String getInvalidTarStatus() {
        return this.invalidTarStatus == Integer.MIN_VALUE ? DELETE : FileStatus.toString(this.invalidTarStatus);
    }

    public void setInvalidTarStatus(String status) {
        this.invalidTarStatus = DELETE.equals(status) ? Integer.MIN_VALUE : FileStatus.toInt(status);
    }

    public String getNotInTarStatus() {
        return this.notInTarStatus == Integer.MIN_VALUE ? DELETE : FileStatus.toString(this.notInTarStatus);
    }

    public void setNotInTarStatus(String status) {
        this.notInTarStatus = DELETE.equals(status) ? Integer.MIN_VALUE : FileStatus.toInt(status);
    }

    public final String getTaskInterval() {
        String s = RetryIntervalls.formatIntervalZeroAsNever(this.taskInterval);
        return this.disabledEndHour == -1 ? s : s + "!" + this.disabledStartHour + "-" + this.disabledEndHour;
    }

    public void setTaskInterval(String interval) throws Exception {
        long oldInterval = this.taskInterval;
        int pos = interval.indexOf(33);
        if (pos == -1) {
            this.taskInterval = RetryIntervalls.parseIntervalOrNever(interval);
            this.disabledEndHour = -1;
        } else {
            this.taskInterval = RetryIntervalls.parseIntervalOrNever(interval.substring(0, pos));
            int pos1 = interval.indexOf(45, pos);
            this.disabledStartHour = Integer.parseInt(interval.substring(pos + 1, pos1));
            this.disabledEndHour = Integer.parseInt(interval.substring(pos1 + 1));
        }
        if (this.getState() == 3 && oldInterval != this.taskInterval) {
            this.scheduler.stopScheduler(this.timerIDCheckSyncFileStatus, this.listenerID, this.timerListener);
            this.listenerID = this.scheduler.startScheduler(this.timerIDCheckSyncFileStatus, this.taskInterval, this.timerListener);
        }
    }

    public final String getMinimumFileAge() {
        return RetryIntervalls.formatInterval(this.minFileAge);
    }

    public final void setMinimumFileAge(String intervall) {
        this.minFileAge = RetryIntervalls.parseInterval(intervall);
    }

    public int getLimitNumberOfFilesPerTask() {
        return this.limitNumberOfFilesPerTask;
    }

    public void setLimitNumberOfFilesPerTask(int limit) {
        this.limitNumberOfFilesPerTask = limit;
    }

    public String getOldestCreatedTimeOfCheckFileStatus() {
        return this.oldestCreatedTimeOfCheckFileStatus == null ? "UNKNOWN" : new SimpleDateFormat("yyyy/MM/dd hh:mm:ss").format(this.oldestCreatedTimeOfCheckFileStatus);
    }

    public void updateOldestCreatedTimeOfCheckFileStatus() {
        this.log.info((Object)("Start updateOldestCreatedTimeOfCheckFileStatus! current:" + this.oldestCreatedTimeOfCheckFileStatus));
        try {
            this.oldestCreatedTimeOfCheckFileStatus = this.newFileSystemMgt().minCreatedTimeOnFsWithFileStatus(this.fileSystem, this.checkFileStatus);
            if (this.oldestCreatedTimeOfCheckFileStatus == null) {
                this.nextUpdate = System.currentTimeMillis() + this.minFileAge;
                this.log.info((Object)("OldestCreatedTimeOfCheckFileStatus is null! -> There is no file with fileStatus=" + this.checkFileStatus + " on filesystem=" + this.fileSystem));
                this.log.info((Object)("Next update of OldestCreatedTimeOfCheckFileStatus in " + this.getMinimumFileAge() + " (when new files are old enough to be considered)"));
            } else {
                Calendar cal = Calendar.getInstance();
                cal.set(11, 23);
                cal.set(12, 59);
                cal.set(13, 59);
                cal.set(14, 999);
                this.nextUpdate = cal.getTimeInMillis();
                this.log.info((Object)("OldestCreatedTimeOfCheckFileStatus updated to " + this.oldestCreatedTimeOfCheckFileStatus + " ! Next update after midnight."));
            }
        }
        catch (Exception x) {
            this.log.warn((Object)"Update OldestCreatedTimeOfCheckFileStatus failed!", (Throwable)x);
        }
    }

    public final String getHSMModulServicename() {
        return this.hsmModuleServicename == null ? NONE : this.hsmModuleServicename.toString();
    }

    public final void setHSMModulServicename(String name) throws MalformedObjectNameException {
        this.hsmModuleServicename = NONE.equals(name) ? null : ObjectName.getInstance(name);
    }

    private boolean isDisabled(int hour) {
        boolean inside;
        if (this.disabledEndHour == -1) {
            return false;
        }
        boolean sameday = this.disabledStartHour <= this.disabledEndHour;
        boolean bl = inside = hour >= this.disabledStartHour && hour < this.disabledEndHour;
        return sameday ? inside : !inside;
    }

    public boolean isRunning() {
        return this.isRunning;
    }

    protected void startService() throws Exception {
        this.listenerID = this.scheduler.startScheduler(this.timerIDCheckSyncFileStatus, this.taskInterval, this.timerListener);
    }

    protected void stopService() throws Exception {
        this.scheduler.stopScheduler(this.timerIDCheckSyncFileStatus, this.listenerID, this.timerListener);
        super.stopService();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int check() throws Exception {
        FileDTO[] c;
        FileSystemMgt2 fsmgt;
        block14: {
            block13: {
                if (this.fileSystem == null) {
                    return 0;
                }
                if (this.hsmModuleServicename == null) {
                    this.log.warn((Object)"HSM Module Servicename not configured! SyncFileStatusService disabled!");
                    return 0;
                }
                SyncFileStatusService syncFileStatusService = this;
                synchronized (syncFileStatusService) {
                    if (this.isRunning) {
                        this.log.info((Object)"SyncFileStatus is already running!");
                        return -1;
                    }
                    this.isRunning = true;
                }
                if (this.oldestCreatedTimeOfCheckFileStatus == null || System.currentTimeMillis() > this.nextUpdate) {
                    this.updateOldestCreatedTimeOfCheckFileStatus();
                }
                if (this.oldestCreatedTimeOfCheckFileStatus != null) break block13;
                this.log.info((Object)"OldestCreatedTimeOfCheckFileStatus is null! SyncFileStatus skipped!");
                int n = 0;
                Object var8_5 = null;
                this.isRunning = false;
                return n;
            }
            this.log.info((Object)"Start SyncFileStatus!");
            fsmgt = this.newFileSystemMgt();
            c = fsmgt.findFilesByStatusAndFileSystem(this.fileSystem, this.checkFileStatus, this.oldestCreatedTimeOfCheckFileStatus, new Timestamp(System.currentTimeMillis() - this.minFileAge), this.limitNumberOfFilesPerTask);
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("found " + c.length + " files to check status."));
            }
            if (c.length != 0) break block14;
            int n = 0;
            Object var8_6 = null;
            this.isRunning = false;
            return n;
        }
        try {
            int count = 0;
            HashMap<String, Integer> checkedTarsStatus = new HashMap<String, Integer>();
            HashMap<String, Map<String, byte[]>> checkedTarsMD5 = this.verifyTar ? new HashMap<String, Map<String, byte[]>>() : null;
            for (int i = 0; i < c.length; ++i) {
                if (!this.check(fsmgt, c[i], checkedTarsStatus, checkedTarsMD5)) continue;
                ++count;
            }
            this.log.info((Object)("SyncFileStatus finished! changed files:" + count));
            int n = count;
            Object var8_7 = null;
            this.isRunning = false;
            return n;
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            this.isRunning = false;
            throw throwable;
        }
    }

    private boolean check(FileSystemMgt2 fsmgt, FileDTO fileDTO, HashMap<String, Integer> checkedTarsStatus, HashMap<String, Map<String, byte[]>> checkedTarsMD5) throws IOException, VerifyTarException {
        Integer status;
        String fsId = fileDTO.getDirectoryPath();
        String filePath = fileDTO.getFilePath();
        String tarPathKey = null;
        if (fsId.startsWith("tar:")) {
            String tarfilePath = filePath.substring(0, filePath.indexOf(33));
            tarPathKey = fsId.substring(4) + '/' + tarfilePath;
            status = checkedTarsStatus.get(tarPathKey);
            Integer tarStatus = null;
            if (status == null) {
                status = this.queryHSM(fsId, tarfilePath, fileDTO.getUserInfo());
                checkedTarsStatus.put(tarPathKey, status);
                if (this.verifyTar) {
                    tarStatus = this.checkSkipVerifyTarStatus(status, fileDTO) ? this.skipVerifyTarHSMStati.get(status) : this.verifyTar(fileDTO, tarPathKey, checkedTarsMD5);
                }
            } else if (this.verifyTar) {
                tarStatus = this.checkSkipVerifyTarStatus(status, fileDTO) ? this.skipVerifyTarHSMStati.get(status) : this.checkFileInTar(fileDTO, tarPathKey, checkedTarsMD5.get(tarPathKey));
            }
            if (tarStatus != null) {
                status = tarStatus;
            }
        } else {
            status = this.queryHSM(fsId, filePath, fileDTO.getUserInfo());
        }
        return status == null ? false : (status == Integer.MIN_VALUE ? true : this.updateFileStatus(fsmgt, fileDTO, status));
    }

    private boolean checkSkipVerifyTarStatus(Integer status, FileDTO dto) {
        if (this.skipVerifyTarHSMStati.containsKey(status)) {
            Integer tarStatus = this.skipVerifyTarHSMStati.get(status);
            if (tarStatus != null && tarStatus == Integer.MIN_VALUE) {
                this.log.error((Object)("Delete file entity for skipVerifyTarHSMStati " + FileStatus.toString(status) + " mapped to DELETE:" + dto.getFilePath()));
                this.deleteFileOnTarFS(dto);
            }
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Integer verifyTar(FileDTO dto, String tarPathKey, HashMap<String, Map<String, byte[]>> checkedTarsMD5) {
        this.log.info((Object)("Verify tar file " + tarPathKey));
        String filePath = dto.getFilePath();
        String tarfilePath = filePath.substring(0, filePath.indexOf(33));
        Map<String, byte[]> entries = null;
        if (checkedTarsMD5.containsKey(tarPathKey)) {
            entries = checkedTarsMD5.get(tarPathKey);
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("entries of checked tar file " + tarPathKey + " :" + entries));
            }
        } else {
            File tarFile = null;
            try {
                try {
                    tarFile = this.fetchTarFile(dto.getDirectoryPath(), tarfilePath);
                    entries = VerifyTar.verify(tarFile, this.buf);
                }
                catch (Exception x) {
                    this.log.error((Object)("Verification of tar file " + tarPathKey + " failed! Reason:" + x.getMessage()));
                    if (this.invalidTarStatus == Integer.MIN_VALUE) {
                        try {
                            this.log.error((Object)("Delete file entities of invalid tar file :" + tarfilePath));
                            this.newFileSystemMgt().deleteFilesOfInvalidTarFile(dto.getDirectoryPath(), tarfilePath);
                        }
                        catch (Exception e) {
                            this.log.error((Object)("Failed to delete files of invalid tar file! tarFile:" + tarfilePath));
                        }
                    }
                    Object var11_9 = null;
                    if (tarFile != null) {
                        this.fetchTarFileFinished(dto.getDirectoryPath(), tarfilePath, tarFile);
                    }
                }
                Object var11_8 = null;
                if (tarFile != null) {
                    this.fetchTarFileFinished(dto.getDirectoryPath(), tarfilePath, tarFile);
                }
            }
            catch (Throwable throwable) {
                Object var11_10 = null;
                if (tarFile != null) {
                    this.fetchTarFileFinished(dto.getDirectoryPath(), tarfilePath, tarFile);
                }
                throw throwable;
            }
            checkedTarsMD5.put(tarPathKey, entries);
        }
        return this.checkFileInTar(dto, tarPathKey, entries);
    }

    private Integer checkFileInTar(FileDTO dto, String tarPathKey, Map<String, byte[]> entries) {
        String filePath = dto.getFilePath();
        String filepathInTar = filePath.substring(filePath.indexOf(33) + 1);
        if (entries == null) {
            this.log.error((Object)("TAR file " + tarPathKey + " not valid -> " + (this.invalidTarStatus == Integer.MIN_VALUE ? "File is deleted!" : "set status to " + FileStatus.toString(this.invalidTarStatus))));
            return this.invalidTarStatus;
        }
        byte[] md5 = entries.get(filepathInTar);
        if (md5 == null) {
            this.log.error((Object)("Tar File " + tarPathKey + " does NOT contain File " + filepathInTar));
            if (this.notInTarStatus == Integer.MIN_VALUE) {
                this.log.error((Object)("Delete file entity that is missing in tar file:" + filePath));
                this.deleteFileOnTarFS(dto);
            } else {
                this.log.error((Object)("Set file status to " + FileStatus.toString(this.notInTarStatus)));
            }
            return this.notInTarStatus;
        }
        if (!Arrays.equals(dto.getFileMd5(), md5)) {
            this.log.error((Object)("Tar File " + tarPathKey + ": MD5 of File " + filepathInTar + " is NOT equal to MD5 of file entity! (" + MD5.toString(md5) + " vs. " + dto.getMd5String() + ")"));
            return this.invalidTarStatus;
        }
        return null;
    }

    private void deleteFileOnTarFS(FileDTO dto) {
        try {
            this.newFileSystemMgt().deleteFileOnTarFs(dto.getDirectoryPath(), dto.getPk());
        }
        catch (Exception e) {
            this.log.error((Object)("Failed to delete file entity! filePath:" + dto.getFilePath()));
        }
    }

    private File fetchTarFile(String fsID, String tarPath) throws Exception {
        try {
            return (File)this.server.invoke(this.tarRetrieverName, "fetchTarFile", new Object[]{fsID, tarPath}, new String[]{String.class.getName(), String.class.getName()});
        }
        catch (InstanceNotFoundException e) {
            throw new ConfigurationException(e.getMessage(), e);
        }
        catch (MBeanException e) {
            throw e.getTargetException();
        }
        catch (ReflectionException e) {
            throw new ConfigurationException(e.getMessage(), e);
        }
    }

    private void fetchTarFileFinished(String fsID, String tarPath, File tarFile) {
        try {
            String tarRetrieverHSMModule = (String)this.server.getAttribute(this.tarRetrieverName, "HSMModulServicename");
            if (!NONE.equals(tarRetrieverHSMModule)) {
                this.server.invoke(new ObjectName(tarRetrieverHSMModule), "fetchHSMFileFinished", new Object[]{fsID, tarPath, tarFile}, new String[]{String.class.getName(), String.class.getName(), File.class.getName()});
            }
        }
        catch (Exception x) {
            this.log.warn((Object)("fetchHSMFileFinished failed! fsID:" + fsID + " tarPath:" + tarPath + " tarFile:" + tarFile), (Throwable)x);
        }
    }

    private boolean updateFileStatus(FileSystemMgt2 fsmgt, FileDTO fileDTO, int status) {
        if (fileDTO.getFileStatus() != status) {
            this.log.info((Object)("Change status of " + fileDTO + " to " + status));
            try {
                fsmgt.setFileStatus(fileDTO.getPk(), status);
                return true;
            }
            catch (Exception e) {
                this.log.error((Object)("Failed to update status of file " + fileDTO), (Throwable)e);
            }
        }
        return false;
    }

    private Integer queryHSM(String fsID, String filePath, String userInfo) throws IOException {
        try {
            return (Integer)this.server.invoke(this.hsmModuleServicename, "queryStatus", new Object[]{fsID, filePath, userInfo}, new String[]{String.class.getName(), String.class.getName(), String.class.getName()});
        }
        catch (Exception x) {
            this.log.error((Object)("queryHSM failed! fsID:" + fsID + " filePath:" + filePath + " userInfo:" + userInfo), (Throwable)x);
            IOException iox = new IOException("Query status of HSMFile failed!");
            iox.initCause(x);
            throw iox;
        }
    }

    protected FileSystemMgt2 newFileSystemMgt() throws Exception {
        return ((FileSystemMgt2Home)EJBHomeFactory.getFactory().lookup(FileSystemMgt2Home.class, "ejb/FileSystemMgt2")).create();
    }

    public String getTimerIDCheckSyncFileStatus() {
        return this.timerIDCheckSyncFileStatus;
    }

    public void setTimerIDCheckSyncFileStatus(String timerIDCheckSyncFileStatus) {
        this.timerIDCheckSyncFileStatus = timerIDCheckSyncFileStatus;
    }

    public int syncArchivedStatusOfInstances(String fsID, String limitStr) throws Exception {
        if (fsID == null || fsID.trim().length() < 1) {
            return 0;
        }
        int limit = limitStr == null || limitStr.trim().length() < 1 ? 1000 : Integer.parseInt(limitStr);
        return this.newFileSystemMgt().syncArchivedFlag(fsID, limit < 1 ? 1000 : limit);
    }
}

