/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4chex.archive.hsm;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.MessageDigest;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageListener;
import javax.jms.ObjectMessage;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanException;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import org.apache.commons.compress.tar.TarEntry;
import org.apache.commons.compress.tar.TarOutputStream;
import org.dcm4che.util.BufferedOutputStream;
import org.dcm4che.util.MD5Utils;
import org.dcm4chex.archive.common.DeleteStudyOrder;
import org.dcm4chex.archive.common.FileStatus;
import org.dcm4chex.archive.config.RetryIntervalls;
import org.dcm4chex.archive.ejb.interfaces.FileDTO;
import org.dcm4chex.archive.ejb.interfaces.FileSystemDTO;
import org.dcm4chex.archive.ejb.interfaces.FileSystemMgt2;
import org.dcm4chex.archive.exceptions.ConcurrentStudyStorageException;
import org.dcm4chex.archive.hsm.VerifyTar;
import org.dcm4chex.archive.mbean.AbstractDeleterService;
import org.dcm4chex.archive.mbean.FileSystemMgt2Delegate;
import org.dcm4chex.archive.mbean.JMSDelegate;
import org.dcm4chex.archive.util.FileSystemUtils;
import org.dcm4chex.archive.util.FileUtils;

public class FileMoveService
extends AbstractDeleterService
implements MessageListener {
    private static final String ERROR = "ERROR";
    private static final String NOT_APPLICABLE = "N.A.";
    private String srcFsGroup;
    private String destFsGroup;
    private Long minFree = null;
    private FileSystemMgt2Delegate fsmgt = new FileSystemMgt2Delegate(this);
    private JMSDelegate jmsDelegate = new JMSDelegate(this);
    private String moveFilesOfStudyQueueName;
    private RetryIntervalls retryIntervalls = new RetryIntervalls();
    private boolean keepSrcFiles;
    private boolean keepMovedFilesOnError;
    Integer destFileStatus;
    private int bufferSize;
    private boolean verifyCopy;
    private ObjectName hsmModuleServicename = null;
    private static final int MD5SUM_ENTRY_LEN = 52;

    public String getSrcFsGroup() {
        return this.srcFsGroup == null ? "NONE" : this.srcFsGroup;
    }

    public void setSrcFsGroup(String srcFsGroup) {
        this.srcFsGroup = "NONE".equals(srcFsGroup) ? null : srcFsGroup;
    }

    public String getDestFsGroup() {
        return this.destFsGroup == null ? "NONE" : this.destFsGroup;
    }

    public void setDestFsGroup(String destFsGroup) {
        if ("NONE".equals(destFsGroup)) {
            this.destFsGroup = null;
        } else {
            if (destFsGroup.equals(this.srcFsGroup)) {
                throw new IllegalArgumentException("Source and Destination must not be the same!");
            }
            this.destFsGroup = destFsGroup;
        }
    }

    public long getMinFreeDiskSpaceBytes() {
        try {
            return this.srcFsGroup == null ? 0L : (this.minFree != null ? this.minFree.longValue() : this.updateMinFreeDiskSpaceFromSrcFSGroup());
        }
        catch (Exception x) {
            this.log.error((Object)"Can't get MinFreeDiskSpaceFromSrcFS! return MIN_FREE_DISK_SPACE:20000000");
            return 20000000L;
        }
    }

    public long updateMinFreeDiskSpaceFromSrcFSGroup() throws Exception {
        String mfd = (String)this.server.getAttribute(new ObjectName(this.getFileSystemMgtServiceNamePrefix() + this.srcFsGroup), "MinimumFreeDiskSpace");
        this.log.info((Object)("getMinFreeDiskSpaceFromSrcFS group:" + this.srcFsGroup + " minFree:" + mfd));
        this.minFree = mfd.equalsIgnoreCase("NONE") ? 0L : FileUtils.parseSize(mfd, 20000000L);
        return this.minFree;
    }

    public String getMinFreeDiskSpace() {
        if (this.srcFsGroup == null) {
            return NOT_APPLICABLE;
        }
        try {
            this.updateMinFreeDiskSpaceFromSrcFSGroup();
        }
        catch (Exception x) {
            this.log.error((Object)"Can't get MinFreeDiskSpaceFromSrcFS! return MIN_FREE_DISK_SPACE:20000000", (Throwable)x);
            return ERROR;
        }
        return this.minFree == 0L ? "NONE" : FileUtils.formatSize(this.minFree);
    }

    public long getExpectedDataVolumePerDayBytes() {
        try {
            return this.srcFsGroup == null ? -1L : (Long)this.server.getAttribute(new ObjectName(this.getFileSystemMgtServiceNamePrefix() + this.srcFsGroup), "ExpectedDataVolumePerDayBytes");
        }
        catch (Exception x) {
            this.log.error((Object)"Failed to get ExpectedDataVolumePerDayBytes!", (Throwable)x);
            return -1L;
        }
    }

    public final String getExpectedDataVolumePerDay() throws Exception {
        return this.srcFsGroup == null ? NOT_APPLICABLE : FileUtils.formatSize(this.getExpectedDataVolumePerDayBytes());
    }

    public String getUsableDiskSpaceStringOnDest() {
        try {
            if (this.destFsGroup == null) {
                return NOT_APPLICABLE;
            }
            if (this.destFsGroup.indexOf(64) == -1) {
                return (String)this.server.getAttribute(new ObjectName(this.getFileSystemMgtServiceNamePrefix() + this.destFsGroup), "UsableDiskSpaceString");
            }
            FileSystemDTO fsDTO = this.getDestinationFilesystem(FileMoveService.fileSystemMgt());
            if (fsDTO == null) {
                return "Dest FS not found!";
            }
            File dir = FileUtils.toFile(fsDTO.getDirectoryPath());
            return dir.isDirectory() ? FileUtils.formatSize(FileSystemUtils.freeSpace(dir.getPath()) - this.getMinFreeDiskSpaceBytes()) : "UNKNOWN";
        }
        catch (Exception x) {
            this.log.error((Object)"Failed to get UsableDiskSpaceStringOnDest!", (Throwable)x);
            return ERROR;
        }
    }

    public String getDestFileStatus() {
        return this.destFileStatus == null ? "-" : FileStatus.toString(this.destFileStatus);
    }

    public void setDestFileStatus(String status) {
        this.destFileStatus = "-".equals(status) ? null : Integer.valueOf(FileStatus.toInt(status));
    }

    public String getFileSystemMgtServiceNamePrefix() {
        return this.fsmgt.getFileSystemMgtServiceNamePrefix();
    }

    public void setFileSystemMgtServiceNamePrefix(String prefix) {
        this.fsmgt.setFileSystemMgtServiceNamePrefix(prefix);
    }

    public final String getRetryIntervalls() {
        return this.retryIntervalls.toString();
    }

    public final void setRetryIntervalls(String s) {
        this.retryIntervalls = new RetryIntervalls(s);
    }

    public boolean isKeepSrcFiles() {
        return this.keepSrcFiles;
    }

    public void setKeepSrcFiles(boolean keepSrcFiles) {
        this.keepSrcFiles = keepSrcFiles;
    }

    public boolean isKeepMovedFilesOnError() {
        return this.keepMovedFilesOnError;
    }

    public void setKeepMovedFilesOnError(boolean b) {
        this.keepMovedFilesOnError = b;
    }

    public int getBufferSize() {
        return this.bufferSize;
    }

    public void setBufferSize(int bufferSize) {
        this.bufferSize = bufferSize;
    }

    public boolean isVerifyCopy() {
        return this.verifyCopy;
    }

    public void setVerifyCopy(boolean verifyCopy) {
        this.verifyCopy = verifyCopy;
    }

    public String getQueueName() {
        return this.moveFilesOfStudyQueueName;
    }

    public void setQueueName(String name) {
        this.moveFilesOfStudyQueueName = name;
    }

    public ObjectName getJmsServiceName() {
        return this.jmsDelegate.getJmsServiceName();
    }

    public void setJmsServiceName(ObjectName jmsServiceName) {
        this.jmsDelegate.setJmsServiceName(jmsServiceName);
    }

    public final String getHSMModulServicename() {
        return this.hsmModuleServicename == null ? "NONE" : this.hsmModuleServicename.toString();
    }

    public final void setHSMModulServicename(String name) throws MalformedObjectNameException {
        this.hsmModuleServicename = "NONE".equals(name) ? null : ObjectName.getInstance(name);
    }

    protected void startService() throws Exception {
        super.startService();
        this.jmsDelegate.startListening(this.moveFilesOfStudyQueueName, this, 1);
    }

    protected void stopService() throws Exception {
        this.jmsDelegate.stopListening(this.moveFilesOfStudyQueueName);
        super.stopService();
    }

    protected void schedule(DeleteStudyOrder order, long scheduledTime) throws Exception {
        if (this.srcFsGroup == null || this.destFsGroup == null) {
            String msg = "FileMove service is disabled! Set SourceFileSystemGroupID and DestinationFileSystemGroupID to enable it.";
            this.log.info((Object)msg);
            throw new RuntimeException(msg);
        }
        if (ERROR.equals(this.getUsableDiskSpaceStringOnDest())) {
            String msg = "UsableDiskSpaceStringOnDest reports an error! Scheduling Move Order cancelled! Please check DestinationFileSystemGroupID configuration!";
            this.log.error((Object)msg);
            throw new RuntimeException(msg);
        }
        if (this.log.isInfoEnabled()) {
            String scheduledTimeStr = scheduledTime > 0L ? new Date(scheduledTime).toString() : "now";
            this.log.info((Object)("Scheduling job [" + order + "] at " + scheduledTimeStr + ". Retry times: " + order.getFailureCount()));
        }
        this.jmsDelegate.queue(this.moveFilesOfStudyQueueName, order, 4, scheduledTime);
    }

    public int scheduleStudiesForMove() throws Exception {
        return this.scheduleStudiesForDeletion();
    }

    public long scheduleStudyForMove(String suid) throws Exception {
        return this.scheduleStudyForDeletion(suid);
    }

    protected String getFileSystemGroupIDForDeleter() {
        return this.srcFsGroup;
    }

    protected void scheduleDeleteOrder(DeleteStudyOrder order) throws Exception {
        this.schedule(order, 0L);
    }

    public String showMoveCriteria() {
        return this.showDeleterCriteria();
    }

    public void onMessage(Message message) {
        block6: {
            ObjectMessage om = (ObjectMessage)message;
            try {
                DeleteStudyOrder order = (DeleteStudyOrder)om.getObject();
                this.log.info((Object)("Start processing " + order));
                try {
                    this.process(order);
                    this.log.info((Object)("Finished processing " + order));
                }
                catch (Exception e) {
                    order.setThrowable(e);
                    int failureCount = order.getFailureCount() + 1;
                    order.setFailureCount(failureCount);
                    long delay = this.retryIntervalls.getIntervall(failureCount);
                    if (delay == -1L) {
                        this.log.error((Object)("Give up to process " + order), (Throwable)e);
                        this.jmsDelegate.fail(this.moveFilesOfStudyQueueName, order);
                        break block6;
                    }
                    this.log.warn((Object)("Failed to process " + order + ". Scheduling retry."), (Throwable)e);
                    this.jmsDelegate.queue(this.moveFilesOfStudyQueueName, order, 0, System.currentTimeMillis() + delay);
                }
            }
            catch (JMSException e) {
                this.log.error((Object)("jms error during processing message: " + message), (Throwable)e);
            }
            catch (Throwable e) {
                this.log.error((Object)("unexpected error during processing message: " + message), e);
            }
        }
    }

    private void process(DeleteStudyOrder order) throws Exception {
        block16: {
            try {
                File[] srcFiles;
                if (this.destFsGroup == null) {
                    throw new RuntimeException("No destination file system configured!");
                }
                FileSystemMgt2 mgt = FileMoveService.fileSystemMgt();
                FileSystemDTO fsDTO = this.getDestinationFilesystem(mgt);
                if (fsDTO == null) {
                    throw new RuntimeException("No destination file system (with free disk space) available!");
                }
                FileDTO[] files = mgt.getFilesOfStudy(order);
                this.log.info((Object)("Move " + files.length + " files of study " + order.getStudyIUID() + " to Filesystem:" + fsDTO));
                if (files.length <= 0) break block16;
                String destPath = fsDTO.getDirectoryPath();
                if (destPath.startsWith("tar:")) {
                    srcFiles = this.copyTar(files, destPath, fsDTO.getPk());
                    mgt.moveFiles(order, files, this.destFileStatus, this.keepSrcFiles, false);
                } else {
                    srcFiles = this.copyFiles(files, destPath, fsDTO.getPk());
                    List failed = mgt.moveFiles(order, files, this.destFileStatus, this.keepSrcFiles, this.keepMovedFilesOnError);
                    this.log.info((Object)("moveFiles done! failed:" + failed));
                    if (failed != null) {
                        if (this.keepSrcFiles) {
                            for (int i = 0; i < failed.size(); ++i) {
                                FileDTO dto = (FileDTO)failed.get(i);
                                this.deleteFile(FileUtils.toFile(dto.getDirectoryPath() + '/' + dto.getFilePath()));
                            }
                        } else {
                            int j = 0;
                            FileDTO failedDto = (FileDTO)failed.get(j);
                            for (int i = 0; i < srcFiles.length; ++i) {
                                if (failedDto != null && files[i].getPk() == failedDto.getPk()) {
                                    this.deleteFile(FileUtils.toFile(failedDto.getDirectoryPath() + '/' + failedDto.getFilePath()));
                                    failedDto = ++j < failed.size() ? (FileDTO)failed.get(j) : null;
                                    continue;
                                }
                                this.deleteFile(srcFiles[i]);
                            }
                        }
                        throw (Exception)order.getThrowable();
                    }
                }
                if (!this.keepSrcFiles) {
                    for (int i = 0; i < srcFiles.length; ++i) {
                        this.deleteFile(srcFiles[i]);
                    }
                    try {
                        mgt.removeStudyOnFSRecord(order);
                    }
                    catch (Exception x) {
                        this.log.warn((Object)("Remove StudyOnFS record failed for " + order), (Throwable)x);
                    }
                }
            }
            catch (ConcurrentStudyStorageException x) {
                this.log.info((Object)x.getMessage());
            }
        }
    }

    private FileSystemDTO getDestinationFilesystem(FileSystemMgt2 mgt) throws Exception {
        if (this.destFsGroup == null) {
            return null;
        }
        int pos = this.destFsGroup.indexOf(64);
        if (pos == -1) {
            return this.fsmgt.selectStorageFileSystem(this.destFsGroup);
        }
        return mgt.getFileSystemOfGroup(this.destFsGroup.substring(pos + 1), this.destFsGroup.substring(0, pos));
    }

    private void deleteFile(File f) {
        this.log.info((Object)("M-DELETE file:" + f));
        if (!f.delete()) {
            this.log.error((Object)("Failed to delete file:" + f));
        }
    }

    private File[] copyFiles(FileDTO[] files, String dirPath, long destFsPk) throws Exception {
        byte[] buffer = new byte[this.bufferSize];
        Exception ex = null;
        MessageDigest digest = null;
        File[] srcFiles = new File[files.length];
        if (this.verifyCopy) {
            digest = MessageDigest.getInstance("MD5");
        }
        for (int i = 0; i < files.length; ++i) {
            FileDTO dtoSrc = files[i];
            srcFiles[i] = FileUtils.toFile(dtoSrc.getDirectoryPath() + '/' + dtoSrc.getFilePath());
            File dst = FileUtils.toFile(dirPath + '/' + dtoSrc.getFilePath());
            try {
                byte[] md5sum;
                this.copy(srcFiles[i], dst, buffer);
                byte[] md5sum0 = dtoSrc.getFileMd5();
                if (md5sum0 != null && digest != null && !Arrays.equals(md5sum0, md5sum = MD5Utils.md5sum(dst, digest, buffer))) {
                    String prompt = "md5 sum of copy " + dst + " differs from md5 sum in DB for file " + srcFiles[i];
                    this.log.warn((Object)prompt);
                    throw new IOException(prompt);
                }
                dtoSrc.setFileSystemPk(destFsPk);
                dtoSrc.setDirectoryPath(dirPath);
                continue;
            }
            catch (Exception e) {
                this.deleteFile(dst);
                ex = e;
            }
        }
        if (ex != null) {
            throw ex;
        }
        return srcFiles;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void copy(File src, File dst, byte[] buffer) throws IOException {
        FileInputStream fis = new FileInputStream(src);
        try {
            File dir = dst.getParentFile();
            if (dir.mkdirs()) {
                this.log.info((Object)("M-WRITE dir:" + dir));
            }
            this.log.info((Object)("M-WRITE file:" + dst));
            BufferedOutputStream bos = new BufferedOutputStream(new FileOutputStream(dst), buffer);
            try {
                bos.copyFrom(fis, (int)src.length());
                Object var8_7 = null;
            }
            catch (Throwable throwable) {
                Object var8_8 = null;
                bos.close();
                throw throwable;
            }
            bos.close();
            Object var10_10 = null;
        }
        catch (Throwable throwable) {
            Object var10_11 = null;
            fis.close();
            throw throwable;
        }
        fis.close();
    }

    private File[] copyTar(FileDTO[] files, String destPath, long destFsPk) throws Exception {
        File[] srcFiles;
        File tarFile;
        String tarPath = this.mkTarPath(files[0].getFilePath());
        String[] tarEntryNames = new String[files.length];
        for (int i = 0; i < tarEntryNames.length; ++i) {
            tarEntryNames[i] = this.mkTarEntryName(files[i]);
        }
        if (this.hsmModuleServicename == null) {
            tarFile = FileUtils.toFile(destPath.substring(4), tarPath);
            srcFiles = this.mkTar(files, tarFile, tarEntryNames);
        } else {
            tarFile = this.prepareHSMFile(destPath, tarPath);
            try {
                srcFiles = this.mkTar(files, tarFile, tarEntryNames);
                tarPath = this.storeHSMFile(tarFile, destPath, tarPath);
            }
            catch (Exception x) {
                this.log.error((Object)"Make Tar file failed!", (Throwable)x);
                this.deleteFile(tarFile);
                this.failedHSMFile(tarFile, destPath, tarPath);
                throw x;
            }
        }
        for (int i = 0; i < tarEntryNames.length; ++i) {
            String fileId = tarPath + '!' + tarEntryNames[i];
            files[i].setFileSystemPk(destFsPk);
            files[i].setDirectoryPath(destPath);
            files[i].setFilePath(fileId);
        }
        return srcFiles;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private File[] mkTar(FileDTO[] dto, File tarFile, String[] tarEntryNames) throws Exception {
        File[] srcFiles = new File[dto.length];
        try {
            if (tarFile.getParentFile().mkdirs()) {
                this.log.info((Object)("M-WRITE " + tarFile.getParent()));
            }
            this.log.info((Object)("M-WRITE " + tarFile));
            TarOutputStream tar = new TarOutputStream((OutputStream)new FileOutputStream(tarFile));
            try {
                this.writeMD5SUM(tar, dto, tarEntryNames);
                for (int i = 0; i < tarEntryNames.length; ++i) {
                    srcFiles[i] = this.writeFile(tar, dto[i], tarEntryNames[i]);
                }
                Object var8_8 = null;
            }
            catch (Throwable throwable) {
                Object var8_9 = null;
                tar.close();
                throw throwable;
            }
            tar.close();
            if (this.verifyCopy) {
                VerifyTar.verify(tarFile, new byte[this.bufferSize]);
            }
        }
        catch (Exception e) {
            this.deleteFile(tarFile);
            throw e;
        }
        return srcFiles;
    }

    private void writeMD5SUM(TarOutputStream tar, FileDTO[] dto, String[] tarEntryNames) throws IOException {
        byte[] md5sum = new byte[dto.length * 52];
        TarEntry tarEntry = new TarEntry("MD5SUM");
        tarEntry.setSize((long)md5sum.length);
        tar.putNextEntry(tarEntry);
        int i = 0;
        for (int j = 0; j < tarEntryNames.length; ++j) {
            MD5Utils.toHexChars(dto[j].getFileMd5(), md5sum, i);
            md5sum[i + 32] = 32;
            md5sum[i + 33] = 32;
            System.arraycopy(tarEntryNames[j].getBytes("US-ASCII"), 0, md5sum, i + 34, 17);
            md5sum[i + 51] = 10;
            i += 52;
        }
        tar.write(md5sum);
        tar.closeEntry();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private File writeFile(TarOutputStream tar, FileDTO dto, String tarEntryName) throws IOException, FileNotFoundException {
        File file = FileUtils.toFile(dto.getDirectoryPath(), dto.getFilePath());
        TarEntry entry = new TarEntry(tarEntryName);
        entry.setSize(dto.getFileSize());
        tar.putNextEntry(entry);
        FileInputStream fis = new FileInputStream(file);
        try {
            tar.copyEntryContents((InputStream)fis);
            Object var8_7 = null;
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            fis.close();
            throw throwable;
        }
        fis.close();
        tar.closeEntry();
        return file;
    }

    private File prepareHSMFile(String fsID, String filePath) throws InstanceNotFoundException, MBeanException, ReflectionException {
        return (File)this.server.invoke(this.hsmModuleServicename, "prepareHSMFile", new Object[]{fsID, filePath}, new String[]{String.class.getName(), String.class.getName()});
    }

    private String storeHSMFile(File file, String fsID, String filePath) throws InstanceNotFoundException, MBeanException, ReflectionException {
        return (String)this.server.invoke(this.hsmModuleServicename, "storeHSMFile", new Object[]{file, fsID, filePath}, new String[]{File.class.getName(), String.class.getName(), String.class.getName()});
    }

    private void failedHSMFile(File file, String fsID, String filePath) throws InstanceNotFoundException, MBeanException, ReflectionException {
        this.server.invoke(this.hsmModuleServicename, "failedHSMFile", new Object[]{file, fsID, filePath}, new String[]{File.class.getName(), String.class.getName(), String.class.getName()});
    }

    private String mkTarPath(String filePath) {
        StringBuffer sb = new StringBuffer(filePath);
        sb.setLength(filePath.lastIndexOf(47));
        sb.append('-').append(System.currentTimeMillis() % 3600000L).append(".tar");
        return sb.toString();
    }

    private String mkTarEntryName(FileDTO dto) {
        StringBuilder sb = new StringBuilder(17);
        String fileId = dto.getFilePath();
        int pos = fileId.lastIndexOf(47);
        int pos1 = fileId.lastIndexOf(47, pos - 1);
        sb.append(fileId.substring(pos1 + 1, pos));
        sb.append('/');
        sb.append(FileUtils.toHex((int)dto.getPk()));
        return sb.toString();
    }
}

