/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4chex.archive.hsm;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanException;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import org.apache.commons.compress.tar.TarEntry;
import org.apache.commons.compress.tar.TarOutputStream;
import org.dcm4che.data.Dataset;
import org.dcm4che.data.DcmElement;
import org.dcm4che.data.DcmObjectFactory;
import org.dcm4che.util.BufferedOutputStream;
import org.dcm4che.util.MD5Utils;
import org.dcm4chex.archive.common.BaseJmsOrder;
import org.dcm4chex.archive.config.ForwardingRules;
import org.dcm4chex.archive.ejb.interfaces.MD5;
import org.dcm4chex.archive.ejb.interfaces.Storage;
import org.dcm4chex.archive.ejb.jdbc.FileInfo;
import org.dcm4chex.archive.ejb.jdbc.QueryCmd;
import org.dcm4chex.archive.hsm.AbstractFileCopyService;
import org.dcm4chex.archive.hsm.FileCopyOrder;
import org.dcm4chex.archive.hsm.VerifyTar;
import org.dcm4chex.archive.util.FileUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileCopyService
extends AbstractFileCopyService {
    private static final String NONE = "NONE";
    private static final int MD5SUM_ENTRY_LEN = 52;
    private ObjectName hsmModuleServicename = null;
    private ArrayList<ObjectName> registeredModules = new ArrayList();
    private boolean isReady;

    public String getRegisteredHSMModules() {
        StringBuilder sb = new StringBuilder();
        for (ObjectName on : this.registeredModules) {
            sb.append(on).append("\n");
        }
        return sb.toString();
    }

    public final String getHSMModulServicename() {
        return this.hsmModuleServicename == null ? NONE : this.hsmModuleServicename.toString();
    }

    public final void setHSMModulServicename(String name) throws MalformedObjectNameException {
        this.hsmModuleServicename = NONE.equals(name) ? null : ObjectName.getInstance(name);
        this.isReady = !this.getDestination().startsWith("tar:") | this.hsmModuleServicename == null | this.registeredModules.contains(this.hsmModuleServicename);
    }

    @Override
    public boolean isReady() {
        return this.isReady;
    }

    public void registerHSMModule(ObjectName module) throws Exception {
        this.registeredModules.add(module);
        this.isReady = this.isReady | this.hsmModuleServicename == null | module.equals(this.hsmModuleServicename);
    }

    public void unregisterHSMModule(ObjectName module) throws Exception {
        this.registeredModules.remove(module);
        if (this.getDestination().startsWith("tar:") && module.equals(this.hsmModuleServicename)) {
            this.isReady = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean copyFilesOfStudy(String studyIUID) throws Exception {
        if (this.destination == null) {
            this.log.warn((Object)"Destination is not configured! skip this copyFilesOfStudy call!");
            return false;
        }
        this.log.info((Object)("Start copy files of study " + studyIUID));
        Dataset queryDs = DcmObjectFactory.getInstance().newDataset();
        queryDs.putCS(524370, "SERIES");
        queryDs.putUI(0x20000D, studyIUID);
        queryDs.putUI(0x20000E);
        QueryCmd cmd = QueryCmd.create((Dataset)queryDs, null, (boolean)true, (boolean)false, (boolean)false, (boolean)false, null);
        try {
            cmd.setFetchSize(this.getFetchSize()).execute();
            while (cmd.next()) {
                this.doCopyFilesOfSeries(cmd.getDataset().getString(0x20000E));
            }
            Object var5_4 = null;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            cmd.close();
            throw throwable;
        }
        cmd.close();
        return true;
    }

    public boolean copyFilesOfSeries(String seriesIUID) throws Exception {
        if (this.destination == null) {
            this.log.warn((Object)"Destination is not configured! skip this copyFilesOfSeries call!");
            return false;
        }
        return this.doCopyFilesOfSeries(seriesIUID);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean doCopyFilesOfSeries(String seriesIUID) throws Exception {
        QueryCmd cmd;
        Dataset queryDs;
        block4: {
            boolean bl;
            queryDs = DcmObjectFactory.getInstance().newDataset();
            queryDs.putCS(524370, "IMAGE");
            queryDs.putUI(0x20000D);
            queryDs.putUI(0x20000E, seriesIUID);
            queryDs.putUI(524312);
            cmd = QueryCmd.create((Dataset)queryDs, null, (boolean)true, (boolean)false, (boolean)false, (boolean)false, null);
            try {
                cmd.execute();
                Dataset ds = null;
                Dataset ian = DcmObjectFactory.getInstance().newDataset();
                Dataset refSeries = ian.putSQ(528661).addNewItem();
                DcmElement refSOPs = refSeries.putSQ(528793);
                while (cmd.next()) {
                    ds = cmd.getDataset();
                    refSeries.putUI(0x20000E, ds.getString(0x20000E));
                    refSOPs.addNewItem().putUI(528725, ds.getString(524312));
                }
                if (ds == null) break block4;
                ian.putUI(0x20000D, ds.getString(0x20000D));
                refSeries.putUI(0x20000E, ds.getString(0x20000E));
                this.schedule(this.createOrder(ian), 0L);
                this.log.info((Object)("Copy files of series " + seriesIUID + " scheduled!"));
                bl = true;
                Object var10_10 = null;
            }
            catch (Throwable throwable) {
                Object var10_12 = null;
                cmd.close();
                throw throwable;
            }
            cmd.close();
            return bl;
        }
        this.log.info((Object)("No instances found for file copy! seriesIUID:" + seriesIUID));
        this.log.debug((Object)queryDs);
        boolean bl = false;
        Object var10_11 = null;
        cmd.close();
        return bl;
    }

    @Override
    protected BaseJmsOrder createOrder(Dataset ian) {
        FileCopyOrder fileCopyOrder = new FileCopyOrder(ian, ForwardingRules.toAET(this.destination), this.getRetrieveAETs(), this.getFetchSize());
        fileCopyOrder.processOrderProperties(new Object[0]);
        return fileCopyOrder;
    }

    @Override
    protected void process(BaseJmsOrder order) throws Exception {
        FileCopyOrder fileCopyOrder = (FileCopyOrder)order;
        String destPath = fileCopyOrder.getDestinationFileSystemPath();
        List<FileInfo> fileInfos = fileCopyOrder.getFileInfos();
        int removed = this.removeOfflineOrTarSourceFiles(fileInfos);
        if (removed > 0) {
            this.log.info((Object)(removed + " Files (Offline or on tar FS) removed from FileCopy Order!" + "\nRemaining files to copy:" + fileInfos.size()));
        }
        if (fileInfos.isEmpty()) {
            this.log.info((Object)"Skip FileCopy Order! No files to copy!");
            return;
        }
        if (destPath.startsWith("tar:")) {
            this.copyTar(fileInfos, destPath);
        } else {
            this.copyFiles(fileInfos, destPath);
        }
    }

    private void copyFiles(List<FileInfo> fileInfos, String destPath) throws Exception {
        byte[] buffer = new byte[this.bufferSize];
        Storage storage = FileCopyService.getStorageHome().create();
        Exception ex = null;
        MessageDigest digest = null;
        if (this.verifyCopy) {
            digest = MessageDigest.getInstance("MD5");
        }
        Iterator<FileInfo> iter = fileInfos.iterator();
        while (iter.hasNext()) {
            FileInfo finfo = iter.next();
            File src = FileUtils.toFile(finfo.basedir + '/' + finfo.fileID);
            File dst = FileUtils.toFile(destPath + '/' + finfo.fileID);
            try {
                byte[] md5sum;
                byte[] md5sum0;
                this.copy(src, dst, buffer);
                byte[] byArray = md5sum0 = finfo.md5 != null ? MD5Utils.toBytes(finfo.md5) : null;
                if (md5sum0 != null && digest != null && !Arrays.equals(md5sum0, md5sum = MD5Utils.md5sum(dst, digest, buffer))) {
                    String prompt = "md5 sum of copy " + dst + " differs from md5 sum in DB for file " + src;
                    this.log.warn((Object)prompt);
                    throw new IOException(prompt);
                }
                storage.storeFile(finfo.sopIUID, finfo.tsUID, destPath, finfo.fileID, (int)finfo.size, md5sum0, this.fileStatus);
                iter.remove();
            }
            catch (Exception e) {
                dst.delete();
                ex = e;
            }
        }
        if (ex != null) {
            throw ex;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void copy(File src, File dst, byte[] buffer) throws IOException {
        FileInputStream fis = new FileInputStream(src);
        try {
            try {
                File dir = dst.getParentFile();
                if (dir.mkdirs()) {
                    this.log.info((Object)("M-WRITE dir:" + dir));
                }
                this.log.info((Object)("M-WRITE file:" + dst));
                BufferedOutputStream bos = new BufferedOutputStream(new FileOutputStream(dst), buffer);
                try {
                    bos.copyFrom(fis, (int)src.length());
                    Object var8_8 = null;
                }
                catch (Throwable throwable) {
                    Object var8_9 = null;
                    bos.close();
                    throw throwable;
                }
                bos.close();
                Object var10_11 = null;
            }
            catch (IOException e) {
                this.log.error((Object)("Copy file " + src + " failed"), (Throwable)e);
                dst.delete();
                throw e;
            }
        }
        catch (Throwable throwable) {
            Object var10_12 = null;
            fis.close();
            throw throwable;
        }
        fis.close();
    }

    private void copyTar(List<FileInfo> fileInfos, String destPath) throws Exception {
        File tarFile;
        FileInfo file1Info = fileInfos.get(0);
        String tarPath = this.mkTarPath(file1Info.fileID);
        String[] tarEntryNames = new String[fileInfos.size()];
        for (int i = 0; i < tarEntryNames.length; ++i) {
            tarEntryNames[i] = this.mkTarEntryName(fileInfos.get(i));
        }
        if (this.hsmModuleServicename == null) {
            tarFile = FileUtils.toFile(destPath.substring(4), tarPath);
            this.mkTar(fileInfos, tarFile, tarEntryNames);
        } else {
            tarFile = this.prepareHSMFile(destPath, tarPath);
            try {
                this.mkTar(fileInfos, tarFile, tarEntryNames);
                tarPath = this.storeHSMFile(tarFile, destPath, tarPath);
            }
            catch (Exception x) {
                this.log.error((Object)"Make Tar file failed!", (Throwable)x);
                tarFile.delete();
                this.failedHSMFile(tarFile, destPath, tarPath);
                throw x;
            }
        }
        Storage storage = FileCopyService.getStorageHome().create();
        for (int i = 0; i < tarEntryNames.length; ++i) {
            String fileId = tarPath + '!' + tarEntryNames[i];
            FileInfo finfo = fileInfos.get(i);
            storage.storeFile(finfo.sopIUID, finfo.tsUID, destPath, fileId, (int)finfo.size, MD5.toBytes(finfo.md5), this.fileStatus);
        }
    }

    private File prepareHSMFile(String fsID, String filePath) throws InstanceNotFoundException, MBeanException, ReflectionException {
        return (File)this.server.invoke(this.hsmModuleServicename, "prepareHSMFile", new Object[]{fsID, filePath}, new String[]{String.class.getName(), String.class.getName()});
    }

    private String storeHSMFile(File file, String fsID, String filePath) throws InstanceNotFoundException, MBeanException, ReflectionException {
        return (String)this.server.invoke(this.hsmModuleServicename, "storeHSMFile", new Object[]{file, fsID, filePath}, new String[]{File.class.getName(), String.class.getName(), String.class.getName()});
    }

    private void failedHSMFile(File file, String fsID, String filePath) throws InstanceNotFoundException, MBeanException, ReflectionException {
        this.server.invoke(this.hsmModuleServicename, "failedHSMFile", new Object[]{file, fsID, filePath}, new String[]{File.class.getName(), String.class.getName(), String.class.getName()});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void mkTar(List<FileInfo> fileInfos, File tarFile, String[] tarEntryNames) throws Exception {
        try {
            if (tarFile.getParentFile().mkdirs()) {
                this.log.info((Object)("M-WRITE " + tarFile.getParent()));
            }
            this.log.info((Object)("M-WRITE " + tarFile));
            TarOutputStream tar = new TarOutputStream((OutputStream)new FileOutputStream(tarFile));
            try {
                this.writeMD5SUM(tar, fileInfos, tarEntryNames);
                for (int i = 0; i < tarEntryNames.length; ++i) {
                    this.writeFile(tar, fileInfos.get(i), tarEntryNames[i]);
                }
                Object var7_7 = null;
            }
            catch (Throwable throwable) {
                Object var7_8 = null;
                tar.close();
                throw throwable;
            }
            tar.close();
            if (this.verifyCopy) {
                VerifyTar.verify(tarFile, new byte[this.bufferSize]);
            }
        }
        catch (Exception e) {
            this.log.error((Object)("M-DELETE tar file due to an error! " + tarFile));
            tarFile.delete();
            throw e;
        }
    }

    private int removeOfflineOrTarSourceFiles(List<FileInfo> fileInfos) {
        int removed = 0;
        Iterator<FileInfo> iter = fileInfos.iterator();
        while (iter.hasNext()) {
            FileInfo fi = iter.next();
            if (fi.availability == 0 && !fi.basedir.startsWith("tar:")) continue;
            ++removed;
            iter.remove();
        }
        return removed;
    }

    private void writeMD5SUM(TarOutputStream tar, List<FileInfo> fileInfos, String[] tarEntryNames) throws IOException {
        byte[] md5sum = new byte[fileInfos.size() * 52];
        TarEntry tarEntry = new TarEntry("MD5SUM");
        tarEntry.setSize((long)md5sum.length);
        tar.putNextEntry(tarEntry);
        int i = 0;
        for (int j = 0; j < tarEntryNames.length; ++j) {
            MD5Utils.toHexChars(MD5.toBytes(fileInfos.get((int)j).md5), md5sum, i);
            md5sum[i + 32] = 32;
            md5sum[i + 33] = 32;
            System.arraycopy(tarEntryNames[j].getBytes("US-ASCII"), 0, md5sum, i + 34, 17);
            md5sum[i + 51] = 10;
            i += 52;
        }
        tar.write(md5sum);
        tar.closeEntry();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeFile(TarOutputStream tar, FileInfo fileInfo, String tarEntryName) throws IOException, FileNotFoundException {
        File file = FileUtils.toFile(fileInfo.basedir, fileInfo.fileID);
        if (file.length() != fileInfo.size) {
            this.log.error((Object)("Filesize doesn't match for file entry:" + fileInfo + "!(" + file.length() + " vs. " + fileInfo.size + ") skipped!"));
            throw new IOException("Filesize doesn't match! file:" + file);
        }
        TarEntry entry = new TarEntry(tarEntryName);
        entry.setSize(fileInfo.size);
        tar.putNextEntry(entry);
        FileInputStream fis = new FileInputStream(file);
        try {
            tar.copyEntryContents((InputStream)fis);
            Object var8_7 = null;
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            fis.close();
            throw throwable;
        }
        fis.close();
        tar.closeEntry();
    }

    private String mkTarEntryName(FileInfo fileInfo) {
        StringBuilder sb = new StringBuilder(17);
        sb.append(FileUtils.toHex(fileInfo.seriesIUID.hashCode()));
        sb.append('/');
        sb.append(FileUtils.toHex((int)fileInfo.pk));
        return sb.toString();
    }

    private String mkTarPath(String filePath) {
        StringBuffer sb = new StringBuffer(filePath);
        sb.setLength(filePath.lastIndexOf(47));
        sb.append('-').append(System.currentTimeMillis() % 3600000L).append(".tar");
        return sb.toString();
    }
}

