/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4chex.archive.hsm;

import java.io.StringWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.dcm4che.data.Dataset;
import org.dcm4che.data.DcmElement;
import org.dcm4chex.archive.common.BaseJmsOrder;
import org.dcm4chex.archive.common.FileStatus;
import org.dcm4chex.archive.ejb.jdbc.FileInfo;
import org.dcm4chex.archive.ejb.jdbc.RetrieveCmd;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileCopyOrder
extends BaseJmsOrder {
    private static final long serialVersionUID = 3258409538737550129L;
    protected List<FileInfo> fileInfos = null;
    protected final String dstFsPath;
    protected final String retrieveAETs;
    protected Dataset ian = null;
    protected int fetchSize;
    private static Logger log = Logger.getLogger(FileCopyOrder.class);

    public FileCopyOrder(Dataset ian, String dstFsPath, String retrieveAETs, int fetchSize) {
        this.ian = ian;
        this.dstFsPath = dstFsPath;
        this.retrieveAETs = retrieveAETs;
        this.fetchSize = fetchSize;
    }

    public List<FileInfo> getFileInfos() throws Exception {
        if (this.fileInfos == null) {
            this.convertFromIAN();
        }
        return this.fileInfos;
    }

    protected void convertFromIAN() throws Exception {
        Dataset refSeriesSeq = this.ian.getItem(528661);
        DcmElement refSOPSeq = refSeriesSeq.get(528793);
        RetrieveCmd cmd = RetrieveCmd.create((DcmElement)refSOPSeq);
        cmd.setFetchSize(this.fetchSize);
        FileInfo[][] aa = cmd.getFileInfos();
        this.fileInfos = new ArrayList<FileInfo>(aa.length);
        HashMap<String, FileInfo> fiCopy = new HashMap<String, FileInfo>();
        HashMap<String, FileInfo> fi2Copy = new HashMap<String, FileInfo>();
        for (FileInfo[] a : aa) {
            fiCopy.clear();
            fi2Copy.clear();
            for (FileInfo fi : a) {
                if (fi.basedir.equals(this.dstFsPath)) {
                    log.info((Object)("Instance " + fi.sopIUID + " md5:" + fi.md5 + " has already a copy on dstFsPath:" + this.dstFsPath));
                    if (fi.status != -3 && fi.status != -4) {
                        fiCopy.put(fi.md5, fi);
                        continue;
                    }
                    log.info((Object)("Copy has file status " + FileStatus.toString(fi.status) + "! Retry copy!"));
                    continue;
                }
                if (!this.isLocalRetrieveAET(fi.fileRetrieveAET)) continue;
                fi2Copy.put(fi.md5, fi);
            }
            for (Map.Entry e : fi2Copy.entrySet()) {
                if (fiCopy.containsKey(e.getKey())) continue;
                this.fileInfos.add((FileInfo)e.getValue());
            }
        }
    }

    private boolean isLocalRetrieveAET(String aet) {
        int pos = this.retrieveAETs.indexOf(aet);
        int end = pos + aet.length();
        return !(pos == -1 || pos != 0 && this.retrieveAETs.charAt(pos - 1) != '\\' || end != this.retrieveAETs.length() && this.retrieveAETs.charAt(end) != '\\');
    }

    public final String getDestinationFileSystemPath() {
        return this.dstFsPath;
    }

    @Override
    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(super.toString());
        sb.append("\tRetrieveAETs: ").append(this.retrieveAETs).append("\n");
        sb.append("\tDestination: ").append(this.dstFsPath).append("\n");
        if (this.fileInfos != null) {
            sb.append("\n\tSource files: \n");
            for (FileInfo fi : this.fileInfos) {
                sb.append("\t\t").append(fi.basedir).append(",").append(fi.fileID).append("\n");
            }
        } else if (this.ian != null) {
            if (log.isDebugEnabled()) {
                sb.append("\n\tIAN Dataset: \n");
                StringWriter sw = new StringWriter();
                try {
                    this.ian.dumpDataset(sw, null);
                    sb.append(sw.toString());
                }
                catch (Throwable e) {
                    sb.append("Failed to dump dataset due to: " + e.getMessage());
                }
            } else {
                sb.append("\n\tIAN ").append(this.ian);
            }
        }
        sb.append("\n");
        return sb.toString();
    }

    @Override
    public void processOrderProperties(Object ... properties) {
        this.setOrderProperty("StudyInstanceUID", this.ian.getString(0x20000D));
        ArrayList<String> seriesUIDList = new ArrayList<String>();
        DcmElement refSeriesSeq = this.ian.get(528661);
        if (refSeriesSeq != null) {
            for (int i = 0; i < refSeriesSeq.countItems(); ++i) {
                Dataset refSeriesDS = refSeriesSeq.getItem(i);
                seriesUIDList.add(refSeriesDS.getString(0x20000E));
            }
        }
        this.setOrderMultiProperty("SeriesInstanceUID", seriesUIDList.toArray(new String[0]));
    }
}

