/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4chex.archive.hsm;

import java.rmi.RemoteException;
import java.sql.SQLException;
import java.util.List;
import javax.ejb.CreateException;
import javax.management.Notification;
import javax.management.NotificationListener;
import javax.management.ObjectName;
import org.dcm4che.data.Dataset;
import org.dcm4chex.archive.config.RetryIntervalls;
import org.dcm4chex.archive.ejb.interfaces.ContentEdit;
import org.dcm4chex.archive.ejb.interfaces.ContentEditHome;
import org.dcm4chex.archive.ejb.jdbc.QueryFilecopyCmd;
import org.dcm4chex.archive.mbean.SchedulerDelegate;
import org.dcm4chex.archive.util.EJBHomeFactory;
import org.dcm4chex.archive.util.HomeFactoryException;
import org.jboss.system.ServiceMBeanSupport;

public class FileCopyByQueryService
extends ServiceMBeanSupport
implements NotificationListener {
    private static final String NONE = "NONE";
    private static final String LF = System.getProperty("line.separator", "\n");
    private final SchedulerDelegate scheduler = new SchedulerDelegate(this);
    private long pollInterval = 0L;
    private long delay = 0L;
    private int limit = 2000;
    private long lastSeriesPk = 0L;
    private int fetchSize;
    private Integer schedulerID;
    private String timerIDFilecopyPolling;
    private boolean isRunning;
    private ObjectName filecopyServiceName;
    private String sql;
    private QueryFilecopyCmd sqlCmd;
    private boolean sqlIsValid = false;
    String lastCheckResult = null;
    private ContentEdit contentEdit;

    public final String getPollInterval() {
        return RetryIntervalls.formatIntervalZeroAsNever(this.pollInterval);
    }

    public void setPollInterval(String interval) throws Exception {
        long l = RetryIntervalls.parseIntervalOrNever(interval);
        if (l != this.pollInterval) {
            this.pollInterval = l;
            if (this.getState() == 3) {
                this.scheduler.stopScheduler(this.timerIDFilecopyPolling, this.schedulerID, this);
                this.schedulerID = this.scheduler.startScheduler(this.timerIDFilecopyPolling, this.pollInterval, this);
            }
        }
    }

    public String getQuery() {
        return this.sql + LF;
    }

    public void setQuery(String newSql) throws SQLException {
        if (!(newSql = newSql.trim().replaceAll("\\s\\s+", " ")).equals(this.sql)) {
            this.sql = newSql;
            if (this.getState() == 3) {
                try {
                    this.checkSQL(newSql);
                    this.updateCmd();
                }
                catch (Throwable t) {
                    this.log.error((Object)"Query String not valid!", t);
                }
            }
        }
    }

    public String getLastQueryCheckResult() {
        return this.lastCheckResult == null ? "NOT CHECKED" : this.lastCheckResult;
    }

    public boolean isRunning() {
        return this.isRunning;
    }

    public long getLastSeriesPk() {
        return this.lastSeriesPk;
    }

    private void checkSQL(String sql) throws SQLException {
        this.sqlIsValid = false;
        String sqlUC = sql.toUpperCase();
        if (sqlUC.indexOf("DELETE ") != -1) {
            this.lastCheckResult = "DELETE is not allowed in this SQL statement!";
            throw new IllegalArgumentException(this.lastCheckResult);
        }
        if (sqlUC.indexOf("UPDATE ") != -1) {
            this.lastCheckResult = "UPDATE is not allowed in this SQL statement!";
            throw new IllegalArgumentException(this.lastCheckResult);
        }
        try {
            QueryFilecopyCmd cmd = QueryFilecopyCmd.getInstance((String)sql, (int)(this.limit > 0 ? 1 : 0), (int)1);
            cmd.setUpdateDatabaseMaxRetries(1);
            List chk = cmd.getSeriesPKs(sql.indexOf(63) != -1 ? Long.valueOf(System.currentTimeMillis()) : null, this.lastSeriesPk);
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("CheckSQL: QueryFilecopyCmd.getSeriesIUIDs done with result:" + chk));
            }
        }
        catch (SQLException x) {
            this.lastCheckResult = x.getCause() == null ? x.toString() : x.getCause().toString();
            throw x;
        }
        this.lastCheckResult = "OK";
        this.sqlIsValid = true;
    }

    private void updateCmd() throws SQLException {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("update QueryFilecopyCmd when state = 3. state:" + this.getState() + " limit:" + this.limit + "\nSQL:" + this.sql));
        }
        if (this.getState() == 3) {
            if (this.sqlCmd != null) {
                this.sqlCmd.close();
            }
            this.sqlCmd = QueryFilecopyCmd.getInstance((String)this.sql, (int)this.limit, (int)this.fetchSize);
        }
    }

    public String getDelay() {
        return this.delay < 0L ? NONE : RetryIntervalls.formatInterval(this.delay);
    }

    public void setDelay(String delay) {
        this.delay = NONE.equals(delay) ? -1L : RetryIntervalls.parseInterval(delay);
    }

    public int getLimit() {
        return this.limit;
    }

    public void setLimit(int limit) throws SQLException {
        if (this.limit != limit) {
            this.limit = limit;
            this.updateCmd();
        }
    }

    public int getFetchSize() {
        return this.fetchSize;
    }

    public void setFetchSize(int fetchSize) {
        this.fetchSize = fetchSize;
    }

    public String getTimerIDFilecopyByQuery() {
        return this.timerIDFilecopyPolling;
    }

    public void setTimerIDFilecopyByQuery(String timerID) {
        this.timerIDFilecopyPolling = timerID;
    }

    public ObjectName getSchedulerServiceName() {
        return this.scheduler.getSchedulerServiceName();
    }

    public void setSchedulerServiceName(ObjectName schedulerServiceName) {
        this.scheduler.setSchedulerServiceName(schedulerServiceName);
    }

    public final ObjectName getFilecopyServiceName() {
        return this.filecopyServiceName;
    }

    public final void setFilecopyServiceName(ObjectName name) {
        this.filecopyServiceName = name;
    }

    public void handleNotification(Notification notification, Object handback) {
        if (this.lastCheckResult == null) {
            try {
                this.checkSQL(this.sql);
                if (this.sqlCmd != null) {
                    this.sqlCmd.close();
                }
                this.sqlCmd = QueryFilecopyCmd.getInstance((String)this.sql, (int)this.limit, (int)this.fetchSize);
            }
            catch (Throwable t) {
                this.log.error((Object)"Check of SQL statement failed!", t);
            }
        }
        if (this.sqlIsValid) {
            this.checkFilecopy();
        } else {
            this.log.warn((Object)"SQL is not marked to be valid! checkFilecopy is disabled!");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int checkFilecopy() {
        if (this.sqlCmd == null) {
            this.log.warn((Object)"No Query defined!");
            return 0;
        }
        FileCopyByQueryService fileCopyByQueryService = this;
        synchronized (fileCopyByQueryService) {
            if (this.isRunning) {
                this.log.info((Object)"FilecopyByQuery is already running!");
                return -1;
            }
            this.isRunning = true;
        }
        int nrOfOrders = 0;
        int notScheduledOrders = 0;
        try {
            this.log.debug((Object)("SQL used to find series for copy:" + this.sqlCmd.getSQL()));
            List seriesPks = this.sqlCmd.getSeriesPKs(this.delay < 0L ? null : new Long(System.currentTimeMillis() - this.delay), this.lastSeriesPk);
            this.log.info((Object)("Found " + seriesPks.size() + " Series for FileCopy! lastSeriesPk:" + this.lastSeriesPk));
            int len = seriesPks.size();
            for (int i = 0; i < len; ++i) {
                Dataset ian = this.lookupContentEdit().getStudyMgtDatasetForSeries(new long[]{(Long)seriesPks.get(i)});
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)("IAN for series pk=" + seriesPks.get(i) + " IAN:"));
                    this.log.debug((Object)ian);
                }
                if (ian == null) continue;
                if (this.scheduleFilecopyOrder(ian)) {
                    ++nrOfOrders;
                    continue;
                }
                ++notScheduledOrders;
            }
            if (notScheduledOrders > 0) {
                this.log.warn((Object)(notScheduledOrders + " Order(s) of FileCopyByQuery service not scheduled! Please check configuration in FileCopy service!"));
            }
            this.lastSeriesPk = seriesPks.size() > 0 ? (Long)seriesPks.get(seriesPks.size() - 1) : 0L;
            int n = nrOfOrders;
            Object var8_11 = null;
            this.isRunning = false;
            return n;
        }
        catch (Exception e) {
            try {
                this.log.error((Object)("Error while checking series for Filecopy! Already scheduled filecopy orders:" + nrOfOrders), (Throwable)e);
                int n = nrOfOrders;
                Object var8_12 = null;
                this.isRunning = false;
                return n;
            }
            catch (Throwable throwable) {
                Object var8_13 = null;
                this.isRunning = false;
                throw throwable;
            }
        }
    }

    public String showSQL() {
        return this.sqlCmd == null ? "QueryFilecopyCmd not set!" : this.sqlCmd.formatSql();
    }

    protected boolean scheduleFilecopyOrder(Dataset ian) {
        try {
            return (Boolean)this.server.invoke(this.filecopyServiceName, "scheduleByIAN", new Object[]{ian, -1L}, new String[]{Dataset.class.getName(), Long.TYPE.getName()});
        }
        catch (Exception e) {
            this.log.error((Object)"Schedule FileCopy Order failed:", (Throwable)e);
            return false;
        }
    }

    protected void startService() throws Exception {
        this.schedulerID = this.scheduler.startScheduler(this.timerIDFilecopyPolling, this.pollInterval, this);
    }

    protected void stopService() throws Exception {
        this.scheduler.stopScheduler(this.timerIDFilecopyPolling, this.schedulerID, this);
        super.stopService();
    }

    private ContentEdit lookupContentEdit() throws HomeFactoryException, RemoteException, CreateException {
        if (this.contentEdit != null) {
            return this.contentEdit;
        }
        ContentEditHome home = (ContentEditHome)EJBHomeFactory.getFactory().lookup(ContentEditHome.class, "ejb/ContentEdit");
        this.contentEdit = home.create();
        return this.contentEdit;
    }
}

