/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4chex.archive.hsm;

import java.util.Date;
import java.util.HashMap;
import javax.jms.Message;
import javax.jms.MessageListener;
import javax.jms.ObjectMessage;
import javax.management.Notification;
import javax.management.NotificationListener;
import javax.management.ObjectName;
import org.dcm4che.data.Dataset;
import org.dcm4chex.archive.common.BaseJmsOrder;
import org.dcm4chex.archive.common.FileStatus;
import org.dcm4chex.archive.common.SeriesStored;
import org.dcm4chex.archive.config.Condition;
import org.dcm4chex.archive.config.ForwardingRules;
import org.dcm4chex.archive.config.RetryIntervalls;
import org.dcm4chex.archive.ejb.interfaces.StorageHome;
import org.dcm4chex.archive.exceptions.ConfigurationException;
import org.dcm4chex.archive.mbean.JMSDelegate;
import org.dcm4chex.archive.util.EJBHomeFactory;
import org.dcm4chex.archive.util.HomeFactoryException;
import org.jboss.system.ServiceMBeanSupport;

public abstract class AbstractFileCopyService
extends ServiceMBeanSupport
implements MessageListener,
NotificationListener {
    protected ObjectName storeScpServiceName;
    protected ObjectName queryRetrieveScpServiceName;
    protected String queueName;
    protected int concurrency = 1;
    protected int fileStatus = 1;
    protected boolean verifyCopy;
    protected Condition condition = null;
    protected String destination = null;
    protected RetryIntervalls retryIntervalls = new RetryIntervalls();
    protected int bufferSize = 8192;
    protected JMSDelegate jmsDelegate = new JMSDelegate(this);
    private long notReadyDelay;
    private int fetchSize;

    public final ObjectName getJmsServiceName() {
        return this.jmsDelegate.getJmsServiceName();
    }

    public final void setJmsServiceName(ObjectName jmsServiceName) {
        this.jmsDelegate.setJmsServiceName(jmsServiceName);
    }

    public final int getBufferSize() {
        return this.bufferSize;
    }

    public final void setBufferSize(int bufferSize) {
        this.bufferSize = bufferSize;
    }

    public final ObjectName getStoreScpServiceName() {
        return this.storeScpServiceName;
    }

    public final void setStoreScpServiceName(ObjectName storeScpServiceName) {
        this.storeScpServiceName = storeScpServiceName;
    }

    public ObjectName getQueryRetrieveScpServiceName() {
        return this.queryRetrieveScpServiceName;
    }

    public void setQueryRetrieveScpServiceName(ObjectName name) {
        this.queryRetrieveScpServiceName = name;
    }

    protected String getRetrieveAETs() {
        try {
            return (String)this.server.getAttribute(this.queryRetrieveScpServiceName, "CalledAETitles");
        }
        catch (Exception e) {
            throw new ConfigurationException("Failed to access CalledAETitles from " + this.queryRetrieveScpServiceName, e);
        }
    }

    public final int getConcurrency() {
        return this.concurrency;
    }

    public final String getDestination() {
        return this.destination == null ? "NONE" : (this.condition == null ? this.destination : this.condition.toString() + this.destination);
    }

    public final void setDestination(String destination) throws Exception {
        if ("NONE".equalsIgnoreCase(destination)) {
            this.condition = null;
            this.destination = null;
            return;
        }
        Condition newCondition = null;
        int startDest = destination.indexOf(93);
        if (startDest != -1) {
            newCondition = new Condition(destination.substring(0, startDest + 1));
            destination = destination.substring(startDest + 1);
        }
        this.condition = newCondition;
        this.destination = destination;
    }

    public final String getFileStatus() {
        return FileStatus.toString(this.fileStatus);
    }

    public final void setFileStatus(String fileStatus) {
        this.fileStatus = FileStatus.toInt(fileStatus);
    }

    public final boolean isVerifyCopy() {
        return this.verifyCopy;
    }

    public final void setVerifyCopy(boolean verifyCopy) {
        this.verifyCopy = verifyCopy;
    }

    public final String getRetryIntervalls() {
        return this.retryIntervalls.toString();
    }

    public final void setRetryIntervalls(String s) {
        this.retryIntervalls = new RetryIntervalls(s);
    }

    public final void setConcurrency(int concurrency) throws Exception {
        if (concurrency <= 0) {
            throw new IllegalArgumentException("Concurrency: " + concurrency);
        }
        if (this.concurrency != concurrency) {
            boolean restart;
            boolean bl = restart = this.getState() == 3;
            if (restart) {
                this.stop();
            }
            this.concurrency = concurrency;
            if (restart) {
                this.start();
            }
        }
    }

    public String getNotReadyDelay() {
        return RetryIntervalls.formatInterval(this.notReadyDelay);
    }

    public void setNotReadyDelay(String notReadyDelay) {
        this.notReadyDelay = RetryIntervalls.parseInterval(notReadyDelay);
    }

    public final String getQueueName() {
        return this.queueName;
    }

    public final void setQueueName(String queueName) {
        this.queueName = queueName;
    }

    protected void startService() throws Exception {
        this.jmsDelegate.startListening(this.queueName, this, this.concurrency);
        this.server.addNotificationListener(this.storeScpServiceName, this, SeriesStored.NOTIF_FILTER, null);
    }

    protected void stopService() throws Exception {
        this.server.removeNotificationListener(this.storeScpServiceName, this, SeriesStored.NOTIF_FILTER, null);
        this.jmsDelegate.stopListening(this.queueName);
    }

    public void handleNotification(Notification notif, Object handback) {
        if (this.destination == null) {
            return;
        }
        SeriesStored seriesStored = (SeriesStored)notif.getUserData();
        if (seriesStored.getRetrieveAET() == null) {
            this.log.warn((Object)"Ignore SeriesStored notification! Reason: Series is not locally retrievable.");
            return;
        }
        if (this.condition != null) {
            HashMap<String, String[]> param = new HashMap<String, String[]>();
            param.put("calling", new String[]{seriesStored.getSourceAET()});
            if (!this.condition.isTrueFor(param)) {
                return;
            }
        }
        this.schedule(this.createOrder(seriesStored.getIAN()), -1L);
    }

    public boolean scheduleByIAN(Dataset ian, long scheduleTime) {
        if (this.destination == null) {
            return false;
        }
        return this.schedule(this.createOrder(ian), scheduleTime);
    }

    protected boolean schedule(BaseJmsOrder order) {
        return this.schedule(order, this.isReady() ? ForwardingRules.toScheduledTime(this.destination) : this.notReadyDelay);
    }

    protected boolean schedule(BaseJmsOrder order, long scheduledTime) {
        if (!this.isReady()) {
            scheduledTime = this.notReadyDelay;
        } else if (scheduledTime < 0L) {
            scheduledTime = ForwardingRules.toScheduledTime(this.destination);
        }
        try {
            this.log.info((Object)("Scheduling " + order + (scheduledTime == 0L ? " now" : " at " + new Date(scheduledTime))));
            this.jmsDelegate.queue(this.queueName, order, 4, scheduledTime);
            return true;
        }
        catch (Exception e) {
            this.log.error((Object)("Failed to schedule " + order), (Throwable)e);
            return false;
        }
    }

    public void onMessage(Message message) {
        block6: {
            ObjectMessage om = (ObjectMessage)message;
            try {
                BaseJmsOrder order = (BaseJmsOrder)om.getObject();
                if (!this.isReady()) {
                    this.log.warn((Object)("FileCopy service not ready! Rescheduled with delay of " + this.notReadyDelay + "ms!"));
                    this.schedule(order, System.currentTimeMillis() + this.notReadyDelay);
                    return;
                }
                this.log.info((Object)("Start processing " + order));
                try {
                    this.process(order);
                    this.log.info((Object)("Finished processing " + order));
                }
                catch (Exception e) {
                    order.setThrowable(e);
                    int failureCount = order.getFailureCount() + 1;
                    order.setFailureCount(failureCount);
                    long delay = this.retryIntervalls.getIntervall(failureCount);
                    if (delay == -1L) {
                        this.log.error((Object)("Give up to process " + order), (Throwable)e);
                        this.jmsDelegate.fail(this.queueName, order);
                        break block6;
                    }
                    this.log.warn((Object)("Failed to process " + order + ". Scheduling retry."), (Throwable)e);
                    this.schedule(order, System.currentTimeMillis() + delay);
                }
            }
            catch (Throwable e) {
                this.log.error((Object)("unexpected error during processing message: " + message), e);
            }
        }
    }

    public abstract boolean isReady();

    protected abstract BaseJmsOrder createOrder(Dataset var1);

    protected abstract void process(BaseJmsOrder var1) throws Exception;

    public int getFetchSize() {
        return this.fetchSize;
    }

    public void setFetchSize(int fetchSize) {
        this.fetchSize = fetchSize;
    }

    protected static StorageHome getStorageHome() throws HomeFactoryException {
        return (StorageHome)EJBHomeFactory.getFactory().lookup(StorageHome.class, "ejb/Storage");
    }
}

