/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4chex.archive.emf;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.security.DigestOutputStream;
import java.security.MessageDigest;
import javax.jms.Message;
import javax.jms.MessageListener;
import javax.jms.ObjectMessage;
import javax.management.Notification;
import javax.management.NotificationListener;
import javax.management.ObjectName;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.dcm4che.data.Dataset;
import org.dcm4che.data.DcmElement;
import org.dcm4che.data.DcmEncodeParam;
import org.dcm4che.data.DcmObjectFactory;
import org.dcm4che.util.BufferedOutputStream;
import org.dcm4chex.archive.common.SeriesStored;
import org.dcm4chex.archive.ejb.interfaces.FileDTO;
import org.dcm4chex.archive.ejb.interfaces.FileSystemMgt2;
import org.dcm4chex.archive.ejb.interfaces.FileSystemMgt2Home;
import org.dcm4chex.archive.emf.EnhancedMFBuilder;
import org.dcm4chex.archive.exceptions.ConfigurationException;
import org.dcm4chex.archive.mbean.JMSDelegate;
import org.dcm4chex.archive.util.EJBHomeFactory;
import org.dcm4chex.archive.util.FileUtils;
import org.jboss.system.ServiceMBeanSupport;

public class UpgradeToEnhancedMFService
extends ServiceMBeanSupport
implements MessageListener,
NotificationListener {
    private static final int PETFrameTypeSeqTag = 1611089;
    private static final int[] SERIES_IUID = new int[]{0x20000E};
    private static final String UPGRADE_CT_XML = "upgrade-ct.xml";
    private static final String UPGRADE_MR_XML = "upgrade-mr.xml";
    private static final String UPGRADE_PET_XML = "upgrade-pet.xml";
    private ObjectName storeScpServiceName;
    private ObjectName queryRetrieveScpServiceName;
    private String queueName;
    private int concurrency = 1;
    private String configDir;
    private String fileSystemGroupID;
    private boolean mergePatientStudySeriesAttributesFromDB;
    private boolean noPixelData;
    private boolean deflate;
    private boolean deleteOriginalStoredSeries;
    private int bufferSize = 8192;
    private JMSDelegate jmsDelegate = new JMSDelegate(this);

    public final ObjectName getJmsServiceName() {
        return this.jmsDelegate.getJmsServiceName();
    }

    public final void setJmsServiceName(ObjectName jmsServiceName) {
        this.jmsDelegate.setJmsServiceName(jmsServiceName);
    }

    public final ObjectName getStoreScpServiceName() {
        return this.storeScpServiceName;
    }

    public final void setStoreScpServiceName(ObjectName storeScpServiceName) {
        this.storeScpServiceName = storeScpServiceName;
    }

    public final ObjectName getQueryRetrieveScpServiceName() {
        return this.queryRetrieveScpServiceName;
    }

    public final void setQueryRetrieveScpServiceName(ObjectName name) {
        this.queryRetrieveScpServiceName = name;
    }

    public final String getQueueName() {
        return this.queueName;
    }

    public final void setQueueName(String queueName) {
        this.queueName = queueName;
    }

    public final String getConfigDir() {
        return this.configDir;
    }

    public final void setConfigDir(String path) {
        this.configDir = path;
    }

    public final String getFileSystemGroupID() {
        return this.fileSystemGroupID;
    }

    public final void setFileSystemGroupID(String fileSystemGroupID) {
        this.fileSystemGroupID = fileSystemGroupID;
    }

    public final boolean isMergePatientStudySeriesAttributesFromDB() {
        return this.mergePatientStudySeriesAttributesFromDB;
    }

    public final void setMergePatientStudySeriesAttributesFromDB(boolean mergeFromDB) {
        this.mergePatientStudySeriesAttributesFromDB = mergeFromDB;
    }

    public final int getConcurrency() {
        return this.concurrency;
    }

    public final void setConcurrency(int concurrency) throws Exception {
        if (concurrency <= 0) {
            throw new IllegalArgumentException("Concurrency: " + concurrency);
        }
        if (this.concurrency != concurrency) {
            boolean restart;
            boolean bl = restart = this.getState() == 3;
            if (restart) {
                this.stop();
            }
            this.concurrency = concurrency;
            if (restart) {
                this.start();
            }
        }
    }

    public final boolean isNoPixelData() {
        return this.noPixelData;
    }

    public final void setNoPixelData(boolean noPixelData) {
        this.noPixelData = noPixelData;
    }

    public final boolean isDeflate() {
        return this.deflate;
    }

    public final void setDeflate(boolean deflate) {
        this.deflate = deflate;
    }

    public final boolean isDeleteOriginalStoredSeries() {
        return this.deleteOriginalStoredSeries;
    }

    public final void setDeleteOriginalStoredSeries(boolean delete) {
        this.deleteOriginalStoredSeries = delete;
    }

    public final int getBufferSize() {
        return this.bufferSize;
    }

    public final void setBufferSize(int bufferSize) {
        this.bufferSize = bufferSize;
    }

    protected void startService() throws Exception {
        this.jmsDelegate.startListening(this.queueName, this, this.concurrency);
        this.server.addNotificationListener(this.storeScpServiceName, this, SeriesStored.NOTIF_FILTER, null);
    }

    protected void stopService() throws Exception {
        this.server.removeNotificationListener(this.storeScpServiceName, this, SeriesStored.NOTIF_FILTER, null);
        this.jmsDelegate.stopListening(this.queueName);
    }

    public boolean isUpgradeEnabled(SeriesStored seriesStored) {
        String modality = seriesStored.getModality();
        if ("CT".equals(modality)) {
            return this.isUpgradeEnabled(seriesStored, UPGRADE_CT_XML, "1.2.840.10008.5.1.4.1.1.2");
        }
        if ("MR".equals(modality)) {
            return this.isUpgradeEnabled(seriesStored, UPGRADE_MR_XML, "1.2.840.10008.5.1.4.1.1.4");
        }
        if ("PT".equals(modality)) {
            return this.isUpgradeEnabled(seriesStored, UPGRADE_PET_XML, "1.2.840.10008.5.1.4.1.1.128");
        }
        return false;
    }

    private File getConfigFile(String aet, String fname) {
        File f;
        if (aet != null && (f = FileUtils.resolve(new File(new File(this.configDir, aet), fname))).exists()) {
            return f;
        }
        return FileUtils.resolve(new File(this.configDir, fname));
    }

    private Dataset loadConfig(File file) throws ConfigurationException {
        Dataset ds = DcmObjectFactory.getInstance().newDataset();
        try {
            SAXParserFactory f = SAXParserFactory.newInstance();
            SAXParser p = f.newSAXParser();
            p.parse(file, ds.getSAXHandler2(null));
        }
        catch (Exception e) {
            throw new ConfigurationException("Failed to load VMF Configuration from " + file);
        }
        return ds;
    }

    private boolean isUpgradeEnabled(SeriesStored seriesStored, String xml, String cuid) {
        String callingAET = seriesStored.getSourceAET();
        return this.getConfigFile(callingAET, xml).exists() && this.containsOnlySOPClass(seriesStored, cuid);
    }

    private boolean containsOnlySOPClass(SeriesStored seriesStored, String cuid) {
        Dataset ian = seriesStored.getIAN();
        Dataset refSeriesSeq = ian.getItem(528661);
        DcmElement refSOPSeq = refSeriesSeq.get(528793);
        int n = refSOPSeq.countItems();
        for (int i = 0; i < n; ++i) {
            Dataset refSOP = refSOPSeq.getItem(i);
            String refCUID = refSOP.getString(528720);
            if (cuid.equals(refCUID)) continue;
            return false;
        }
        return true;
    }

    public void handleNotification(Notification notif, Object handback) {
        SeriesStored seriesStored = (SeriesStored)notif.getUserData();
        if (this.isUpgradeEnabled(seriesStored)) {
            this.schedule(seriesStored);
        }
    }

    private void schedule(SeriesStored seriesStored) {
        try {
            this.log.info((Object)("Scheduling Upgrade to Enhanced MF for " + seriesStored));
            this.jmsDelegate.queue(this.queueName, seriesStored, 4, 0L);
        }
        catch (Exception e) {
            this.log.error((Object)("Failed to schedule Upgrade to Enhanced MF for " + seriesStored), (Throwable)e);
        }
    }

    public void onMessage(Message message) {
        block6: {
            ObjectMessage om = (ObjectMessage)message;
            try {
                SeriesStored seriesStored = (SeriesStored)om.getObject();
                this.log.info((Object)("Start upgrading " + seriesStored + " to Enhanced MF"));
                try {
                    this.upgradeToEMF(seriesStored);
                    this.log.info((Object)("Finished upgrading " + seriesStored + " to Enhanced MF"));
                    if (!this.deleteOriginalStoredSeries) break block6;
                    try {
                        this.deleteStoredSeries(seriesStored);
                    }
                    catch (Exception e) {
                        this.log.error((Object)("Failed to delete original " + seriesStored), (Throwable)e);
                    }
                }
                catch (Exception e) {
                    this.log.error((Object)("Failed to upgrade " + seriesStored + " to Enhanced MF"), (Throwable)e);
                }
            }
            catch (Throwable e) {
                this.log.error((Object)("unexpected error during processing message: " + message), e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void upgradeToEMF(SeriesStored seriesStored) throws Exception {
        block17: {
            Dataset ian = seriesStored.getIAN();
            Dataset refSeriesSeq = ian.getItem(528661);
            DcmElement refSOPSeq = refSeriesSeq.get(528793);
            int numFrames = refSOPSeq.countItems();
            EnhancedMFBuilder builder = this.newEMFBuilder(seriesStored, numFrames);
            File[] files = new File[numFrames];
            for (int i = 0; i < numFrames; ++i) {
                Dataset refSOP = refSOPSeq.getItem(i);
                String iuid = refSOP.getString(528725);
                files[i] = this.locateInstance(iuid);
                builder.add(files[i]);
            }
            Dataset mfds = builder.build();
            if (this.mergePatientStudySeriesAttributesFromDB) {
                mfds.putAll(seriesStored.getSeriesAttrs().exclude(SERIES_IUID));
                mfds.putAll(seriesStored.getStudyAttrs());
                mfds.putAll(seriesStored.getPatientAttrs());
            }
            String tsUID = mfds.getFileMetaInfo().getTransferSyntaxUID();
            FileDTO fileDTO = this.makeFile(mfds);
            File mffile = FileUtils.toFile(fileDTO.getDirectoryPath(), fileDTO.getFilePath());
            boolean deleteFile = true;
            try {
                this.log.info((Object)("M-WRITE file:" + mffile));
                MessageDigest md = MessageDigest.getInstance("MD5");
                DigestOutputStream dos = new DigestOutputStream(new FileOutputStream(mffile), md);
                BufferedOutputStream out = new BufferedOutputStream(dos, new byte[this.bufferSize]);
                try {
                    DcmEncodeParam encParam = DcmEncodeParam.valueOf(tsUID);
                    mfds.writeFile(out, encParam);
                    if (!this.noPixelData) {
                        mfds.writeHeader(out, encParam, 2145386512, builder.getPixelDataVR(), builder.getPixelDataLength());
                        if (encParam.encapsulated) {
                            mfds.writeHeader(out, encParam, -73728, 0, 0);
                        }
                        for (int i = 0; i < numFrames; ++i) {
                            Object var23_22;
                            long off = builder.getPixelDataOffset(i);
                            int len = builder.getPixelDataLength(i);
                            if (encParam.encapsulated) {
                                mfds.writeHeader(out, encParam, -73728, 0, len);
                            }
                            FileInputStream in = new FileInputStream(files[i]);
                            try {
                                while (off > 0L) {
                                    off -= in.skip(off);
                                }
                                out.copyFrom(in, len);
                                var23_22 = null;
                            }
                            catch (Throwable throwable) {
                                var23_22 = null;
                                in.close();
                                throw throwable;
                            }
                            in.close();
                        }
                        if (encParam.encapsulated) {
                            mfds.writeHeader(out, encParam, -73507, 0, 0);
                        }
                    }
                    Object var25_24 = null;
                }
                catch (Throwable throwable) {
                    Object var25_25 = null;
                    out.close();
                    throw throwable;
                }
                out.close();
                fileDTO.setFileMd5(md.digest());
                fileDTO.setFileSize(mffile.length());
                fileDTO.setFileTsuid(tsUID);
                this.importFile(fileDTO, mfds);
                deleteFile = false;
                Object var27_27 = null;
                if (!deleteFile) break block17;
            }
            catch (Throwable throwable) {
                Object var27_28 = null;
                if (deleteFile) {
                    this.log.info((Object)("M-DELETE file:" + mffile));
                    if (!mffile.delete()) {
                        this.log.error((Object)("Failed to delete " + mffile));
                    }
                }
                throw throwable;
            }
            this.log.info((Object)("M-DELETE file:" + mffile));
            if (!mffile.delete()) {
                this.log.error((Object)("Failed to delete " + mffile));
            }
        }
    }

    private EnhancedMFBuilder newEMFBuilder(SeriesStored seriesStored, int numFrames) {
        String callingAET = seriesStored.getSourceAET();
        String modality = seriesStored.getModality();
        if ("CT".equals(modality)) {
            return new EnhancedMFBuilder(this, this.loadConfig(this.getConfigFile(callingAET, UPGRADE_CT_XML)), 1610537, numFrames);
        }
        if ("MR".equals(modality)) {
            return new EnhancedMFBuilder(this, this.loadConfig(this.getConfigFile(callingAET, UPGRADE_MR_XML)), 1610278, numFrames);
        }
        if ("PT".equals(modality)) {
            return new EnhancedMFBuilder(this, this.loadConfig(this.getConfigFile(callingAET, UPGRADE_PET_XML)), 1611089, numFrames);
        }
        throw new IllegalArgumentException("modality: " + modality);
    }

    private FileDTO makeFile(Dataset dataset) throws Exception {
        return (FileDTO)this.server.invoke(this.storeScpServiceName, "makeFile", new Object[]{this.fileSystemGroupID, dataset}, new String[]{String.class.getName(), Dataset.class.getName()});
    }

    private void importFile(FileDTO fileDTO, Dataset dataset) throws Exception {
        this.server.invoke(this.storeScpServiceName, "importFile", new Object[]{fileDTO, dataset, null, Boolean.TRUE}, new String[]{FileDTO.class.getName(), Dataset.class.getName(), String.class.getName(), Boolean.TYPE.getName()});
    }

    private File locateInstance(String iuid) throws Exception {
        return (File)this.server.invoke(this.queryRetrieveScpServiceName, "locateInstance", new Object[]{iuid}, new String[]{String.class.getName()});
    }

    protected FileSystemMgt2 newFileSystemMgt() throws Exception {
        return ((FileSystemMgt2Home)EJBHomeFactory.getFactory().lookup(FileSystemMgt2Home.class, "ejb/FileSystemMgt2")).create();
    }

    private void deleteStoredSeries(SeriesStored seriesStored) throws Exception {
        FileDTO[] fileDTOs;
        for (FileDTO fileDTO : fileDTOs = this.newFileSystemMgt().deleteStoredSeries(seriesStored)) {
            FileUtils.delete(FileUtils.toFile(fileDTO.getDirectoryPath(), fileDTO.getFilePath()), true, fileDTO.getDirectoryPath());
        }
    }
}

