/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4chex.archive.emf;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Arrays;
import java.util.Date;
import java.util.Iterator;
import org.dcm4che.data.Dataset;
import org.dcm4che.data.DcmElement;
import org.dcm4che.data.DcmObjectFactory;
import org.dcm4che.data.DcmParser;
import org.dcm4che.data.DcmParserFactory;
import org.dcm4che.data.DcmValueException;
import org.dcm4che.data.FileFormat;
import org.dcm4che.util.UIDGenerator;
import org.dcm4chex.archive.emf.UpgradeToEnhancedMFException;
import org.dcm4chex.archive.emf.UpgradeToEnhancedMFService;
import org.jboss.logging.Logger;

class EnhancedMFBuilder {
    private static final int[] FG_SEQ_TAGS = new int[]{1375769129, 1375769136};
    private static final Dataset ALTERNATE_SOP_CLASS_INSTANCE = DcmObjectFactory.getInstance().newDataset();
    private final Logger log;
    private final Dataset filter;
    private final Dataset fgFilters;
    private final Dataset dataset;
    private final Dataset sharedFGs;
    private final int frameTypeTag;
    private final boolean noPixelData;
    private final boolean deflate;
    private final long[] pixelDataOffsets;
    private final int[] pixelDataLengths;
    private File f0;
    private int pixelDataVR;
    private int pixelDataLength;
    private int curFrame = 0;
    private String tsuid;
    private String[] imageType;
    private Date acquisitionDatetime;
    private Date contentDatetime;
    private String instanceNumber;

    public EnhancedMFBuilder(UpgradeToEnhancedMFService service, Dataset filter, int frameTypeTag, int numFrames) {
        this.log = service.getLog();
        this.noPixelData = service.isNoPixelData();
        this.deflate = service.isDeflate();
        this.filter = filter;
        this.fgFilters = filter.getItem(1375769129);
        this.dataset = DcmObjectFactory.getInstance().newDataset();
        this.sharedFGs = this.dataset.putSQ(1375769129).addNewItem();
        this.frameTypeTag = frameTypeTag;
        this.pixelDataOffsets = new long[numFrames];
        this.pixelDataLengths = new int[numFrames];
    }

    public final int getPixelDataVR() {
        return this.pixelDataVR;
    }

    public int getPixelDataLength() {
        return this.pixelDataLength == -1 ? -1 : this.pixelDataLength * this.pixelDataOffsets.length;
    }

    public long getPixelDataOffset(int i) {
        return this.pixelDataOffsets[i];
    }

    public int getPixelDataLength(int i) {
        return this.pixelDataLengths[i];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(File f) throws UpgradeToEnhancedMFException, IOException {
        if (this.curFrame == this.pixelDataOffsets.length) {
            throw new IllegalStateException("curFrame: " + this.curFrame + " == numFrame: " + this.pixelDataOffsets.length);
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("M-READ " + f));
        }
        Dataset source = DcmObjectFactory.getInstance().newDataset();
        BufferedInputStream bis = new BufferedInputStream(new FileInputStream(f));
        DcmParser parser = DcmParserFactory.getInstance().newDcmParser(bis);
        try {
            parser.setDcmHandler(source.getDcmHandler());
            parser.parseDcmFile(FileFormat.DICOM_FILE, 2145386512);
            if (parser.getReadTag() != 2145386512) {
                throw new UpgradeToEnhancedMFException("No Pixel Data in " + f);
            }
            if (this.curFrame == 0) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)("Create new Enhanced MF from " + f));
                }
                this.tsuid = source.getFileMetaInfo().getTransferSyntaxUID();
                this.pixelDataVR = parser.getReadVR();
                this.pixelDataLength = parser.getReadLength();
                this.init(source);
                this.f0 = f;
            } else {
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)("Merge Functional Groups to Enhanced MF from " + f));
                }
                if (this.pixelDataVR != parser.getReadVR()) {
                    throw new UpgradeToEnhancedMFException("VR of Pixel Data in " + f + " differs from " + this.f0);
                }
                if (this.pixelDataLength != parser.getReadLength()) {
                    throw new UpgradeToEnhancedMFException("Pixel Data Length in " + f + " differs from " + this.f0);
                }
                if (!this.noPixelData && !this.tsuid.equals(source.getFileMetaInfo().getTransferSyntaxUID())) {
                    throw new UpgradeToEnhancedMFException("Transfer Syntax of " + f + " differs from " + this.f0);
                }
                if (!this.dataset.exclude(FG_SEQ_TAGS).equals(source.subSet(this.filter))) {
                    throw new UpgradeToEnhancedMFException("Non Functional Groups elements of " + f + " differs from " + this.f0);
                }
                this.mergeFunctionalGroups(this.dataset, source);
            }
            if (this.pixelDataLength == -1) {
                parser.parseHeader();
                if (parser.getReadLength() != 0) {
                    throw new UpgradeToEnhancedMFException("Non-empty Frame Offset table in " + f);
                }
                parser.parseHeader();
            }
            this.pixelDataOffsets[this.curFrame] = parser.getStreamPosition();
            this.pixelDataLengths[this.curFrame] = parser.getReadLength();
            Object var6_5 = null;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            try {
                bis.close();
            }
            catch (IOException ignore) {
                // empty catch block
            }
            throw throwable;
        }
        try {
            bis.close();
        }
        catch (IOException ignore) {}
        ++this.curFrame;
    }

    private void init(Dataset source) {
        this.dataset.putAll(source.subSet(this.filter));
        Iterator it = this.fgFilters.iterator();
        while (it.hasNext()) {
            DcmElement el = (DcmElement)it.next();
            Dataset fgFilter = el.getItem();
            Dataset fg = source.subSet(fgFilter);
            if (fg.isEmpty()) continue;
            this.sharedFGs.putSQ(el.tag()).addNewItem().putAll(fg);
        }
        this.imageType = source.getStrings(524296);
        this.sharedFGs.putSQ(this.frameTypeTag).addNewItem().putCS(561159, this.imageType);
        Dataset perFrameFGs = this.dataset.putSQ(1375769136).addNewItem();
        this.addReferencedImageFG(perFrameFGs, source);
        this.addFrameContentFG(perFrameFGs, source);
    }

    private void addReferencedImageFG(Dataset perFrameFGs, Dataset source) {
        DcmElement refImageSeq = perFrameFGs.putSQ(528704);
        Dataset refSource = refImageSeq.addNewItem();
        refSource.putUI(528720, source.getString(524310));
        refSource.putUI(528725, source.getString(524312));
        refSource.putSQ(4235632).addItem(ALTERNATE_SOP_CLASS_INSTANCE);
        DcmElement srcRefImageSeq = source.get(528704);
        if (srcRefImageSeq != null) {
            int n = srcRefImageSeq.countItems();
            for (int i = 0; i < n; ++i) {
                refImageSeq.addItem(srcRefImageSeq.getItem(i));
            }
        }
    }

    private void addFrameContentFG(Dataset perFrameFGs, Dataset source) {
        String s;
        Dataset fg = perFrameFGs.putSQ(2134289).addNewItem();
        Date d = source.getDate(524330);
        if (d == null) {
            d = source.getDateTime(524322, 524338);
        }
        if (d != null) {
            fg.putDT(1609844, d);
            if (this.acquisitionDatetime == null || this.acquisitionDatetime.compareTo(d) > 0) {
                this.acquisitionDatetime = d;
            }
        }
        if ((s = source.getString(0x200012)) != null) {
            try {
                fg.putUS(2134358, Integer.parseInt(s));
            }
            catch (NumberFormatException e) {
                this.log.info((Object)("Ignore non-numeric Acquisition Number: " + s + " of Instance: " + source.getString(524312)));
            }
        }
        if ((s = source.getString(0x204000)) != null) {
            fg.putLT(2134360, s);
        }
        if ((s = source.getString(524306)) != null) {
            fg.putDA(524306, s);
        }
        if ((s = source.getString(524307)) != null) {
            fg.putTM(524307, s);
        }
        if ((s = source.getString(524323)) != null) {
            fg.putDA(524323, s);
        }
        if ((s = source.getString(524339)) != null) {
            fg.putTM(524339, s);
        }
        if ((s = source.getString(2097171)) != null) {
            fg.putIS(2097171, s);
        }
        if ((d = source.getDateTime(524323, 524339)) != null && (this.contentDatetime == null || this.contentDatetime.compareTo(d) > 0)) {
            this.contentDatetime = d;
            this.instanceNumber = s;
        }
    }

    private void mergeFunctionalGroups(Dataset dataset, Dataset source) {
        DcmElement perFrameFGSeq = dataset.get(1375769136);
        Dataset perFrameFGs = perFrameFGSeq.addNewItem();
        this.addReferencedImageFG(perFrameFGs, source);
        this.addFrameContentFG(perFrameFGs, source);
        int[] noLongerSharedFGTags = new int[]{};
        Iterator it = this.fgFilters.iterator();
        while (it.hasNext()) {
            Dataset sharedFG;
            DcmElement el = (DcmElement)it.next();
            int fgTag = el.tag();
            Dataset fgFilter = el.getItem();
            Dataset fg = source.subSet(fgFilter);
            if (fg.equals(sharedFG = this.sharedFGs.getItem(fgTag))) continue;
            if (sharedFG != null) {
                noLongerSharedFGTags = this.append(noLongerSharedFGTags, fgTag);
            }
            if (fg.isEmpty()) continue;
            perFrameFGs.putSQ(fgTag).addNewItem().putAll(fg);
        }
        Object[] frameType = source.getStrings(524296);
        if (!Arrays.equals(this.imageType, frameType) && this.sharedFGs.contains(this.frameTypeTag)) {
            noLongerSharedFGTags = this.append(noLongerSharedFGTags, this.frameTypeTag);
        }
        if (noLongerSharedFGTags.length != 0) {
            Dataset noLongerSharedFGs = this.sharedFGs.subSet(noLongerSharedFGTags);
            int n = perFrameFGSeq.countItems() - 1;
            for (int i = 0; i < n; ++i) {
                perFrameFGSeq.getItem(i).putAll(noLongerSharedFGs);
            }
            noLongerSharedFGs.clear();
        }
        if (!this.sharedFGs.contains(this.frameTypeTag)) {
            perFrameFGs.putSQ(this.frameTypeTag).addNewItem().putCS(561159, (String[])frameType);
        }
        this.imageType = this.mergeImageType(this.imageType, (String[])frameType);
    }

    private int[] append(int[] a, int i) {
        int[] tmp = new int[a.length + 1];
        System.arraycopy(a, 0, tmp, 0, a.length);
        tmp[a.length] = i;
        return tmp;
    }

    public Dataset build() throws UpgradeToEnhancedMFException {
        if (this.curFrame < this.pixelDataOffsets.length) {
            throw new IllegalStateException("curFrame: " + this.curFrame + " < numFrame: " + this.pixelDataOffsets.length);
        }
        this.dataset.putCS(524296, this.imageType);
        this.dataset.putCS(2097171, this.instanceNumber);
        this.dataset.putDA(524323, this.contentDatetime);
        this.dataset.putTM(524339, this.contentDatetime);
        this.dataset.putDT(524330, this.acquisitionDatetime);
        this.dataset.putIS(0x280008, this.pixelDataOffsets.length);
        UIDGenerator uidGen = UIDGenerator.getInstance();
        if (!this.dataset.containsValue(0x20000E)) {
            this.dataset.putUI(0x20000E, uidGen.createUID());
        }
        this.dataset.putUI(524310, this.filter.getString(524310));
        this.dataset.putUI(524312, uidGen.createUID());
        try {
            this.dataset.setFileMetaInfo(DcmObjectFactory.getInstance().newFileMetaInfo(this.dataset, this.noPixelData ? (this.deflate ? "1.2.840.10008.1.2.4.97" : "1.2.840.10008.1.2.4.96") : this.tsuid));
        }
        catch (DcmValueException e) {
            throw new UpgradeToEnhancedMFException(e);
        }
        return this.dataset;
    }

    private String[] mergeImageType(String[] t1, String[] t2) {
        if (t1.length < t2.length) {
            String[] tmp = t1;
            t1 = t2;
            t2 = tmp;
        }
        for (int i = 0; i < t1.length; ++i) {
            if (i < t2.length && t1[i].equals(t2[i])) continue;
            t1[i] = "MIXED";
        }
        return t1;
    }

    static {
        ALTERNATE_SOP_CLASS_INSTANCE.putLO(524544, "121326");
        ALTERNATE_SOP_CLASS_INSTANCE.putSH(524546, "DCM");
        ALTERNATE_SOP_CLASS_INSTANCE.putLO(524548, "Alternate SOP Class instance");
    }
}

