/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4chex.archive.dcm.ups;

import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageListener;
import javax.jms.ObjectMessage;
import javax.management.ObjectName;
import org.dcm4che.data.Command;
import org.dcm4che.data.Dataset;
import org.dcm4che.data.DcmObjectFactory;
import org.dcm4che.net.AAssociateAC;
import org.dcm4che.net.AAssociateRQ;
import org.dcm4che.net.AcceptorPolicy;
import org.dcm4che.net.ActiveAssociation;
import org.dcm4che.net.Association;
import org.dcm4che.net.AssociationFactory;
import org.dcm4che.net.DcmServiceException;
import org.dcm4che.net.DcmServiceRegistry;
import org.dcm4che.net.Dimse;
import org.dcm4che.net.ExtNegotiator;
import org.dcm4che.net.PDU;
import org.dcm4che.net.RoleSelection;
import org.dcm4che.util.UIDGenerator;
import org.dcm4chex.archive.common.UPSState;
import org.dcm4chex.archive.config.RetryIntervalls;
import org.dcm4chex.archive.dcm.AbstractScpService;
import org.dcm4chex.archive.dcm.ups.UPSEventReportOrder;
import org.dcm4chex.archive.dcm.ups.UPSFindScp;
import org.dcm4chex.archive.dcm.ups.UPSScp;
import org.dcm4chex.archive.ejb.conf.AttributeFilter;
import org.dcm4chex.archive.ejb.interfaces.AEDTO;
import org.dcm4chex.archive.ejb.interfaces.AEManager;
import org.dcm4chex.archive.ejb.interfaces.UPSManager;
import org.dcm4chex.archive.ejb.interfaces.UPSManagerHome;
import org.dcm4chex.archive.ejb.jdbc.UPSQueryCmd;
import org.dcm4chex.archive.exceptions.UnknownAETException;
import org.dcm4chex.archive.mbean.JMSDelegate;
import org.dcm4chex.archive.mbean.TLSConfigDelegate;
import org.dcm4chex.archive.util.EJBHomeFactory;

public class UPSScpService
extends AbstractScpService
implements MessageListener {
    private static final int FUZZY_MATCHING = 2;
    private static final int UNKNOWN_RECEIVING_AET = 49928;
    private static final int MSG_ID = 1;
    private static final int ERR_UPSEVENT_RJ = -2;
    private static final int ERR_ASSOC_RJ = -1;
    private static final int PCID_UPSEVENT = 1;
    private static final UIDGenerator uidgen = UIDGenerator.getInstance();
    private static final ExtNegotiator extNegotiator = new ExtNegotiator(){

        public byte[] negotiate(byte[] offered) {
            if (offered.length > 2) {
                offered[2] = (byte)(offered[2] & (AttributeFilter.isSoundexEnabled() ? (byte)1 : 0));
            }
            return offered;
        }
    };
    private boolean noMatchForNoValue;
    private String worklistLabel;
    private final Map<String, String> cuidMap = new LinkedHashMap<String, String>();
    private final UPSScp pushScp = new UPSScp(this);
    private final UPSFindScp findScp = new UPSFindScp(this);
    private TLSConfigDelegate tlsConfig = new TLSConfigDelegate(this);
    private int acTimeout = 5000;
    private int dimseTimeout = 0;
    private int soCloseDelay = 500;
    private RetryIntervalls.Map reportRetryIntervalls;
    private int concurrency = 1;
    private JMSDelegate jmsDelegate = new JMSDelegate(this);
    private String queueName = "UPSScp";
    private int fetchSize;

    public final ObjectName getJmsServiceName() {
        return this.jmsDelegate.getJmsServiceName();
    }

    public final void setJmsServiceName(ObjectName jmsServiceName) {
        this.jmsDelegate.setJmsServiceName(jmsServiceName);
    }

    public final int getConcurrency() {
        return this.concurrency;
    }

    public final void setConcurrency(int concurrency) throws Exception {
        if (concurrency <= 0) {
            throw new IllegalArgumentException("Concurrency: " + concurrency);
        }
        if (this.concurrency != concurrency) {
            boolean restart;
            boolean bl = restart = this.getState() == 3;
            if (restart) {
                this.stop();
            }
            this.concurrency = concurrency;
            if (restart) {
                this.start();
            }
        }
    }

    public String getReportRetryIntervalls() {
        return this.reportRetryIntervalls != null ? this.reportRetryIntervalls.toString() : "NEVER\n";
    }

    public void setReportRetryIntervalls(String text) {
        this.reportRetryIntervalls = new RetryIntervalls.Map(text);
    }

    public final ObjectName getTLSConfigName() {
        return this.tlsConfig.getTLSConfigName();
    }

    public final void setTLSConfigName(ObjectName tlsConfigName) {
        this.tlsConfig.setTLSConfigName(tlsConfigName);
    }

    public final int getReceiveBufferSize() {
        return this.tlsConfig.getReceiveBufferSize();
    }

    public final void setReceiveBufferSize(int size) {
        this.tlsConfig.setReceiveBufferSize(size);
    }

    public final int getSendBufferSize() {
        return this.tlsConfig.getSendBufferSize();
    }

    public final void setSendBufferSize(int size) {
        this.tlsConfig.setSendBufferSize(size);
    }

    public final boolean isTcpNoDelay() {
        return this.tlsConfig.isTcpNoDelay();
    }

    public final void setTcpNoDelay(boolean on) {
        this.tlsConfig.setTcpNoDelay(on);
    }

    public final String getQueueName() {
        return this.queueName;
    }

    public final void setQueueName(String queueName) {
        this.queueName = queueName;
    }

    public final int getAcTimeout() {
        return this.acTimeout;
    }

    public final void setAcTimeout(int acTimeout) {
        this.acTimeout = acTimeout;
    }

    public final int getDimseTimeout() {
        return this.dimseTimeout;
    }

    public final void setDimseTimeout(int dimseTimeout) {
        this.dimseTimeout = dimseTimeout;
    }

    public final int getSoCloseDelay() {
        return this.soCloseDelay;
    }

    public final void setSoCloseDelay(int soCloseDelay) {
        this.soCloseDelay = soCloseDelay;
    }

    public final String getWorklistLabel() {
        return this.worklistLabel;
    }

    public final void setWorklistLabel(String s) {
        String trim = s.trim();
        if (trim.length() == 0) {
            throw new IllegalArgumentException("Worklist Label cannot be empty!");
        }
        this.worklistLabel = trim;
    }

    public String getAcceptedSOPClasses() {
        return this.toString(this.cuidMap);
    }

    public void setAcceptedSOPClasses(String s) {
        this.updateAcceptedSOPClass(this.cuidMap, s, null);
    }

    public final boolean isNoMatchForNoValue() {
        return this.noMatchForNoValue;
    }

    public final void setNoMatchForNoValue(boolean noMatchForNoValue) {
        this.noMatchForNoValue = noMatchForNoValue;
    }

    public final boolean getAccessBlobAsLongVarBinary() {
        return UPSQueryCmd.blobAccessType == -4;
    }

    public final void setAccessBlobAsLongVarBinary(boolean enable) {
        UPSQueryCmd.blobAccessType = enable ? -4 : 2004;
    }

    public final String getTransactionIsolationLevel() {
        return UPSQueryCmd.transactionIsolationLevelAsString((int)UPSQueryCmd.transactionIsolationLevel);
    }

    public final void setTransactionIsolationLevel(String level) {
        UPSQueryCmd.transactionIsolationLevel = UPSQueryCmd.transactionIsolationLevelOf((String)level);
    }

    public int getFetchSize() {
        return this.fetchSize;
    }

    public void setFetchSize(int fetchSize) {
        this.fetchSize = fetchSize;
    }

    protected void bindDcmServices(DcmServiceRegistry services) {
        services.bind("1.2.840.10008.5.1.4.34.4.1", this.pushScp);
        services.bind("1.2.840.10008.5.1.4.34.4.3", this.findScp);
        services.bind("1.2.840.10008.5.1.4.34.4.2", this.findScp);
    }

    protected void unbindDcmServices(DcmServiceRegistry services) {
        services.unbind("1.2.840.10008.5.1.4.34.4.1");
        services.unbind("1.2.840.10008.5.1.4.34.4.3");
        services.unbind("1.2.840.10008.5.1.4.34.4.2");
    }

    protected void enablePresContexts(AcceptorPolicy policy) {
        this.putPresContexts(policy, UPSScpService.valuesToStringArray(this.cuidMap), UPSScpService.valuesToStringArray(this.tsuidMap));
        policy.putExtNegPolicy("1.2.840.10008.5.1.4.34.4.3", extNegotiator);
        policy.putExtNegPolicy("1.2.840.10008.5.1.4.34.4.2", extNegotiator);
    }

    protected void disablePresContexts(AcceptorPolicy policy) {
        this.putPresContexts(policy, UPSScpService.valuesToStringArray(this.cuidMap), null);
        policy.putExtNegPolicy("1.2.840.10008.5.1.4.34.4.3", null);
        policy.putExtNegPolicy("1.2.840.10008.5.1.4.34.4.2", null);
    }

    String createUID() {
        return uidgen.createUID();
    }

    public void updateOrCreateUPS(Dataset ups) throws Exception {
        if (!this.upsManager().updateMatchingUPS(ups)) {
            ups.putUI(524312, this.createUID());
            this.createUPS(this.calledAETs[0], ups);
        }
    }

    public void createUPS(String scpAET, Dataset ds) throws DcmServiceException {
        String iuid = ds.getString(524312);
        try {
            UPSManager upsmgr = this.upsManager();
            upsmgr.createUPS(ds, this.patientMatching());
            Collection receivingAETs = upsmgr.getReceivingAETs(iuid);
            if (!receivingAETs.isEmpty()) {
                Dataset stateReport = DcmObjectFactory.getInstance().newDataset();
                stateReport.putCS(7606272, ds.getString(7606272));
                for (String receivingAET : receivingAETs) {
                    this.queueUPSEventReportOrder(scpAET, receivingAET, iuid, 1, stateReport);
                }
            }
        }
        catch (DcmServiceException e) {
            throw e;
        }
        catch (Exception e) {
            throw new DcmServiceException(272, e.getMessage(), e);
        }
    }

    public void updateUPS(String scpAET, String iuid, Dataset rqData) throws DcmServiceException {
        try {
            UPSManager upsmgr = this.upsManager();
            upsmgr.updateUPS(iuid, rqData);
            Dataset processInfo = rqData.getItem(7606274);
            if (processInfo != null && (processInfo.contains(7606276) || processInfo.contains(7606278))) {
                Collection receivingAETs = upsmgr.getReceivingAETs(iuid);
                for (String receivingAET : receivingAETs) {
                    this.queueUPSEventReportOrder(scpAET, receivingAET, iuid, 3, processInfo);
                }
            }
        }
        catch (DcmServiceException e) {
            throw e;
        }
        catch (Exception e) {
            throw new DcmServiceException(272, e.getMessage(), e);
        }
    }

    public void requestUPSCancel(String scpAET, String iuid, String requestingAET, Dataset rqData) throws DcmServiceException {
        try {
            UPSManager upsmgr = this.upsManager();
            int upsState = upsmgr.getUPSState(iuid);
            Collection receivingAETs = upsmgr.getReceivingAETs(iuid);
            boolean noReceivingAETs = receivingAETs.isEmpty();
            switch (upsState) {
                case 1: {
                    if (!noReceivingAETs) break;
                    throw new DcmServiceException(49938, "The performer cannot be contacted");
                }
                case 2: {
                    throw new DcmServiceException(49938, "UPS is already COMPLETED");
                }
                case 3: {
                    throw new DcmServiceException(45828, "UPS is already CANCELED");
                }
            }
            if (!noReceivingAETs) {
                Dataset cancelRequested = DcmObjectFactory.getInstance().newDataset();
                cancelRequested.putAll(rqData);
                cancelRequested.putAE(7606838, requestingAET);
                for (String receivingAET : receivingAETs) {
                    this.queueUPSEventReportOrder(scpAET, receivingAET, iuid, 2, cancelRequested);
                }
            }
            if (upsState == 0) {
                if (!rqData.isEmpty()) {
                    upsmgr.setRequestUPSCancelInfo(iuid, rqData);
                }
                String tuid = this.startUPS(scpAET, iuid);
                this.cancelUPS(scpAET, iuid, tuid);
            }
        }
        catch (DcmServiceException e) {
            throw e;
        }
        catch (Exception e) {
            throw new DcmServiceException(272, e.getMessage(), e);
        }
    }

    Dataset getUPS(String iuid, int[] attrList) throws DcmServiceException {
        try {
            Dataset ups = this.upsManager().getUPS(iuid);
            return attrList != null ? ups.subSet(attrList) : ups;
        }
        catch (DcmServiceException e) {
            throw e;
        }
        catch (Exception e) {
            throw new DcmServiceException(272, e.getMessage(), e);
        }
    }

    void changeUPSState(String scpAET, String iuid, int state, String tuid) throws DcmServiceException {
        try {
            UPSManager upsmgr = this.upsManager();
            Collection receivingAETs = upsmgr.getReceivingAETs(iuid);
            Dataset stateReport = upsmgr.changeUPSState(iuid, state, tuid);
            for (String receivingAET : receivingAETs) {
                this.queueUPSEventReportOrder(scpAET, receivingAET, iuid, 1, stateReport);
            }
        }
        catch (DcmServiceException e) {
            throw e;
        }
        catch (Exception e) {
            throw new DcmServiceException(272, e.getMessage(), e);
        }
    }

    public String startUPS(String scpAET, String iuid) throws DcmServiceException {
        String tsuid = this.createUID();
        this.changeUPSState(scpAET, iuid, 1, tsuid);
        return tsuid;
    }

    public void completeUPS(String scpAET, String iuid, String tsuid) throws DcmServiceException {
        this.changeUPSState(scpAET, iuid, 2, tsuid);
    }

    public void cancelUPS(String scpAET, String iuid, String tsuid) throws DcmServiceException {
        this.changeUPSState(scpAET, iuid, 3, tsuid);
    }

    public void subscribeReceiveUPSEventReports(String scpAET, String iuid, String receivingAET, boolean dellock) throws DcmServiceException {
        try {
            this.aeMgr().findByAET(receivingAET);
            UPSManager upsmgr = this.upsManager();
            upsmgr.subscribeReceiveUPSEventReports(iuid, receivingAET, dellock);
            Dataset stateReport = upsmgr.getUPSStateReport(iuid);
            this.queueUPSEventReportOrder(scpAET, receivingAET, iuid, 1, stateReport);
        }
        catch (DcmServiceException e) {
            throw e;
        }
        catch (UnknownAETException e) {
            throw new DcmServiceException(49928, "Receiving AE-TITLE: " + receivingAET + " is Unknown to this SCP");
        }
        catch (Exception e) {
            throw new DcmServiceException(272, e.getMessage(), e);
        }
    }

    public void subscribeGlobally(String scpAET, String receivingAET, boolean dellock) throws DcmServiceException {
        try {
            this.aeMgr().findByAET(receivingAET);
            UPSManager upsmgr = this.upsManager();
            Collection iuids = upsmgr.subscribeGlobally(receivingAET, dellock);
            if (dellock) {
                for (String iuid : iuids) {
                    Dataset stateReport = upsmgr.getUPSStateReport(iuid);
                    this.queueUPSEventReportOrder(scpAET, receivingAET, iuid, 1, stateReport);
                }
            }
        }
        catch (DcmServiceException e) {
            throw e;
        }
        catch (UnknownAETException e) {
            throw new DcmServiceException(49928, "Receiving AE-TITLE: " + receivingAET + " is Unknown to this SCP");
        }
        catch (Exception e) {
            throw new DcmServiceException(272, e.getMessage(), e);
        }
    }

    public void unsubscribeReceiveUPSEventReports(String iuid, String aet) throws DcmServiceException {
        try {
            this.upsManager().unsubscribeReceiveUPSEventReports(iuid, aet);
        }
        catch (DcmServiceException e) {
            throw e;
        }
        catch (Exception e) {
            throw new DcmServiceException(272, e.getMessage(), e);
        }
    }

    public void unsubscribeGlobally(String aet) throws DcmServiceException {
        try {
            this.upsManager().unsubscribeGlobally(aet);
        }
        catch (DcmServiceException e) {
            throw e;
        }
        catch (Exception e) {
            throw new DcmServiceException(272, e.getMessage(), e);
        }
    }

    public void suspendGlobalSubscription(String aet) throws DcmServiceException {
        try {
            this.upsManager().suspendGlobalSubscription(aet);
        }
        catch (Exception e) {
            throw new DcmServiceException(272, e.getMessage(), e);
        }
    }

    private UPSManager upsManager() throws Exception {
        return ((UPSManagerHome)EJBHomeFactory.getFactory().lookup(UPSManagerHome.class, "ejb/UPSManager")).create();
    }

    public void queueUPSEventReportOrder(String callingAET, String calledAET, String iuid, int eventTypeID, Dataset eventInfo) throws Exception {
        UPSEventReportOrder order = new UPSEventReportOrder(callingAET, calledAET, iuid, eventTypeID, eventInfo);
        this.jmsDelegate.queue(this.queueName, order, 0, 0L);
    }

    public void onMessage(Message message) {
        block6: {
            ObjectMessage om = (ObjectMessage)message;
            try {
                UPSEventReportOrder order = (UPSEventReportOrder)om.getObject();
                this.log.info((Object)("Start processing " + order));
                try {
                    this.process(order);
                    this.log.info((Object)("Finished processing " + order));
                }
                catch (Exception e) {
                    order.setThrowable(e);
                    int failureCount = order.getFailureCount() + 1;
                    order.setFailureCount(failureCount);
                    long delay = this.reportRetryIntervalls.getIntervall(order.getCalledAET(), failureCount);
                    if (delay == -1L) {
                        this.log.error((Object)("Give up to process " + order), (Throwable)e);
                        this.jmsDelegate.fail(this.queueName, order);
                        break block6;
                    }
                    this.log.warn((Object)("Failed to process " + order + ". Scheduling retry."), (Throwable)e);
                    this.jmsDelegate.queue(this.queueName, order, 0, System.currentTimeMillis() + delay);
                }
            }
            catch (JMSException e) {
                this.log.error((Object)("jms error during processing message: " + message), (Throwable)e);
            }
            catch (Throwable e) {
                this.log.error((Object)("unexpected error during processing message: " + message), e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void process(UPSEventReportOrder order) throws Exception {
        AEManager aeMgr = this.aeMgr();
        String aet = order.getCalledAET();
        String callingAET = order.getCallingAET();
        AEDTO callingAE = aeMgr.findByAET(callingAET);
        AEDTO remoteAE = aeMgr.findByAET(aet);
        Dataset ds = order.getEventInfo();
        AssociationFactory af = AssociationFactory.getInstance();
        Association a = af.newRequestor(this.tlsConfig.createSocket(callingAE, remoteAE));
        a.setAcTimeout(this.acTimeout);
        a.setDimseTimeout(this.dimseTimeout);
        a.setSoCloseDelay(this.soCloseDelay);
        AAssociateRQ rq = af.newAAssociateRQ();
        rq.setCalledAET(aet);
        rq.setCallingAET(callingAET);
        rq.addPresContext(af.newPresContext(1, "1.2.840.10008.5.1.4.34.4.4", UPSScpService.valuesToStringArray(this.tsuidMap)));
        rq.addRoleSelection(af.newRoleSelection("1.2.840.10008.5.1.4.34.4.4", false, true));
        PDU ac = a.connect(rq);
        if (!(ac instanceof AAssociateAC)) {
            throw new DcmServiceException(-1, "Association not accepted by " + aet + ": " + ac);
        }
        ActiveAssociation aa = af.newActiveAssociation(a, null);
        aa.start();
        try {
            if (a.getAcceptedTransferSyntaxUID(1) == null) {
                throw new DcmServiceException(-2, "UPS Event SOP Class not supported by remote AE: " + aet);
            }
            Command cmdRq = DcmObjectFactory.getInstance().newCommand();
            RoleSelection rs = ((AAssociateAC)ac).getRoleSelection("1.2.840.10008.5.1.4.34.4.4");
            if (rs == null || !rs.scp()) {
                this.log.warn((Object)("SCU Role of UPS Event SOP Class rejected by " + aet + " - try to send N_EVENT_REPORT anyway"));
            }
            cmdRq.initNEventReportRQ(1, "1.2.840.10008.5.1.4.34.4.1", order.getSOPInstanceUID(), order.getEventTypeID());
            this.log.debug((Object)ds);
            Dimse rsp = aa.invoke(af.newDimse(1, cmdRq, ds)).get();
            Command cmdRsp = rsp.getCommand();
            int status = cmdRsp.getStatus();
            if (status != 0) {
                throw new DcmServiceException(status, cmdRsp.getString(2306));
            }
            Object var19_18 = null;
        }
        catch (Throwable throwable) {
            Object var19_19 = null;
            try {
                aa.release(true);
            }
            catch (Exception e) {
                this.log.warn((Object)("Failed to release association " + aa.getAssociation()), (Throwable)e);
            }
            throw throwable;
        }
        try {
            aa.release(true);
        }
        catch (Exception e) {
            this.log.warn((Object)("Failed to release association " + aa.getAssociation()), (Throwable)e);
        }
    }

    protected void startService() throws Exception {
        super.startService();
        this.jmsDelegate.startListening(this.queueName, this, this.concurrency);
    }

    protected void stopService() throws Exception {
        this.jmsDelegate.stopListening(this.queueName);
        super.stopService();
    }

    static int upsStateAsInt(String upsState) throws DcmServiceException {
        try {
            return UPSState.toInt(upsState);
        }
        catch (IllegalArgumentException e) {
            throw new DcmServiceException(262, "Illegal UPS State Value: " + upsState);
        }
    }
}

