/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4chex.archive.dcm.ups;

import java.io.IOException;
import java.util.Date;
import org.dcm4che.data.Command;
import org.dcm4che.data.Dataset;
import org.dcm4che.data.DcmElement;
import org.dcm4che.dict.Tags;
import org.dcm4che.net.ActiveAssociation;
import org.dcm4che.net.Association;
import org.dcm4che.net.DcmServiceBase;
import org.dcm4che.net.DcmServiceException;
import org.dcm4che.net.Dimse;
import org.dcm4chex.archive.dcm.ups.UPSScpService;
import org.jboss.logging.Logger;

class UPSScp
extends DcmServiceBase {
    private static final int CORRECT_TRANSACTION_UID_NOT_PROVIDED = 49921;
    private static final int MAY_ONLY_BECOME_SCHEDULED_VIA_NCREATE = 49923;
    private static final int UPS_STATE_WAS_NOT_SCHEDULED = 49929;
    private final UPSScpService service;
    private Logger log;

    public UPSScp(UPSScpService service) {
        this.service = service;
        this.log = service.getLog();
    }

    protected Dataset doNCreate(ActiveAssociation assoc, Dimse rq, Command rspCmd) throws IOException, DcmServiceException {
        String calledAET = assoc.getAssociation().getCalledAET();
        Command rqCmd = rq.getCommand();
        Dataset rqData = rq.getDataset();
        if (!UPSScp.abstractSyntaxEquals(assoc, rq, "1.2.840.10008.5.1.4.34.4.1")) {
            throw new DcmServiceException(529);
        }
        this.log.debug((Object)"Identifier:\n");
        this.log.debug((Object)rqData);
        UPSScp.checkNCreateRQ(rqCmd, rqData);
        this.coerceNCreateRQ(rspCmd, rqData);
        this.service.createUPS(calledAET, rqData);
        return null;
    }

    private void coerceNCreateRQ(Command rspCmd, Dataset rqData) {
        rqData.putUI(524310, rspCmd.getAffectedSOPClassUID());
        rqData.putUI(524312, rspCmd.getAffectedSOPInstanceUID());
        this.initSPSModificationDateandTime(rqData);
        if (!rqData.containsValue(7606786)) {
            rqData.putLO(7606786, this.service.getWorklistLabel());
        }
    }

    private void initSPSModificationDateandTime(Dataset rqData) {
        rqData.putDT(0x404010, new Date());
    }

    private static void checkNCreateRQ(Command rqCmd, Dataset rqData) throws DcmServiceException {
        UPSScp.shallBeEmpty(rqData, 528789, new int[0]);
        UPSScp.notAllowed(rqData, 524310);
        UPSScp.notAllowed(rqData, 524312);
        UPSScp.type1(rqData, 7606784, new int[0]);
        UPSScp.type2(rqData, 0x404010, new int[0]);
        UPSScp.type1(rqData, 7606788, new int[0]);
        UPSScp.type2(rqData, 7606786, new int[0]);
        UPSScp.type2(rqData, 7606800, new int[0]);
        UPSScp.checkContentItem(rqData, 7606800, new int[0]);
        UPSScp.type2(rqData, 4210725, new int[0]);
        UPSScp.checkCodeItem(rqData, ItemCount.MULTIPLE, 4210725, new int[0]);
        UPSScp.type2(rqData, 4210726, new int[0]);
        UPSScp.checkCodeItem(rqData, ItemCount.MULTIPLE, 4210726, new int[0]);
        UPSScp.type2(rqData, 4210727, new int[0]);
        UPSScp.checkCodeItem(rqData, ItemCount.MULTIPLE, 4210727, new int[0]);
        UPSScp.type2(rqData, 0x404004, new int[0]);
        UPSScp.checkCodeItem(rqData, ItemCount.MULTIPLE, 0x404004, new int[0]);
        UPSScp.checkScheduledHumanPerformers(rqData);
        UPSScp.type1(rqData, 0x404005, new int[0]);
        UPSScp.type2(rqData, 4210712, new int[0]);
        UPSScp.checkCodeItem(rqData, ItemCount.SINGLE, 4210712, new int[0]);
        UPSScp.type2(rqData, 0x400400, new int[0]);
        UPSScp.type2(rqData, 4210721, new int[0]);
        UPSScp.checkImageSOPInstanceAndSourceReference(rqData, 4210721, new int[0]);
        UPSScp.type2(rqData, 3670032, new int[0]);
        UPSScp.type2(rqData, 3670036, new int[0]);
        UPSScp.type2(rqData, 528512, new int[0]);
        UPSScp.type2(rqData, 528516, new int[0]);
        UPSScp.checkCodeItem(rqData, ItemCount.MULTIPLE, 528516, new int[0]);
        UPSScp.type2(rqData, 4236144, new int[0]);
        UPSScp.checkReferencedRequests(rqData);
        UPSScp.type2(rqData, 7606816, new int[0]);
        UPSScp.checkRelatedProcedureSteps(rqData);
        UPSScp.type1(rqData, 7606272, new int[0]);
        if (UPSScpService.upsStateAsInt(rqData.getString(7606272)) != 0) {
            throw new DcmServiceException(49929, "The provided value of UPS State was not SCHEDULED");
        }
        UPSScp.shallBeEmpty(rqData, 7606274, new int[0]);
        UPSScp.shallBeEmpty(rqData, 7606806, new int[0]);
    }

    private static void checkRelatedProcedureSteps(Dataset rqData) throws DcmServiceException {
        DcmElement sq = rqData.get(7606816);
        if (sq == null) {
            return;
        }
        int n = sq.countItems();
        for (int i = 0; i < n; ++i) {
            Dataset item = sq.getItem(i);
            UPSScp.type1(item, 528720, 7606816);
            UPSScp.type1(item, 528725, 7606816);
            UPSScp.type1(item, 4235632, 7606816);
            UPSScp.checkCodeItem(item, ItemCount.SINGLE, 4235632, 7606816);
        }
    }

    private static void checkReferencedRequests(Dataset rqData) throws DcmServiceException {
        DcmElement sq = rqData.get(4236144);
        if (sq == null) {
            return;
        }
        int n = sq.countItems();
        for (int i = 0; i < n; ++i) {
            Dataset item = sq.getItem(i);
            UPSScp.type1(item, 0x20000D, 4236144);
            UPSScp.type2(item, 524368, 4236144);
            UPSScp.type2(item, 0x401001, 4236144);
            UPSScp.type2(item, 3280992, 4236144);
            UPSScp.type2(item, 3280996, 4236144);
            UPSScp.checkCodeItem(item, ItemCount.SINGLE, 3280996, 4236144);
            UPSScp.checkCodeItem(item, ItemCount.MULTIPLE, 4198410, 4236144);
        }
    }

    private static void checkImageSOPInstanceAndSourceReference(Dataset rqData, int tag, int ... sqTags) throws DcmServiceException {
        DcmElement sq = rqData.get(tag);
        if (sq == null) {
            return;
        }
        int[] sqTags1 = UPSScp.cat(sqTags, tag);
        int[] sqTags2 = UPSScp.cat(sqTags1, 528793);
        int n = sq.countItems();
        for (int i = 0; i < n; ++i) {
            Dataset item = sq.getItem(i);
            UPSScp.type1(item, 528793, sqTags1);
            DcmElement refSOPSeq = item.get(528793);
            int m = refSOPSeq.countItems();
            for (int j = 0; j < m; ++j) {
                Dataset refSOP = refSOPSeq.getItem(j);
                UPSScp.type1(refSOP, 528720, sqTags2);
                UPSScp.type1(refSOP, 528725, sqTags2);
            }
        }
    }

    private static void checkScheduledHumanPerformers(Dataset rqData) throws DcmServiceException {
        DcmElement sq = rqData.get(0x404034);
        if (sq == null) {
            return;
        }
        int n = sq.countItems();
        for (int i = 0; i < n; ++i) {
            Dataset item = sq.getItem(i);
            UPSScp.type1(item, 0x404009, 0x404034);
            UPSScp.checkCodeItem(item, ItemCount.SINGLE, 0x404009, 0x404034);
            UPSScp.type1(item, 4210743, 0x404034);
            UPSScp.type1(item, 4210742, 0x404034);
        }
    }

    private static void checkCodeItem(Dataset rqData, ItemCount itemCount, int tag, int ... sqTags) throws DcmServiceException {
        DcmElement sq = rqData.get(tag);
        if (sq == null || sq.isEmpty()) {
            return;
        }
        int n = sq.countItems();
        if (itemCount == ItemCount.SINGLE && n > 1) {
            throw new DcmServiceException(262, UPSScp.errorMessage("More than 1 item of Attribute: ", tag, sqTags));
        }
        int[] sqTags1 = UPSScp.cat(sqTags, tag);
        for (int i = 0; i < n; ++i) {
            Dataset item = sq.getItem(i);
            UPSScp.type1(item, 524544, sqTags1);
            UPSScp.type1(item, 524546, sqTags1);
            UPSScp.type1(item, 524548, sqTags1);
        }
    }

    private static int[] cat(int[] sqTags, int tag) {
        int last = sqTags.length;
        int[] dest = new int[last + 1];
        System.arraycopy(sqTags, 0, dest, 0, last);
        dest[last] = tag;
        return dest;
    }

    private static void checkContentItem(Dataset rqData, int tag, int ... sqTags) throws DcmServiceException {
        DcmElement sq = rqData.get(tag);
        if (sq == null || sq.isEmpty()) {
            return;
        }
        int[] sqTags1 = UPSScp.cat(sqTags, tag);
        int n = sq.countItems();
        for (int i = 0; i < n; ++i) {
            Dataset item = sq.getItem(i);
            UPSScp.type1(item, 0x40A040, sqTags1);
            UPSScp.type1(item, 4235331, sqTags1);
            UPSScp.checkCodeItem(item, ItemCount.SINGLE, 4235331, sqTags1);
            String valueType = item.getString(0x40A040);
            if (valueType.equals("DATETIME")) {
                UPSScp.type1(item, 4235552, sqTags1);
                continue;
            }
            if (valueType.equals("DATE")) {
                UPSScp.type1(item, 4235553, sqTags1);
                continue;
            }
            if (valueType.equals("TIME")) {
                UPSScp.type1(item, 4235554, sqTags1);
                continue;
            }
            if (valueType.equals("PNAME")) {
                UPSScp.type1(item, 4235555, sqTags1);
                continue;
            }
            if (valueType.equals("UIDREF")) {
                UPSScp.type1(item, 4235556, sqTags1);
                continue;
            }
            if (valueType.equals("TEXT")) {
                UPSScp.type1(item, 4235616, sqTags1);
                continue;
            }
            if (valueType.equals("CODE")) {
                UPSScp.type1(item, 4235624, sqTags1);
                UPSScp.checkCodeItem(item, ItemCount.SINGLE, 4235624, sqTags1);
                continue;
            }
            if (valueType.equals("NUMERIC")) {
                UPSScp.type1(item, 4236042, sqTags1);
                UPSScp.type1(item, 4196586, sqTags1);
                UPSScp.checkCodeItem(item, ItemCount.SINGLE, 4196586, sqTags1);
                continue;
            }
            throw new DcmServiceException(262, UPSScp.errorMessage("Invalid Value Type: " + valueType + " ", 0x40A040, sqTags1));
        }
    }

    private static void shallBeEmpty(Dataset rqData, int tag, int ... sqTags) throws DcmServiceException {
        UPSScp.type2(rqData, tag, sqTags);
        if (rqData.containsValue(tag)) {
            throw new DcmServiceException(262, UPSScp.errorMessage("Shall be empty Attribute: ", tag, sqTags));
        }
    }

    private static void notAllowed(Dataset rqData, int tag) throws DcmServiceException {
        if (rqData.contains(tag)) {
            throw new DcmServiceException(261, UPSScp.errorMessage("Not allowed Attribute: ", tag, new int[0]));
        }
    }

    private static void type1(Dataset rqData, int tag, int ... sqTags) throws DcmServiceException {
        if (!rqData.containsValue(tag)) {
            UPSScp.type2(rqData, tag, sqTags);
            new DcmServiceException(sqTags.length == 0 ? 289 : 262, UPSScp.errorMessage("Missing Attribute Value: ", tag, sqTags));
        }
    }

    private static String errorMessage(String msg, int tag, int ... sqTags) {
        StringBuffer sb = new StringBuffer(msg);
        if (sqTags != null && sqTags.length != 0) {
            for (int sqTag : sqTags) {
                Tags.toString(sb, sqTag).append('/');
            }
        }
        Tags.toString(sb, tag);
        return sb.toString();
    }

    private static void type2(Dataset rqData, int tag, int ... sqTags) throws DcmServiceException {
        if (!rqData.contains(tag)) {
            new DcmServiceException(sqTags.length == 0 ? 288 : 262, UPSScp.errorMessage("Missing Attribute ", tag, sqTags));
        }
    }

    private static boolean abstractSyntaxEquals(ActiveAssociation assoc, Dimse rq, String uid) {
        String asuid = assoc.getAssociation().getProposedPresContext(rq.pcid()).getAbstractSyntaxUID();
        return asuid.equals(uid);
    }

    private static boolean abstractSyntaxEquals(ActiveAssociation assoc, Dimse rq, String uid1, String uid2) {
        String asuid = assoc.getAssociation().getProposedPresContext(rq.pcid()).getAbstractSyntaxUID();
        return asuid.equals(uid1) || asuid.equals(uid2);
    }

    protected Dataset doNSet(ActiveAssociation assoc, Dimse rq, Command rspCmd) throws IOException, DcmServiceException {
        String calledAET = assoc.getAssociation().getCalledAET();
        Command rqCmd = rq.getCommand();
        Dataset rqData = rq.getDataset();
        if (!UPSScp.abstractSyntaxEquals(assoc, rq, "1.2.840.10008.5.1.4.34.4.3")) {
            throw new DcmServiceException(529);
        }
        this.log.debug((Object)"Identifier:\n");
        this.log.debug((Object)rqData);
        this.checkNSetRQ(rqCmd, rqData);
        this.initSPSModificationDateandTime(rqData);
        this.service.updateUPS(calledAET, rspCmd.getAffectedSOPInstanceUID(), rqData);
        return null;
    }

    private void checkNSetRQ(Command rqCmd, Dataset rqData) throws DcmServiceException {
        UPSScp.notAllowed(rqData, 524310);
        UPSScp.notAllowed(rqData, 524312);
        UPSScp.checkContentItem(rqData, 7606800, new int[0]);
        UPSScp.checkCodeItem(rqData, ItemCount.MULTIPLE, 4210725, new int[0]);
        UPSScp.checkCodeItem(rqData, ItemCount.MULTIPLE, 4210726, new int[0]);
        UPSScp.checkCodeItem(rqData, ItemCount.MULTIPLE, 4210727, new int[0]);
        UPSScp.checkScheduledHumanPerformers(rqData);
        UPSScp.checkCodeItem(rqData, ItemCount.SINGLE, 4210712, new int[0]);
        UPSScp.checkImageSOPInstanceAndSourceReference(rqData, 4210721, new int[0]);
        UPSScp.notAllowed(rqData, 0x100020);
        UPSScp.notAllowed(rqData, 0x100021);
        UPSScp.notAllowed(rqData, 0x100022);
        UPSScp.notAllowed(rqData, 0x101002);
        UPSScp.notAllowed(rqData, 0x100030);
        UPSScp.notAllowed(rqData, 0x100040);
        UPSScp.notAllowed(rqData, 3670032);
        UPSScp.notAllowed(rqData, 3670036);
        UPSScp.notAllowed(rqData, 528512);
        UPSScp.notAllowed(rqData, 528516);
        UPSScp.notAllowed(rqData, 4236144);
        UPSScp.checkRelatedProcedureSteps(rqData);
        UPSScp.notAllowed(rqData, 7606272);
        this.checkUPSProgressInformation(rqData);
        this.checkUPSPerformedProcedure(rqData);
    }

    private void checkUPSProgressInformation(Dataset rqData) throws DcmServiceException {
        DcmElement sq = rqData.get(7606274);
        if (sq == null || sq.isEmpty()) {
            return;
        }
        int n = sq.countItems();
        if (n > 1) {
            throw new DcmServiceException(262, UPSScp.errorMessage("More than 1 item of Attribute: ", 7606274, new int[0]));
        }
        Dataset item = sq.getItem();
        this.checkUPSCommunicationsURI(item);
        UPSScp.checkCodeItem(item, ItemCount.MULTIPLE, 7606286, 7606274);
    }

    private void checkUPSCommunicationsURI(Dataset progressInfo) throws DcmServiceException {
        DcmElement sq = progressInfo.get(7606280);
        if (sq == null) {
            return;
        }
        int n = sq.countItems();
        for (int i = 0; i < n; ++i) {
            Dataset item = sq.getItem(i);
            UPSScp.type1(item, 7606282, 7606274, 7606280);
        }
    }

    private void checkUPSPerformedProcedure(Dataset rqData) throws DcmServiceException {
        DcmElement sq = rqData.get(7606806);
        if (sq == null || sq.isEmpty()) {
            return;
        }
        int n = sq.countItems();
        if (n > 1) {
            throw new DcmServiceException(262, UPSScp.errorMessage("More than 1 item of Attribute: ", 7606806, new int[0]));
        }
        Dataset item = sq.getItem();
        UPSScp.checkActualHumanPerformers(item);
        UPSScp.checkCodeItem(item, ItemCount.MULTIPLE, 4210728, 7606806);
        UPSScp.checkCodeItem(item, ItemCount.MULTIPLE, 4210729, 7606806);
        UPSScp.checkCodeItem(item, ItemCount.MULTIPLE, 0x404030, 7606806);
        UPSScp.checkCodeItem(item, ItemCount.MULTIPLE, 0x404007, 7606806);
        UPSScp.checkCodeItem(item, ItemCount.SINGLE, 4210713, 7606806);
        UPSScp.checkContentItem(item, 7606802, 7606806);
        UPSScp.checkImageSOPInstanceAndSourceReference(item, 0x404033, 7606806);
    }

    private static void checkActualHumanPerformers(Dataset performedProcedure) throws DcmServiceException {
        DcmElement sq = performedProcedure.get(4210741);
        if (sq == null) {
            return;
        }
        int n = sq.countItems();
        for (int i = 0; i < n; ++i) {
            Dataset item = sq.getItem(i);
            UPSScp.checkCodeItem(item, ItemCount.SINGLE, 0x404009, 4210741, 7606806);
        }
    }

    protected Dataset doNGet(ActiveAssociation assoc, Dimse rq, Command rspCmd) throws IOException, DcmServiceException {
        Command rqCmd = rq.getCommand();
        Dataset rqData = rq.getDataset();
        if (!UPSScp.abstractSyntaxEquals(assoc, rq, "1.2.840.10008.5.1.4.34.4.3", "1.2.840.10008.5.1.4.34.4.2")) {
            throw new DcmServiceException(529);
        }
        if (rqData != null) {
            throw new DcmServiceException(530, "N-GET-RQ includes Data Set");
        }
        return this.service.getUPS(rspCmd.getAffectedSOPInstanceUID(), rqCmd.getTags(4101));
    }

    protected Dataset doNAction(ActiveAssociation assoc, Dimse rq, Command rspCmd) throws IOException, DcmServiceException {
        Association a = assoc.getAssociation();
        String calledAET = a.getCalledAET();
        String callingAET = a.getCallingAET();
        Command rqCmd = rq.getCommand();
        Dataset rqData = rq.getDataset();
        int actionTypeID = rqCmd.getInt(4104, 0);
        rspCmd.putUS(4104, actionTypeID);
        String iuid = rqCmd.getRequestedSOPInstanceUID();
        switch (actionTypeID) {
            case 1: {
                if (!UPSScp.abstractSyntaxEquals(assoc, rq, "1.2.840.10008.5.1.4.34.4.3")) break;
                UPSScp.type1(rqData, 7606272, new int[0]);
                int state = UPSScpService.upsStateAsInt(rqData.getString(7606272));
                if (state == 0) {
                    throw new DcmServiceException(49923);
                }
                String tuid = rqData.getString(528789);
                if (tuid == null) {
                    throw new DcmServiceException(49921);
                }
                this.service.changeUPSState(calledAET, iuid, state, tuid);
                return rqData;
            }
            case 2: {
                if (!UPSScp.abstractSyntaxEquals(assoc, rq, "1.2.840.10008.5.1.4.34.4.1", "1.2.840.10008.5.1.4.34.4.2")) break;
                UPSScp.checkCodeItem(rqData, ItemCount.SINGLE, 7606286, new int[0]);
                this.service.requestUPSCancel(calledAET, iuid, callingAET, rqData);
                return rqData;
            }
            case 3: {
                if (!UPSScp.abstractSyntaxEquals(assoc, rq, "1.2.840.10008.5.1.4.34.4.2")) break;
                UPSScp.type1(rqData, 7606836, new int[0]);
                UPSScp.type1(rqData, 7606832, new int[0]);
                String receivingAET = rqData.getString(7606836);
                boolean dellock = UPSScp.deletionLockAsBoolean(rqData.getString(7606832));
                if (iuid.equals("1.2.840.10008.5.1.4.34.5")) {
                    this.service.subscribeGlobally(calledAET, receivingAET, dellock);
                } else {
                    this.service.subscribeReceiveUPSEventReports(calledAET, iuid, receivingAET, dellock);
                }
                return rqData;
            }
            case 4: {
                if (!UPSScp.abstractSyntaxEquals(assoc, rq, "1.2.840.10008.5.1.4.34.4.2")) break;
                UPSScp.type1(rqData, 7606836, new int[0]);
                String receivingAET = rqData.getString(7606836);
                if (iuid.equals("1.2.840.10008.5.1.4.34.5")) {
                    this.service.unsubscribeGlobally(receivingAET);
                } else {
                    this.service.unsubscribeReceiveUPSEventReports(iuid, receivingAET);
                }
                return rqData;
            }
            case 5: {
                if (!UPSScp.abstractSyntaxEquals(assoc, rq, "1.2.840.10008.5.1.4.34.4.2") || !iuid.equals("1.2.840.10008.5.1.4.34.5")) break;
                UPSScp.type1(rqData, 7606836, new int[0]);
                String receivingAET = rqData.getString(7606836);
                this.service.suspendGlobalSubscription(receivingAET);
                return rqData;
            }
        }
        throw new DcmServiceException(291).setActionTypeID(actionTypeID);
    }

    private static boolean deletionLockAsBoolean(String deletionLock) throws DcmServiceException {
        if ("TRUE".equals(deletionLock)) {
            return true;
        }
        if ("FALSE".equals(deletionLock)) {
            return false;
        }
        throw new DcmServiceException(262, "Illegal Deletion Lock Value: " + deletionLock);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum ItemCount {
        SINGLE,
        MULTIPLE;

    }
}

