/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4chex.archive.dcm.ups;

import java.io.IOException;
import java.sql.SQLException;
import org.dcm4che.data.Command;
import org.dcm4che.data.Dataset;
import org.dcm4che.net.ActiveAssociation;
import org.dcm4che.net.Association;
import org.dcm4che.net.DcmServiceBase;
import org.dcm4che.net.DcmServiceException;
import org.dcm4che.net.Dimse;
import org.dcm4che.net.DimseListener;
import org.dcm4che.net.ExtNegotiation;
import org.dcm4chex.archive.dcm.ups.UPSScpService;
import org.dcm4chex.archive.ejb.jdbc.UPSQueryCmd;
import org.jboss.logging.Logger;

class UPSFindScp
extends DcmServiceBase {
    private static final int FUZZY_MATCHING = 2;
    private final UPSScpService service;
    private Logger log;

    public UPSFindScp(UPSScpService service) {
        this.service = service;
        this.log = service.getLog();
    }

    protected DcmServiceBase.MultiDimseRsp doCFind(ActiveAssociation assoc, Dimse rq, Command rspCmd) throws IOException, DcmServiceException {
        Association a = assoc.getAssociation();
        Command rqCmd = rq.getCommand();
        Dataset rqData = rq.getDataset();
        if (rqData == null) {
            throw new DcmServiceException(530, "C-FIND-RQ without Data Set");
        }
        this.log.debug((Object)"Identifier:\n");
        this.log.debug((Object)rqData);
        this.checkCFindRQ(rqData);
        try {
            this.service.logDicomQuery(a, rqCmd.getAffectedSOPClassUID(), rqData);
            boolean fuzzyMatchingOfPN = this.fuzzyMatchingOfPN(a.getAcceptedExtNegotiation(rqCmd.getAffectedSOPClassUID()));
            UPSQueryCmd queryCmd = new UPSQueryCmd(rqData, fuzzyMatchingOfPN, this.service.isNoMatchForNoValue());
            queryCmd.setFetchSize(this.service.getFetchSize()).execute();
            return new MultiCFindRsp(queryCmd);
        }
        catch (DcmServiceException e) {
            throw e;
        }
        catch (Exception e) {
            this.service.getLog().error((Object)"Query DB failed:", (Throwable)e);
            throw new DcmServiceException(272, (Throwable)e);
        }
    }

    private boolean fuzzyMatchingOfPN(ExtNegotiation extNeg) {
        byte[] info;
        return extNeg != null && (info = extNeg.info()).length > 2 && info[2] != 0;
    }

    private void checkCFindRQ(Dataset rqData) throws DcmServiceException {
        String s = rqData.getString(7606272);
        if (s != null) {
            UPSScpService.upsStateAsInt(s);
        }
    }

    private class MultiCFindRsp
    implements DcmServiceBase.MultiDimseRsp {
        private final UPSQueryCmd queryCmd;
        private boolean canceled = false;

        public MultiCFindRsp(UPSQueryCmd queryCmd) {
            this.queryCmd = queryCmd;
        }

        public DimseListener getCancelListener() {
            return new DimseListener(){

                public void dimseReceived(Association assoc, Dimse dimse) {
                    MultiCFindRsp.this.canceled = true;
                }
            };
        }

        public Dataset next(ActiveAssociation assoc, Dimse rq, Command rspCmd) throws DcmServiceException {
            if (this.canceled) {
                rspCmd.putUS(2304, 65024);
                return null;
            }
            try {
                if (!this.queryCmd.next()) {
                    rspCmd.putUS(2304, 0);
                    return null;
                }
                rspCmd.putUS(2304, 65280);
                Dataset rspData = this.queryCmd.getDataset();
                UPSFindScp.this.log.debug((Object)"Identifier:\n");
                UPSFindScp.this.log.debug((Object)rspData);
                return rspData;
            }
            catch (SQLException e) {
                UPSFindScp.this.service.getLog().error((Object)"Retrieve DB record failed:", (Throwable)e);
                throw new DcmServiceException(272, (Throwable)e);
            }
            catch (Exception e) {
                UPSFindScp.this.service.getLog().error((Object)"Corrupted DB record:", (Throwable)e);
                throw new DcmServiceException(272, (Throwable)e);
            }
        }

        public void release() {
            this.queryCmd.close();
        }
    }
}

