/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4chex.archive.dcm.ups;

import javax.management.Notification;
import javax.management.NotificationListener;
import javax.management.ObjectName;
import javax.xml.transform.Templates;
import org.dcm4che.data.Dataset;
import org.dcm4che.data.DcmElement;
import org.dcm4che.data.DcmObjectFactory;
import org.dcm4chex.archive.dcm.ianscu.IANScuService;
import org.dcm4chex.archive.mbean.TemplatesDelegate;
import org.dcm4chex.archive.util.XSLTUtils;
import org.jboss.system.ServiceMBeanSupport;

public class UPSFeedService
extends ServiceMBeanSupport {
    private static final String MPPS2UPS_XSL = "mpps2ups.xsl";
    private TemplatesDelegate templates = new TemplatesDelegate(this);
    private ObjectName ianScuServiceName;
    private ObjectName upsScpServiceName;
    private final NotificationListener ianListener = new NotificationListener(){

        public void handleNotification(Notification notif, Object handback) {
            UPSFeedService.this.onIAN((Dataset)notif.getUserData());
        }
    };

    public final ObjectName getTemplatesServiceName() {
        return this.templates.getTemplatesServiceName();
    }

    public final void setTemplatesServiceName(ObjectName serviceName) {
        this.templates.setTemplatesServiceName(serviceName);
    }

    public final String getWorkItemConfigDir() {
        return this.templates.getConfigDir();
    }

    public final void setWorkItemConfigDir(String path) {
        this.templates.setConfigDir(path);
    }

    public final ObjectName getIANScuServiceName() {
        return this.ianScuServiceName;
    }

    public final void setIANScuServiceName(ObjectName ianScuServiceName) {
        this.ianScuServiceName = ianScuServiceName;
    }

    public final ObjectName getUPSScpServiceName() {
        return this.upsScpServiceName;
    }

    public final void setUPSScpServiceName(ObjectName upsScpServiceName) {
        this.upsScpServiceName = upsScpServiceName;
    }

    protected void startService() throws Exception {
        this.server.addNotificationListener(this.ianScuServiceName, this.ianListener, IANScuService.NOTIF_FILTER, null);
    }

    protected void stopService() throws Exception {
        this.server.removeNotificationListener(this.ianScuServiceName, this.ianListener, IANScuService.NOTIF_FILTER, null);
    }

    private void onIAN(Dataset mpps) {
        String aet = mpps.getString(4194881);
        Templates stylesheet = this.templates.getTemplatesForAET(aet, MPPS2UPS_XSL);
        if (stylesheet == null) {
            this.log.info((Object)("No mpps2ups.xsl found for " + aet));
            return;
        }
        Dataset wkitems = DcmObjectFactory.getInstance().newDataset();
        try {
            XSLTUtils.xslt(mpps, stylesheet, wkitems);
        }
        catch (Exception e) {
            this.log.error((Object)("Failed to create UPS triggered by MPPS from " + aet), (Throwable)e);
            return;
        }
        DcmElement wkitemSeq = wkitems.get(4390944);
        int n = wkitemSeq.countItems();
        this.log.info((Object)("Creating " + n + " UPS(s) triggered by MPPS from " + aet));
        try {
            for (int i = 0; i < n; ++i) {
                this.updateOrCreateUPS(wkitemSeq.getItem(i));
            }
        }
        catch (Exception e) {
            this.log.error((Object)("Failed to create UPS triggered by MPPS from " + aet), (Throwable)e);
        }
    }

    private void updateOrCreateUPS(Dataset ups) throws Exception {
        this.server.invoke(this.upsScpServiceName, "updateOrCreateUPS", new Object[]{ups}, new String[]{Dataset.class.getName()});
    }
}

