/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4chex.archive.dcm.stymgt;

import java.util.HashMap;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageListener;
import javax.jms.ObjectMessage;
import javax.management.Notification;
import javax.management.NotificationListener;
import javax.management.ObjectName;
import org.dcm4che.data.Command;
import org.dcm4che.data.Dataset;
import org.dcm4che.data.DcmObjectFactory;
import org.dcm4che.net.ActiveAssociation;
import org.dcm4che.net.AssociationFactory;
import org.dcm4che.net.DcmServiceException;
import org.dcm4che.net.Dimse;
import org.dcm4chex.archive.config.ForwardingRules;
import org.dcm4chex.archive.config.RetryIntervalls;
import org.dcm4chex.archive.dcm.AbstractScuService;
import org.dcm4chex.archive.dcm.stymgt.StudyMgtOrder;
import org.dcm4chex.archive.dcm.stymgt.StudyMgtScpService;
import org.dcm4chex.archive.mbean.JMSDelegate;

public class StudyMgtScuService
extends AbstractScuService
implements MessageListener,
NotificationListener {
    private static final int MSG_ID = 1;
    private static final int PCID_STYMGT = 1;
    private RetryIntervalls retryIntervalls = new RetryIntervalls();
    private ForwardingRules forwardingRules = new ForwardingRules("");
    private ObjectName scpServiceName;
    private String queueName;
    private boolean retryIfNoSuchSOPInstance = false;
    private int concurrency = 1;
    private JMSDelegate jmsDelegate = new JMSDelegate(this);

    public final ObjectName getJmsServiceName() {
        return this.jmsDelegate.getJmsServiceName();
    }

    public final void setJmsServiceName(ObjectName jmsServiceName) {
        this.jmsDelegate.setJmsServiceName(jmsServiceName);
    }

    public final int getConcurrency() {
        return this.concurrency;
    }

    public final void setConcurrency(int concurrency) throws Exception {
        if (concurrency <= 0) {
            throw new IllegalArgumentException("Concurrency: " + concurrency);
        }
        if (this.concurrency != concurrency) {
            boolean restart;
            boolean bl = restart = this.getState() == 3;
            if (restart) {
                this.stop();
            }
            this.concurrency = concurrency;
            if (restart) {
                this.start();
            }
        }
    }

    public final String getForwardingRules() {
        return this.forwardingRules.toString();
    }

    public final void setForwardingRules(String forwardingRules) {
        this.forwardingRules = new ForwardingRules(forwardingRules);
    }

    public final ObjectName getStudyMgtScpServiceName() {
        return this.scpServiceName;
    }

    public boolean isRetryIfNoSuchSOPInstance() {
        return this.retryIfNoSuchSOPInstance;
    }

    public void setRetryIfNoSuchSOPInstance(boolean retry) {
        this.retryIfNoSuchSOPInstance = retry;
    }

    public final void setStudyMgtScpServiceName(ObjectName scpServiceName) {
        this.scpServiceName = scpServiceName;
    }

    public final String getQueueName() {
        return this.queueName;
    }

    public final void setQueueName(String queueName) {
        this.queueName = queueName;
    }

    public String getRetryIntervalls() {
        return this.retryIntervalls.toString();
    }

    public void setRetryIntervalls(String text) {
        this.retryIntervalls = new RetryIntervalls(text);
    }

    protected void startService() throws Exception {
        this.jmsDelegate.startListening(this.queueName, this, this.concurrency);
        this.server.addNotificationListener(this.scpServiceName, this, StudyMgtScpService.NOTIF_FILTER, null);
    }

    protected void stopService() throws Exception {
        this.server.removeNotificationListener(this.scpServiceName, this, StudyMgtScpService.NOTIF_FILTER, null);
        this.jmsDelegate.stopListening(this.queueName);
    }

    public void handleNotification(Notification notif, Object handback) {
        StudyMgtOrder order = (StudyMgtOrder)notif.getUserData();
        this.forward(order.getCallingAET(), order.getCalledAET(), order.getSOPInstanceUID(), order.getCommandField(), order.getActionTypeID(), order.getDataset());
    }

    public int forward(String origCallingAET, String origCalledAET, String iuid, int commandField, int actionTypeID, Dataset dataset) {
        int count = 0;
        HashMap<String, String[]> keys = new HashMap<String, String[]>();
        keys.put("calling", new String[]{origCallingAET});
        keys.put("called", new String[]{origCalledAET});
        keys.put("command", new String[]{StudyMgtOrder.commandAsString(commandField, actionTypeID)});
        String[] forwardAETs = this.forwardingRules.getForwardDestinationsFor(keys);
        for (int i = 0; i < forwardAETs.length; ++i) {
            StudyMgtOrder order = new StudyMgtOrder(origCallingAET, forwardAETs[i], commandField, actionTypeID, iuid, dataset);
            order.processOrderProperties(new Object[0]);
            try {
                this.log.info((Object)("Scheduling " + order));
                this.jmsDelegate.queue(this.queueName, order, 4, 0L);
                ++count;
                continue;
            }
            catch (Exception e) {
                this.log.error((Object)("Failed to schedule " + order), (Throwable)e);
            }
        }
        return count;
    }

    public void onMessage(Message message) {
        block15: {
            ObjectMessage om = (ObjectMessage)message;
            try {
                StudyMgtOrder order = (StudyMgtOrder)om.getObject();
                this.log.info((Object)("Start processing " + order));
                try {
                    try {
                        switch (order.getCommandField()) {
                            case 304: {
                                this.naction(order.getCalledAET(), order.getSOPInstanceUID(), order.getActionTypeID(), order.getDataset());
                                break;
                            }
                            case 320: {
                                this.ncreate(order.getCalledAET(), order.getSOPInstanceUID(), order.getDataset());
                                break;
                            }
                            case 336: {
                                this.ndelete(order.getCalledAET(), order.getSOPInstanceUID());
                                break;
                            }
                            case 288: {
                                this.nset(order.getCalledAET(), order.getSOPInstanceUID(), order.getDataset());
                            }
                        }
                    }
                    catch (DcmServiceException e) {
                        if (e.getStatus() != 274 || this.retryIfNoSuchSOPInstance) {
                            throw e;
                        }
                        this.log.info((Object)("No such SOP Instance for " + order));
                    }
                    this.log.info((Object)("Finished processing " + order));
                }
                catch (Exception e) {
                    order.setThrowable(e);
                    int failureCount = order.getFailureCount() + 1;
                    order.setFailureCount(failureCount);
                    long delay = this.retryIntervalls.getIntervall(failureCount);
                    if (delay == -1L) {
                        this.log.error((Object)("Give up to process " + order));
                        this.jmsDelegate.fail(this.queueName, order);
                        break block15;
                    }
                    this.log.warn((Object)("Failed to process " + order + ". Scheduling retry."));
                    this.jmsDelegate.queue(this.queueName, order, 0, System.currentTimeMillis() + delay);
                }
            }
            catch (JMSException e) {
                this.log.error((Object)("jms error during processing message: " + message), (Throwable)e);
            }
            catch (Throwable e) {
                this.log.error((Object)("unexpected error during processing message: " + message), e);
            }
        }
    }

    public void ncreate(String aet, String iuid, Dataset ds) throws Exception {
        Command cmd = DcmObjectFactory.getInstance().newCommand();
        cmd.initNCreateRQ(1, "1.2.40.0.13.1.3.1.2.3.1", iuid);
        this.checkStatus(this.invoke(aet, cmd, ds).getCommand());
    }

    public void nset(String aet, String iuid, Dataset ds) throws Exception {
        Command cmd = DcmObjectFactory.getInstance().newCommand();
        cmd.initNSetRQ(1, "1.2.40.0.13.1.3.1.2.3.1", iuid);
        this.checkStatus(this.invoke(aet, cmd, ds).getCommand());
    }

    public void naction(String aet, String iuid, int actionTypeID, Dataset ds) throws Exception {
        Command cmd = DcmObjectFactory.getInstance().newCommand();
        cmd.initNActionRQ(1, "1.2.40.0.13.1.3.1.2.3.1", iuid, actionTypeID);
        this.checkStatus(this.invoke(aet, cmd, ds).getCommand());
    }

    public void ndelete(String aet, String iuid) throws Exception {
        Command cmd = DcmObjectFactory.getInstance().newCommand();
        cmd.initNDeleteRQ(1, "1.2.40.0.13.1.3.1.2.3.1", iuid);
        this.checkStatus(this.invoke(aet, cmd, null).getCommand());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Dimse invoke(String aet, Command cmd, Dataset ds) throws Exception {
        Dimse dimse;
        ActiveAssociation aa = this.openAssociation(aet, "1.2.40.0.13.1.3.1.2.3.1");
        try {
            dimse = aa.invoke(AssociationFactory.getInstance().newDimse(1, cmd, ds)).get();
            Object var7_6 = null;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            try {
                aa.release(true);
            }
            catch (Exception e) {
                this.log.warn((Object)("Failed to release association " + aa.getAssociation()), (Throwable)e);
            }
            throw throwable;
        }
        try {
            aa.release(true);
        }
        catch (Exception e) {
            this.log.warn((Object)("Failed to release association " + aa.getAssociation()), (Throwable)e);
        }
        return dimse;
    }

    private void checkStatus(Command cmdRsp) throws DcmServiceException {
        if (cmdRsp.getStatus() != 0) {
            throw new DcmServiceException(cmdRsp.getStatus(), cmdRsp.getString(2306));
        }
    }
}

