/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4chex.archive.dcm.stymgt;

import javax.management.InstanceNotFoundException;
import javax.management.MBeanException;
import javax.management.Notification;
import javax.management.NotificationFilter;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import org.dcm4che.data.Dataset;
import org.dcm4che.net.AcceptorPolicy;
import org.dcm4che.net.ActiveAssociation;
import org.dcm4che.net.Association;
import org.dcm4che.net.DcmServiceRegistry;
import org.dcm4chex.archive.common.PatientMatching;
import org.dcm4chex.archive.dcm.AbstractScpService;
import org.dcm4chex.archive.dcm.stymgt.StudyMgtOrder;
import org.dcm4chex.archive.dcm.stymgt.StudyMgtScp;

public class StudyMgtScpService
extends AbstractScpService {
    public static final String EVENT_TYPE = "org.dcm4chex.archive.dcm.stymgt";
    public static final NotificationFilter NOTIF_FILTER = new NotificationFilter(){
        private static final long serialVersionUID = 3257281448414097465L;

        public boolean isNotificationEnabled(Notification notif) {
            return StudyMgtScpService.EVENT_TYPE.equals(notif.getType());
        }
    };
    private ObjectName contentEditServiceName;
    private StudyMgtScp stymgtScp = new StudyMgtScp(this);
    private PatientMatching studyMovePatientMatching;

    public ObjectName getContentEditServiceName() {
        return this.contentEditServiceName;
    }

    public void setContentEditServiceName(ObjectName serviceName) {
        this.contentEditServiceName = serviceName;
    }

    public boolean isIgnoreDeleteFailed() {
        return this.stymgtScp.isIgnoreDeleteFailed();
    }

    public void setIgnoreDeleteFailed(boolean ignoreDeleteFailed) {
        this.stymgtScp.setIgnoreDeleteFailed(ignoreDeleteFailed);
    }

    public String getStudyMovePatientMatching() {
        return this.studyMovePatientMatching.toString();
    }

    public void setStudyMovePatientMatching(String s) {
        this.studyMovePatientMatching = new PatientMatching(s.trim());
    }

    public PatientMatching studyMovePatientMatching() {
        return this.studyMovePatientMatching;
    }

    protected void bindDcmServices(DcmServiceRegistry services) {
        services.bind("1.2.40.0.13.1.3.1.2.3.1", this.stymgtScp);
    }

    protected void unbindDcmServices(DcmServiceRegistry services) {
        services.unbind("1.2.40.0.13.1.3.1.2.3.1");
    }

    protected void enablePresContexts(AcceptorPolicy policy) {
        policy.putPresContext("1.2.40.0.13.1.3.1.2.3.1", StudyMgtScpService.valuesToStringArray(this.tsuidMap));
    }

    protected void disablePresContexts(AcceptorPolicy policy) {
        policy.putPresContext("1.2.40.0.13.1.3.1.2.3.1", null);
    }

    void sendStudyMgtNotification(ActiveAssociation assoc, int cmdField, int actionTypeID, String iuid, Dataset ds) {
        Association a = assoc.getAssociation();
        long eventID = super.getNextNotificationSequenceNumber();
        Notification notif = new Notification(EVENT_TYPE, (Object)this, eventID);
        StudyMgtOrder studyMgtOrder = new StudyMgtOrder(a.getCallingAET(), a.getCalledAET(), cmdField, actionTypeID, iuid, ds);
        studyMgtOrder.processOrderProperties(new Object[0]);
        notif.setUserData(studyMgtOrder);
        super.sendNotification(notif);
    }

    void moveStudyToTrash(String iuid) throws Exception {
        try {
            this.server.invoke(this.contentEditServiceName, "moveStudyToTrash", new Object[]{iuid}, new String[]{String.class.getName()});
        }
        catch (MBeanException e) {
            throw e.getTargetException();
        }
        catch (InstanceNotFoundException e) {
            throw e;
        }
        catch (ReflectionException e) {
            throw e;
        }
    }

    void moveSeriesToTrash(String[] iuids) throws Exception {
        try {
            this.server.invoke(this.contentEditServiceName, "moveSeriesToTrash", new Object[]{iuids}, new String[]{String[].class.getName()});
        }
        catch (MBeanException e) {
            throw e.getTargetException();
        }
        catch (InstanceNotFoundException e) {
            throw e;
        }
        catch (ReflectionException e) {
            throw e;
        }
    }

    void moveInstancesToTrash(String[] iuids) throws Exception {
        try {
            this.server.invoke(this.contentEditServiceName, "moveInstancesToTrash", new Object[]{iuids}, new String[]{String[].class.getName()});
        }
        catch (MBeanException e) {
            throw e.getTargetException();
        }
        catch (InstanceNotFoundException e) {
            throw e;
        }
        catch (ReflectionException e) {
            throw e;
        }
    }
}

