/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4chex.archive.dcm.stymgt;

import java.io.IOException;
import java.util.ArrayList;
import javax.ejb.ObjectNotFoundException;
import org.dcm4che.data.Command;
import org.dcm4che.data.Dataset;
import org.dcm4che.data.DcmElement;
import org.dcm4che.net.ActiveAssociation;
import org.dcm4che.net.DcmServiceBase;
import org.dcm4che.net.DcmServiceException;
import org.dcm4che.net.Dimse;
import org.dcm4chex.archive.dcm.stymgt.StudyMgtScpService;
import org.dcm4chex.archive.ejb.interfaces.StudyMgt;
import org.dcm4chex.archive.ejb.interfaces.StudyMgtHome;
import org.dcm4chex.archive.util.EJBHomeFactory;
import org.dcm4chex.archive.util.HomeFactoryException;
import org.jboss.logging.Logger;

class StudyMgtScp
extends DcmServiceBase {
    final StudyMgtScpService service;
    private Logger log;
    private boolean ignoreDeleteFailed;

    public StudyMgtScp(StudyMgtScpService service) {
        this.service = service;
        this.log = service.getLog();
    }

    public boolean isIgnoreDeleteFailed() {
        return this.ignoreDeleteFailed;
    }

    public void setIgnoreDeleteFailed(boolean ignoreDeleteFailed) {
        this.ignoreDeleteFailed = ignoreDeleteFailed;
    }

    private StudyMgtHome getStudyMgtHome() throws HomeFactoryException {
        return (StudyMgtHome)EJBHomeFactory.getFactory().lookup(StudyMgtHome.class, "ejb/StudyMgt");
    }

    protected Dataset doNAction(ActiveAssociation assoc, Dimse rq, Command rspCmd) throws IOException, DcmServiceException {
        Command cmd = rq.getCommand();
        int actionTypeID = cmd.getInt(4104, -1);
        String iuid = cmd.getRequestedSOPInstanceUID();
        Dataset ds = rq.getDataset();
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)"Received N-Action cmd with ds:");
            this.log.debug((Object)ds);
        }
        this.checkStudyIuid(iuid, ds);
        try {
            switch (actionTypeID) {
                case 1: {
                    this.service.moveSeriesToTrash(this.toSeriesIuids(ds));
                    break;
                }
                case 2: {
                    this.service.moveInstancesToTrash(this.toSopIuids(ds));
                }
            }
        }
        catch (Exception e) {
            throw new DcmServiceException(272, (Throwable)e);
        }
        this.service.sendStudyMgtNotification(assoc, 304, actionTypeID, iuid, ds);
        return null;
    }

    private String[] toSeriesIuids(Dataset ds) throws DcmServiceException {
        return this.toIuids(ds, true);
    }

    private String[] toSopIuids(Dataset ds) throws DcmServiceException {
        return this.toIuids(ds, false);
    }

    private String[] toIuids(Dataset ds, boolean seriesIuids) throws DcmServiceException {
        ArrayList<String> iuids = new ArrayList<String>();
        DcmElement sersq = ds.get(528661);
        if (sersq == null) {
            throw new DcmServiceException(288, "Missing Referenced Series Seq.");
        }
        int n = sersq.countItems();
        for (int i = 0; i < n; ++i) {
            Dataset ser = sersq.getItem(i);
            String siuid = ser.getString(0x20000E);
            if (siuid == null) {
                throw new DcmServiceException(288, "Missing Series Instance UID");
            }
            if (seriesIuids) {
                iuids.add(siuid);
                continue;
            }
            DcmElement sops = ser.get(528793);
            if (sops == null) {
                throw new DcmServiceException(288, "Missing Referenced SOP Seq.");
            }
            int m = sops.countItems();
            for (int j = 0; j < m; ++j) {
                Dataset sop = sops.getItem(i);
                String iuid = sop.getString(528725);
                if (iuid == null) {
                    throw new DcmServiceException(288, "Missing Referenced SOP Instance UID");
                }
                iuids.add(iuid);
            }
        }
        return iuids.toArray(new String[iuids.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Dataset doNCreate(ActiveAssociation assoc, Dimse rq, Command rspCmd) throws IOException, DcmServiceException {
        Command cmd = rq.getCommand();
        String iuid = cmd.getAffectedSOPInstanceUID();
        Dataset ds = rq.getDataset();
        String suid = ds.getString(0x20000D);
        if (suid == null) {
            throw new DcmServiceException(288, "Missing Study Instance UID");
        }
        if (iuid == null) {
            iuid = suid;
            rspCmd.putUI(4096, iuid);
        } else {
            this.checkStudyIuid(iuid, ds);
        }
        try {
            StudyMgt stymgt = this.getStudyMgtHome().create();
            try {
                stymgt.createStudy(ds, this.service.patientMatching());
                Object var10_11 = null;
            }
            catch (Throwable throwable) {
                Object var10_12 = null;
                try {
                    stymgt.remove();
                }
                catch (Exception e) {
                    this.log.warn((Object)"Failed to remove StudyMgt Session Bean", (Throwable)e);
                }
                throw throwable;
            }
            try {
                stymgt.remove();
            }
            catch (Exception e) {
                this.log.warn((Object)"Failed to remove StudyMgt Session Bean", (Throwable)e);
            }
        }
        catch (DcmServiceException e) {
            throw e;
        }
        catch (Exception e) {
            throw new DcmServiceException(272, (Throwable)e);
        }
        this.service.sendStudyMgtNotification(assoc, 320, 0, iuid, ds);
        return null;
    }

    protected Dataset doNDelete(ActiveAssociation assoc, Dimse rq, Command rspCmd) throws IOException, DcmServiceException {
        Command cmd = rq.getCommand();
        String iuid = cmd.getRequestedSOPInstanceUID();
        Dataset ds = rq.getDataset();
        try {
            this.service.moveStudyToTrash(iuid);
        }
        catch (ObjectNotFoundException e) {
            if (!this.ignoreDeleteFailed) {
                throw new DcmServiceException(274);
            }
        }
        catch (Exception e) {
            throw new DcmServiceException(272, (Throwable)e);
        }
        this.service.sendStudyMgtNotification(assoc, 336, 0, iuid, null);
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Dataset doNSet(ActiveAssociation assoc, Dimse rq, Command rspCmd) throws IOException, DcmServiceException {
        Command cmd = rq.getCommand();
        String iuid = cmd.getRequestedSOPInstanceUID();
        Dataset ds = rq.getDataset();
        this.checkStudyIuid(iuid, ds);
        try {
            StudyMgt stymgt = this.getStudyMgtHome().create();
            try {
                stymgt.updateStudy(iuid, ds, this.service.studyMovePatientMatching());
                Object var9_10 = null;
            }
            catch (Throwable throwable) {
                Object var9_11 = null;
                try {
                    stymgt.remove();
                }
                catch (Exception e) {
                    this.log.warn((Object)"Failed to remove StudyMgt Session Bean", (Throwable)e);
                }
                throw throwable;
            }
            try {
                stymgt.remove();
            }
            catch (Exception e) {
                this.log.warn((Object)"Failed to remove StudyMgt Session Bean", (Throwable)e);
            }
        }
        catch (DcmServiceException e) {
            throw e;
        }
        catch (Exception e) {
            throw new DcmServiceException(272, (Throwable)e);
        }
        this.service.sendStudyMgtNotification(assoc, 288, 0, iuid, ds);
        return null;
    }

    private void checkStudyIuid(String iuid, Dataset ds) throws DcmServiceException {
        String suid = ds.getString(0x20000D);
        if (suid != null && !suid.equals(iuid)) {
            throw new DcmServiceException(262, "Study Instance UID must match SOP Instance UID");
        }
    }
}

